/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.render.common.HtmlBasicRendererBase;
import org.operamasks.faces.render.common.RendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRenderer
extends HtmlBasicRendererBase {
    @Override
    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    @Override
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        ResponseWriter out = context.getResponseWriter();
        out.startElement("table", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        RendererUtils.renderPassThruAttributes(out, component, "rows");
        out.writeText((Object)"\n", null);
        this.renderCaption(context, component);
        this.renderHeader(context, component);
        this.renderFooter(context, component);
    }

    @Override
    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        this.renderBody(context, component);
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        ResponseWriter out = context.getResponseWriter();
        out.endElement("table");
        out.writeText((Object)"\n", null);
    }

    private void renderCaption(FacesContext context, UIComponent component) throws IOException {
        UIComponent caption = component.getFacet("caption");
        if (caption == null || !caption.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String captionClass = (String)component.getAttributes().get("captionClass");
        String captionStyle = (String)component.getAttributes().get("captionStyle");
        out.startElement("caption", caption);
        if (captionClass != null) {
            out.writeAttribute("class", (Object)captionClass, "captionClass");
        }
        if (captionStyle != null) {
            out.writeAttribute("style", (Object)captionStyle, "captionStyle");
        }
        caption.encodeAll(context);
        out.endElement("caption");
    }

    private void renderHeader(FacesContext context, UIComponent component) throws IOException {
        UIComponent header = component.getFacet("header");
        int columnHeaderCount = this.getFacetCount(component, "header");
        if (!(header != null && header.isRendered() || columnHeaderCount != 0)) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String headerClass = (String)component.getAttributes().get("headerClass");
        out.startElement("thead", component);
        out.writeText((Object)"\n", null);
        if (header != null && header.isRendered()) {
            out.startElement("tr", header);
            out.startElement("th", header);
            if (headerClass != null) {
                out.writeAttribute("class", (Object)headerClass, "headerClass");
            }
            out.writeAttribute("colspan", (Object)this.getColumnCount(component), null);
            out.writeAttribute("scope", (Object)"colgroup", null);
            header.encodeAll(context);
            out.endElement("th");
            out.endElement("tr");
            out.writeText((Object)"\n", null);
        }
        if (columnHeaderCount != 0) {
            out.startElement("tr", component);
            for (UIColumn column : this.getColumns(component)) {
                String columnHeaderClass = (String)column.getAttributes().get("headerClass");
                UIComponent columnHeader = column.getFacet("header");
                out.startElement("th", (UIComponent)column);
                if (columnHeaderClass != null) {
                    out.writeAttribute("class", (Object)columnHeaderClass, "columnHeaderClass");
                } else if (headerClass != null) {
                    out.writeAttribute("class", (Object)headerClass, "headerClass");
                }
                out.writeAttribute("scope", (Object)"col", null);
                if (columnHeader != null && columnHeader.isRendered()) {
                    columnHeader.encodeAll(context);
                }
                out.endElement("th");
            }
            out.endElement("tr");
            out.writeText((Object)"\n", null);
        }
        out.endElement("thead");
        out.writeText((Object)"\n", null);
    }

    private void renderFooter(FacesContext context, UIComponent component) throws IOException {
        UIComponent footer = component.getFacet("footer");
        int columnFooterCount = this.getFacetCount(component, "footer");
        if (!(footer != null && footer.isRendered() || columnFooterCount != 0)) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String footerClass = (String)component.getAttributes().get("footerClass");
        out.startElement("tfoot", component);
        out.writeText((Object)"\n", null);
        if (columnFooterCount != 0) {
            out.startElement("tr", component);
            for (UIColumn column : this.getColumns(component)) {
                String columnFooterClass = (String)column.getAttributes().get("footerClass");
                UIComponent columnFooter = column.getFacet("footer");
                out.startElement("td", (UIComponent)column);
                if (columnFooterClass != null) {
                    out.writeAttribute("class", (Object)columnFooterClass, "columnFooterClass");
                } else if (footerClass != null) {
                    out.writeAttribute("class", (Object)footerClass, "footerClass");
                }
                if (columnFooter != null && columnFooter.isRendered()) {
                    columnFooter.encodeAll(context);
                }
                out.endElement("td");
            }
            out.endElement("tr");
            out.writeText((Object)"\n", null);
        }
        if (footer != null && footer.isRendered()) {
            out.startElement("tr", footer);
            out.startElement("td", footer);
            if (footerClass != null) {
                out.writeAttribute("class", (Object)footerClass, "footerClass");
            }
            out.writeAttribute("colspan", (Object)this.getColumnCount(component), null);
            footer.encodeAll(context);
            out.endElement("td");
            out.endElement("tr");
            out.writeText((Object)"\n", null);
        }
        out.endElement("tfoot");
        out.writeText((Object)"\n", null);
    }

    private void renderBody(FacesContext context, UIComponent component) throws IOException {
        List<UIColumn> columns = this.getColumns(component);
        String[] rowClasses = this.getStyleClasses(component, "rowClasses");
        String[] columnClasses = this.getStyleClasses(component, "columnClasses");
        int rowStyles = rowClasses.length;
        int columnStyles = columnClasses.length;
        UIData data = (UIData)component;
        int rows = data.getRows();
        int rowIndex = data.getFirst();
        int rowStyle = 0;
        ResponseWriter out = context.getResponseWriter();
        out.startElement("tbody", component);
        out.writeText((Object)"\n", null);
        for (int curRow = 0; rows == 0 || curRow < rows; ++curRow) {
            data.setRowIndex(rowIndex++);
            if (!data.isRowAvailable()) break;
            out.startElement("tr", component);
            if (rowStyles > 0) {
                out.writeAttribute("class", (Object)rowClasses[rowStyle++], "rowClasses");
                if (rowStyle >= rowStyles) {
                    rowStyle = 0;
                }
            }
            out.writeText((Object)"\n", null);
            int columnStyle = 0;
            for (UIColumn column : columns) {
                out.startElement("td", (UIComponent)column);
                if (columnStyles > 0) {
                    out.writeAttribute("class", (Object)columnClasses[columnStyle++], "columnClasses");
                    if (columnStyle >= columnStyles) {
                        columnStyle = 0;
                    }
                }
                for (UIComponent kid : column.getChildren()) {
                    if (!kid.isRendered()) continue;
                    kid.encodeAll(context);
                }
                out.endElement("td");
                out.writeText((Object)"\n", null);
            }
            out.endElement("tr");
            out.writeText((Object)"\n", null);
        }
        out.endElement("tbody");
        out.writeText((Object)"\n", null);
        data.setRowIndex(-1);
    }

    private List<UIColumn> getColumns(UIComponent component) {
        ArrayList<UIColumn> result = new ArrayList<UIColumn>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
            result.add((UIColumn)kid);
        }
        return result;
    }

    private int getColumnCount(UIComponent component) {
        int n = 0;
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
            ++n;
        }
        return n;
    }

    private int getFacetCount(UIComponent component, String name) {
        int n = 0;
        for (UIComponent kid : component.getChildren()) {
            UIComponent facet;
            if (!(kid instanceof UIColumn) || !kid.isRendered() || (facet = kid.getFacet(name)) == null || !facet.isRendered()) continue;
            ++n;
        }
        return n;
    }

    private String[] getStyleClasses(UIComponent component, String name) {
        String values = (String)component.getAttributes().get(name);
        if (values == null) {
            return new String[0];
        }
        String[] result = values.split(",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }
}

