/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.UIInputRenderer;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UISelectRenderer
extends UIInputRenderer {
    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        if (component instanceof UISelectMany) {
            Map paramValuesMap = context.getExternalContext().getRequestParameterValuesMap();
            if (paramValuesMap.containsKey(clientId)) {
                String[] newValues = (String[])paramValuesMap.get(clientId);
                this.setSubmittedValue(component, newValues);
            } else {
                this.setSubmittedValue(component, new String[0]);
            }
        } else {
            Map paramMap = context.getExternalContext().getRequestParameterMap();
            if (paramMap.containsKey(clientId)) {
                String newValue = (String)paramMap.get(clientId);
                this.setSubmittedValue(component, newValue);
            } else {
                this.setSubmittedValue(component, "");
            }
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (component instanceof UISelectMany) {
            return this.convertSelectManyValue(context, (UISelectMany)component, (String[])submittedValue);
        }
        return this.convertSelectOneValue(context, (UISelectOne)component, (String)submittedValue);
    }

    protected Object convertSelectOneValue(FacesContext context, UISelectOne component, String newValue) throws ConverterException {
        if (newValue == null || newValue.length() == 0) {
            return null;
        }
        return super.getConvertedValue(context, (UIComponent)component, newValue);
    }

    protected Object convertSelectManyValue(FacesContext context, UISelectMany component, String[] newValues) throws ConverterException {
        ValueExpression binding = component.getValueExpression("value");
        Object result = null;
        if (binding != null) {
            Class bindingType = binding.getType(context.getELContext());
            if (bindingType != null) {
                if (bindingType.isArray()) {
                    result = this.convertArrayValue(context, component, bindingType, newValues);
                } else if (List.class.isAssignableFrom(bindingType)) {
                    result = this.convertListValue(context, newValues);
                }
            }
        } else {
            result = newValues;
        }
        return result;
    }

    protected Object convertArrayValue(FacesContext context, UISelectMany component, Class arrayType, String[] newValues) throws ConverterException {
        Object result;
        Class<?> elementType = arrayType.getComponentType();
        int len = newValues.length;
        if (elementType == String.class || elementType == Object.class) {
            return newValues;
        }
        try {
            result = Array.newInstance(elementType, len);
        }
        catch (Exception ex) {
            throw new ConverterException((Throwable)ex);
        }
        Converter converter = component.getConverter();
        if (converter == null) {
            converter = context.getApplication().createConverter(elementType);
        }
        if (converter == null) {
            throw new ConverterException(Resources._T("JSF_NO_SUCH_CONVERTER_TYPE", elementType.getName()));
        }
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, converter.getAsObject(context, (UIComponent)component, newValues[i]));
        }
        return result;
    }

    protected Object convertListValue(FacesContext context, String[] newValues) {
        ArrayList<String> result = new ArrayList<String>(newValues.length);
        for (int i = 0; i < newValues.length; ++i) {
            result.add(newValues[i]);
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     */
    public List<SelectItem> getSelectItems(FacesContext context, UIComponent component) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>(component.getChildCount());
        for (UIComponent kid : component.getChildren()) {
            Object value;
            if (kid instanceof UISelectItem) {
                UISelectItem item = (UISelectItem)kid;
                Object value2 = item.getValue();
                if (value2 == null) {
                    list.add(new SelectItem(item.getItemValue(), item.getItemLabel(), item.getItemDescription(), item.isItemDisabled()));
                    continue;
                }
                if (value2 instanceof SelectItem) {
                    list.add((SelectItem)value2);
                    continue;
                }
                throw new IllegalArgumentException("Not a SelectItem");
            }
            if (!(kid instanceof UISelectItems) || (value = ((UISelectItems)kid).getValue()) == null) continue;
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof String) {
                list.add(new SelectItem(value));
                continue;
            }
            if (value instanceof SelectItem[]) {
                for (SelectItem item : (SelectItem[])value) {
                    list.add(item);
                }
                continue;
            }
            if (value instanceof String[]) {
                for (SelectItem str : (String[])value) {
                    list.add(new SelectItem((Object)str));
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    if (element instanceof SelectItem) {
                        list.add((SelectItem)element);
                        continue;
                    }
                    if (element instanceof String) {
                        list.add(new SelectItem(element));
                        continue;
                    }
                    throw new IllegalArgumentException("SelectItems's value MUST BE SelectItem(s) or String(s)");
                }
                continue;
            }
            if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key == null || val == null) continue;
                    list.add(new SelectItem((Object)key.toString(), val.toString()));
                }
                continue;
            }
            throw new IllegalArgumentException("SelectItems's value MUST BE SelectItem(s) or String(s)");
        }
        return list;
    }

    public int getSelectItemCount(FacesContext context, UIComponent component) {
        int itemCount = 0;
        for (SelectItem item : this.getSelectItems(context, component)) {
            ++itemCount;
            if (!(item instanceof SelectItemGroup)) continue;
            itemCount += ((SelectItemGroup)item).getSelectItems().length;
        }
        return itemCount;
    }

    protected Object[] getSubmittedSelectedValues(FacesContext context, UIComponent component) {
        if (component instanceof UISelectMany) {
            return (Object[])((UISelectMany)component).getSubmittedValue();
        }
        Object value = ((UISelectOne)component).getSubmittedValue();
        if (value == null) {
            return null;
        }
        return new Object[]{value};
    }

    protected Object getCurrentSelectedValues(FacesContext cotnext, UIComponent component) {
        if (component instanceof UISelectMany) {
            Object value = ((UISelectMany)component).getValue();
            if (value == null) {
                return null;
            }
            if (value instanceof List) {
                return ((List)value).toArray();
            }
            if (value.getClass().isArray()) {
                return value;
            }
            return new Object[]{value};
        }
        Object value = ((UISelectOne)component).getValue();
        if (value == null) {
            return null;
        }
        return new Object[]{value};
    }

    public boolean isSelected(FacesContext context, UIComponent component, SelectItem item) {
        Object itemValue = item.getValue();
        String itemStr = this.getFormattedValue(context, component, itemValue);
        return this.isSelected(context, component, itemValue, itemStr);
    }

    protected boolean isSelected(FacesContext context, UIComponent component, Object itemValue, String itemStr) {
        if (component instanceof UISelectMany) {
            return this.isManySelected(context, component, itemValue, itemStr);
        }
        return this.isOneSelected(context, component, itemValue);
    }

    protected boolean isOneSelected(FacesContext context, UIComponent component, Object itemValue) {
        String currentValue = this.getCurrentValue(context, component);
        if (currentValue == null) {
            return itemValue == null;
        }
        Class<?> itemType = currentValue.getClass();
        itemValue = TypeCoercion.coerce((Object)itemValue, itemType);
        return currentValue.equals(itemValue);
    }

    protected boolean isManySelected(FacesContext context, UIComponent component, Object itemValue, String itemStr) {
        Object currentValues;
        Object[] submittedValues = this.getSubmittedSelectedValues(context, component);
        if (submittedValues != null) {
            int len = submittedValues.length;
            for (int i = 0; i < len; ++i) {
                if (!submittedValues[i].equals(itemStr)) continue;
                return true;
            }
        }
        if ((currentValues = this.getCurrentSelectedValues(context, component)) != null) {
            Class<?> elementType = currentValues.getClass().getComponentType();
            itemValue = TypeCoercion.coerce((Object)itemValue, elementType);
            int len = Array.getLength(currentValues);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(currentValues, i);
                if (!(value == null ? itemValue == null : value.equals(itemValue))) continue;
                return true;
            }
        }
        return false;
    }
}

