/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.render.resource.GlobalResourceService;
import org.operamasks.faces.render.resource.ResourceService;
import org.operamasks.faces.util.LoggerUtil;

public class ResourceServiceManager {
    private static final String SERVICES_FILE_NAME = "META-INF/faces.resource.services";
    private List<ResourceService> services = new CopyOnWriteArrayList<ResourceService>();
    private GlobalResourceService global = new GlobalResourceService();

    public static ResourceServiceManager getInstance(FacesContext context) {
        ApplicationAssociate assoc = ApplicationAssociate.getInstance(context);
        return assoc.getSingleton(ResourceServiceManager.class);
    }

    private ResourceServiceManager() {
        this.init();
    }

    public void registerResourceService(ResourceService service) {
        this.services.add(service);
    }

    public void unregisterResourceService(ResourceService service) {
        this.services.remove(service);
    }

    public void service(FacesContext context) throws IOException {
        for (ResourceService service : this.services) {
            service.service(context);
            if (!context.getResponseComplete()) continue;
            return;
        }
        this.global.service(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Logger logger = LoggerUtil.getLogger("org.operamasks.faces.view");
        try {
            Enumeration<URL> urls = cl == null ? ClassLoader.getSystemResources(SERVICES_FILE_NAME) : cl.getResources(SERVICES_FILE_NAME);
            HashSet classes = new HashSet();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream stream = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    String name;
                    while ((name = reader.readLine()) != null) {
                        if ((name = name.trim()).length() == 0) continue;
                        try {
                            Class<?> clazz = cl == null ? Class.forName(name) : cl.loadClass(name);
                            if (classes.contains(clazz)) continue;
                            ResourceService service = (ResourceService)clazz.newInstance();
                            this.registerResourceService(service);
                            classes.add(clazz);
                        }
                        catch (Exception ex) {
                            logger.log(Level.SEVERE, "Could not load resource service: " + name, ex);
                        }
                    }
                }
                finally {
                    stream.close();
                    reader.close();
                }
            }
            return;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Load resource services failed.", ex);
        }
    }
}

