/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.HtmlPageStub;
import org.operamasks.faces.render.resource.SkinDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinManager {
    public static final String SKIN_PARAM = "org.operamasks.faces.SKIN";
    public static final String DEFAULT_SKIN = "default";
    private static final String SKINS_FILE = "META-INF/resource/skins.xml";
    private Map<String, SkinDescriptor> skins = Collections.unmodifiableMap(SkinManager.loadSkins());
    private String defaultSkin;

    public static SkinManager getInstance(FacesContext context) {
        return ApplicationAssociate.getInstance(context).getSingleton(SkinManager.class);
    }

    private SkinManager() {
        ExternalContext extctx = FacesContext.getCurrentInstance().getExternalContext();
        String skin = extctx.getInitParameter(SKIN_PARAM);
        if (skin == null || skin.length() == 0) {
            skin = DEFAULT_SKIN;
        }
        this.defaultSkin = skin;
    }

    public String getDefaultSkin() {
        return this.defaultSkin;
    }

    public void setDefaultSkin(String skin) {
        if (skin == null || skin.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.defaultSkin = skin;
    }

    public Map<String, SkinDescriptor> getSkins() {
        return this.skins;
    }

    public SkinDescriptor getSkin(String name) {
        return this.skins.get(name);
    }

    public static String getCurrentSkin(FacesContext context) {
        String skin;
        UIComponent page = (UIComponent)FacesUtils.findComponent((UIComponent)context.getViewRoot(), HtmlPageStub.class);
        if (page != null && (skin = (String)page.getAttributes().get("skin")) != null && skin.length() != 0) {
            return skin;
        }
        ExternalContext extctx = context.getExternalContext();
        if (extctx.getSession(false) != null && (skin = (String)extctx.getSessionMap().get(SKIN_PARAM)) != null && skin.length() != 0) {
            return skin;
        }
        return SkinManager.getInstance(context).getDefaultSkin();
    }

    public static void setCurrentSkin(FacesContext context, String skin) {
        if (skin == null) {
            throw new NullPointerException();
        }
        if (skin.length() == 0) {
            throw new IllegalArgumentException("Empty skin name");
        }
        ExternalContext ectx = context.getExternalContext();
        ectx.getSessionMap().put(SKIN_PARAM, skin);
    }

    private static Map<String, SkinDescriptor> loadSkins() {
        LinkedHashMap<String, SkinDescriptor> skins = new LinkedHashMap<String, SkinDescriptor>();
        try {
            ClassLoader loader = SkinManager.getClassLoader();
            Enumeration<URL> resources = loader.getResources(SKINS_FILE);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream stream = url.openStream();
                SkinManager.load(stream, skins);
                stream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return skins;
    }

    private static void load(InputStream stream, Map<String, SkinDescriptor> skins) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(false);
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(stream);
            ArrayList<String> extraProps = new ArrayList<String>();
            extraProps.add("description");
            extraProps.add("authorName");
            extraProps.add("authorEmail");
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("skin");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element skinEle = (Element)nodeList.item(i);
                String id = skinEle.getAttribute("id");
                String file = skinEle.getAttribute("file");
                SkinDescriptor skinDescriptor = new SkinDescriptor(id, file);
                NodeList displayNameNodeList = skinEle.getElementsByTagName("displayName");
                if (displayNameNodeList.getLength() > 0) {
                    Locale l;
                    String locale;
                    Element displayEle;
                    if (displayNameNodeList.item(0).getFirstChild() != null && displayNameNodeList.item(0).getFirstChild().getNodeType() == 4) {
                        for (int j = 0; j < displayNameNodeList.getLength(); ++j) {
                            displayEle = (Element)displayNameNodeList.item(j);
                            locale = displayEle.getAttribute("locale");
                            if (locale != null && locale.length() > 0) {
                                l = SkinManager.parseLocale(locale);
                                skinDescriptor.setDisplayName(l, displayNameNodeList.item(0).getFirstChild().getNodeValue());
                                continue;
                            }
                            skinDescriptor.setDisplayName(Locale.ENGLISH, displayNameNodeList.item(0).getFirstChild().getNodeValue());
                        }
                    } else {
                        for (int j = 0; j < displayNameNodeList.getLength(); ++j) {
                            displayEle = (Element)displayNameNodeList.item(j);
                            locale = displayEle.getAttribute("locale");
                            if (locale != null && locale.length() > 0) {
                                l = SkinManager.parseLocale(locale);
                                skinDescriptor.setDisplayName(l, displayNameNodeList.item(0).getTextContent());
                                continue;
                            }
                            skinDescriptor.setDisplayName(Locale.ENGLISH, displayNameNodeList.item(0).getFirstChild().getNodeValue());
                        }
                    }
                }
                for (String prop : extraProps) {
                    NodeList propNodeList = skinEle.getElementsByTagName(prop);
                    if (propNodeList.getLength() <= 0) continue;
                    if (propNodeList.item(0).getFirstChild() != null && propNodeList.item(0).getFirstChild().getNodeType() == 4) {
                        skinDescriptor.setProperty(prop, propNodeList.item(0).getFirstChild().getNodeValue());
                        continue;
                    }
                    skinDescriptor.setProperty(prop, propNodeList.item(0).getTextContent());
                }
                skins.put(id, skinDescriptor);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Locale parseLocale(String locale) {
        int j = locale.indexOf("_");
        if (j >= 0) {
            String language = locale.substring(0, j);
            String country = locale.length() > j + 1 ? locale.substring(j + 1) : "";
            return new Locale(language, country);
        }
        String language = locale;
        return new Locale(language);
    }

    private static ClassLoader getClassLoader() {
        ApplicationAssociate associate = ApplicationAssociate.getInstance();
        if (associate != null) {
            return associate.getClassLoader();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }
}

