/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.operamasks.faces.debug.Debug;
import org.operamasks.faces.debug.DebugMode;
import org.operamasks.faces.render.ajax.AjaxRenderKitImpl;

public class PhaseMonitorListener
implements PhaseListener {
    public static final String PHASE_ID = "org.operamasks.faces.render.widget.PhaseMonitor.phaseId";
    private static final String KEY_BEFORE_PHASE = "BEFORE_PHASE";
    private static final String KEY_AFTER_PHASE = "AFTER_PHASE";
    private static final String KEY_MISC_INFO = "MISC_INFO";
    private static final String KEY_REQUEST_START_TIME = "org.operamasks.faces.RequestStartTime";
    private static final String KEY_VALIDATION_ERROR = "VALIDATION_ERROR";

    public void afterPhase(PhaseEvent event) {
        FacesContext facesContext;
        Iterator iter;
        FacesContext context = event.getFacesContext();
        Logger logger = Debug.getLogger();
        if (event.getPhaseId() == PhaseId.PROCESS_VALIDATIONS && Debug.isEnabled(DebugMode.EXCEPTION) && (iter = (facesContext = FacesContext.getCurrentInstance()).getMessages()) != null && iter.hasNext()) {
            while (iter.hasNext()) {
                FacesMessage message = (FacesMessage)iter.next();
                Debug.getLogger().log(Level.INFO, KEY_VALIDATION_ERROR, new Object[]{message.getSeverity(), message.getSummary(), message.getDetail()});
            }
        }
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE && Debug.isEnabled(context, DebugMode.MISC)) {
            logger.log(Level.INFO, KEY_MISC_INFO, new Object[]{context.getViewRoot().getViewId(), this.getResponseMode(context), this.getRenderKitId(context), this.getResponseTime(context)});
        }
        if (this.isDebugPhase(event)) {
            logger.log(Level.INFO, KEY_AFTER_PHASE, event.getPhaseId());
        }
    }

    private Object getResponseTime(FacesContext context) {
        long startTime = (Long)context.getExternalContext().getRequestMap().get(KEY_REQUEST_START_TIME);
        return System.currentTimeMillis() - startTime;
    }

    private boolean isDebugPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        DebugMode phaseDebugMode = Debug.DEBUG_MODE_LIFECYCLE_PHASES[event.getPhaseId().getOrdinal() - 1];
        return Debug.isEnabled(context, phaseDebugMode);
    }

    private String getResponseMode(FacesContext context) {
        String responseMode = "HTML Response";
        if (AjaxRenderKitImpl.isAjaxResponse(context)) {
            responseMode = "AJAX Response";
        }
        return responseMode;
    }

    private String getRenderKitId(FacesContext context) {
        String renderKitId = context.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            renderKitId = context.getApplication().getDefaultRenderKitId();
        }
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        return renderKitId;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        Logger logger = Debug.getLogger();
        if (this.isDebugPhase(event)) {
            logger.log(Level.INFO, KEY_BEFORE_PHASE, event.getPhaseId());
        }
        context.getExternalContext().getRequestMap().put(PHASE_ID, event.getPhaseId());
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            long startTime = System.currentTimeMillis();
            context.getExternalContext().getRequestMap().put(KEY_REQUEST_START_TIME, startTime);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

