/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.yuiext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentOperationManager {
    private static final String COMPONENT_MANAGER_PARAM = "org.operamasks.faces.COMPONENT_OPERATION_MANAGER";
    private static final String HANDLER_METHOD_NAME = "handleOperation";
    private StringBuffer initScript = new StringBuffer();
    private StringBuffer endScript = new StringBuffer();
    private StringBuffer lastScript = new StringBuffer();
    private StringBuffer operationScript = new StringBuffer();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private static final Class[] OPERATION_METHOD_SIGNATURE = new Class[]{FacesContext.class, UIComponent.class};
    private static final Class[] HANDLE_METHOD_SIGNATURE = new Class[]{String.class, FacesContext.class, UIComponent.class};
    private static final String RESOURCE_EXT = ".properties";
    private static final String RESOURE_PREFIX = "/_global/resource/cscript/";
    private static final String URL_CACHE_KEY = ComponentOperationManager.class.getName() + ".url.cache.key";
    private List<Command> commandQueue = new LinkedList<Command>();

    public static ComponentOperationManager getInstance(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ComponentOperationManager cm = (ComponentOperationManager)requestMap.get(COMPONENT_MANAGER_PARAM);
        if (cm == null) {
            cm = new ComponentOperationManager();
            requestMap.put(COMPONENT_MANAGER_PARAM, cm);
        }
        return cm;
    }

    private ComponentOperationManager() {
    }

    public void invoke(FacesContext context, String operationName, UIComponent component) {
        this.commandQueue.add(new Command(context, operationName, component, this.attributes));
        this.attributes.clear();
    }

    public void addOperationScript(String s) {
        this.endScript.append(s);
    }

    public void addLastScript(String s) {
        this.lastScript.append(s);
    }

    public void encodeOperationScript(String operationName, FacesContext context, UIComponent component, Map<String, Object> valueContext) {
        String s = this.getMergedScript(operationName, context, component, valueContext);
        if (s == null || s.length() == 0) {
            s = String.format("%s.%s();\n", FacesUtils.getJsvar(context, component), operationName);
        }
        this.operationScript.append(s);
    }

    public String getMergedScript(String operationName, FacesContext context, UIComponent component, Map valueContext) {
        String script = this.getOperationScript(operationName, context, component);
        script = this.merge(script, valueContext);
        script = this.merge(script, this.attributes);
        return script;
    }

    private void renderAndInvoke(FacesContext context, String operationName, UIComponent component, Map<String, Object> valueContext) {
        if (!FacesUtils.shouldComponentBeRendered(component)) {
            return;
        }
        this.encodeOperationScript(operationName, context, component, valueContext);
        Renderer renderer = FacesUtils.getRenderer(context, component);
        if (renderer != null) {
            this.invokeRenderer(context, renderer, operationName, component);
        }
    }

    private String merge(String opScript, Map<String, Object> valueContext) {
        if (opScript == null) {
            return null;
        }
        String result = opScript;
        if (null != valueContext) {
            for (Map.Entry<String, Object> entry : valueContext.entrySet()) {
                String key = entry.getKey();
                String variable = "\\Q${" + key + "}";
                String value = entry.getValue().toString();
                result = result.replaceAll(variable, Matcher.quoteReplacement(value));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOperationScript(String operationName, FacesContext context, UIComponent component) {
        Map<Class<? extends UIComponent>, PropCache> propCaches = ComponentOperationManager.getURLCache(context);
        Class<?> clazz = component.getClass();
        PropCache cache = propCaches.get(clazz);
        boolean propCached = true;
        if (cache == null) {
            Map<Class<? extends UIComponent>, PropCache> map = propCaches;
            synchronized (map) {
                if (!propCaches.containsKey(clazz)) {
                    cache = new PropCache();
                    propCaches.put(clazz, cache);
                    propCached = false;
                } else {
                    cache = propCaches.get(clazz);
                }
            }
        }
        if (propCached && cache.getProps() == null) {
            return null;
        }
        Properties props = cache.getProps();
        if (props == null) {
            URL url = this.getResourceURL(context, component.getClass());
            if (url == null) {
                return null;
            }
            props = new Properties();
            InputStream in = null;
            try {
                in = url.openStream();
                props.load(in);
                cache.setProps(props);
            }
            catch (IOException e) {
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        String script = null;
        String operationValue = null;
        try {
            operationValue = OMUtils.getFieldValueString(component, operationName);
            if (operationValue != null) {
                operationValue = operationValue.toLowerCase();
                String operationWithValue = operationName + "." + OMUtils.getFieldValueString(component, operationName).toLowerCase();
                script = props.getProperty(operationWithValue);
                if (script == null) {
                    script = props.getProperty(operationName);
                }
                if (script != null) {
                    script = script.replaceAll("\\Q${value}", operationValue);
                }
            }
        }
        catch (NoSuchFieldException ex) {
            script = props.getProperty(operationName);
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class<? extends UIComponent>, PropCache> getURLCache(FacesContext context) {
        Map appMap = context.getExternalContext().getApplicationMap();
        Map urlcache = (HashMap)appMap.get(URL_CACHE_KEY);
        if (urlcache == null) {
            Map map = appMap;
            synchronized (map) {
                if (!appMap.containsKey(URL_CACHE_KEY)) {
                    urlcache = new HashMap();
                    appMap.put(URL_CACHE_KEY, urlcache);
                } else {
                    urlcache = (Map)appMap.get(URL_CACHE_KEY);
                }
            }
        }
        return urlcache;
    }

    private URL getResourceURL(FacesContext context, Class<? extends UIComponent> componentClass) {
        Class<? extends UIComponent> clz = componentClass;
        while (clz.getSuperclass() != null) {
            String res = clz.getName().replace('.', '/').concat(RESOURCE_EXT);
            URL url = null;
            try {
                url = ResourceManager.getInstance(context).getLocalResource(RESOURE_PREFIX + res);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (url != null) {
                return url;
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    private void invokeRenderer(FacesContext context, Renderer renderer, String operationName, UIComponent component) {
        Class<?> rendererClass = renderer.getClass();
        Method opMethod = this.getOperationMethod(rendererClass, operationName);
        if (null != opMethod) {
            try {
                opMethod.invoke((Object)renderer, context, component);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new FacesException(e.getTargetException());
            }
        } else {
            Method handlerMethod = this.getHandlerMethod(rendererClass, operationName);
            if (null != handlerMethod) {
                try {
                    handlerMethod.invoke((Object)renderer, operationName, context, component);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    throw new FacesException(e.getTargetException());
                }
            }
        }
    }

    private Method getHandlerMethod(Class rendererClass, String operationName) {
        Method method = null;
        try {
            method = rendererClass.getMethod(HANDLER_METHOD_NAME, HANDLE_METHOD_SIGNATURE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    private Method getOperationMethod(Class rendererClass, String operationName) {
        Method method = null;
        try {
            method = rendererClass.getMethod(operationName, OPERATION_METHOD_SIGNATURE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.writeScript(context, this.initScript);
    }

    private void executeCommand() {
        for (Command cmd : this.commandQueue) {
            String clientId;
            if (cmd == null) continue;
            String jsvar = FacesUtils.getJsvar(cmd.context, cmd.component);
            if (jsvar != null && jsvar.length() > 0) {
                cmd.valueContext.put("jsvar", jsvar);
            }
            String string = clientId = cmd.component != null ? cmd.component.getClientId(cmd.context) : null;
            if (clientId != null && clientId.length() > 0) {
                cmd.valueContext.put("clientId", clientId);
            }
            if (cmd.component == null) continue;
            this.renderAndInvoke(cmd.context, cmd.operationName, cmd.component, cmd.valueContext);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.executeCommand();
        this.writeScript(context, this.operationScript, this.endScript, this.lastScript);
    }

    private void writeScript(FacesContext context, StringBuffer ... script) throws IOException {
        int len = 0;
        for (StringBuffer buf : script) {
            len += buf.length();
        }
        if (len != 0) {
            ResponseWriter out = context.getResponseWriter();
            if (out instanceof AjaxResponseWriter) {
                String s = this.encodeAjaxInitScript(script);
                ((AjaxResponseWriter)out).writeActionScript(s);
            } else {
                String s = this.encodeInitScript(script);
                out.write(s);
            }
        }
    }

    private String encodeInitScript(StringBuffer ... scripts) {
        boolean catchException = ComponentResource.getCatchAllException();
        String catchBegin = catchException ? "OM.E(function(){" : "";
        String catchEnd = catchException ? "});" : "";
        StringBuilder buf = new StringBuilder();
        buf.append("<script type=\"text/javascript\">\n<!--\n");
        buf.append(catchBegin + "Ext.onReady(function(){\n");
        for (StringBuffer s : scripts) {
            buf.append(s);
        }
        buf.append("\n});" + catchEnd + "\n");
        buf.append("//-->\n</script>\n");
        return buf.toString();
    }

    private String encodeAjaxInitScript(StringBuffer ... scripts) {
        StringBuilder buf = new StringBuilder();
        buf.append("(function(){");
        for (StringBuffer s : scripts) {
            buf.append(s);
        }
        buf.append("})();");
        return buf.toString();
    }

    public void addInitScript(String script) {
        this.initScript.append(script);
    }

    public void addEndScript(String script) {
        this.endScript.append(script);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void reset() {
        this.initScript.setLength(0);
        this.endScript.setLength(0);
        this.lastScript.setLength(0);
        this.operationScript.setLength(0);
        this.attributes.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Command {
        FacesContext context;
        String operationName;
        UIComponent component;
        Map<String, Object> valueContext = new HashMap<String, Object>();

        Command(FacesContext context, String operationName, UIComponent component, Map<String, Object> attrs) {
            this.context = context;
            this.operationName = operationName;
            this.component = component;
            this.valueContext.putAll(attrs);
        }
    }

    private static class PropCache {
        private Properties props;

        private PropCache() {
        }

        public Properties getProps() {
            return this.props;
        }

        public void setProps(Properties props) {
            this.props = props;
        }
    }
}

