/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;
import javax.faces.context.FacesContext;

public final class HtmlEncoder {
    private static String[] ISO8859_1_ENTITIES;
    private static BitSet dontNeedEncoding;
    private static final int maxBytesPerChar = 10;

    public static void encode(Writer out, String s) throws IOException {
        int length = s.length();
        if (length == 0) {
            return;
        }
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            String escape = HtmlEncoder.encodeSingle(ch);
            if (escape == null) continue;
            if (start < i) {
                out.write(s.substring(start, i));
            }
            start = i + 1;
            out.write(escape);
        }
        if (start == 0) {
            out.write(s);
        } else if (start < length) {
            out.write(s.substring(start, length));
        }
    }

    public static String encode(String s) {
        int length = s.length();
        if (length == 0) {
            return "";
        }
        StringBuffer out = null;
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            String escape = HtmlEncoder.encodeSingle(ch);
            if (escape == null) continue;
            if (out == null) {
                out = new StringBuffer();
            }
            if (start < i) {
                out.append(s.substring(start, i));
            }
            start = i + 1;
            out.append(escape);
        }
        if (out == null) {
            return s;
        }
        if (start < length) {
            out.append(s.substring(start, length));
        }
        return out.toString();
    }

    public static void encode(Writer out, char[] text, int off, int len) throws IOException {
        if (off < 0 || off > text.length || len < 0 || off + len > text.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int start = off;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = text[i];
            String escape = HtmlEncoder.encodeSingle(ch);
            if (escape == null) continue;
            if (start < i) {
                out.write(text, start, i - start);
            }
            out.write(escape);
            start = i + 1;
        }
        if (start < end) {
            out.write(text, start, end - start);
        }
    }

    public static String encode(char[] text, int off, int len) {
        if (off < 0 || off > text.length || len < 0 || off + len > text.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return "";
        }
        StringBuffer out = null;
        int start = off;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = text[i];
            String escape = HtmlEncoder.encodeSingle(ch);
            if (escape == null) continue;
            if (out == null) {
                out = new StringBuffer();
            }
            if (start < i) {
                out.append(text, start, i - start);
            }
            out.append(escape);
            start = i + 1;
        }
        if (out == null) {
            return new String(text, off, len);
        }
        if (start < end) {
            out.append(text, start, end - start);
        }
        return out.toString();
    }

    private static String encodeSingle(char ch) {
        if (ch >= '\"' && ch <= '>') {
            if (ch == '<') {
                return "&lt;";
            }
            if (ch == '>') {
                return "&gt;";
            }
            if (ch == '\"') {
                return "&quot;";
            }
            if (ch == '\'') {
                return "&#39;";
            }
        } else if (ch >= '\u00a0') {
            if (ch <= '\u00ff') {
                return ISO8859_1_ENTITIES[ch - 160];
            }
            return String.valueOf(ch);
        }
        return null;
    }

    public static void encodeURI(Writer out, String s, String clientEncoding) throws IOException {
        HtmlEncoder.encodeURI(out, s, clientEncoding, true);
    }

    public static void encodeURIComponent(Writer out, String s, String clientEncoding) throws IOException {
        HtmlEncoder.encodeURI(out, s, clientEncoding, false);
    }

    private static void encodeURI(Writer out, String s, String clientEncoding, boolean beforeQuery) throws IOException {
        int length = s.length();
        if (length == 0) {
            return;
        }
        CharsetEncoder utf8Encoder = null;
        CharsetEncoder clientEncoder = null;
        CharBuffer charBuf = null;
        ByteBuffer byteBuf = null;
        int start = 0;
        for (int i = 0; i < length; ++i) {
            boolean needEscape;
            char ch = s.charAt(i);
            CharsetEncoder encoder = null;
            if (beforeQuery) {
                boolean bl = needEscape = ch <= ' ' || ch >= '\u007f' || ch == '\"';
                if (needEscape) {
                    if (utf8Encoder == null) {
                        utf8Encoder = Charset.forName("UTF-8").newEncoder();
                    }
                    encoder = utf8Encoder;
                }
                if (ch == '?') {
                    beforeQuery = false;
                }
            } else {
                boolean bl = needEscape = !dontNeedEncoding.get(ch);
                if (needEscape) {
                    if (clientEncoder == null) {
                        clientEncoder = Charset.forName(clientEncoding).newEncoder();
                    }
                    encoder = clientEncoder;
                }
            }
            if (needEscape) {
                if (start < i) {
                    out.write(s.substring(start, i));
                }
                start = i + 1;
                if (charBuf == null) {
                    charBuf = CharBuffer.allocate(1);
                    byteBuf = ByteBuffer.allocate(10);
                } else {
                    charBuf.clear();
                    byteBuf.clear();
                }
                try {
                    assert (encoder != null);
                    charBuf.put(ch).flip();
                    encoder.encode(charBuf, byteBuf, true);
                    byteBuf.flip();
                }
                catch (Exception ex) {
                    encoder.reset();
                    continue;
                }
                byte[] ba = byteBuf.array();
                int lim = byteBuf.limit();
                for (int j = 0; j < lim; ++j) {
                    int b = ba[j] & 0xFF;
                    out.write(37);
                    out.write(HtmlEncoder.intToHex(b >> 4 & 0xF));
                    out.write(HtmlEncoder.intToHex(b & 0xF));
                }
                encoder.reset();
                continue;
            }
            if (ch != ' ') continue;
            if (start < i) {
                out.write(s.substring(start, i));
            }
            start = i + 1;
            out.write(43);
        }
        if (start == 0) {
            out.write(s);
        } else if (start < length) {
            out.write(s.substring(start, length));
        }
    }

    public static String encodeURI(String s, String encoding) {
        StringWriter out = new StringWriter();
        try {
            HtmlEncoder.encodeURI(out, s, encoding, true);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toString();
    }

    public static String encodeURIComponent(String s, String encoding) {
        StringWriter out = new StringWriter();
        try {
            HtmlEncoder.encodeURI(out, s, encoding, false);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toString();
    }

    public static String encodeURI(String s) {
        return HtmlEncoder.encodeURI(s, HtmlEncoder.getCurrentEncoding());
    }

    public static String encodeURIComponent(String s) {
        return HtmlEncoder.encodeURIComponent(s, HtmlEncoder.getCurrentEncoding());
    }

    private static String getCurrentEncoding() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getResponseWriter() != null) {
            return context.getResponseWriter().getCharacterEncoding();
        }
        return context.getExternalContext().getResponseCharacterEncoding();
    }

    private static char intToHex(int i) {
        return i < 10 ? (char)(48 + i) : (char)(65 + i - 10);
    }

    public static String enquote(String s) {
        return HtmlEncoder.enquote(s, Character.valueOf('\''));
    }

    public static String enquote(String s, Character quoteChar) {
        StringBuilder buf = new StringBuilder();
        if (quoteChar != null) {
            buf.append(quoteChar);
        }
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    if (quoteChar.charValue() == c) {
                        buf.append('\\');
                    }
                    buf.append(c);
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (quoteChar != null) {
            buf.append(quoteChar);
        }
        return buf.toString();
    }

    private HtmlEncoder() {
    }

    static {
        int i;
        ISO8859_1_ENTITIES = new String[]{"&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;"};
        dontNeedEncoding = new BitSet();
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(37);
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(35);
        dontNeedEncoding.set(38);
        dontNeedEncoding.set(61);
        dontNeedEncoding.set(47);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(33);
        dontNeedEncoding.set(126);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(39);
        dontNeedEncoding.set(40);
        dontNeedEncoding.set(41);
    }
}

