/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class JSPacker {
    private static final int EOF = -1;
    private PushbackInputStream in;
    private OutputStream out;
    private int theA;
    private int theB;

    public JSPacker(InputStream in, OutputStream out) {
        this.in = new PushbackInputStream(in);
        this.out = out;
    }

    private static boolean isAlphanum(int c) {
        return c >= 97 && c <= 122 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c == 95 || c == 36 || c == 92 || c > 126;
    }

    private int get() throws IOException {
        int c = this.in.read();
        if (c >= 32 || c == 10 || c == -1) {
            return c;
        }
        if (c == 13) {
            return 10;
        }
        return 32;
    }

    private int peek() throws IOException {
        int lookaheadChar = this.in.read();
        this.in.unread(lookaheadChar);
        return lookaheadChar;
    }

    private int next() throws IOException {
        int c = this.get();
        if (c == 47) {
            switch (this.peek()) {
                case 47: {
                    while ((c = this.get()) > 10) {
                    }
                    return c;
                }
                case 42: {
                    this.get();
                    while (true) {
                        switch (this.get()) {
                            case 42: {
                                if (this.peek() != 47) break;
                                this.get();
                                return 32;
                            }
                            case -1: {
                                return -1;
                            }
                        }
                    }
                }
            }
            return c;
        }
        return c;
    }

    private void action(int d) throws IOException {
        switch (d) {
            case 1: {
                this.out.write(this.theA);
            }
            case 2: {
                this.theA = this.theB;
                if (this.theA == 39 || this.theA == 34) {
                    while (true) {
                        this.out.write(this.theA);
                        this.theA = this.get();
                        if (this.theA == this.theB || this.theA <= 10) break;
                        if (this.theA != 92) continue;
                        this.out.write(this.theA);
                        this.theA = this.get();
                    }
                }
            }
            case 3: {
                this.theB = this.next();
                if (this.theB != 47 || this.theA != 40 && this.theA != 44 && this.theA != 61) break;
                this.out.write(this.theA);
                this.out.write(this.theB);
                while (true) {
                    this.theA = this.get();
                    if (this.theA == 47) break;
                    if (this.theA == 92) {
                        this.out.write(this.theA);
                        this.theA = this.get();
                    } else if (this.theA <= 10) {
                        this.out.write(this.theA);
                        break;
                    }
                    this.out.write(this.theA);
                }
                this.theB = this.next();
            }
        }
    }

    public void pack() throws IOException {
        this.theA = 10;
        this.action(3);
        block15: while (this.theA != -1) {
            switch (this.theA) {
                case 32: {
                    if (JSPacker.isAlphanum(this.theB)) {
                        this.action(1);
                        continue block15;
                    }
                    this.action(2);
                    continue block15;
                }
                case 10: {
                    switch (this.theB) {
                        case 40: 
                        case 43: 
                        case 45: 
                        case 91: 
                        case 123: {
                            this.action(1);
                            continue block15;
                        }
                        case 32: {
                            this.action(3);
                            continue block15;
                        }
                    }
                    if (JSPacker.isAlphanum(this.theB)) {
                        this.action(1);
                        continue block15;
                    }
                    this.action(2);
                    continue block15;
                }
            }
            switch (this.theB) {
                case 32: {
                    if (JSPacker.isAlphanum(this.theA)) {
                        this.action(1);
                        continue block15;
                    }
                    this.action(3);
                    continue block15;
                }
                case 10: {
                    switch (this.theA) {
                        case 34: 
                        case 39: 
                        case 41: 
                        case 43: 
                        case 45: 
                        case 93: 
                        case 125: {
                            this.action(1);
                            continue block15;
                        }
                    }
                    if (JSPacker.isAlphanum(this.theA)) {
                        this.action(1);
                        continue block15;
                    }
                    this.action(3);
                    continue block15;
                }
            }
            this.action(1);
        }
        this.out.flush();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                JSPacker.packFile(System.in, System.out);
            } else if (args.length == 1) {
                JSPacker.packFile(new FileInputStream(args[0]), System.out);
            } else {
                File inFile = new File(args[0]);
                File outFile = new File(args[1]);
                if (inFile.isDirectory()) {
                    JSPacker.packDirectory(inFile, outFile);
                } else {
                    JSPacker.packFile(new FileInputStream(args[0]), new FileOutputStream(args[1]));
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage() + ": not found.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void packFile(InputStream in, OutputStream out) throws IOException {
        JSPacker packer = new JSPacker(in, out);
        packer.pack();
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packDirectory(File srcDir, File dstDir) throws IOException {
        String[] filenames = srcDir.list();
        if (filenames == null) {
            return;
        }
        FileInputStream srcInputStream = null;
        FileOutputStream dstOutputStream = null;
        try {
            for (String filename : filenames) {
                File srcFile = new File(srcDir, filename);
                File dstFile = new File(dstDir, filename);
                if (srcFile.isFile() && filename.endsWith(".js")) {
                    if (!dstDir.exists() && !dstDir.mkdirs()) {
                        System.err.println("make directory fails.");
                    }
                    srcInputStream = new FileInputStream(srcFile);
                    dstOutputStream = new FileOutputStream(dstFile);
                    JSPacker.packFile(srcInputStream, dstOutputStream);
                } else if (srcFile.isDirectory()) {
                    JSPacker.packDirectory(srcFile, dstFile);
                }
                srcInputStream.close();
                dstOutputStream.close();
            }
        }
        finally {
            if (srcInputStream != null) {
                srcInputStream.close();
            }
            if (dstOutputStream != null) {
                dstOutputStream.close();
            }
        }
    }
}

