/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util.jsformatter;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.operamasks.faces.util.jsformatter.TokenType;

public class JSFormatter {
    private ArrayList<String> output;
    private String input;
    private String token_text;
    private String last_text;
    private String last_last_text;
    private String last_word;
    private Flag flags;
    private ArrayList<Flag> flag_store;
    private String indent_string;
    private String whitespace = "\n\r\t ";
    private String wordchar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$";
    private String digits = "0123456789";
    private String[] punct;
    private String[] line_starters;
    private int parser_pos;
    private String prefix;
    private TokenType token_type;
    private TokenType last_type;
    private boolean do_block_just_closed;
    private boolean wanted_newline;
    private int n_newlines;
    private boolean just_added_newline;
    private int input_length;
    private boolean opt_braces_on_own_line = false;
    private int opt_indent_size = 4;
    private char opt_indent_char = (char)32;
    private boolean opt_preserve_newlines = false;
    private int opt_indent_level = 0;
    private boolean opt_space_after_anon_function = true;
    private boolean opt_keep_array_indentation = false;

    public JSFormatter() {
        this.punct = "+ - * / % & ++ -- = += -= *= /= %= == === != !== > < >= <= >> << >>> >>>= >>= <<= && &= | || ! !! , : ? ^ ^= |= ::".split(" ");
        this.line_starters = "continue,try,throw,return,var,if,switch,case,default,for,while,break,function".split(",");
    }

    private void init() {
        this.output = null;
        this.last_word = null;
        this.last_last_text = null;
        this.last_text = null;
        this.token_text = null;
        this.flags = null;
        this.flag_store = null;
        this.indent_string = null;
        this.parser_pos = 0;
        this.prefix = null;
        this.token_type = null;
        this.last_type = null;
        this.do_block_just_closed = false;
        this.wanted_newline = false;
        this.n_newlines = 0;
        this.just_added_newline = false;
        this.input_length = 0;
    }

    public void setBraces_on_own_line(boolean optBracesOnOwnLine) {
        this.opt_braces_on_own_line = optBracesOnOwnLine;
    }

    public void setIndent_size(int optIndentSize) {
        this.opt_indent_size = optIndentSize;
    }

    public void setIndent_char(char optIndentChar) {
        this.opt_indent_char = optIndentChar;
    }

    public void setPreserve_newlines(boolean optPreserveNewlines) {
        this.opt_preserve_newlines = optPreserveNewlines;
    }

    public void setIndent_level(int optIndentLevel) {
        this.opt_indent_level = optIndentLevel;
    }

    public void setSpace_after_anon_function(boolean optSpaceAfterAnonFunction) {
        this.opt_space_after_anon_function = optSpaceAfterAnonFunction;
    }

    public void setKeep_array_indentation(boolean optKeepArrayIndentation) {
        this.opt_keep_array_indentation = optKeepArrayIndentation;
    }

    private void trim_output() {
        while (this.output.size() > 0 && (" ".equals(this.output.get(this.output.size() - 1)) || this.indent_string.equals(this.output.get(this.output.size() - 1)))) {
            this.output.remove(this.output.size() - 1);
        }
    }

    private boolean is_array(String mode) {
        return "[EXPRESSION]".equals(mode) || "[INDENTED-EXPRESSION]".equals(mode);
    }

    private void print_newline() {
        this.print_newline(true);
    }

    private void print_newline(boolean ignore_repeated) {
        this.flags.eat_next_space = false;
        if (this.opt_keep_array_indentation && this.is_array(this.flags.mode)) {
            return;
        }
        this.flags.if_line = false;
        this.trim_output();
        if (this.output.size() == 0) {
            return;
        }
        if (!this.output.get(this.output.size() - 1).equals("\n") || !ignore_repeated) {
            this.just_added_newline = true;
            this.output.add("\n");
        }
        for (int i = 0; i < this.flags.indentation_level + (this.flags.var_line && this.flags.var_line_reindented ? 1 : 0); ++i) {
            this.output.add(this.indent_string);
        }
    }

    private void print_single_space() {
        if (this.flags.eat_next_space) {
            this.flags.eat_next_space = false;
            return;
        }
        String last_output = " ";
        if (this.output.size() > 0) {
            last_output = this.output.get(this.output.size() - 1);
        }
        if (!(" ".equals(last_output) || "\n".equals(last_output) || this.indent_string.equals(last_output))) {
            this.output.add(" ");
        }
    }

    private void print_token() {
        this.just_added_newline = false;
        this.flags.eat_next_space = false;
        this.output.add(this.token_text);
    }

    private void indent() {
        this.flags.indentation_level += 1;
    }

    private void remove_indent() {
        int len = this.output.size();
        if (len > 0 && this.indent_string.equals(this.output.get(len - 1))) {
            this.output.remove(len - 1);
        }
    }

    private void set_mode(String mode) {
        Flag old = this.flags;
        if (this.flags != null) {
            this.flag_store.add(this.flags);
        }
        this.flags = new Flag();
        this.flags.mode = mode;
        this.flags.var_line = false;
        this.flags.var_line_tainted = false;
        this.flags.var_line_reindented = false;
        this.flags.in_html_comment = false;
        this.flags.if_line = false;
        this.flags.in_case = false;
        this.flags.eat_next_space = false;
        this.flags.indentation_baseline = -1;
        this.flags.indentation_level = old != null ? old.indentation_level + (old.var_line && old.var_line_reindented ? 1 : 0) : this.opt_indent_level;
    }

    private boolean is_expression(String mode) {
        return "[EXPRESSION]".equals(mode) || "[INDENTED-EXPRESSION]".equals(mode) || "(EXPRESSION)".equals(mode);
    }

    private void restore_mode() {
        this.do_block_just_closed = "DO_BLOCK".equals(this.flags.mode);
        int size = this.flag_store.size();
        if (size > 0) {
            this.flags = this.flag_store.get(size - 1);
            this.flag_store.remove(size - 1);
        }
    }

    private boolean in_array(Object what, Object[] arr) {
        for (Object item : arr) {
            if (!(item == null ? what == null : item.equals(what))) continue;
            return true;
        }
        return false;
    }

    private boolean in_array(char what, String arr) {
        return arr.indexOf(what) >= 0;
    }

    private boolean is_ternary_op() {
        int level = 0;
        int colon_count = 0;
        block7: for (int i = this.output.size() - 1; i >= 0; --i) {
            String t = this.output.get(i);
            if (t.length() > 1) continue;
            switch (t.charAt(0)) {
                case ':': {
                    if (level != 0) continue block7;
                    ++colon_count;
                    continue block7;
                }
                case '?': {
                    if (level != 0) continue block7;
                    if (colon_count == 0) {
                        return true;
                    }
                    --colon_count;
                    continue block7;
                }
                case '{': {
                    if (level == 0) {
                        return false;
                    }
                    --level;
                    continue block7;
                }
                case '(': 
                case '[': {
                    --level;
                    continue block7;
                }
                case ')': 
                case ']': 
                case '}': {
                    ++level;
                }
            }
        }
        return false;
    }

    private Object[] get_next_token() {
        boolean keep_whitespace;
        int n_newlines = 0;
        if (this.parser_pos >= this.input_length) {
            return new Object[]{"", TokenType.TK_EOF};
        }
        boolean wanted_newline = false;
        String c = String.valueOf(this.input.charAt(this.parser_pos));
        char c1 = c.charAt(0);
        ++this.parser_pos;
        boolean bl = keep_whitespace = this.opt_keep_array_indentation && this.is_array(this.flags.mode);
        if (keep_whitespace) {
            int whitespace_count = 0;
            while (this.in_array(c1, this.whitespace)) {
                if (c1 == '\n') {
                    this.trim_output();
                    this.output.add("\n");
                    this.just_added_newline = true;
                    whitespace_count = 0;
                } else {
                    whitespace_count = c1 == '\t' ? (whitespace_count += 4) : ++whitespace_count;
                }
                if (this.parser_pos >= this.input_length) {
                    return new Object[]{"", TokenType.TK_EOF};
                }
                c1 = this.input.charAt(this.parser_pos);
                ++this.parser_pos;
            }
            c = String.valueOf(c1);
            if (this.flags.indentation_baseline == -1) {
                this.flags.indentation_baseline = whitespace_count;
            }
            if (this.just_added_newline) {
                int i;
                for (i = 0; i < this.flags.indentation_level + 1; ++i) {
                    this.output.add(this.indent_string);
                }
                if (this.flags.indentation_baseline != -1) {
                    for (i = 0; i < whitespace_count - this.flags.indentation_baseline; ++i) {
                        this.output.add(" ");
                    }
                }
            }
        } else {
            while (this.in_array(c1, this.whitespace)) {
                if (c1 == '\n') {
                    ++n_newlines;
                }
                if (this.parser_pos >= this.input_length) {
                    return new Object[]{"", TokenType.TK_EOF};
                }
                c1 = this.input.charAt(this.parser_pos);
                ++this.parser_pos;
            }
            c = String.valueOf(c1);
            if (this.opt_preserve_newlines && n_newlines > 1) {
                for (int i = 0; i < n_newlines; ++i) {
                    this.print_newline(i == 0);
                    this.just_added_newline = true;
                }
            }
            boolean bl2 = wanted_newline = n_newlines > 0;
        }
        if (this.in_array(c1, this.wordchar)) {
            if (this.parser_pos < this.input_length) {
                while (this.in_array(this.input.charAt(this.parser_pos), this.wordchar)) {
                    c = c + this.input.charAt(this.parser_pos);
                    ++this.parser_pos;
                    if (this.parser_pos != this.input_length) continue;
                }
            }
            if (this.parser_pos != this.input_length && c.matches("^[0-9]+[Ee]$") && (this.input.charAt(this.parser_pos) == '-' || this.input.charAt(this.parser_pos) == '+')) {
                String sign = String.valueOf(this.input.charAt(this.parser_pos));
                ++this.parser_pos;
                Object[] t = this.get_next_token();
                c = c + sign + t[0];
                return new Object[]{c, TokenType.TK_WORD};
            }
            if ("in".equals(c)) {
                return new Object[]{c, TokenType.TK_OPERATOR};
            }
            if (wanted_newline && TokenType.TK_OPERATOR.equals((Object)this.last_type) && !this.flags.if_line && (this.opt_preserve_newlines || !"var".equals(this.last_text))) {
                this.print_newline();
            }
            return new Object[]{c, TokenType.TK_WORD};
        }
        c1 = c.charAt(0);
        if (c1 == '(' || c1 == '[') {
            return new Object[]{c, TokenType.TK_START_EXPR};
        }
        if (c1 == ')' || c1 == ']') {
            return new Object[]{c, TokenType.TK_END_EXPR};
        }
        if (c1 == '{') {
            return new Object[]{c, TokenType.TK_START_BLOCK};
        }
        if (c1 == '}') {
            return new Object[]{c, TokenType.TK_END_BLOCK};
        }
        if (c1 == ';') {
            return new Object[]{c, TokenType.TK_SEMICOLON};
        }
        if (c1 == '/') {
            String comment = "";
            boolean inline_comment = true;
            if (this.input.charAt(this.parser_pos) == '*') {
                ++this.parser_pos;
                if (this.parser_pos < this.input_length) {
                    while ((this.input.charAt(this.parser_pos) != '*' || this.input.length() <= this.parser_pos + 2 || this.input.charAt(this.parser_pos + 1) != '/') && this.parser_pos < this.input_length) {
                        c1 = this.input.charAt(this.parser_pos);
                        c = String.valueOf(c1);
                        comment = comment + c1;
                        if (c1 == '\n' || c1 == '\r') {
                            inline_comment = false;
                        }
                        ++this.parser_pos;
                        if (this.parser_pos < this.input_length) continue;
                    }
                }
                this.parser_pos += 2;
                if (inline_comment) {
                    return new Object[]{"/*" + comment + "*/", TokenType.TK_INLINE_COMMENT};
                }
                return new Object[]{"/*" + comment + "*/", TokenType.TK_BLOCK_COMMENT};
            }
            if (this.input.charAt(this.parser_pos) == '/') {
                comment = c;
                while (this.input.charAt(this.parser_pos) != '\r' && this.input.charAt(this.parser_pos) != '\n') {
                    comment = comment + this.input.charAt(this.parser_pos);
                    ++this.parser_pos;
                    if (this.parser_pos < this.input_length) continue;
                }
                ++this.parser_pos;
                if (wanted_newline) {
                    this.print_newline();
                }
                return new Object[]{comment, TokenType.TK_COMMENT};
            }
        }
        if (c1 == '\'' || c1 == '\"' || c1 == '/' && (this.last_type == TokenType.TK_WORD && this.in_array(this.last_text, new Object[]{"return", "do"}) || this.last_type == TokenType.TK_START_EXPR || this.last_type == TokenType.TK_START_BLOCK || this.last_type == TokenType.TK_END_BLOCK || this.last_type == TokenType.TK_OPERATOR || this.last_type == TokenType.TK_EQUALS || this.last_type == TokenType.TK_EOF || this.last_type == TokenType.TK_SEMICOLON)) {
            char sep = c1;
            boolean esc = false;
            String resulting_string = c;
            if (this.parser_pos < this.input_length) {
                if (sep == '/') {
                    boolean in_char_class = false;
                    while (esc || in_char_class || this.input.charAt(this.parser_pos) != sep) {
                        resulting_string = resulting_string + this.input.charAt(this.parser_pos);
                        if (!esc) {
                            boolean bl3 = esc = this.input.charAt(this.parser_pos) == '\\';
                            if (this.input.charAt(this.parser_pos) == '[') {
                                in_char_class = true;
                            } else if (this.input.charAt(this.parser_pos) == ']') {
                                in_char_class = false;
                            }
                        } else {
                            esc = false;
                        }
                        ++this.parser_pos;
                        if (this.parser_pos < this.input_length) continue;
                        return new Object[]{resulting_string, TokenType.TK_STRING};
                    }
                } else {
                    while (esc || this.input.charAt(this.parser_pos) != sep) {
                        resulting_string = resulting_string + this.input.charAt(this.parser_pos);
                        esc = !esc ? this.input.charAt(this.parser_pos) == '\\' : false;
                        ++this.parser_pos;
                        if (this.parser_pos < this.input_length) continue;
                        return new Object[]{resulting_string, TokenType.TK_STRING};
                    }
                }
            }
            ++this.parser_pos;
            resulting_string = resulting_string + sep;
            if (sep == '/') {
                while (this.parser_pos < this.input_length && this.in_array(this.input.charAt(this.parser_pos), this.wordchar)) {
                    resulting_string = resulting_string + this.input.charAt(this.parser_pos);
                    ++this.parser_pos;
                }
            }
            return new Object[]{resulting_string, TokenType.TK_STRING};
        }
        if (c1 == '#') {
            String sharp = "#";
            if (this.parser_pos < this.input_length && this.in_array(this.input.charAt(this.parser_pos), this.digits)) {
                do {
                    c1 = this.input.charAt(this.parser_pos);
                    c = String.valueOf(c1);
                    sharp = sharp + c1;
                    ++this.parser_pos;
                } while (this.parser_pos < this.input_length && c1 != '#' && c1 != '=');
                if (c1 != '#') {
                    if (this.input.charAt(this.parser_pos) == '[' && this.input.charAt(this.parser_pos + 1) == ']') {
                        sharp = sharp + "[]";
                        this.parser_pos += 2;
                    } else if (this.input.charAt(this.parser_pos) == '{' && this.input.charAt(this.parser_pos + 1) == '}') {
                        sharp = sharp + "{}";
                        this.parser_pos += 2;
                    }
                }
                return new Object[]{sharp, TokenType.TK_WORD};
            }
        }
        if (c1 == '<' && "<!--".equals(this.input.substring(this.parser_pos - 1, this.parser_pos + 3))) {
            this.parser_pos += 3;
            this.flags.in_html_comment = true;
            return new Object[]{"<!--", TokenType.TK_COMMENT};
        }
        if (c1 == '-' && this.flags.in_html_comment && "-->".equals(this.input.substring(this.parser_pos - 1, this.parser_pos + 2))) {
            this.flags.in_html_comment = false;
            this.parser_pos += 2;
            if (wanted_newline) {
                this.print_newline();
            }
            return new Object[]{"-->", TokenType.TK_COMMENT};
        }
        if (this.in_array(c, this.punct)) {
            while (this.parser_pos < this.input_length && this.in_array(c + this.input.charAt(this.parser_pos), this.punct)) {
                c = c + this.input.charAt(this.parser_pos);
                ++this.parser_pos;
                if (this.parser_pos < this.input_length) continue;
            }
            if ((c1 = c.charAt(0)) == '=') {
                return new Object[]{c, TokenType.TK_EQUALS};
            }
            return new Object[]{c, TokenType.TK_OPERATOR};
        }
        return new Object[]{c, TokenType.TK_UNKNOWN};
    }

    public String format(String js_source_text) {
        this.init();
        this.just_added_newline = false;
        this.input_length = js_source_text.length();
        this.indent_string = "";
        while (this.opt_indent_size > 0) {
            this.indent_string = this.indent_string + this.opt_indent_char;
            --this.opt_indent_size;
        }
        this.input = js_source_text;
        this.last_word = "";
        this.last_type = TokenType.TK_START_EXPR;
        this.last_text = "";
        this.last_last_text = "";
        this.output = new ArrayList();
        this.do_block_just_closed = false;
        this.flag_store = new ArrayList();
        this.set_mode("BLOCK");
        this.parser_pos = 0;
        while (true) {
            Object[] t = this.get_next_token();
            this.token_text = (String)t[0];
            this.token_type = (TokenType)((Object)t[1]);
            if (this.token_type == TokenType.TK_EOF) break;
            switch (this.token_type) {
                case TK_START_EXPR: {
                    if ("[".equals(this.token_text)) {
                        if (this.last_type == TokenType.TK_WORD || ")".equals(this.last_text)) {
                            if (this.in_array(this.last_text, this.line_starters)) {
                                this.print_single_space();
                            }
                            this.set_mode("(EXPRESSION)");
                            this.print_token();
                            break;
                        }
                        if ("[EXPRESSION]".equals(this.flags.mode) || "[INDENTED-EXPRESSION]".equals(this.flags.mode)) {
                            if ("]".equals(this.last_last_text) && ",".equals(this.last_text)) {
                                if ("[EXPRESSION]".equals(this.flags.mode)) {
                                    this.flags.mode = "[INDENTED-EXPRESSION]";
                                    if (!this.opt_keep_array_indentation) {
                                        this.indent();
                                    }
                                }
                                this.set_mode("[EXPRESSION]");
                                if (!this.opt_keep_array_indentation) {
                                    this.print_newline();
                                }
                            } else if ("[".equals(this.last_text)) {
                                if ("[EXPRESSION]".equals(this.flags.mode)) {
                                    this.flags.mode = "[INDENTED-EXPRESSION]";
                                    if (!this.opt_keep_array_indentation) {
                                        this.indent();
                                    }
                                }
                                this.set_mode("[EXPRESSION]");
                                if (!this.opt_keep_array_indentation) {
                                    this.print_newline();
                                }
                            } else {
                                this.set_mode("[EXPRESSION]");
                            }
                        } else {
                            this.set_mode("[EXPRESSION]");
                        }
                    } else {
                        this.set_mode("(EXPRESSION)");
                    }
                    if (";".equals(this.last_text) || this.last_type == TokenType.TK_START_BLOCK) {
                        this.print_newline();
                    } else if (this.last_type != TokenType.TK_END_EXPR && this.last_type != TokenType.TK_START_EXPR && this.last_type != TokenType.TK_END_BLOCK && !".".equals(this.last_text)) {
                        if (this.last_type != TokenType.TK_WORD && this.last_type != TokenType.TK_OPERATOR) {
                            this.print_single_space();
                        } else if ("function".equals(this.last_word)) {
                            if (this.opt_space_after_anon_function) {
                                this.print_single_space();
                            }
                        } else if (this.in_array(this.last_text, this.line_starters) || "catch".equals(this.last_text)) {
                            this.print_single_space();
                        }
                    }
                    this.print_token();
                    break;
                }
                case TK_END_EXPR: {
                    if ("]".equals(this.token_text)) {
                        if (this.opt_keep_array_indentation) {
                            if ("}".equals(this.last_text)) {
                                this.remove_indent();
                                this.print_token();
                                this.restore_mode();
                                break;
                            }
                        } else if ("[INDENTED-EXPRESSION]".equals(this.flags.mode) && "]".equals(this.last_text)) {
                            this.restore_mode();
                            this.print_newline();
                            this.print_token();
                            break;
                        }
                    }
                    this.restore_mode();
                    this.print_token();
                    break;
                }
                case TK_START_BLOCK: {
                    if ("do".equals(this.last_word)) {
                        this.set_mode("DO_BLOCK");
                    } else {
                        this.set_mode("BLOCK");
                    }
                    if (this.opt_braces_on_own_line) {
                        if (this.last_type == TokenType.TK_OPERATOR) {
                            if ("return".equals(this.last_text)) {
                                this.print_single_space();
                            } else {
                                this.print_newline(true);
                            }
                        }
                        this.print_token();
                        this.indent();
                        break;
                    }
                    if (this.last_type != TokenType.TK_OPERATOR && this.last_type != TokenType.TK_START_EXPR) {
                        if (this.last_type == TokenType.TK_START_BLOCK) {
                            this.print_newline();
                        } else {
                            this.print_single_space();
                        }
                    }
                    this.indent();
                    this.print_token();
                    break;
                }
                case TK_END_BLOCK: {
                    this.restore_mode();
                    if (this.opt_braces_on_own_line) {
                        this.print_newline();
                        this.print_token();
                        break;
                    }
                    if (this.last_type == TokenType.TK_START_BLOCK) {
                        if (this.just_added_newline) {
                            this.remove_indent();
                        } else {
                            this.trim_output();
                        }
                    } else {
                        this.print_newline();
                    }
                    this.print_token();
                    break;
                }
                case TK_WORD: {
                    if (this.do_block_just_closed) {
                        this.print_single_space();
                        this.print_token();
                        this.print_single_space();
                        this.do_block_just_closed = false;
                        break;
                    }
                    if ("function".equals(this.token_text) && (this.just_added_newline || ";".equals(this.last_text)) && "{".equals(this.last_text)) {
                        this.n_newlines = this.just_added_newline ? this.n_newlines : 0;
                        for (int i = 0; i < 2 - this.n_newlines; ++i) {
                            this.print_newline(false);
                        }
                    }
                    if ("case".equals(this.token_text) || "default".equals(this.token_text)) {
                        if (":".equals(this.last_text)) {
                            this.remove_indent();
                        } else {
                            this.flags.indentation_level--;
                            this.print_newline();
                            this.flags.indentation_level++;
                        }
                        this.print_token();
                        this.flags.in_case = true;
                        break;
                    }
                    this.prefix = "NONE";
                    if (this.last_type == TokenType.TK_END_BLOCK) {
                        if (!this.in_array(this.token_text.toLowerCase(), new String[]{"else", "catch", "finally"})) {
                            this.prefix = "NEWLINE";
                        } else if (this.opt_braces_on_own_line) {
                            this.prefix = "NEWLINE";
                        } else {
                            this.prefix = "SPACE";
                            this.print_single_space();
                        }
                    } else if (this.last_type == TokenType.TK_SEMICOLON && ("BLOCK".equals(this.flags.mode) || "DO_BLOCK".equals(this.flags.mode))) {
                        this.prefix = "NEWLINE";
                    } else if (this.last_type == TokenType.TK_SEMICOLON && this.is_expression(this.flags.mode)) {
                        this.prefix = "SPACE";
                    } else if (this.last_type == TokenType.TK_STRING) {
                        this.prefix = "NEWLINE";
                    } else if (this.last_type == TokenType.TK_WORD) {
                        this.prefix = "SPACE";
                    } else if (this.last_type == TokenType.TK_START_BLOCK) {
                        this.prefix = "NEWLINE";
                    } else if (this.last_type == TokenType.TK_END_EXPR) {
                        this.print_single_space();
                        this.prefix = "NEWLINE";
                    }
                    if (this.last_type != TokenType.TK_END_BLOCK && this.in_array(this.token_text.toLowerCase(), new String[]{"else", "catch", "finally"})) {
                        this.print_newline();
                    } else if (this.in_array(this.token_text, this.line_starters) || "NEWLINE".equals(this.prefix)) {
                        if ("else".equals(this.last_text)) {
                            this.print_single_space();
                        } else if (this.last_type != TokenType.TK_START_EXPR && !"=".equals(this.last_text) && !",".equals(this.last_text) || !"function".equals(this.token_text)) {
                            if ("return".equals(this.last_text) || "throw".equals(this.last_text)) {
                                this.print_single_space();
                            } else if (this.last_type != TokenType.TK_END_EXPR) {
                                if (!(this.last_type == TokenType.TK_START_EXPR && "var".equals(this.token_text) || ":".equals(this.last_text))) {
                                    if ("if".equals(this.token_text) && "else".equals(this.last_word) && !"{".equals(this.last_text)) {
                                        this.print_single_space();
                                    } else {
                                        this.print_newline();
                                    }
                                }
                            } else if (this.in_array(this.token_text, this.line_starters) && !")".equals(this.last_text)) {
                                this.print_newline();
                            }
                        }
                    } else if ("SPACE".equals(this.prefix)) {
                        this.print_single_space();
                    }
                    this.print_token();
                    this.last_word = this.token_text;
                    if ("var".equals(this.token_text)) {
                        this.flags.var_line = true;
                        this.flags.var_line_reindented = false;
                        this.flags.var_line_tainted = false;
                    }
                    if (!"if".equals(this.token_text) && !"else".equals(this.token_text)) break;
                    this.flags.if_line = true;
                    break;
                }
                case TK_SEMICOLON: {
                    this.print_token();
                    this.flags.var_line = false;
                    this.flags.var_line_reindented = false;
                    break;
                }
                case TK_STRING: {
                    if (this.last_type == TokenType.TK_START_BLOCK || this.last_type == TokenType.TK_END_BLOCK || this.last_type == TokenType.TK_SEMICOLON) {
                        this.print_newline();
                    } else if (this.last_type == TokenType.TK_WORD) {
                        this.print_single_space();
                    }
                    this.print_token();
                    break;
                }
                case TK_EQUALS: {
                    if (this.flags.var_line) {
                        this.flags.var_line_tainted = true;
                    }
                    this.print_single_space();
                    this.print_token();
                    this.print_single_space();
                    break;
                }
                case TK_OPERATOR: {
                    boolean space_before = true;
                    boolean space_after = true;
                    if (this.flags.var_line && ",".equals(this.token_text) && this.is_expression(this.flags.mode)) {
                        this.flags.var_line_tainted = false;
                    }
                    if (this.flags.var_line && ",".equals(this.token_text)) {
                        if (this.flags.var_line_tainted) {
                            this.print_token();
                            this.flags.var_line_reindented = true;
                            this.flags.var_line_tainted = false;
                            this.print_newline();
                            break;
                        }
                        this.flags.var_line_tainted = false;
                    }
                    if ("return".equals(this.last_text) || "throw".equals(this.last_text)) {
                        this.print_single_space();
                        this.print_token();
                        break;
                    }
                    if (":".equals(this.token_text) && this.flags.in_case) {
                        this.print_token();
                        this.print_newline();
                        this.flags.in_case = false;
                        break;
                    }
                    if ("::".equals(this.token_text)) {
                        this.print_token();
                        break;
                    }
                    if (",".equals(this.token_text)) {
                        if (this.flags.var_line) {
                            if (this.flags.var_line_tainted) {
                                this.print_token();
                                this.print_newline();
                                this.flags.var_line_tainted = false;
                                break;
                            }
                            this.print_token();
                            this.print_single_space();
                            break;
                        }
                        if (this.last_type == TokenType.TK_END_BLOCK && !"(EXPRESSION)".equals(this.flags.mode)) {
                            this.print_token();
                            this.print_single_space();
                            break;
                        }
                        if ("BLOCK".equals(this.flags.mode)) {
                            this.print_token();
                            this.print_newline();
                            break;
                        }
                        this.print_token();
                        this.print_single_space();
                        break;
                    }
                    if (this.in_array(this.token_text, new String[]{"--", "++", "!"}) || this.in_array(this.token_text, new String[]{"-", "+"}) && (this.in_array((Object)this.last_type, (Object[])new TokenType[]{TokenType.TK_START_BLOCK, TokenType.TK_START_EXPR, TokenType.TK_EQUALS, TokenType.TK_OPERATOR}) || this.in_array(this.last_text, this.line_starters))) {
                        space_before = false;
                        space_after = false;
                        if (";".equals(this.last_text) && this.is_expression(this.flags.mode)) {
                            space_before = true;
                        }
                        if ("TK_WORD".equals((Object)this.last_type) && this.in_array(this.last_text, this.line_starters)) {
                            space_before = true;
                        }
                        if ("BLOCK".equals(this.flags.mode) && ("{".equals(this.last_text) || ";".equals(this.last_text))) {
                            this.print_newline();
                        }
                    } else if (".".equals(this.token_text)) {
                        space_before = false;
                    } else if (":".equals(this.token_text) && !this.is_ternary_op()) {
                        space_before = false;
                    }
                    if (space_before) {
                        this.print_single_space();
                    }
                    this.print_token();
                    if (space_after) {
                        this.print_single_space();
                    }
                    if (!"!".equals(this.token_text)) break;
                    break;
                }
                case TK_BLOCK_COMMENT: {
                    int i;
                    String[] lines = this.token_text.split("\u0000xa|\u0000xd\u0000xa");
                    if (Pattern.matches("^\\/\\*\\*", this.token_text)) {
                        this.print_newline();
                        this.output.add(lines[0]);
                        for (i = 1; i < lines.length; ++i) {
                            this.print_newline();
                            this.output.add(" ");
                            this.output.add(lines[i].replaceAll("^\\s\\s*|\\s\\s*$", ""));
                        }
                    } else {
                        if (lines.length > 1) {
                            this.print_newline();
                            this.trim_output();
                        } else {
                            this.print_single_space();
                        }
                        for (i = 0; i < lines.length; ++i) {
                            this.output.add(lines[i]);
                            this.output.add("\n");
                        }
                    }
                    this.print_newline();
                    break;
                }
                case TK_INLINE_COMMENT: {
                    this.print_single_space();
                    this.print_token();
                    if (this.is_expression(this.flags.mode)) {
                        this.print_single_space();
                        break;
                    }
                    this.print_newline();
                    break;
                }
                case TK_COMMENT: {
                    if (this.wanted_newline) {
                        this.print_newline();
                    } else {
                        this.print_single_space();
                    }
                    this.print_token();
                    this.print_newline();
                    break;
                }
                case TK_UNKNOWN: {
                    this.print_token();
                }
            }
            this.last_last_text = this.last_text;
            this.last_type = this.token_type;
            this.last_text = this.token_text;
        }
        StringBuilder result = new StringBuilder();
        for (String s : this.output) {
            result.append(s);
        }
        return result.toString().replaceAll("[\\n ]+$", "");
    }

    private static class Flag {
        public int indentation_baseline;
        public boolean in_case;
        public boolean in_html_comment;
        public boolean var_line_tainted;
        private boolean eat_next_space;
        private String mode;
        private boolean if_line;
        private int indentation_level;
        private boolean var_line;
        private boolean var_line_reindented;

        private Flag() {
        }
    }
}

