/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.webapp.core;

import java.util.Locale;
import java.util.TimeZone;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.webapp.ConverterELTag;
import javax.servlet.jsp.JspException;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.resources.Resources;

public class ConvertDateTimeTag
extends ConverterELTag {
    private ValueExpression dateStyle;
    private ValueExpression locale;
    private ValueExpression pattern;
    private ValueExpression timeStyle;
    private ValueExpression timeZone;
    private ValueExpression type;
    private ValueExpression binding;

    public void release() {
        super.release();
        this.dateStyle = null;
        this.locale = null;
        this.pattern = null;
        this.timeStyle = null;
        this.timeZone = null;
        this.type = null;
        this.binding = null;
    }

    public void setDateStyle(ValueExpression dateStyle) {
        this.dateStyle = dateStyle;
    }

    public void setLocale(ValueExpression locale) {
        this.locale = locale;
    }

    public void setPattern(ValueExpression pattern) {
        this.pattern = pattern;
    }

    public void setTimeStyle(ValueExpression timeStyle) {
        this.timeStyle = timeStyle;
    }

    public void setTimeZone(ValueExpression timeZone) {
        this.timeZone = timeZone;
    }

    public void setType(ValueExpression type) {
        this.type = type;
    }

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }

    protected Converter createConverter() throws JspException {
        DateTimeConverter converter;
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elctx = context.getELContext();
        if (this.binding != null && (converter = (DateTimeConverter)this.binding.getValue(elctx)) != null) {
            return converter;
        }
        converter = (DateTimeConverter)context.getApplication().createConverter("javax.faces.DateTime");
        if (this.pattern != null) {
            converter.setPattern((String)this.pattern.getValue(elctx));
        }
        if (this.dateStyle != null) {
            converter.setDateStyle((String)this.dateStyle.getValue(elctx));
        }
        if (this.timeStyle != null) {
            converter.setTimeStyle((String)this.timeStyle.getValue(elctx));
        }
        if (this.type != null) {
            converter.setType((String)this.type.getValue(elctx));
        } else if (this.dateStyle != null && this.timeStyle != null) {
            converter.setType("both");
        } else if (this.dateStyle != null) {
            converter.setType("date");
        } else if (this.timeStyle != null) {
            converter.setType("time");
        }
        Locale loc = null;
        if (this.locale != null) {
            loc = OMUtils.getLocaleFromExpression(context, this.locale);
        }
        if (loc == null) {
            loc = context.getViewRoot().getLocale();
        }
        converter.setLocale(loc);
        if (this.timeZone != null) {
            TimeZone tz;
            Object tzval = this.timeZone.getValue(elctx);
            if (tzval instanceof TimeZone) {
                tz = (TimeZone)tzval;
            } else if (tzval instanceof String) {
                tz = TimeZone.getTimeZone((String)tzval);
            } else {
                throw new JspException(Resources._T("JSF_TIMEZONE_TYPE_EXPECTED", this.timeZone.getExpressionString()));
            }
            converter.setTimeZone(tz);
        } else {
            TimeZone initTimeZone = FacesUtils.getInitTimeZone();
            if (initTimeZone != null) {
                converter.setTimeZone(initTimeZone);
            }
        }
        if (this.binding != null) {
            this.binding.setValue(elctx, (Object)converter);
        }
        return converter;
    }
}

