/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.webapp.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.developer.util.FacesUtils;

public class DefaultSuffixRedirector
implements Filter {
    private ServletContext servletContext;
    private String defaultSuffix;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String contextRoot = req.getContextPath();
        String path = req.getServletPath();
        String facesPath = null;
        if (path == null || "".equals(path)) {
            path = req.getRequestURI();
            facesPath = FacesUtils.getDefaultSuffixRedirectPath(this.servletContext, path, this.defaultSuffix, true, contextRoot);
        } else {
            facesPath = FacesUtils.getDefaultSuffixRedirectPath(this.servletContext, path, this.defaultSuffix, false, contextRoot);
        }
        if (facesPath != null && facesPath.length() > 0) {
            String queryString = req.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                facesPath = facesPath + "?" + queryString;
            }
            res.sendRedirect(facesPath);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private String getDefaultSuffix() {
        if (this.defaultSuffix == null) {
            this.defaultSuffix = FacesUtils.getDefaultSuffix(this.servletContext);
        }
        return this.defaultSuffix;
    }

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        this.defaultSuffix = this.getDefaultSuffix();
    }
}

