/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web.filter;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.EntryRefreshPolicy;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.util.ClassLoaderUtil;
import com.opensymphony.oscache.util.StringUtil;
import com.opensymphony.oscache.web.ServletCacheAdministrator;
import com.opensymphony.oscache.web.filter.CacheHttpServletResponseWrapper;
import com.opensymphony.oscache.web.filter.ExpiresRefreshPolicy;
import com.opensymphony.oscache.web.filter.ICacheGroupsProvider;
import com.opensymphony.oscache.web.filter.ICacheKeyProvider;
import com.opensymphony.oscache.web.filter.ResponseContent;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheFilter
implements Filter,
ICacheKeyProvider,
ICacheGroupsProvider {
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final int FRAGMENT_AUTODETECT = -1;
    public static final int FRAGMENT_NO = 0;
    public static final int FRAGMENT_YES = 1;
    public static final int NOCACHE_OFF = 0;
    public static final int NOCACHE_SESSION_ID_IN_URL = 1;
    public static final long LAST_MODIFIED_OFF = 0L;
    public static final long LAST_MODIFIED_ON = 1L;
    public static final long LAST_MODIFIED_INITIAL = -1L;
    public static final long EXPIRES_OFF = 0L;
    public static final long EXPIRES_ON = 1L;
    public static final long EXPIRES_TIME = -1L;
    public static final long MAX_AGE_NO_INIT = Long.MIN_VALUE;
    public static final long MAX_AGE_TIME = Long.MAX_VALUE;
    private static final String REQUEST_FILTERED = "__oscache_filtered__";
    private String requestFiltered;
    private EntryRefreshPolicy expiresRefreshPolicy;
    private final Log log = LogFactory.getLog(this.getClass());
    private FilterConfig config;
    private ServletCacheAdministrator admin = null;
    private int cacheScope = 4;
    private int fragment = -1;
    private int time = 3600;
    private String cron = null;
    private int nocache = 0;
    private long lastModified = -1L;
    private long expires = 1L;
    private long cacheControlMaxAge = -60L;
    private ICacheKeyProvider cacheKeyProvider = this;
    private ICacheGroupsProvider cacheGroupsProvider = this;
    private List disableCacheOnMethods = null;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("OSCache: filter in scope " + this.cacheScope));
        }
        if (this.isFilteredBefore(request) || !this.isCacheableInternal(request)) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(this.requestFiltered, (Object)Boolean.TRUE);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean fragmentRequest = this.isFragment(httpRequest);
        Cache cache = this.cacheScope == 3 ? this.admin.getSessionScopeCache(httpRequest.getSession(true)) : this.admin.getAppScopeCache(this.config.getServletContext());
        String key = this.cacheKeyProvider.createCacheKey(httpRequest, this.admin, cache);
        try {
            ResponseContent respContent = (ResponseContent)cache.getFromCache(key, this.time, this.cron);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("OSCache: Using cached entry for " + key));
            }
            boolean acceptsGZip = false;
            if (!fragmentRequest && this.lastModified != 0L) {
                long clientLastModified = httpRequest.getDateHeader(HEADER_IF_MODIFIED_SINCE);
                if (clientLastModified != -1L && clientLastModified >= respContent.getLastModified()) {
                    ((HttpServletResponse)response).setStatus(304);
                    return;
                }
                acceptsGZip = respContent.isContentGZiped() && this.acceptsGZipEncoding(httpRequest);
            }
            respContent.writeTo(response, fragmentRequest, acceptsGZip);
        }
        catch (NeedsRefreshException nre) {
            boolean updateSucceeded = false;
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("OSCache: New cache entry, cache stale or cache scope flushed for " + key));
                }
                CacheHttpServletResponseWrapper cacheResponse = new CacheHttpServletResponseWrapper((HttpServletResponse)response, fragmentRequest, (long)this.time * 1000L, this.lastModified, this.expires, this.cacheControlMaxAge);
                chain.doFilter(request, (ServletResponse)cacheResponse);
                cacheResponse.flushBuffer();
                if (this.isCacheableInternal(cacheResponse)) {
                    String[] groups = this.cacheGroupsProvider.createCacheGroups(httpRequest, this.admin, cache);
                    cache.putInCache(key, cacheResponse.getContent(), groups, this.expiresRefreshPolicy, null);
                    updateSucceeded = true;
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("OSCache: New entry added to the cache with key " + key));
                    }
                }
            }
            finally {
                if (!updateSucceeded) {
                    cache.cancelUpdate(key);
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        EntryRefreshPolicy expiresRefreshPolicyParam;
        ICacheGroupsProvider cacheGroupsProviderParam;
        ICacheKeyProvider cacheKeyProviderParam;
        String cacheControlMaxAgeParam;
        String expiresParam;
        String lastModifiedParam;
        String nocacheParam;
        String scopeParam;
        this.config = filterConfig;
        this.log.info((Object)("OSCache: Initializing CacheFilter with filter name " + this.config.getFilterName()));
        this.requestFiltered = REQUEST_FILTERED + this.config.getFilterName();
        this.log.info((Object)("Request filter attribute is " + this.requestFiltered));
        Properties props = null;
        try {
            String propertiesfile = this.config.getInitParameter("oscache-properties-file");
            if (propertiesfile != null && propertiesfile.length() > 0) {
                props = Config.loadProperties(propertiesfile, "CacheFilter with filter name '" + this.config.getFilterName() + "'");
            }
        }
        catch (Exception e) {
            this.log.info((Object)"OSCache: Init parameter 'oscache-properties-file' not set, using default.");
        }
        this.admin = ServletCacheAdministrator.getInstance(this.config.getServletContext(), props);
        String timeParam = this.config.getInitParameter("time");
        if (timeParam != null) {
            try {
                this.setTime(Integer.parseInt(timeParam));
            }
            catch (NumberFormatException nfe) {
                this.log.error((Object)("OSCache: Unexpected value for the init parameter 'time', defaulting to one hour. Message=" + nfe.getMessage()));
            }
        }
        if ((scopeParam = this.config.getInitParameter("scope")) != null) {
            if ("session".equalsIgnoreCase(scopeParam)) {
                this.setCacheScope(3);
            } else if ("application".equalsIgnoreCase(scopeParam)) {
                this.setCacheScope(4);
            } else {
                this.log.error((Object)("OSCache: Wrong value '" + scopeParam + "' for init parameter 'scope', defaulting to 'application'."));
            }
        }
        this.setCron(this.config.getInitParameter("cron"));
        String fragmentParam = this.config.getInitParameter("fragment");
        if (fragmentParam != null) {
            if ("no".equalsIgnoreCase(fragmentParam)) {
                this.setFragment(0);
            } else if ("yes".equalsIgnoreCase(fragmentParam)) {
                this.setFragment(1);
            } else if ("auto".equalsIgnoreCase(fragmentParam)) {
                this.setFragment(-1);
            } else {
                this.log.error((Object)("OSCache: Wrong value '" + fragmentParam + "' for init parameter 'fragment', defaulting to 'auto detect'."));
            }
        }
        if ((nocacheParam = this.config.getInitParameter("nocache")) != null) {
            if ("off".equalsIgnoreCase(nocacheParam)) {
                this.nocache = 0;
            } else if ("sessionIdInURL".equalsIgnoreCase(nocacheParam)) {
                this.nocache = 1;
            } else {
                this.log.error((Object)("OSCache: Wrong value '" + nocacheParam + "' for init parameter 'nocache', defaulting to 'off'."));
            }
        }
        if ((lastModifiedParam = this.config.getInitParameter("lastModified")) != null) {
            if ("off".equalsIgnoreCase(lastModifiedParam)) {
                this.lastModified = 0L;
            } else if ("on".equalsIgnoreCase(lastModifiedParam)) {
                this.lastModified = 1L;
            } else if ("initial".equalsIgnoreCase(lastModifiedParam)) {
                this.lastModified = -1L;
            } else {
                this.log.error((Object)("OSCache: Wrong value '" + lastModifiedParam + "' for init parameter 'lastModified', defaulting to 'initial'."));
            }
        }
        if ((expiresParam = this.config.getInitParameter("expires")) != null) {
            if ("off".equalsIgnoreCase(expiresParam)) {
                this.setExpires(0L);
            } else if ("on".equalsIgnoreCase(expiresParam)) {
                this.setExpires(1L);
            } else if ("time".equalsIgnoreCase(expiresParam)) {
                this.setExpires(-1L);
            } else {
                this.log.error((Object)("OSCache: Wrong value '" + expiresParam + "' for init parameter 'expires', defaulting to 'on'."));
            }
        }
        if ((cacheControlMaxAgeParam = this.config.getInitParameter("max-age")) != null) {
            if (cacheControlMaxAgeParam.equalsIgnoreCase("no init")) {
                this.setCacheControlMaxAge(Long.MIN_VALUE);
            } else if (cacheControlMaxAgeParam.equalsIgnoreCase("time")) {
                this.setCacheControlMaxAge(Long.MAX_VALUE);
            } else {
                try {
                    this.setCacheControlMaxAge(Long.parseLong(cacheControlMaxAgeParam));
                }
                catch (NumberFormatException nfe) {
                    this.log.error((Object)("OSCache: Unexpected value for the init parameter 'max-age', defaulting to '60'. Message=" + nfe.getMessage()));
                }
            }
        }
        if ((cacheKeyProviderParam = (ICacheKeyProvider)this.instantiateFromInitParam("ICacheKeyProvider", ICacheKeyProvider.class, this.getClass().getName())) != null) {
            this.setCacheKeyProvider(cacheKeyProviderParam);
        }
        if ((cacheGroupsProviderParam = (ICacheGroupsProvider)this.instantiateFromInitParam("ICacheGroupsProvider", ICacheGroupsProvider.class, this.getClass().getName())) != null) {
            this.setCacheGroupsProvider(cacheGroupsProviderParam);
        }
        if ((expiresRefreshPolicyParam = (EntryRefreshPolicy)this.instantiateFromInitParam("EntryRefreshPolicy", EntryRefreshPolicy.class, ExpiresRefreshPolicy.class.getName())) != null) {
            this.setExpiresRefreshPolicy(expiresRefreshPolicyParam);
        } else {
            this.setExpiresRefreshPolicy(new ExpiresRefreshPolicy(this.time));
        }
        String disableCacheOnMethodsParam = this.config.getInitParameter("disableCacheOnMethods");
        if (StringUtil.hasLength(disableCacheOnMethodsParam)) {
            this.disableCacheOnMethods = StringUtil.split(disableCacheOnMethodsParam, ',');
        }
    }

    private Object instantiateFromInitParam(String classInitParam, Class interfaceClass, String defaultObjectName) {
        String className = this.config.getInitParameter(classInitParam);
        if (className != null) {
            try {
                Class clazz = ClassLoaderUtil.loadClass(className, this.getClass());
                if (!interfaceClass.isAssignableFrom(clazz)) {
                    this.log.error((Object)("OSCache: Specified class '" + className + "' does not implement" + interfaceClass.getName() + ". Using default " + defaultObjectName + "."));
                    return null;
                }
                return clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)("OSCache: Class '" + className + "' not found. Defaulting to " + defaultObjectName + "."), (Throwable)e);
            }
            catch (InstantiationException e) {
                this.log.error((Object)("OSCache: Class '" + className + "' could not be instantiated because it is not a concrete class. Using default object " + defaultObjectName + "."), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)("OSCache: Class '" + className + "' could not be instantiated because it is not public. Using default object " + defaultObjectName + "."), (Throwable)e);
            }
        }
        return null;
    }

    public String createCacheKey(HttpServletRequest httpRequest, ServletCacheAdministrator scAdmin, Cache cache) {
        return scAdmin.generateEntryKey(null, httpRequest, this.cacheScope);
    }

    public String[] createCacheGroups(HttpServletRequest httpRequest, ServletCacheAdministrator scAdmin, Cache cache) {
        return null;
    }

    public boolean isFragment(HttpServletRequest request) {
        if (this.fragment == -1) {
            return request.getAttribute("javax.servlet.include.request_uri") != null;
        }
        return this.fragment != 0;
    }

    public boolean isFilteredBefore(ServletRequest request) {
        return request.getAttribute(this.requestFiltered) != null;
    }

    private final boolean isCacheableInternal(ServletRequest request) {
        boolean cacheable = this.isCacheable(request);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("OSCache: the request " + (cacheable ? "is" : "is not") + " cachable."));
        }
        return cacheable;
    }

    public boolean isCacheable(ServletRequest request) {
        boolean cacheable = request instanceof HttpServletRequest;
        if (cacheable) {
            HttpServletRequest requestHttp = (HttpServletRequest)request;
            if (this.disableCacheOnMethods != null && this.disableCacheOnMethods.contains(requestHttp.getMethod())) {
                return false;
            }
            if (this.nocache == 1) {
                cacheable = !requestHttp.isRequestedSessionIdFromURL();
            }
        }
        return cacheable;
    }

    private final boolean isCacheableInternal(CacheHttpServletResponseWrapper cacheResponse) {
        boolean cacheable = this.isCacheable(cacheResponse);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("OSCache: the response " + (cacheable ? "is" : "is not") + " cachable."));
        }
        return cacheable;
    }

    public boolean isCacheable(CacheHttpServletResponseWrapper cacheResponse) {
        return cacheResponse.getStatus() == 200;
    }

    public boolean acceptsGZipEncoding(HttpServletRequest request) {
        String acceptEncoding = request.getHeader(HEADER_ACCEPT_ENCODING);
        return acceptEncoding != null && acceptEncoding.indexOf("gzip") != -1;
    }

    public long getCacheControlMaxAge() {
        if (this.cacheControlMaxAge == Long.MIN_VALUE || this.cacheControlMaxAge == Long.MAX_VALUE) {
            return this.cacheControlMaxAge;
        }
        return -this.cacheControlMaxAge;
    }

    public void setCacheControlMaxAge(long cacheControlMaxAge) {
        if (cacheControlMaxAge == Long.MIN_VALUE || cacheControlMaxAge == Long.MAX_VALUE) {
            this.cacheControlMaxAge = cacheControlMaxAge;
        } else if (cacheControlMaxAge >= 0L) {
            this.cacheControlMaxAge = -cacheControlMaxAge;
        } else {
            this.log.warn((Object)"OSCache: 'max-age' must be at least a positive integer, defaulting to '60'. ");
            this.cacheControlMaxAge = -60L;
        }
    }

    public ICacheGroupsProvider getCacheGroupsProvider() {
        return this.cacheGroupsProvider;
    }

    public void setCacheGroupsProvider(ICacheGroupsProvider cacheGroupsProvider) {
        if (cacheGroupsProvider == null) {
            throw new IllegalArgumentException("The ICacheGroupsProvider is null.");
        }
        this.cacheGroupsProvider = cacheGroupsProvider;
    }

    public ICacheKeyProvider getCacheKeyProvider() {
        return this.cacheKeyProvider;
    }

    public void setCacheKeyProvider(ICacheKeyProvider cacheKeyProvider) {
        if (cacheKeyProvider == null) {
            throw new IllegalArgumentException("The ICacheKeyProvider is null.");
        }
        this.cacheKeyProvider = cacheKeyProvider;
    }

    public int getCacheScope() {
        return this.cacheScope;
    }

    public void setCacheScope(int cacheScope) {
        if (cacheScope != 4 && cacheScope != 3) {
            throw new IllegalArgumentException("Acceptable values for cache scope are PageContext.APPLICATION_SCOPE or PageContext.SESSION_SCOPE");
        }
        this.cacheScope = cacheScope;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        if (expires < -1L || expires > 1L) {
            throw new IllegalArgumentException("Expires value out of range.");
        }
        this.expires = expires;
    }

    public EntryRefreshPolicy getExpiresRefreshPolicy() {
        return this.expiresRefreshPolicy;
    }

    public void setExpiresRefreshPolicy(EntryRefreshPolicy expiresRefreshPolicy) {
        if (expiresRefreshPolicy == null) {
            throw new IllegalArgumentException("The EntryRefreshPolicy is null.");
        }
        this.expiresRefreshPolicy = expiresRefreshPolicy;
    }

    public int getFragment() {
        return this.fragment;
    }

    public void setFragment(int fragment) {
        if (fragment < -1 || fragment > 1) {
            throw new IllegalArgumentException("Fragment value out of range.");
        }
        this.fragment = fragment;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        if (lastModified < -1L || lastModified > 1L) {
            throw new IllegalArgumentException("LastModified value out of range.");
        }
        this.lastModified = lastModified;
    }

    public int getNocache() {
        return this.nocache;
    }

    public void setNocache(int nocache) {
        if (nocache < 0 || nocache > 1) {
            throw new IllegalArgumentException("Nocache value out of range.");
        }
        this.nocache = nocache;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
        if (this.expiresRefreshPolicy instanceof ExpiresRefreshPolicy) {
            ((ExpiresRefreshPolicy)this.expiresRefreshPolicy).setRefreshPeriod(time);
        }
    }

    public List getDisableCacheOnMethods() {
        return this.disableCacheOnMethods;
    }

    public void setDisableCacheOnMethods(List disableCacheOnMethods) {
        this.disableCacheOnMethods = disableCacheOnMethods;
    }
}

