/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble.ear;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.assemble.AbstractArchiveAssembler;
import org.apache.pluto.util.assemble.AssemblerConfig;
import org.apache.pluto.util.assemble.ear.AssemblySink;
import org.apache.pluto.util.assemble.ear.ByteArrayAssemblySink;
import org.apache.pluto.util.assemble.ear.FileAssemblySink;
import org.apache.pluto.util.assemble.io.JarStreamingAssembly;

public class EarAssembler
extends AbstractArchiveAssembler {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$util$assemble$ear$EarAssembler == null ? (class$org$apache$pluto$util$assemble$ear$EarAssembler = EarAssembler.class$("org.apache.pluto.util.assemble.ear.EarAssembler")) : class$org$apache$pluto$util$assemble$ear$EarAssembler));
    private static final int BUFLEN = 8192;
    static /* synthetic */ Class class$org$apache$pluto$util$assemble$ear$EarAssembler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assembleInternal(AssemblerConfig config) throws UtilityException, IOException {
        File source = config.getSource();
        File dest = config.getDestination();
        JarInputStream earIn = new JarInputStream(new FileInputStream(source));
        JarOutputStream earOut = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dest), 8192));
        try {
            JarEntry entry;
            while ((entry = earIn.getNextJarEntry()) != null) {
                if (entry.getName().toLowerCase().endsWith(".war")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Assembling war file " + entry.getName()));
                    }
                    AssemblySink warBytesOut = this.getAssemblySink(config, entry);
                    JarOutputStream warOut = new JarOutputStream(warBytesOut);
                    JarStreamingAssembly.assembleStream(new JarInputStream(earIn), warOut, config.getDispatchServletClass());
                    JarEntry warEntry = new JarEntry(entry);
                    warEntry.setSize(warBytesOut.getByteCount());
                    warEntry.setCrc(warBytesOut.getCrc());
                    warEntry.setCompressedSize(-1L);
                    earOut.putNextEntry(warEntry);
                    warBytesOut.writeTo(earOut);
                    ((FilterOutputStream)earOut).flush();
                    earOut.closeEntry();
                    earIn.closeEntry();
                    continue;
                }
                earOut.putNextEntry(entry);
                IOUtils.copy((InputStream)earIn, (OutputStream)earOut);
                ((FilterOutputStream)earOut).flush();
                earOut.closeEntry();
                earIn.closeEntry();
            }
        }
        finally {
            earOut.close();
            earIn.close();
        }
    }

    protected AssemblySink getAssemblySink(AssemblerConfig config, JarEntry entry) throws IOException {
        File f = File.createTempFile("earAssemblySink", "tmp");
        f.deleteOnExit();
        return this.getFileAssemblySink(entry, f);
    }

    private AssemblySink getByteArrayAssemblySink(JarEntry entry) {
        ByteArrayAssemblySink warBytesOut = null;
        int defaultBuflen = 0xA00000;
        int assemblyBuflen = 32768;
        if (entry.getSize() > (long)(Integer.MAX_VALUE - assemblyBuflen) || entry.getSize() < 1L) {
            warBytesOut = new ByteArrayAssemblySink(new ByteArrayOutputStream(defaultBuflen));
        } else {
            int buflen = (int)entry.getSize() + assemblyBuflen;
            warBytesOut = new ByteArrayAssemblySink(new ByteArrayOutputStream(buflen));
        }
        return warBytesOut;
    }

    private AssemblySink getFileAssemblySink(JarEntry e, File f) {
        FileAssemblySink sink = null;
        try {
            sink = new FileAssemblySink(f);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return sink;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

