/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.install.file;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TomcatCrossContextGenerator {
    private static final String PLUTO_TEMP_DIR = "PlutoDomain";
    private static Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$util$install$file$TomcatCrossContextGenerator == null ? (class$org$apache$pluto$util$install$file$TomcatCrossContextGenerator = TomcatCrossContextGenerator.class$("org.apache.pluto.util.install.file.TomcatCrossContextGenerator")) : class$org$apache$pluto$util$install$file$TomcatCrossContextGenerator));
    static /* synthetic */ Class class$org$apache$pluto$util$install$file$TomcatCrossContextGenerator;

    public static void main(String[] args) throws IOException {
        File tomcatHome = new File(args[0]);
        File webapps = new File(tomcatHome, "webapps");
        File conf = new File(tomcatHome, "conf/Catalina/localhost");
        File[] files = webapps.listFiles(new PortletFileNameFilter());
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getName();
            String contextName = fileName.substring(0, fileName.indexOf(".war"));
            TomcatCrossContextGenerator.createContextFile(conf, fileName, contextName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createContextFile(File confDir, String fileName, String contextName) throws IOException {
        PrintWriter out = null;
        try {
            StringBuffer contents = new StringBuffer();
            contents.append("<Context ").append("path=\"").append(contextName).append("\" ").append("docBase=\"../").append(PLUTO_TEMP_DIR).append("/").append(fileName).append("\" ").append("crossContext=\"true\">").append("</Context>");
            File confFile = new File(confDir, contextName + ".xml");
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Writing file: " + confFile.getAbsolutePath()));
            }
            out = new PrintWriter(new FileWriter(confFile));
            out.println(contents.toString());
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PortletFileNameFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.startsWith("portlet") && name.endsWith(".war");
        }
    }
}

