/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.install.file.tomcat5;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.pluto.util.install.InstallationConfig;
import org.apache.pluto.util.install.file.FileSystemInstaller;

public class Tomcat5FileSystemInstaller
extends FileSystemInstaller {
    public boolean isValidInstallationDirectory(File installDir) {
        File serverConfig = new File(installDir, "conf/server.xml");
        File catalinaProps = new File(installDir, "conf/catalina.properties");
        return serverConfig.exists() && catalinaProps.exists();
    }

    public void writeConfiguration(InstallationConfig config) throws IOException {
        File contextConfigurationDirectory = this.getConfigurationDir(config);
        if (!contextConfigurationDirectory.exists()) {
            contextConfigurationDirectory.mkdirs();
        }
        Iterator it = config.getPortletApplications().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String context = entry.getKey().toString();
            File portletApp = (File)entry.getValue();
            String deployed = "../" + config.getServerConfig().getDomain() + "/" + portletApp.getName();
            String contents = this.getPortletApplicationConfig(context, deployed);
            FileWriter out = new FileWriter(new File(contextConfigurationDirectory, context + ".xml"));
            out.write(contents);
            out.flush();
            out.close();
        }
        File xmlFile = new File(contextConfigurationDirectory, config.getPortalContextPath() + ".xml");
        FileWriter out = new FileWriter(xmlFile);
        out.write(this.getPortalApplicationConfig(config));
        out.flush();
        out.close();
    }

    protected File getEndorsedDir(InstallationConfig config) {
        File installationDirectory = config.getInstallationDirectory();
        return new File(installationDirectory, "common/endorsed");
    }

    protected File getSharedDir(InstallationConfig config) {
        File installationDirectory = config.getInstallationDirectory();
        if (new File(config.getInstallationDirectory(), "bin/commons-logging-api.jar").exists()) {
            Iterator iter = config.getSharedDependencies().iterator();
            while (iter.hasNext()) {
                File dep = (File)iter.next();
                if (dep.getPath().indexOf("commons-logging-api") == -1) continue;
                iter.remove();
            }
        }
        return new File(installationDirectory, "shared/lib");
    }

    protected File getWebAppDir(InstallationConfig config) {
        File installationDirectory = config.getInstallationDirectory();
        return new File(installationDirectory, config.getServerConfig().getDomain());
    }

    protected File getConfigurationDir(InstallationConfig config) {
        File installationDirectory = config.getInstallationDirectory();
        String engine = "Catalina";
        String host = config.getServerConfig().getHost();
        return new File(installationDirectory, "conf/" + engine + "/" + host);
    }

    private String getPortalApplicationConfig(InstallationConfig config) {
        String war = "../" + config.getServerConfig().getDomain() + "/" + config.getPortalApplication().getName();
        String contextPath = config.getPortalContextPath();
        return this.getConfigContents(war, contextPath);
    }

    private String getPortletApplicationConfig(String contextPath, String file) {
        return this.getConfigContents(file, contextPath);
    }

    private String getConfigContents(String war, String contextPath) {
        StringBuffer contents = new StringBuffer();
        contents.append("<Context ").append("path=\"").append(contextPath).append("\" ").append("docBase=\"").append(war).append("\" ").append("crossContext=\"true\">").append("</Context>");
        return contents.toString();
    }
}

