/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.xerial.snappy.OSInfo;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyNative;

public class SnappyLoader {
    public static final String SNAPPY_SYSTEM_PROPERTIES_FILE = "org-xerial-snappy.properties";
    public static final String KEY_SNAPPY_LIB_PATH = "org.xerial.snappy.lib.path";
    public static final String KEY_SNAPPY_LIB_NAME = "org.xerial.snappy.lib.name";
    public static final String KEY_SNAPPY_TEMPDIR = "org.xerial.snappy.tempdir";
    public static final String KEY_SNAPPY_USE_SYSTEMLIB = "org.xerial.snappy.use.systemlib";
    public static final String KEY_SNAPPY_DISABLE_BUNDLED_LIBS = "org.xerial.snappy.disable.bundled.libs";
    private static volatile boolean isLoaded = false;
    private static volatile SnappyNative api = null;
    private static File nativeLibFile = null;

    static {
        SnappyLoader.loadSnappySystemProperties();
    }

    static void cleanUpExtractedNativeLib() {
        if (nativeLibFile != null && nativeLibFile.exists()) {
            nativeLibFile.delete();
        }
    }

    static synchronized void setApi(SnappyNative nativeCode) {
        api = nativeCode;
    }

    private static void loadSnappySystemProperties() {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(SNAPPY_SYSTEM_PROPERTIES_FILE);
            if (is == null) {
                return;
            }
            Properties props = new Properties();
            props.load(is);
            is.close();
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith("org.xerial.snappy.") || System.getProperty(name) != null) continue;
                System.setProperty(name, props.getProperty(name));
            }
        }
        catch (Throwable ex) {
            System.err.println("Could not load 'org-xerial-snappy.properties' from classpath: " + ex.toString());
        }
    }

    static synchronized SnappyNative load() {
        if (api != null) {
            return api;
        }
        try {
            SnappyLoader.loadNativeLibrary();
            SnappyLoader.setApi(new SnappyNative());
            isLoaded = true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, e2.getMessage());
        }
        return api;
    }

    private static void loadNativeLibrary() {
        nativeLibFile = SnappyLoader.findNativeLibrary();
        if (nativeLibFile != null) {
            System.load(nativeLibFile.getAbsolutePath());
        } else {
            System.loadLibrary("snappyjava");
        }
    }

    private static boolean contentsEquals(InputStream in1, InputStream in2) throws IOException {
        int ch2;
        if (!(in1 instanceof BufferedInputStream)) {
            in1 = new BufferedInputStream(in1);
        }
        if (!(in2 instanceof BufferedInputStream)) {
            in2 = new BufferedInputStream(in2);
        }
        int ch = in1.read();
        while (ch != -1) {
            ch2 = in2.read();
            if (ch != ch2) {
                return false;
            }
            ch = in1.read();
        }
        ch2 = in2.read();
        return ch2 == -1;
    }

    private static File extractLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        String nativeLibraryFilePath = String.valueOf(libFolderForCurrentOS) + "/" + libraryFileName;
        String extractedLibFileName = String.format("snappy-%s-%s", SnappyLoader.getVersion(), libraryFileName);
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        try {
            InputStream reader = SnappyLoader.class.getResourceAsStream(nativeLibraryFilePath);
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            try {
                byte[] buffer = new byte[8192];
                int bytesRead = 0;
                while ((bytesRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, bytesRead);
                }
            }
            finally {
                extractedLibFile.deleteOnExit();
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            extractedLibFile.setReadable(true);
            extractedLibFile.setWritable(true, true);
            extractedLibFile.setExecutable(true);
            InputStream nativeIn = SnappyLoader.class.getResourceAsStream(nativeLibraryFilePath);
            FileInputStream extractedLibIn = new FileInputStream(extractedLibFile);
            try {
                if (!SnappyLoader.contentsEquals(nativeIn, extractedLibIn)) {
                    throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, String.format("Failed to write a native library file at %s", extractedLibFile));
                }
            }
            finally {
                if (nativeIn != null) {
                    nativeIn.close();
                }
                if (extractedLibIn != null) {
                    ((InputStream)extractedLibIn).close();
                }
            }
            return new File(targetFolder, extractedLibFileName);
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
            return null;
        }
    }

    static File findNativeLibrary() {
        String snappyNativeLibraryName = System.mapLibraryName("snappyjava");
        File snappyLibFile = new File(String.valueOf(System.getProperty("user.home")) + "/snappy/" + String.format("snappy-%s-%s", SnappyLoader.getVersion(), snappyNativeLibraryName));
        if (snappyLibFile.exists()) {
            return snappyLibFile;
        }
        File snappyLibFolder = new File(String.valueOf(System.getProperty("user.home")) + "/snappy");
        if (!snappyLibFolder.exists()) {
            snappyLibFolder.mkdir();
        }
        String tempFolder = snappyLibFolder.getAbsolutePath();
        String snappyNativeLibraryPath = "/org/xerial/snappy/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
        return SnappyLoader.extractLibraryFile(snappyNativeLibraryPath, snappyNativeLibraryName, tempFolder);
    }

    private static boolean hasResource(String path) {
        return SnappyLoader.class.getResource(path) != null;
    }

    public static String getVersion() {
        return "1.1.1.6";
    }
}

