/*
 * Decompiled with CFR 0.152.
 */
package q.storage.columnar.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import q.datasource.io.AbstractInputStream;
import q.storage.columnar.CodecFactory;
import q.storage.columnar.QingStorageFileWriter;
import q.storage.columnar.metadata.FileMetaData;
import q.storage.columnar.metadata.a.a;
import q.storage.columnar.metadata.a.e;
import q.storage.columnar.metadata.b;
import q.storage.columnar.metadata.f;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.bytes.BytesInput;
import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.column.statistics.Statistics;
import shaded.org.apache.parquet.format.PageHeader;
import shaded.org.apache.parquet.format.PageType;
import shaded.org.apache.parquet.format.Util;
import shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import shaded.org.apache.parquet.io.api.Binary;

public class QingStorageUtils {
    public static final int DATA_TYPE_DECIMAL = 0;
    public static final int DATA_TYPE_BINARY = 1;
    public static final int DATA_TYPE_STRING = 2;
    public static final int DATA_TYPE_INT32 = 3;
    public static final int DATA_TYPE_INT64 = 4;
    public static final int DATA_TYPE_FLOAT = 5;
    public static final int DATA_TYPE_DOUBLE = 6;
    private static final Log a = Log.getLog(QingStorageUtils.class);
    private static final a b = new a();

    private static final f a(AbstractInputStream abstractInputStream, e object, boolean bl) throws IOException {
        try {
            long l2 = abstractInputStream.length();
            if (Log.DEBUG) {
                a.debug("File length " + l2);
            }
            if (l2 < (long)(QingStorageFileWriter.MAGIC.length + 4 + QingStorageFileWriter.MAGIC.length)) {
                throw new RuntimeException("not a qing-storage file (too small)");
            }
            long l3 = l2 - 4L - (long)QingStorageFileWriter.MAGIC.length;
            if (Log.DEBUG) {
                a.debug("reading footer index at " + l3);
            }
            abstractInputStream.seek(l3);
            int n2 = BytesUtils.readIntLittleEndian(abstractInputStream);
            byte[] byArray = new byte[QingStorageFileWriter.MAGIC.length];
            abstractInputStream.read(byArray);
            if (!Arrays.equals(QingStorageFileWriter.MAGIC, byArray)) {
                throw new RuntimeException("not a qing-storage file. expected magic number at tail " + Arrays.toString(QingStorageFileWriter.MAGIC) + " but found " + Arrays.toString(byArray));
            }
            long l4 = l3 - (long)n2;
            if (Log.DEBUG) {
                a.debug("read footer length: " + n2 + ", footer index: " + l4);
            }
            if (l4 < (long)QingStorageFileWriter.MAGIC.length || l4 >= l3) {
                throw new RuntimeException("corrupted file: the footer index is not within the file");
            }
            abstractInputStream.seek(l4);
            object = b.a(abstractInputStream, (e)object);
            return object;
        }
        finally {
            if (bl) {
                abstractInputStream.close();
            }
        }
    }

    public static final FileMetaData readQingStorageMetaData(AbstractInputStream abstractInputStream, boolean bl) throws IOException {
        return QingStorageUtils.a(abstractInputStream, q.storage.columnar.metadata.a.a.b, bl).b();
    }

    public static final byte[] encodeBigDecimal(BigDecimal bigDecimal, int n2) {
        byte[] byArray = bigDecimal.unscaledValue().toByteArray();
        int n3 = byArray.length - (n2 - 4);
        if (n3 > 0) {
            throw new IllegalArgumentException("byte overflow: don't have sufficient byte slots. require " + n3 + " more");
        }
        int n4 = byArray.length;
        if (n4 > 255) {
            throw new IllegalArgumentException("byte overflow: too large significand");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, -n3, byArray.length);
        int n5 = bigDecimal.scale();
        byArray2[n2 - 4] = (byte)n4;
        byArray2[n2 - 3] = (byte)(n5 >>> 16);
        byArray2[n2 - 2] = (byte)(n5 >>> 8);
        byArray2[n2 - 1] = (byte)n5;
        return byArray2;
    }

    public static final BigDecimal decodeBigDecimal(byte[] byArray) {
        int n2 = byArray.length - 4;
        byte by = byArray[n2];
        byte[] byArray2 = new byte[by];
        System.arraycopy(byArray, n2 - by, byArray2, 0, by);
        int n3 = byArray[n2 + 1] << 16 | byArray[n2 + 2] << 8 | byArray[n2 + 3];
        return new BigDecimal(new BigInteger(byArray2), n3);
    }

    public static final Set getDistinctValuesFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl, int n2) throws IOException {
        Object object = QingStorageUtils.a(abstractInputStream, q.storage.columnar.metadata.a.a.a, false).a();
        HashSet<Object> hashSet = new HashSet<Object>();
        CodecFactory codecFactory = new CodecFactory();
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Iterator iterator = (q.storage.columnar.metadata.a)object.next();
                iterator = ((q.storage.columnar.metadata.a)((Object)iterator)).d();
                iterator = iterator.iterator();
                block13: while (iterator.hasNext()) {
                    Object object2 = (b)iterator.next();
                    if (!((b)object2).c().equals(columnPath)) continue;
                    abstractInputStream.seek(((b)object2).a());
                    PageHeader pageHeader = Util.readPageHeader(abstractInputStream);
                    if (pageHeader.type == PageType.DICTIONARY_PAGE) {
                        if (((b)object2).j().getNumNulls() > 0L) {
                            hashSet.add(null);
                        }
                        int n3 = pageHeader.getUncompressed_page_size();
                        int n4 = pageHeader.getCompressed_page_size();
                        byte[] byArray = new byte[n4];
                        abstractInputStream.read(byArray);
                        object2 = codecFactory.getDecompressor(((b)object2).b()).a(BytesInput.from(byArray), n3).toByteArray();
                        switch (n2) {
                            case 0: {
                                Binary binary;
                                int n5;
                                n4 = 0;
                                int n6 = pageHeader.getDictionary_page_header().getNum_values();
                                for (n3 = 0; n3 < n6; ++n3) {
                                    n5 = BytesUtils.readIntLittleEndian((byte[])object2, n4);
                                    binary = Binary.fromConstantByteArray((byte[])object2, n4 += 4, n5);
                                    hashSet.add(QingStorageUtils.decodeBigDecimal(binary.getBytes()));
                                    n4 += n5;
                                }
                                continue block13;
                            }
                            case 1: {
                                int n5;
                                n4 = 0;
                                int n7 = pageHeader.getDictionary_page_header().getNum_values();
                                for (n3 = 0; n3 < n7; ++n3) {
                                    n5 = BytesUtils.readIntLittleEndian((byte[])object2, n4);
                                    hashSet.add(Binary.fromConstantByteArray((byte[])object2, n4 += 4, n5));
                                    n4 += n5;
                                }
                                continue block13;
                            }
                            case 2: {
                                Binary binary;
                                int n5;
                                n4 = 0;
                                int n8 = pageHeader.getDictionary_page_header().getNum_values();
                                for (n3 = 0; n3 < n8; ++n3) {
                                    n5 = BytesUtils.readIntLittleEndian((byte[])object2, n4);
                                    binary = Binary.fromConstantByteArray((byte[])object2, n4 += 4, n5);
                                    hashSet.add(binary.toStringUsingUTF8());
                                    n4 += n5;
                                }
                                continue block13;
                            }
                            case 3: {
                                int n5;
                                n4 = pageHeader.getDictionary_page_header().getNum_values();
                                for (n3 = 0; n3 < n4; ++n3) {
                                    int n9 = n3 << 2;
                                    n5 = ((object2[n9 + 3] & 0xFF) << 24) + ((object2[n9 + 2] & 0xFF) << 16) + ((object2[n9 + 1] & 0xFF) << 8) + (object2[n9] & 0xFF);
                                    hashSet.add(n5);
                                }
                                continue block13;
                            }
                            case 4: {
                                long l2;
                                n4 = pageHeader.getDictionary_page_header().getNum_values();
                                for (n3 = 0; n3 < n4; ++n3) {
                                    int n10 = n3 << 3;
                                    l2 = ((long)object2[n10 + 7] << 56) + ((long)(object2[n10 + 6] & 0xFF) << 48) + ((long)(object2[n10 + 5] & 0xFF) << 40) + ((long)(object2[n10 + 4] & 0xFF) << 32) + ((long)(object2[n10 + 3] & 0xFF) << 24) + ((long)(object2[n10 + 2] & 0xFF) << 16) + ((long)(object2[n10 + 1] & 0xFF) << 8) + (long)(object2[n10] & 0xFF);
                                    hashSet.add(l2);
                                }
                                continue block13;
                            }
                            case 5: {
                                int n5;
                                n4 = pageHeader.getDictionary_page_header().getNum_values();
                                for (n3 = 0; n3 < n4; ++n3) {
                                    int n11 = n3 << 2;
                                    n5 = ((object2[n11 + 3] & 0xFF) << 24) + ((object2[n11 + 2] & 0xFF) << 16) + ((object2[n11 + 1] & 0xFF) << 8) + (object2[n11] & 0xFF);
                                    hashSet.add(Float.valueOf(Float.intBitsToFloat(n5)));
                                }
                                continue block13;
                            }
                            case 6: {
                                long l2;
                                n4 = pageHeader.getDictionary_page_header().getNum_values();
                                for (n3 = 0; n3 < n4; ++n3) {
                                    int n12 = n3 << 3;
                                    l2 = ((long)object2[n12 + 7] << 56) + ((long)(object2[n12 + 6] & 0xFF) << 48) + ((long)(object2[n12 + 5] & 0xFF) << 40) + ((long)(object2[n12 + 4] & 0xFF) << 32) + ((long)(object2[n12 + 3] & 0xFF) << 24) + ((long)(object2[n12 + 2] & 0xFF) << 16) + ((long)(object2[n12 + 1] & 0xFF) << 8) + (long)(object2[n12] & 0xFF);
                                    hashSet.add(Double.longBitsToDouble(l2));
                                }
                                continue block13;
                            }
                            default: {
                                throw new IllegalArgumentException("unknown data type parameter");
                            }
                        }
                    }
                    return null;
                }
            }
        }
        finally {
            if (bl) {
                abstractInputStream.close();
            }
        }
        return hashSet;
    }

    public static final Set getDistinctDecimalValuesFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        return QingStorageUtils.getDistinctValuesFast(abstractInputStream, columnPath, bl, 0);
    }

    public static final Set getDistinctBinaryValuesFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        return QingStorageUtils.getDistinctValuesFast(abstractInputStream, columnPath, bl, 1);
    }

    public static final Set getDistinctStringValuesFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        return QingStorageUtils.getDistinctValuesFast(abstractInputStream, columnPath, bl, 2);
    }

    public static final Set getDistinctIntegerValuesFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        return QingStorageUtils.getDistinctValuesFast(abstractInputStream, columnPath, bl, 3);
    }

    public static final Set getDistinctLongValuesFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        return QingStorageUtils.getDistinctValuesFast(abstractInputStream, columnPath, bl, 4);
    }

    public static final Set getDistinctFloatValuesFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        return QingStorageUtils.getDistinctValuesFast(abstractInputStream, columnPath, bl, 5);
    }

    public static final Set getDistinctDoubleValuesFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        return QingStorageUtils.getDistinctValuesFast(abstractInputStream, columnPath, bl, 6);
    }

    public static final int getApproxDistinctCountFast(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        Object object = QingStorageUtils.a(abstractInputStream, q.storage.columnar.metadata.a.a.a, false).a();
        int n2 = 0;
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Iterator iterator = (q.storage.columnar.metadata.a)object.next();
                iterator = ((q.storage.columnar.metadata.a)((Object)iterator)).d();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Object object2 = (b)iterator.next();
                    if (!((b)object2).c().equals(columnPath)) continue;
                    abstractInputStream.seek(((b)object2).a());
                    object2 = Util.readPageHeader(abstractInputStream);
                    if (((PageHeader)object2).type == PageType.DICTIONARY_PAGE) {
                        int n3 = ((PageHeader)object2).getDictionary_page_header().getNum_values();
                        n2 = n2 < n3 ? n3 : n2;
                        continue;
                    }
                    return -1;
                }
            }
        }
        finally {
            if (bl) {
                abstractInputStream.close();
            }
        }
        return n2;
    }

    public static final Statistics getStatistics(AbstractInputStream abstractInputStream, ColumnPath columnPath, boolean bl) throws IOException {
        Object object = QingStorageUtils.a(abstractInputStream, q.storage.columnar.metadata.a.a.a, false).a();
        try {
            Statistics statistics = null;
            object = object.iterator();
            while (object.hasNext()) {
                Iterator iterator = (q.storage.columnar.metadata.a)object.next();
                iterator = ((q.storage.columnar.metadata.a)((Object)iterator)).d();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    b b2 = (b)iterator.next();
                    if (!b2.c().equals(columnPath)) continue;
                    if (statistics == null) {
                        statistics = Statistics.getStatsBasedOnType(b2.d());
                    }
                    statistics.mergeStatistics(b2.j());
                }
            }
            object = statistics;
            return object;
        }
        finally {
            if (bl) {
                abstractInputStream.close();
            }
        }
    }
}

