/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T checkNotNull(T o2, String name) throws NullPointerException {
        if (o2 == null) {
            throw new NullPointerException(name + " should not be null");
        }
        return o2;
    }

    public static void checkArgument(boolean isValid, String message) throws IllegalArgumentException {
        if (!isValid) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean isValid, String message, Object ... args) throws IllegalArgumentException {
        if (!isValid) {
            throw new IllegalArgumentException(String.format(String.valueOf(message), Preconditions.strings(args)));
        }
    }

    public static void checkState(boolean isValid, String message) throws IllegalStateException {
        if (!isValid) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkState(boolean isValid, String message, Object ... args) throws IllegalStateException {
        if (!isValid) {
            throw new IllegalStateException(String.format(String.valueOf(message), Preconditions.strings(args)));
        }
    }

    private static String[] strings(Object[] objects) {
        String[] strings = new String[objects.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            strings[i2] = String.valueOf(objects[i2]);
        }
        return strings;
    }
}

