/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.column.values.ValuesReader;
import shaded.org.apache.parquet.column.values.bitpacking.BitPacking;
import shaded.org.apache.parquet.io.ParquetDecodingException;

public class BitPackingValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BitPackingValuesReader.class);
    private ByteArrayInputStream in;
    private BitPacking.BitPackingReader bitPackingReader;
    private final int bitsPerValue;
    private int nextOffset;

    public BitPackingValuesReader(int bound) {
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt(bound);
    }

    @Override
    public int readInteger() {
        try {
            return this.bitPackingReader.read();
        }
        catch (IOException e2) {
            throw new ParquetDecodingException(e2);
        }
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        int effectiveBitLength = valueCount * this.bitsPerValue;
        int length = BytesUtils.paddedByteCountFromBits(effectiveBitLength);
        if (Log.DEBUG) {
            LOG.debug("reading " + length + " bytes for " + valueCount + " values of size " + this.bitsPerValue + " bits.");
        }
        this.in = new ByteArrayInputStream(in, offset, length);
        this.bitPackingReader = BitPacking.createBitPackingReader(this.bitsPerValue, this.in, valueCount);
        this.nextOffset = offset + length;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

