/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.plain;

import java.io.IOException;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.column.values.ValuesReader;
import shaded.org.apache.parquet.io.ParquetDecodingException;
import shaded.org.apache.parquet.io.api.Binary;

public class FixedLenByteArrayPlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(FixedLenByteArrayPlainValuesReader.class);
    private byte[] in;
    private int offset;
    private int length;

    public FixedLenByteArrayPlainValuesReader(int length) {
        this.length = length;
    }

    @Override
    public Binary readBytes() {
        try {
            int start = this.offset;
            this.offset = start + this.length;
            return Binary.fromConstantByteArray(this.in, start, this.length);
        }
        catch (RuntimeException e2) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e2);
        }
    }

    @Override
    public void skip() {
        this.offset += this.length;
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.in = in;
        this.offset = offset;
    }
}

