/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleIterators;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectIterators;

public abstract class AbstractDoubleCollection
extends AbstractCollection<Double>
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    @Override
    public double[] toArray(double[] a2) {
        return this.toDoubleArray(a2);
    }

    @Override
    public double[] toDoubleArray() {
        return this.toDoubleArray(null);
    }

    @Override
    public double[] toDoubleArray(double[] a2) {
        if (a2 == null || a2.length < this.size()) {
            a2 = new double[this.size()];
        }
        DoubleIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public boolean addAll(DoubleCollection c2) {
        boolean retVal = false;
        DoubleIterator i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (!this.add(i2.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean containsAll(DoubleCollection c2) {
        DoubleIterator i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (this.contains(i2.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(DoubleCollection c2) {
        boolean retVal = false;
        int n2 = this.size();
        DoubleIterator i2 = this.iterator();
        while (n2-- != 0) {
            if (c2.contains(i2.nextDouble())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(DoubleCollection c2) {
        boolean retVal = false;
        int n2 = c2.size();
        DoubleIterator i2 = c2.iterator();
        while (n2-- != 0) {
            if (!this.rem(i2.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public Object[] toArray() {
        Object[] a2 = new Object[this.size()];
        ObjectIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.size()) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public boolean addAll(Collection<? extends Double> c2) {
        boolean retVal = false;
        Iterator<? extends Double> i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (!this.add(i2.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean add(double k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public DoubleIterator doubleIterator() {
        return this.iterator();
    }

    @Override
    public abstract DoubleIterator iterator();

    @Override
    public boolean remove(Object ok) {
        return this.rem((Double)ok);
    }

    @Override
    public boolean add(Double o2) {
        return this.add((double)o2);
    }

    public boolean rem(Object o2) {
        return this.rem((Double)o2);
    }

    @Override
    public boolean contains(Object o2) {
        return this.contains((Double)o2);
    }

    @Override
    public boolean contains(double k2) {
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextDouble()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(double k2) {
        DoubleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextDouble()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        int n2 = c2.size();
        Iterator<?> i2 = c2.iterator();
        while (n2-- != 0) {
            if (this.contains(i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        boolean retVal = false;
        int n2 = this.size();
        DoubleIterator i2 = this.iterator();
        while (n2-- != 0) {
            if (c2.contains(i2.next())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean retVal = false;
        int n2 = c2.size();
        Iterator<?> i2 = c2.iterator();
        while (n2-- != 0) {
            if (!this.remove(i2.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        DoubleIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            double k2 = i2.nextDouble();
            s2.append(String.valueOf(k2));
        }
        s2.append("}");
        return s2.toString();
    }
}

