/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.longs;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.HashCommon;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.longs.LongCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.longs.LongList;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.longs.LongListIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.longs.LongStack;

public abstract class AbstractLongList
extends AbstractLongCollection
implements LongList,
LongStack {
    protected AbstractLongList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index, long k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(long k2) {
        this.add(this.size(), k2);
        return true;
    }

    @Override
    public long removeLong(int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long set(int index, long k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c2) {
        this.ensureIndex(index);
        int n2 = c2.size();
        if (n2 == 0) {
            return false;
        }
        Iterator<? extends Long> i2 = c2.iterator();
        while (n2-- != 0) {
            this.add(index++, i2.next());
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    @Deprecated
    public LongListIterator longListIterator() {
        return this.listIterator();
    }

    @Override
    @Deprecated
    public LongListIterator longListIterator(int index) {
        return this.listIterator(index);
    }

    @Override
    public LongListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public LongListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public LongListIterator listIterator(final int index) {
        return new AbstractLongListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractLongList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractLongList.this.getLong(this.last);
            }

            @Override
            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractLongList.this.getLong(this.pos);
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(long k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.add(this.pos++, k2);
                this.last = -1;
            }

            @Override
            public void set(long k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.removeLong(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(long k2) {
        return this.indexOf(k2) >= 0;
    }

    @Override
    public int indexOf(long k2) {
        LongListIterator i2 = this.listIterator();
        while (i2.hasNext()) {
            long e2 = i2.nextLong();
            if (k2 != e2) continue;
            return i2.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long k2) {
        LongListIterator i2 = this.listIterator(this.size());
        while (i2.hasPrevious()) {
            long e2 = i2.previousLong();
            if (k2 != e2) continue;
            return i2.nextIndex();
        }
        return -1;
    }

    @Override
    public void size(int size) {
        int i2 = this.size();
        if (size > i2) {
            while (i2++ < size) {
                this.add(0L);
            }
        } else {
            while (i2-- != size) {
                this.remove(i2);
            }
        }
    }

    @Override
    public LongList subList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new LongSubList(this, from, to);
    }

    @Override
    @Deprecated
    public LongList longSubList(int from, int to) {
        return this.subList(from, to);
    }

    @Override
    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        LongListIterator i2 = this.listIterator(from);
        int n2 = to - from;
        if (n2 < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n2-- != 0) {
            i2.nextLong();
            i2.remove();
        }
    }

    @Override
    public void addElements(int index, long[] a2, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a2.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a2.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a2[offset++]);
        }
    }

    @Override
    public void addElements(int index, long[] a2) {
        this.addElements(index, a2, 0, a2.length);
    }

    @Override
    public void getElements(int from, long[] a2, int offset, int length) {
        LongListIterator i2 = this.listIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a2.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a2.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a2[offset++] = i2.nextLong();
        }
    }

    private boolean valEquals(Object a2, Object b2) {
        return a2 == null ? b2 == null : a2.equals(b2);
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        List l2 = (List)o2;
        int s2 = this.size();
        if (s2 != l2.size()) {
            return false;
        }
        if (l2 instanceof LongList) {
            LongListIterator i1 = this.listIterator();
            LongListIterator i2 = ((LongList)l2).listIterator();
            while (s2-- != 0) {
                if (i1.nextLong() == i2.nextLong()) continue;
                return false;
            }
            return true;
        }
        LongListIterator i1 = this.listIterator();
        ListIterator i2 = l2.listIterator();
        while (s2-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Long> l2) {
        if (l2 == this) {
            return 0;
        }
        if (l2 instanceof LongList) {
            LongListIterator i1 = this.listIterator();
            LongListIterator i2 = ((LongList)l2).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r2;
                long e2;
                long e1 = i1.nextLong();
                if ((e1 < (e2 = i2.nextLong()) ? -1 : (r2 = e1 == e2 ? 0 : 1)) == 0) continue;
                return r2;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        LongListIterator i1 = this.listIterator();
        ListIterator<? extends Long> i2 = l2.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r3 = ((Comparable)i1.next()).compareTo(i2.next());
            if (r3 == 0) continue;
            return r3;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public int hashCode() {
        LongListIterator i2 = this.iterator();
        int h2 = 1;
        int s2 = this.size();
        while (s2-- != 0) {
            long k2 = i2.nextLong();
            h2 = 31 * h2 + HashCommon.long2int(k2);
        }
        return h2;
    }

    @Override
    public void push(long o2) {
        this.add(o2);
    }

    @Override
    public long popLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeLong(this.size() - 1);
    }

    @Override
    public long topLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getLong(this.size() - 1);
    }

    @Override
    public long peekLong(int i2) {
        return this.getLong(this.size() - 1 - i2);
    }

    @Override
    public boolean rem(long k2) {
        int index = this.indexOf(k2);
        if (index == -1) {
            return false;
        }
        this.removeLong(index);
        return true;
    }

    @Override
    public boolean remove(Object o2) {
        return this.rem((Long)o2);
    }

    @Override
    public boolean addAll(int index, LongCollection c2) {
        return this.addAll(index, (Collection<? extends Long>)c2);
    }

    @Override
    public boolean addAll(int index, LongList l2) {
        return this.addAll(index, (LongCollection)l2);
    }

    @Override
    public boolean addAll(LongCollection c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    public boolean addAll(LongList l2) {
        return this.addAll(this.size(), l2);
    }

    @Override
    public void add(int index, Long ok) {
        this.add(index, (long)ok);
    }

    @Override
    public Long set(int index, Long ok) {
        return this.set(index, (long)ok);
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public int indexOf(Object ok) {
        return this.indexOf((Long)ok);
    }

    @Override
    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Long)ok);
    }

    @Override
    public Long remove(int index) {
        return this.removeLong(index);
    }

    @Override
    public void push(Long o2) {
        this.push((long)o2);
    }

    @Override
    public Long pop() {
        return this.popLong();
    }

    @Override
    public Long top() {
        return this.topLong();
    }

    @Override
    public Long peek(int i2) {
        return this.peekLong(i2);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        LongListIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("[");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            long k2 = i2.nextLong();
            s2.append(String.valueOf(k2));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class LongSubList
    extends AbstractLongList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final LongList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public LongSubList(LongList l2, int from, int to) {
            this.l = l2;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        @Override
        public boolean add(long k2) {
            this.l.add(this.to, k2);
            ++this.to;
            return true;
        }

        @Override
        public void add(int index, long k2) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k2);
            ++this.to;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c2) {
            this.ensureIndex(index);
            this.to += c2.size();
            return this.l.addAll(this.from + index, c2);
        }

        @Override
        public long getLong(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getLong(this.from + index);
        }

        @Override
        public long removeLong(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeLong(this.from + index);
        }

        @Override
        public long set(int index, long k2) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k2);
        }

        @Override
        public void clear() {
            this.removeElements(0, this.size());
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from, long[] a2, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a2, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        @Override
        public void addElements(int index, long[] a2, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a2, offset, length);
            this.to += length;
        }

        @Override
        public LongListIterator listIterator(final int index) {
            this.ensureIndex(index);
            return new AbstractLongListIterator(){
                int pos;
                int last;
                {
                    this.pos = index;
                    this.last = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < LongSubList.this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return LongSubList.this.l.getLong(LongSubList.this.from + this.last);
                }

                @Override
                public long previousLong() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return LongSubList.this.l.getLong(LongSubList.this.from + this.pos);
                }

                @Override
                public int nextIndex() {
                    return this.pos;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void add(long k2) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    LongSubList.this.add(this.pos++, k2);
                    this.last = -1;
                }

                @Override
                public void set(long k2) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    LongSubList.this.set(this.last, k2);
                }

                @Override
                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    LongSubList.this.removeLong(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        @Override
        public LongList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new LongSubList(this, from, to);
        }

        @Override
        public boolean rem(long k2) {
            int index = this.indexOf(k2);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeLong(this.from + index);
            return true;
        }

        @Override
        public boolean remove(Object o2) {
            return this.rem((Long)o2);
        }

        @Override
        public boolean addAll(int index, LongCollection c2) {
            this.ensureIndex(index);
            this.to += c2.size();
            return this.l.addAll(this.from + index, c2);
        }

        @Override
        public boolean addAll(int index, LongList l2) {
            this.ensureIndex(index);
            this.to += l2.size();
            return this.l.addAll(this.from + index, l2);
        }
    }
}

