/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.Hash;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.HashCommon;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.booleans.BooleanArrays;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntListIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.AbstractObject2IntSortedMap;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.Object2IntMap;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectArrays;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectSortedSet;

public class Object2IntLinkedOpenHashMap<K>
extends AbstractObject2IntSortedMap<K>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient int[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Object2IntSortedMap.FastSortedEntrySet<K> entries;
    protected volatile transient ObjectSortedSet<K> keys;
    protected volatile transient IntCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;

    public Object2IntLinkedOpenHashMap(int expected, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.n = HashCommon.arraySize(expected, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new Object[this.n];
        this.value = new int[this.n];
        this.used = new boolean[this.n];
        this.link = new long[this.n];
    }

    public Object2IntLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Object2IntLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Object2IntLinkedOpenHashMap(Map<? extends K, ? extends Integer> m2, float f2) {
        this(m2.size(), f2);
        this.putAll(m2);
    }

    public Object2IntLinkedOpenHashMap(Map<? extends K, ? extends Integer> m2) {
        this(m2, 0.75f);
    }

    public Object2IntLinkedOpenHashMap(Object2IntMap<K> m2, float f2) {
        this(m2.size(), f2);
        this.putAll(m2);
    }

    public Object2IntLinkedOpenHashMap(Object2IntMap<K> m2) {
        this(m2, 0.75f);
    }

    public Object2IntLinkedOpenHashMap(K[] k2, int[] v, float f2) {
        this(k2.length, f2);
        if (k2.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k2.length + " and " + v.length + ")");
        }
        for (int i2 = 0; i2 < k2.length; ++i2) {
            this.put(k2[i2], v[i2]);
        }
    }

    public Object2IntLinkedOpenHashMap(K[] k2, int[] v) {
        this(k2, v, 0.75f);
    }

    @Override
    public int put(K k2, int v) {
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k2 == null : this.key[pos].equals(k2)) {
                int oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k2;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n2 = this.last;
            this.link[n2] = this.link[n2] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Integer put(K ok, Integer ov) {
        int v = ov;
        K k2 = ok;
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k2 == null : this.key[pos].equals(k2)) {
                Integer oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k2;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n2 = this.last;
            this.link[n2] = this.link[n2] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    @Deprecated
    public int add(K k2, int incr) {
        return this.addTo(k2, incr);
    }

    public int addTo(K k2, int incr) {
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k2 == null : this.key[pos].equals(k2)) {
                int oldValue = this.value[pos];
                int n2 = pos;
                this.value[n2] = this.value[n2] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k2;
        this.value[pos] = this.defRetValue + incr;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n3 = this.last;
            this.link[n3] = this.link[n3] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(this.key[pos].hashCode() ^ this.mask)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
        this.key[last] = null;
        return last;
    }

    @Override
    public int removeInt(Object k2) {
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k2 == null : this.key[pos].equals(k2)) {
                --this.size;
                this.fixPointers(pos);
                int v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Integer remove(Object ok) {
        Object k2 = ok;
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k2 == null : this.key[pos].equals(k2)) {
                --this.size;
                this.fixPointers(pos);
                int v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public int removeFirstInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.first;
        this.first = (int)this.link[pos];
        if (0 <= this.first) {
            int n2 = this.first;
            this.link[n2] = this.link[n2] | 0xFFFFFFFF00000000L;
        }
        int v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    public int removeLastInt() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.last;
        this.last = (int)(this.link[pos] >>> 32);
        if (0 <= this.last) {
            int n2 = this.last;
            this.link[n2] = this.link[n2] | 0xFFFFFFFFL;
        }
        int v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    private void moveIndexToFirst(int i2) {
        if (this.size == 1 || this.first == i2) {
            return;
        }
        if (this.last == i2) {
            int n2 = this.last = (int)(this.link[i2] >>> 32);
            this.link[n2] = this.link[n2] | 0xFFFFFFFFL;
        } else {
            long linki = this.link[i2];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n3 = prev;
            this.link[n3] = this.link[n3] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n4 = next;
            this.link[n4] = this.link[n4] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n5 = this.first;
        this.link[n5] = this.link[n5] ^ (this.link[this.first] ^ ((long)i2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[i2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = i2;
    }

    private void moveIndexToLast(int i2) {
        if (this.size == 1 || this.last == i2) {
            return;
        }
        if (this.first == i2) {
            int n2 = this.first = (int)this.link[i2];
            this.link[n2] = this.link[n2] | 0xFFFFFFFF00000000L;
        } else {
            long linki = this.link[i2];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n3 = prev;
            this.link[n3] = this.link[n3] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n4 = next;
            this.link[n4] = this.link[n4] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n5 = this.last;
        this.link[n5] = this.link[n5] ^ (this.link[this.last] ^ (long)i2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[i2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = i2;
    }

    public int getAndMoveToFirst(K k2) {
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ mask)) & mask;
        while (used[pos]) {
            if (k2 == null ? key[pos] == null : k2.equals(key[pos])) {
                this.moveIndexToFirst(pos);
                return this.value[pos];
            }
            pos = pos + 1 & mask;
        }
        return this.defRetValue;
    }

    public int getAndMoveToLast(K k2) {
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ mask)) & mask;
        while (used[pos]) {
            if (k2 == null ? key[pos] == null : k2.equals(key[pos])) {
                this.moveIndexToLast(pos);
                return this.value[pos];
            }
            pos = pos + 1 & mask;
        }
        return this.defRetValue;
    }

    public int putAndMoveToFirst(K k2, int v) {
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ mask)) & mask;
        while (used[pos]) {
            if (k2 == null ? key[pos] == null : k2.equals(key[pos])) {
                int oldValue = this.value[pos];
                this.value[pos] = v;
                this.moveIndexToFirst(pos);
                return oldValue;
            }
            pos = pos + 1 & mask;
        }
        used[pos] = true;
        key[pos] = k2;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n2 = this.first;
            this.link[n2] = this.link[n2] ^ (this.link[this.first] ^ ((long)pos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[pos] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public int putAndMoveToLast(K k2, int v) {
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ mask)) & mask;
        while (used[pos]) {
            if (k2 == null ? key[pos] == null : k2.equals(key[pos])) {
                int oldValue = this.value[pos];
                this.value[pos] = v;
                this.moveIndexToLast(pos);
                return oldValue;
            }
            pos = pos + 1 & mask;
        }
        used[pos] = true;
        key[pos] = k2;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n2 = this.last;
            this.link[n2] = this.link[n2] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public int getInt(Object k2) {
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k2 == null : this.key[pos].equals(k2)) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(Object k2) {
        int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k2 == null : this.key[pos].equals(k2)) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(int v) {
        int[] value = this.value;
        boolean[] used = this.used;
        int i2 = this.n;
        while (i2-- != 0) {
            if (!used[i2] || value[i2] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i2) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i2) {
            this.first = (int)this.link[i2];
            if (0 <= this.first) {
                int n2 = this.first;
                this.link[n2] = this.link[n2] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == i2) {
            this.last = (int)(this.link[i2] >>> 32);
            if (0 <= this.last) {
                int n3 = this.last;
                this.link[n3] = this.link[n3] | 0xFFFFFFFFL;
            }
            return;
        }
        long linki = this.link[i2];
        int prev = (int)(linki >>> 32);
        int next = (int)linki;
        int n4 = prev;
        this.link[n4] = this.link[n4] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n5 = next;
        this.link[n5] = this.link[n5] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int s2, int d2) {
        if (this.size == 1) {
            this.first = this.last = d2;
            this.link[d2] = -1L;
            return;
        }
        if (this.first == s2) {
            this.first = d2;
            int n2 = (int)this.link[s2];
            this.link[n2] = this.link[n2] ^ (this.link[(int)this.link[s2]] ^ ((long)d2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[d2] = this.link[s2];
            return;
        }
        if (this.last == s2) {
            this.last = d2;
            int n3 = (int)(this.link[s2] >>> 32);
            this.link[n3] = this.link[n3] ^ (this.link[(int)(this.link[s2] >>> 32)] ^ (long)d2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[d2] = this.link[s2];
            return;
        }
        long links = this.link[s2];
        int prev = (int)(links >>> 32);
        int next = (int)links;
        int n4 = prev;
        this.link[n4] = this.link[n4] ^ (this.link[prev] ^ (long)d2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n5 = next;
        this.link[n5] = this.link[n5] ^ (this.link[next] ^ ((long)d2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[d2] = links;
    }

    @Override
    public K firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public K lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public Object2IntSortedMap<K> tailMap(K from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object2IntSortedMap<K> headMap(K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object2IntSortedMap<K> subMap(K from, K to) {
        throw new UnsupportedOperationException();
    }

    public Object2IntSortedMap.FastSortedEntrySet<K> object2IntEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ObjectSortedSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new AbstractIntCollection(){

                @Override
                public IntIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Object2IntLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(int v) {
                    return Object2IntLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Object2IntLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l2 = HashCommon.arraySize(this.size, this.f);
        if (l2 >= this.n) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n2) {
        int l2 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (this.n <= l2) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i2 = this.first;
        int prev = -1;
        int newPrev = -1;
        K[] key = this.key;
        int[] value = this.value;
        int mask = newN - 1;
        Object[] newKey = new Object[newN];
        int[] newValue = new int[newN];
        boolean[] newUsed = new boolean[newN];
        long[] link = this.link;
        long[] newLink = new long[newN];
        this.first = -1;
        int j2 = this.size;
        while (j2-- != 0) {
            K k2 = key[i2];
            int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ mask)) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k2;
            newValue[pos] = value[i2];
            if (prev != -1) {
                int n2 = newPrev;
                newLink[n2] = newLink[n2] ^ (newLink[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n3 = pos;
                newLink[n3] = newLink[n3] ^ (newLink[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1L;
            }
            int t2 = i2;
            i2 = (int)link[i2];
            prev = t2;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n4 = newPrev;
            newLink[n4] = newLink[n4] | 0xFFFFFFFFL;
        }
    }

    public Object2IntLinkedOpenHashMap<K> clone() {
        Object2IntLinkedOpenHashMap c2;
        try {
            c2 = (Object2IntLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.keys = null;
        c2.values = null;
        c2.entries = null;
        c2.key = (Object[])this.key.clone();
        c2.value = (int[])this.value.clone();
        c2.used = (boolean[])this.used.clone();
        c2.link = (long[])this.link.clone();
        return c2;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int j2 = this.size;
        int i2 = 0;
        int t2 = 0;
        while (j2-- != 0) {
            while (!this.used[i2]) {
                ++i2;
            }
            if (this != this.key[i2]) {
                t2 = this.key[i2] == null ? 0 : this.key[i2].hashCode();
            }
            h2 += (t2 ^= this.value[i2]);
            ++i2;
        }
        return h2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        K[] key = this.key;
        int[] value = this.value;
        MapIterator i2 = new MapIterator();
        s2.defaultWriteObject();
        int j2 = this.size;
        while (j2-- != 0) {
            int e2 = i2.nextEntry();
            s2.writeObject(key[e2]);
            s2.writeInt(value[e2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n];
        Object[] key = this.key;
        this.value = new int[this.n];
        int[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new long[this.n];
        long[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i2 = this.size;
        int pos = 0;
        while (i2-- != 0) {
            Object k2 = s2.readObject();
            int v = s2.readInt();
            pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ this.mask)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k2;
            value[pos] = v;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ (link[prev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n3 = pos;
                link[n3] = link[n3] ^ (link[pos] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            int n4 = pos;
            link[n4] = link[n4] | 0xFFFFFFFF00000000L;
        }
        this.last = prev;
        if (prev != -1) {
            int n5 = prev;
            link[n5] = link[n5] | 0xFFFFFFFFL;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements IntListIterator {
        @Override
        public int previousInt() {
            return Object2IntLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Integer previous() {
            return Object2IntLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(Integer ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Integer ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextInt() {
            return Object2IntLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Integer next() {
            return Object2IntLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractObjectSortedSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectListIterator<K> iterator(K from) {
            return new KeyIterator(from);
        }

        @Override
        public ObjectListIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Object2IntLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(Object k2) {
            return Object2IntLinkedOpenHashMap.this.containsKey(k2);
        }

        @Override
        public boolean remove(Object k2) {
            int oldSize = Object2IntLinkedOpenHashMap.this.size;
            Object2IntLinkedOpenHashMap.this.remove(k2);
            return Object2IntLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Object2IntLinkedOpenHashMap.this.clear();
        }

        @Override
        public K first() {
            if (Object2IntLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Object2IntLinkedOpenHashMap.this.key[Object2IntLinkedOpenHashMap.this.first];
        }

        @Override
        public K last() {
            if (Object2IntLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Object2IntLinkedOpenHashMap.this.key[Object2IntLinkedOpenHashMap.this.last];
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public final ObjectSortedSet<K> tailSet(K from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ObjectSortedSet<K> headSet(K to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ObjectSortedSet<K> subSet(K from, K to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator<K> {
        public KeyIterator(K k2) {
            super(k2);
        }

        @Override
        public K previous() {
            return Object2IntLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(K k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(K k2) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public K next() {
            return Object2IntLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Object2IntMap.Entry<K>>
    implements Object2IntSortedMap.FastSortedEntrySet<K> {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Object2IntMap.Entry<K>> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Object2IntMap.Entry<K>> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Object2IntMap.Entry<K>> subSet(Object2IntMap.Entry<K> fromElement, Object2IntMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Object2IntMap.Entry<K>> headSet(Object2IntMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Object2IntMap.Entry<K>> tailSet(Object2IntMap.Entry<K> fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object2IntMap.Entry<K> first() {
            if (Object2IntLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Object2IntLinkedOpenHashMap.this.first);
        }

        @Override
        public Object2IntMap.Entry<K> last() {
            if (Object2IntLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Object2IntLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object k2 = e2.getKey();
            int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ Object2IntLinkedOpenHashMap.this.mask)) & Object2IntLinkedOpenHashMap.this.mask;
            while (Object2IntLinkedOpenHashMap.this.used[pos]) {
                if (Object2IntLinkedOpenHashMap.this.key[pos] == null ? k2 == null : Object2IntLinkedOpenHashMap.this.key[pos].equals(k2)) {
                    return Object2IntLinkedOpenHashMap.this.value[pos] == (Integer)e2.getValue();
                }
                pos = pos + 1 & Object2IntLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object k2 = e2.getKey();
            int pos = (k2 == null ? 142593372 : HashCommon.murmurHash3(k2.hashCode() ^ Object2IntLinkedOpenHashMap.this.mask)) & Object2IntLinkedOpenHashMap.this.mask;
            while (Object2IntLinkedOpenHashMap.this.used[pos]) {
                if (Object2IntLinkedOpenHashMap.this.key[pos] == null ? k2 == null : Object2IntLinkedOpenHashMap.this.key[pos].equals(k2)) {
                    Object2IntLinkedOpenHashMap.this.remove(e2.getKey());
                    return true;
                }
                pos = pos + 1 & Object2IntLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Object2IntLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Object2IntLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Object2IntMap.Entry<K>> iterator(Object2IntMap.Entry<K> from) {
            return new EntryIterator(from.getKey());
        }

        @Override
        public ObjectBidirectionalIterator<Object2IntMap.Entry<K>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Object2IntMap.Entry<K>> fastIterator(Object2IntMap.Entry<K> from) {
            return new FastEntryIterator(from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2IntMap.Entry<K>> {
        final AbstractObject2IntMap.BasicEntry<K> entry;

        public FastEntryIterator() {
            this.entry = new AbstractObject2IntMap.BasicEntry<Object>(null, 0);
        }

        public FastEntryIterator(K from) {
            super(from);
            this.entry = new AbstractObject2IntMap.BasicEntry<Object>(null, 0);
        }

        @Override
        public AbstractObject2IntMap.BasicEntry<K> next() {
            int e2 = this.nextEntry();
            this.entry.key = Object2IntLinkedOpenHashMap.this.key[e2];
            this.entry.value = Object2IntLinkedOpenHashMap.this.value[e2];
            return this.entry;
        }

        @Override
        public AbstractObject2IntMap.BasicEntry<K> previous() {
            int e2 = this.previousEntry();
            this.entry.key = Object2IntLinkedOpenHashMap.this.key[e2];
            this.entry.value = Object2IntLinkedOpenHashMap.this.value[e2];
            return this.entry;
        }

        @Override
        public void set(Object2IntMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2IntMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2IntMap.Entry<K>> {
        private MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(K from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }

        @Override
        public void set(Object2IntMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2IntMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        private MapIterator() {
            this.next = Object2IntLinkedOpenHashMap.this.first;
            this.index = 0;
        }

        private MapIterator(K from) {
            if (!(Object2IntLinkedOpenHashMap.this.key[Object2IntLinkedOpenHashMap.this.last] == null ? from == null : Object2IntLinkedOpenHashMap.this.key[Object2IntLinkedOpenHashMap.this.last].equals(from))) {
                int pos = (from == null ? 142593372 : HashCommon.murmurHash3(from.hashCode() ^ Object2IntLinkedOpenHashMap.this.mask)) & Object2IntLinkedOpenHashMap.this.mask;
                while (Object2IntLinkedOpenHashMap.this.used[pos]) {
                    if (Object2IntLinkedOpenHashMap.this.key[pos] == null ? from == null : Object2IntLinkedOpenHashMap.this.key[pos].equals(from)) {
                        this.next = (int)Object2IntLinkedOpenHashMap.this.link[pos];
                        this.prev = pos;
                        return;
                    }
                    pos = pos + 1 & Object2IntLinkedOpenHashMap.this.mask;
                }
                throw new NoSuchElementException("The key " + from + " does not belong to this map.");
            }
            this.prev = Object2IntLinkedOpenHashMap.this.last;
            this.index = Object2IntLinkedOpenHashMap.this.size;
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private final void ensureIndexKnown() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = Object2IntLinkedOpenHashMap.this.size;
                return;
            }
            int pos = Object2IntLinkedOpenHashMap.this.first;
            this.index = 1;
            while (pos != this.prev) {
                pos = (int)Object2IntLinkedOpenHashMap.this.link[pos];
                ++this.index;
            }
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Object2IntLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = (int)Object2IntLinkedOpenHashMap.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = (int)(Object2IntLinkedOpenHashMap.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(Object2IntLinkedOpenHashMap.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)Object2IntLinkedOpenHashMap.this.link[this.curr];
            }
            --Object2IntLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Object2IntLinkedOpenHashMap.this.first = this.next;
            } else {
                int n2 = this.prev;
                Object2IntLinkedOpenHashMap.this.link[n2] = Object2IntLinkedOpenHashMap.this.link[n2] ^ (Object2IntLinkedOpenHashMap.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                Object2IntLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n3 = this.next;
                Object2IntLinkedOpenHashMap.this.link[n3] = Object2IntLinkedOpenHashMap.this.link[n3] ^ (Object2IntLinkedOpenHashMap.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Object2IntLinkedOpenHashMap.this.mask;
                while (Object2IntLinkedOpenHashMap.this.used[pos]) {
                    int slot = (Object2IntLinkedOpenHashMap.this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(Object2IntLinkedOpenHashMap.this.key[pos].hashCode() ^ Object2IntLinkedOpenHashMap.this.mask)) & Object2IntLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Object2IntLinkedOpenHashMap.this.mask;
                }
                if (!Object2IntLinkedOpenHashMap.this.used[pos]) break;
                Object2IntLinkedOpenHashMap.this.key[last] = Object2IntLinkedOpenHashMap.this.key[pos];
                Object2IntLinkedOpenHashMap.this.value[last] = Object2IntLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Object2IntLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Object2IntLinkedOpenHashMap.this.used[last] = false;
            Object2IntLinkedOpenHashMap.this.key[last] = null;
            this.curr = -1;
        }

        public int skip(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n2 - i2 - 1;
        }

        public int back(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n2 - i2 - 1;
        }
    }

    private final class MapEntry
    implements Object2IntMap.Entry<K>,
    Map.Entry<K, Integer> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Object2IntLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Integer getValue() {
            return Object2IntLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public int getIntValue() {
            return Object2IntLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public int setValue(int v) {
            int oldValue = Object2IntLinkedOpenHashMap.this.value[this.index];
            Object2IntLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Integer setValue(Integer v) {
            return this.setValue((int)v);
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return (Object2IntLinkedOpenHashMap.this.key[this.index] == null ? e2.getKey() == null : Object2IntLinkedOpenHashMap.this.key[this.index].equals(e2.getKey())) && Object2IntLinkedOpenHashMap.this.value[this.index] == (Integer)e2.getValue();
        }

        @Override
        public int hashCode() {
            return (Object2IntLinkedOpenHashMap.this.key[this.index] == null ? 0 : Object2IntLinkedOpenHashMap.this.key[this.index].hashCode()) ^ Object2IntLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Object2IntLinkedOpenHashMap.this.key[this.index] + "=>" + Object2IntLinkedOpenHashMap.this.value[this.index];
        }
    }
}

