/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shaded.org.apache.parquet.io.InvalidRecordException;
import shaded.org.apache.parquet.schema.IncompatibleSchemaModificationException;
import shaded.org.apache.parquet.schema.InvalidSchemaException;
import shaded.org.apache.parquet.schema.OriginalType;
import shaded.org.apache.parquet.schema.Type;
import shaded.org.apache.parquet.schema.TypeConverter;
import shaded.org.apache.parquet.schema.TypeVisitor;

public class GroupType
extends Type {
    private final List<Type> fields;
    private final Map<String, Integer> indexByName;

    public GroupType(Type.Repetition repetition, String name, List<Type> fields) {
        this(repetition, name, null, fields, null);
    }

    public GroupType(Type.Repetition repetition, String name, Type ... fields) {
        this(repetition, name, Arrays.asList(fields));
    }

    @Deprecated
    public GroupType(Type.Repetition repetition, String name, OriginalType originalType, Type ... fields) {
        this(repetition, name, originalType, Arrays.asList(fields));
    }

    @Deprecated
    public GroupType(Type.Repetition repetition, String name, OriginalType originalType, List<Type> fields) {
        this(repetition, name, originalType, fields, null);
    }

    GroupType(Type.Repetition repetition, String name, OriginalType originalType, List<Type> fields, Type.ID id) {
        super(name, repetition, originalType, id);
        if (fields.isEmpty()) {
            throw new InvalidSchemaException("A group type can not be empty. Parquet does not support empty group without leaves. Empty group: " + name);
        }
        this.fields = fields;
        this.indexByName = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            this.indexByName.put(fields.get(i2).getName(), i2);
        }
    }

    @Override
    public GroupType withId(int id) {
        return new GroupType(this.getRepetition(), this.getName(), this.getOriginalType(), this.fields, new Type.ID(id));
    }

    public GroupType withNewFields(List<Type> newFields) {
        return new GroupType(this.getRepetition(), this.getName(), this.getOriginalType(), newFields, this.getId());
    }

    public GroupType withNewFields(Type ... newFields) {
        return this.withNewFields(Arrays.asList(newFields));
    }

    public String getFieldName(int index) {
        return this.fields.get(index).getName();
    }

    public boolean containsField(String name) {
        return this.indexByName.containsKey(name);
    }

    public int getFieldIndex(String name) {
        if (!this.indexByName.containsKey(name)) {
            throw new InvalidRecordException(name + " not found in " + this);
        }
        return this.indexByName.get(name);
    }

    public List<Type> getFields() {
        return this.fields;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public Type getType(String fieldName) {
        return this.getType(this.getFieldIndex(fieldName));
    }

    public Type getType(int index) {
        return this.fields.get(index);
    }

    void membersDisplayString(StringBuilder sb, String indent) {
        for (Type field : this.fields) {
            field.writeToStringBuilder(sb, indent);
            if (field.isPrimitive()) {
                sb.append(";");
            }
            sb.append("\n");
        }
    }

    @Override
    public void writeToStringBuilder(StringBuilder sb, String indent) {
        sb.append(indent).append(this.getRepetition().name().toLowerCase()).append(" group ").append(this.getName()).append(this.getOriginalType() == null ? "" : " (" + (Object)((Object)this.getOriginalType()) + ")").append(this.getId() == null ? "" : " = " + this.getId()).append(" {\n");
        this.membersDisplayString(sb, indent + "  ");
        sb.append(indent).append("}");
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Deprecated
    protected int typeHashCode() {
        return this.hashCode();
    }

    @Override
    @Deprecated
    protected boolean typeEquals(Type other) {
        return this.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.getFields().hashCode();
    }

    @Override
    protected boolean equals(Type otherType) {
        return !otherType.isPrimitive() && super.equals(otherType) && this.getFields().equals(otherType.asGroupType().getFields());
    }

    @Override
    protected int getMaxRepetitionLevel(String[] path, int depth) {
        int myVal;
        int n2 = myVal = this.isRepetition(Type.Repetition.REPEATED) ? 1 : 0;
        if (depth == path.length) {
            return myVal;
        }
        return myVal + this.getType(path[depth]).getMaxRepetitionLevel(path, depth + 1);
    }

    @Override
    protected int getMaxDefinitionLevel(String[] path, int depth) {
        int myVal;
        int n2 = myVal = !this.isRepetition(Type.Repetition.REQUIRED) ? 1 : 0;
        if (depth == path.length) {
            return myVal;
        }
        return myVal + this.getType(path[depth]).getMaxDefinitionLevel(path, depth + 1);
    }

    @Override
    protected Type getType(String[] path, int depth) {
        if (depth == path.length) {
            return this;
        }
        return this.getType(path[depth]).getType(path, depth + 1);
    }

    @Override
    protected boolean containsPath(String[] path, int depth) {
        if (depth == path.length) {
            return false;
        }
        return this.containsField(path[depth]) && this.getType(path[depth]).containsPath(path, depth + 1);
    }

    @Override
    protected List<String[]> getPaths(int depth) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Type field : this.fields) {
            List<String[]> paths = field.getPaths(depth + 1);
            for (String[] path : paths) {
                path[depth] = field.getName();
                result.add(path);
            }
        }
        return result;
    }

    @Override
    void checkContains(Type subType) {
        super.checkContains(subType);
        this.checkGroupContains(subType);
    }

    void checkGroupContains(Type subType) {
        if (subType.isPrimitive()) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
        List<Type> fields = subType.asGroupType().getFields();
        for (Type otherType : fields) {
            Type thisType = this.getType(otherType.getName());
            thisType.checkContains(otherType);
        }
    }

    @Override
    <T> T convert(List<GroupType> path, TypeConverter<T> converter) {
        ArrayList<GroupType> childrenPath = new ArrayList<GroupType>(path);
        childrenPath.add(this);
        List<T> children = this.convertChildren(childrenPath, converter);
        return converter.convertGroupType(path, this, children);
    }

    protected <T> List<T> convertChildren(List<GroupType> path, TypeConverter<T> converter) {
        ArrayList<T> children = new ArrayList<T>(this.fields.size());
        for (Type field : this.fields) {
            children.add(field.convert(path, converter));
        }
        return children;
    }

    @Override
    protected Type union(Type toMerge) {
        return this.union(toMerge, true);
    }

    @Override
    protected Type union(Type toMerge, boolean strict) {
        if (toMerge.isPrimitive()) {
            throw new IncompatibleSchemaModificationException("can not merge primitive type " + toMerge + " into group type " + this);
        }
        return new GroupType(toMerge.getRepetition(), this.getName(), this.mergeFields(toMerge.asGroupType()));
    }

    List<Type> mergeFields(GroupType toMerge) {
        return this.mergeFields(toMerge, true);
    }

    List<Type> mergeFields(GroupType toMerge, boolean strict) {
        ArrayList<Type> newFields = new ArrayList<Type>();
        for (Type type : this.getFields()) {
            Type merged;
            if (toMerge.containsField(type.getName())) {
                Type fieldToMerge = toMerge.getType(type.getName());
                if (fieldToMerge.getRepetition().isMoreRestrictiveThan(type.getRepetition())) {
                    throw new IncompatibleSchemaModificationException("repetition constraint is more restrictive: can not merge type " + fieldToMerge + " into " + type);
                }
                merged = type.union(fieldToMerge, strict);
            } else {
                merged = type;
            }
            newFields.add(merged);
        }
        for (Type type : toMerge.getFields()) {
            if (this.containsField(type.getName())) continue;
            newFields.add(type);
        }
        return newFields;
    }
}

