/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.schema;

import java.util.Arrays;
import java.util.StringTokenizer;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.schema.MessageType;
import shaded.org.apache.parquet.schema.OriginalType;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;
import shaded.org.apache.parquet.schema.Types;

public class MessageTypeParser {
    private static final Log LOG = Log.getLog(MessageTypeParser.class);

    private MessageTypeParser() {
    }

    public static MessageType parseMessageType(String input) {
        return MessageTypeParser.parse(input);
    }

    private static MessageType parse(String schemaString) {
        Tokenizer st = new Tokenizer(schemaString, " ;{}()\n\t");
        Types.MessageTypeBuilder builder = Types.buildMessage();
        String t2 = st.nextToken();
        MessageTypeParser.check(t2, "message", "start with 'message'", st);
        String name = st.nextToken();
        MessageTypeParser.addGroupTypeFields(st.nextToken(), st, builder);
        return builder.named(name);
    }

    private static void addGroupTypeFields(String t2, Tokenizer st, Types.GroupBuilder builder) {
        MessageTypeParser.check(t2, "{", "start of message", st);
        while (!(t2 = st.nextToken()).equals("}")) {
            MessageTypeParser.addType(t2, st, builder);
        }
    }

    private static void addType(String t2, Tokenizer st, Types.GroupBuilder builder) {
        Type.Repetition repetition = MessageTypeParser.asRepetition(t2, st);
        String type = st.nextToken();
        if ("group".equalsIgnoreCase(type)) {
            MessageTypeParser.addGroupType(t2, st, repetition, builder);
        } else {
            MessageTypeParser.addPrimitiveType(t2, st, MessageTypeParser.asPrimitive(type, st), repetition, builder);
        }
    }

    private static void addGroupType(String t2, Tokenizer st, Type.Repetition r2, Types.GroupBuilder<?> builder) {
        Types.GroupBuilder childBuilder = builder.group(r2);
        String name = st.nextToken();
        t2 = st.nextToken();
        OriginalType originalType = null;
        if (t2.equalsIgnoreCase("(")) {
            originalType = OriginalType.valueOf(st.nextToken());
            childBuilder.as(originalType);
            MessageTypeParser.check(st.nextToken(), ")", "original type ended by )", st);
            t2 = st.nextToken();
        }
        if (t2.equals("=")) {
            childBuilder.id(Integer.parseInt(st.nextToken()));
            t2 = st.nextToken();
        }
        try {
            MessageTypeParser.addGroupTypeFields(t2, st, childBuilder);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("problem reading type: type = group, name = " + name + ", original type = " + (Object)((Object)originalType), e2);
        }
        childBuilder.named(name);
    }

    private static void addPrimitiveType(String t2, Tokenizer st, PrimitiveType.PrimitiveTypeName type, Type.Repetition r2, Types.GroupBuilder<?> builder) {
        Types.PrimitiveBuilder childBuilder = builder.primitive(type, r2);
        if (type == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            t2 = st.nextToken();
            if (!t2.equalsIgnoreCase("(")) {
                throw new IllegalArgumentException("expecting (length) for field of type fixed_len_byte_array");
            }
            childBuilder.length(Integer.parseInt(st.nextToken()));
            MessageTypeParser.check(st.nextToken(), ")", "type length ended by )", st);
        }
        String name = st.nextToken();
        t2 = st.nextToken();
        OriginalType originalType = null;
        if (t2.equalsIgnoreCase("(")) {
            originalType = OriginalType.valueOf(st.nextToken());
            childBuilder.as(originalType);
            if (OriginalType.DECIMAL == originalType) {
                t2 = st.nextToken();
                if (t2.equalsIgnoreCase("(")) {
                    childBuilder.precision(Integer.parseInt(st.nextToken()));
                    t2 = st.nextToken();
                    if (t2.equalsIgnoreCase(",")) {
                        childBuilder.scale(Integer.parseInt(st.nextToken()));
                        t2 = st.nextToken();
                    }
                    MessageTypeParser.check(t2, ")", "decimal type ended by )", st);
                    t2 = st.nextToken();
                }
            } else {
                t2 = st.nextToken();
            }
            MessageTypeParser.check(t2, ")", "original type ended by )", st);
            t2 = st.nextToken();
        }
        if (t2.equals("=")) {
            childBuilder.id(Integer.parseInt(st.nextToken()));
            t2 = st.nextToken();
        }
        MessageTypeParser.check(t2, ";", "field ended by ';'", st);
        try {
            childBuilder.named(name);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("problem reading type: type = " + (Object)((Object)type) + ", name = " + name + ", original type = " + (Object)((Object)originalType), e2);
        }
    }

    private static PrimitiveType.PrimitiveTypeName asPrimitive(String t2, Tokenizer st) {
        try {
            return PrimitiveType.PrimitiveTypeName.valueOf(t2.toUpperCase());
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("expected one of " + Arrays.toString((Object[])PrimitiveType.PrimitiveTypeName.values()) + " got " + t2 + " at " + st.getLocationString(), e2);
        }
    }

    private static Type.Repetition asRepetition(String t2, Tokenizer st) {
        try {
            return Type.Repetition.valueOf(t2.toUpperCase());
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("expected one of " + Arrays.toString((Object[])Type.Repetition.values()) + " got " + t2 + " at " + st.getLocationString(), e2);
        }
    }

    private static void check(String t2, String expected, String message, Tokenizer tokenizer) {
        if (!t2.equalsIgnoreCase(expected)) {
            throw new IllegalArgumentException(message + ": expected '" + expected + "' but got '" + t2 + "' at " + tokenizer.getLocationString());
        }
    }

    private static class Tokenizer {
        private StringTokenizer st;
        private int line = 0;
        private StringBuffer currentLine = new StringBuffer();

        public Tokenizer(String schemaString, String string) {
            this.st = new StringTokenizer(schemaString, " ,;{}()\n\t=", true);
        }

        public String nextToken() {
            while (this.st.hasMoreTokens()) {
                String t2 = this.st.nextToken();
                if (t2.equals("\n")) {
                    ++this.line;
                    this.currentLine.setLength(0);
                } else {
                    this.currentLine.append(t2);
                }
                if (this.isWhitespace(t2)) continue;
                return t2;
            }
            throw new IllegalArgumentException("unexpected end of schema");
        }

        private boolean isWhitespace(String t2) {
            return t2.equals(" ") || t2.equals("\t") || t2.equals("\n");
        }

        public String getLocationString() {
            return "line " + this.line + ": " + this.currentLine.toString();
        }
    }
}

