/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.flex.messaging.services;

import cn.org.rapid_framework.util.ScanClassUtils;
import flex.messaging.Destination;
import flex.messaging.config.ConfigMap;
import flex.messaging.services.AbstractBootstrapService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceException;
import flex.messaging.services.remoting.RemotingDestination;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaveBeanRemotingDestinationBootstrapService
extends AbstractBootstrapService {
    private String destChannel;
    private String destSecurityConstraint;
    private String destScope;
    private String destAdapter;
    private String destFactory;
    private String serviceId;
    private String packageToScan = null;

    public void initialize(String id, ConfigMap properties) {
        this.serviceId = properties.getPropertyAsString("service-id", "remoting-service");
        this.destFactory = properties.getProperty("dest-factory");
        this.destAdapter = properties.getProperty("dest-adapter");
        this.destScope = properties.getProperty("dest-scope");
        this.destChannel = properties.getPropertyAsString("dest-channel", "my-amf");
        this.destSecurityConstraint = properties.getProperty("dest-security-constraint");
        this.packageToScan = properties.getProperty("package-to-scan");
        if (this.packageToScan == null || "".equals(this.packageToScan.trim())) {
            throw this.createServiceException("'package-to-scan' property must be specify");
        }
        Service remotingService = this.broker.getService(this.serviceId);
        if (remotingService == null) {
            throw this.createServiceException("not found Service with serviceId:" + this.serviceId);
        }
        this.createJavaBeanDestinations(remotingService);
    }

    private ServiceException createServiceException(String message) {
        ServiceException ex = new ServiceException();
        ex.setMessage(message);
        return ex;
    }

    private void createJavaBeanDestinations(Service remotingService) {
        ArrayList<String> addedBeanNames = new ArrayList<String>();
        List<Class> roJavaBeans = this.getRemoteObjectJavaBean();
        for (Class clazz : roJavaBeans) {
            this.createJavaBeanDestination(remotingService, clazz);
            addedBeanNames.add(StringUtils.uncapitalize((String)ClassUtils.getShortName((Class)clazz)));
        }
        System.out.println("[Auto Export JavaBean to BlazeDS RemotingDestination],beans=" + addedBeanNames);
    }

    protected void createJavaBeanDestination(Service service, Class clazz) {
        String destinationId = StringUtils.uncapitalize((String)ClassUtils.getShortName((Class)clazz));
        RemotingDestination destination = (RemotingDestination)service.createDestination(destinationId);
        destination.setSource(clazz.getName());
        if (this.destFactory != null) {
            destination.setFactory(this.destFactory);
        }
        if (this.destAdapter != null) {
            destination.createAdapter(this.destAdapter);
        }
        if (this.destScope != null) {
            destination.setScope(this.destScope);
        }
        if (this.destSecurityConstraint != null) {
            destination.setSecurityConstraint(this.destSecurityConstraint);
        }
        if (this.destChannel != null) {
            destination.addChannel(this.destChannel);
        }
        service.addDestination((Destination)destination);
    }

    public void start() {
    }

    public void stop() {
    }

    private List<Class> getRemoteObjectJavaBean() {
        PathMatchingResourcePatternResolver rl = new PathMatchingResourcePatternResolver();
        ArrayList<Class> result = new ArrayList<Class>();
        try {
            List<String> classNames = ScanClassUtils.scanPackages(this.packageToScan);
            for (String className : classNames) {
                Class<?> type = Class.forName(className);
                if (!this.isRemoteObject(type)) continue;
                result.add(type);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("scan JavaBean RemoteObject error", e);
        }
        return result;
    }

    private boolean isRemoteObject(Class clazz) {
        return clazz.isAnnotationPresent(RemoteObject.class) && !clazz.isInterface() && !this.isAbstract(clazz) && !clazz.isAnonymousClass() && !clazz.isMemberClass();
    }

    boolean isAbstract(Class type) {
        return (type.getModifiers() ^ 0x400) == 0;
    }

    public static void main(String[] args) {
        JaveBeanRemotingDestinationBootstrapService b = new JaveBeanRemotingDestinationBootstrapService();
        List<Class> lst = b.getRemoteObjectJavaBean();
        for (Class class1 : lst) {
            System.out.println(class1.getName());
        }
    }
}

