/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.io;

import cn.org.rapid_framework.io.AsyncExceptinHandler;
import cn.org.rapid_framework.io.BufferCopyUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class AsyncOutputStream
extends OutputStream {
    private static final byte[] CLOSED_SIGNEL = new byte[0];
    private DataProcessorThread dataProcessor;
    private boolean isClosed = false;
    private boolean isStartd = false;
    OutputStream output;
    BlockingQueue queue;
    private AsyncExceptinHandler asyncExceptinHandler = new AsyncExceptinHandler.DefaultAsyncExceptinHandler();
    private static long threadSeqNumber;

    public AsyncOutputStream(OutputStream output) {
        this(output, new ArrayBlockingQueue(50000));
    }

    public AsyncOutputStream(OutputStream output, BlockingQueue queue) {
        if (output == null) {
            throw new NullPointerException();
        }
        if (queue == null) {
            throw new NullPointerException();
        }
        this.output = output;
        this.queue = queue;
        this.dataProcessor = new DataProcessorThread();
    }

    public void start() {
        this.dataProcessor.start();
        this.isStartd = true;
    }

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        if (!this.isStartd) {
            throw new IOException("must start() before wirte()");
        }
        if (this.isClosed) {
            throw new IOException("output is closed");
        }
        AsyncOutputStream asyncOutputStream = this;
        synchronized (asyncOutputStream) {
            try {
                this.queue.put(b);
            }
            catch (InterruptedException e) {
                throw new IOException("AsyncOutputStream occer InterruptedException error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.isStartd) {
            throw new IOException("must start() before wirte()");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        AsyncOutputStream asyncOutputStream = this;
        synchronized (asyncOutputStream) {
            if (this.isClosed) {
                throw new IOException("output is closed");
            }
            try {
                this.queue.put(BufferCopyUtils.copyBuffer(b, off, len));
            }
            catch (InterruptedException e) {
                throw new IOException("AsyncOutputStream occer InterruptedException error");
            }
        }
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlush() throws IOException {
        AsyncOutputStream asyncOutputStream = this;
        synchronized (asyncOutputStream) {
            while (this.queue.size() > 0) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.output.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        AsyncOutputStream asyncOutputStream = this;
        synchronized (asyncOutputStream) {
            try {
                this.isClosed = true;
                this.dataProcessor.enabled = false;
                if (this.queue.isEmpty()) {
                    this.queue.offer(CLOSED_SIGNEL);
                }
                try {
                    this.dataProcessor.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.dataProcessor.hasRuned) {
                    this.dataProcessor.run();
                }
            }
            finally {
                this.output.close();
            }
        }
    }

    public void setAsyncExceptinHandler(AsyncExceptinHandler asyncExceptinHandler) {
        if (asyncExceptinHandler == null) {
            throw new NullPointerException();
        }
        this.asyncExceptinHandler = asyncExceptinHandler;
    }

    private class DataProcessorThread
    extends Thread {
        private boolean enabled;
        private boolean hasRuned;

        DataProcessorThread() {
            super("AsyncOutputStream.DataProcessorThread-" + AsyncOutputStream.nextThreadID());
            this.enabled = true;
            this.hasRuned = false;
            this.setDaemon(true);
        }

        public void run() {
            this.hasRuned = true;
            while (this.enabled || !AsyncOutputStream.this.queue.isEmpty()) {
                Object buf;
                try {
                    buf = AsyncOutputStream.this.queue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (buf == CLOSED_SIGNEL) {
                    return;
                }
                try {
                    if (buf instanceof Integer) {
                        AsyncOutputStream.this.output.write((Integer)buf);
                        continue;
                    }
                    AsyncOutputStream.this.output.write((byte[])buf);
                }
                catch (IOException e) {
                    AsyncOutputStream.this.asyncExceptinHandler.handle(e);
                }
            }
        }
    }
}

