/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.mail;

import cn.org.rapid_framework.util.concurrent.async.AsyncToken;
import cn.org.rapid_framework.util.concurrent.async.AsyncTokenFactory;
import cn.org.rapid_framework.util.concurrent.async.AsyncTokenUtils;
import cn.org.rapid_framework.util.concurrent.async.DefaultAsyncTokenFactory;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class AsyncJavaMailSender
implements InitializingBean,
DisposableBean,
BeanNameAware {
    protected static final Log log = LogFactory.getLog(AsyncJavaMailSender.class);
    protected int sendMailThreadPoolSize = 0;
    protected ExecutorService executorService;
    protected JavaMailSender javaMailSender;
    protected boolean shutdownExecutorService = true;
    protected boolean waitForTasksToCompleteOnShutdown = true;
    protected AsyncTokenFactory asyncTokenFactory = new DefaultAsyncTokenFactory();
    private String beanName;

    public void afterPropertiesSet() throws Exception {
        if (this.executorService == null && this.sendMailThreadPoolSize > 0) {
            this.executorService = Executors.newFixedThreadPool(this.sendMailThreadPoolSize, (ThreadFactory)new CustomizableThreadFactory(this.getClass().getSimpleName() + "-"));
            log.info((Object)("create send mail executorService,sendMailThreadPoolSize:" + this.sendMailThreadPoolSize));
        }
        Assert.notNull((Object)this.javaMailSender, (String)"javaMailSender must be not null");
        Assert.notNull((Object)this.executorService, (String)"executorService must be not null");
        Assert.notNull((Object)this.asyncTokenFactory, (String)"asyncTokenFactory must be not null");
    }

    public void destroy() throws Exception {
        if (this.shutdownExecutorService) {
            this.shutdown();
        }
    }

    public void shutdown() {
        log.info((Object)("Shutting down ExecutorService" + (this.beanName != null ? " '" + this.beanName + "'" : "")));
        if (this.waitForTasksToCompleteOnShutdown) {
            this.executorService.shutdown();
        } else {
            this.executorService.shutdownNow();
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean isWaitForTasksToCompleteOnShutdown() {
        return this.waitForTasksToCompleteOnShutdown;
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForTasksToCompleteOnShutdown) {
        this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
    }

    public void setSendMailThreadPoolSize(int sendMailThreadPool) {
        this.sendMailThreadPoolSize = sendMailThreadPool;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public AsyncTokenFactory getAsyncTokenFactory() {
        return this.asyncTokenFactory;
    }

    public void setAsyncTokenFactory(AsyncTokenFactory asyncTokenFactory) {
        this.asyncTokenFactory = asyncTokenFactory;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public JavaMailSender getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public void setShutdownExecutorService(boolean shutdownExecutorService) {
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public boolean isShutdownExecutorService() {
        return this.shutdownExecutorService;
    }

    public MimeMessage createMimeMessage() {
        return this.javaMailSender.createMimeMessage();
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        return this.javaMailSender.createMimeMessage(contentStream);
    }

    public AsyncToken send(final MimeMessage mimeMessage) throws MailException {
        return AsyncTokenUtils.execute((Executor)this.executorService, this.asyncTokenFactory, new Runnable(){

            public void run() {
                AsyncJavaMailSender.this.javaMailSender.send(mimeMessage);
            }
        });
    }

    public AsyncToken send(final MimeMessage[] mimeMessages) throws MailException {
        return AsyncTokenUtils.execute((Executor)this.executorService, this.asyncTokenFactory, new Runnable(){

            public void run() {
                AsyncJavaMailSender.this.javaMailSender.send(mimeMessages);
            }
        });
    }

    public AsyncToken send(final MimeMessagePreparator mimeMessagePreparator) throws MailException {
        return AsyncTokenUtils.execute((Executor)this.executorService, this.asyncTokenFactory, new Runnable(){

            public void run() {
                AsyncJavaMailSender.this.javaMailSender.send(mimeMessagePreparator);
            }
        });
    }

    public AsyncToken send(final MimeMessagePreparator[] mimeMessagePreparators) throws MailException {
        return AsyncTokenUtils.execute((Executor)this.executorService, this.asyncTokenFactory, new Runnable(){

            public void run() {
                AsyncJavaMailSender.this.javaMailSender.send(mimeMessagePreparators);
            }
        });
    }

    public AsyncToken send(final SimpleMailMessage simpleMessage) throws MailException {
        return AsyncTokenUtils.execute((Executor)this.executorService, this.asyncTokenFactory, new Runnable(){

            public void run() {
                AsyncJavaMailSender.this.javaMailSender.send(simpleMessage);
            }
        });
    }

    public AsyncToken send(final SimpleMailMessage[] simpleMessages) throws MailException {
        return AsyncTokenUtils.execute((Executor)this.executorService, this.asyncTokenFactory, new Runnable(){

            public void run() {
                AsyncJavaMailSender.this.javaMailSender.send(simpleMessages);
            }
        });
    }
}

