/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.spring.beans.factory.support;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.util.StringUtils;

public class SmartBeanNameGenerator
extends DefaultBeanNameGenerator {
    String DEFAULT_REMOVE_SUFFIX = "impl";
    String DEFAULT_REMOVE_PERFIX = "";
    private String removedSuffix = this.DEFAULT_REMOVE_SUFFIX;
    private String removedPrefix = this.DEFAULT_REMOVE_PERFIX;

    public void setRemovedSuffix(String removedSuffix) {
        this.removedSuffix = removedSuffix;
    }

    public void setRemovedPrefix(String removedPrefix) {
        this.removedPrefix = removedPrefix;
    }

    public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        String id = super.generateBeanName(definition, registry);
        return this.generateBeanName(id);
    }

    String generateBeanName(String generatedBeanName) {
        String id = generatedBeanName;
        if (id.toLowerCase().endsWith(this.removedSuffix.toLowerCase())) {
            id = id.substring(0, id.length() - this.removedSuffix.length());
        }
        if (id.toLowerCase().startsWith(this.removedPrefix.toLowerCase())) {
            id = id.substring(this.removedPrefix.length());
            id = StringUtils.uncapitalize((String)id);
        }
        return id;
    }
}

