/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.test.hsql;

import cn.org.rapid_framework.test.hsql.HSQLMemDataSourceUtils;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class HSQLMemDataSourceFactoryBean
implements FactoryBean {
    private Resource[] scriptLocations;
    private String sqlScript;
    private String encoding = Charset.defaultCharset().name();

    public HSQLMemDataSourceFactoryBean() {
    }

    public HSQLMemDataSourceFactoryBean(Resource initScriptsLocation, String encoding) {
        this.scriptLocations = new Resource[]{initScriptsLocation};
        this.encoding = encoding;
    }

    public void setScriptLocations(Resource ... initScriptsLocation) {
        this.scriptLocations = initScriptsLocation;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSqlScript(String sqlScript) {
        this.sqlScript = sqlScript;
    }

    public Object getObject() throws Exception {
        DataSource ds = HSQLMemDataSourceUtils.getDataSource();
        if (this.scriptLocations != null) {
            for (Resource r : this.scriptLocations) {
                HSQLMemDataSourceUtils.executeSqlScripts(new InputStreamReader(r.getInputStream(), this.encoding), ds);
            }
        }
        if (this.sqlScript != null) {
            HSQLMemDataSourceUtils.executeSqlScripts(new StringReader(this.sqlScript), ds);
        }
        return ds;
    }

    public Class getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

