/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.test.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDefaultValueUtils {
    public static int DEFAULT_VALUE = 1;

    public static <T> T setBeanProperties(T obj) {
        return BeanDefaultValueUtils.setBeanProperties(obj, DEFAULT_VALUE);
    }

    public static <T> T setBeanProperties(T obj, int defaultValue) {
        PropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(obj.getClass());
        for (int i = 0; i < descriptors.length; ++i) {
            String name = descriptors[i].getName();
            Method writeMethod = descriptors[i].getWriteMethod();
            if (writeMethod == null) continue;
            for (Class<?> parameterType : writeMethod.getParameterTypes()) {
                Object value = null;
                try {
                    value = BeanDefaultValueUtils.getDefaultValue0(parameterType, defaultValue);
                    writeMethod.setAccessible(true);
                    writeMethod.invoke(obj, value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("cannot set property:" + name + " with default value:" + value, e);
                }
            }
        }
        return obj;
    }

    private static Object getDefaultValue(Class<?> targetType) {
        return BeanDefaultValueUtils.getDefaultValue(targetType, DEFAULT_VALUE);
    }

    private static Object getDefaultValue(Class<?> targetType, int defaultValue) {
        try {
            return BeanDefaultValueUtils.getDefaultValue0(targetType, defaultValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot generate default value for targetType:" + targetType);
        }
    }

    private static Object getDefaultValue0(Class<?> targetType, int defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (targetType.isArray()) {
            Class<?> componentType = targetType.getComponentType();
            Object array = Array.newInstance(componentType, 1);
            Array.set(array, 0, BeanDefaultValueUtils.getDefaultValue(componentType, defaultValue));
            return array;
        }
        if (targetType == String.class) {
            return String.valueOf(defaultValue);
        }
        if (targetType == Character.TYPE) {
            return Character.valueOf(String.valueOf(defaultValue).charAt(0));
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return (byte)defaultValue;
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return (short)defaultValue;
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return defaultValue;
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return (long)defaultValue;
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf(defaultValue);
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return (double)defaultValue;
        }
        if (targetType == BigDecimal.class) {
            return new BigDecimal(defaultValue);
        }
        if (targetType == BigInteger.class) {
            return BigInteger.valueOf(defaultValue);
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return true;
        }
        if (targetType == java.util.Date.class) {
            return new java.util.Date();
        }
        if (targetType == Date.class) {
            return new Date(System.currentTimeMillis());
        }
        if (targetType == Time.class) {
            return new Time(System.currentTimeMillis());
        }
        if (targetType == Timestamp.class) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (targetType == Calendar.class) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            return calendar;
        }
        if (targetType.isEnum()) {
            Enum[] enums = (Enum[])targetType.getEnumConstants();
            return enums != null && enums.length > 0 ? enums[0] : null;
        }
        if (targetType.isInterface()) {
            if (targetType.isAssignableFrom(Set.class)) {
                return new HashSet();
            }
            if (targetType.isAssignableFrom(List.class)) {
                return new ArrayList();
            }
            if (targetType.isAssignableFrom(Collection.class)) {
                return new ArrayList();
            }
            if (targetType.isAssignableFrom(Map.class)) {
                return new HashMap();
            }
            return null;
        }
        try {
            return BeanUtils.instantiateClass(targetType);
        }
        catch (Exception e) {
            return null;
        }
    }
}

