/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.util.concurrent.async;

import cn.org.rapid_framework.util.concurrent.async.IResponder;
import cn.org.rapid_framework.util.concurrent.async.UncaughtExceptionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncToken<T> {
    public static final String DEFAULT_TOKEN_GROUP = "default";
    private static AtomicLong tokenIdSequence = new AtomicLong(1L);
    private String tokenGroup = "default";
    private String tokenName;
    private long tokenId;
    private List<IResponder> _responders = new ArrayList<IResponder>(2);
    private UncaughtExceptionHandler uncaughtExceptionHandler;
    private T _result;
    private Exception _fault;
    private boolean _isFiredResult;
    private CountDownLatch awaitResultSignal = null;

    public AsyncToken() {
        this(null);
    }

    public AsyncToken(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this(DEFAULT_TOKEN_GROUP, null);
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public AsyncToken(String tokenGroup, String tokenName) {
        this.setTokenGroup(tokenGroup);
        this.setTokenName(tokenName);
        this.tokenId = tokenIdSequence.getAndIncrement();
    }

    public String getTokenGroup() {
        return this.tokenGroup;
    }

    public void setTokenGroup(String tokenGroup) {
        if (tokenGroup == null) {
            throw new IllegalArgumentException("'tokenGroup' must be not null");
        }
        this.tokenGroup = tokenGroup;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public void addResponder(IResponder<T> responder) {
        this.addResponder(responder, false);
    }

    public void addResponder(final IResponder<T> responder, boolean invokeResponderInOtherThread) {
        this._responders.add(responder);
        if (this._isFiredResult) {
            if (invokeResponderInOtherThread) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AsyncToken.this.fireResult2Responder(responder);
                    }
                });
            } else {
                this.fireResult2Responder(responder);
            }
        }
    }

    public List<IResponder> getResponders() {
        return this._responders;
    }

    public boolean hasResponder() {
        return this._responders != null && this._responders.size() > 0;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    private void fireResult2Responder(IResponder responder) {
        try {
            if (this._fault != null) {
                responder.onFault(this._fault);
            } else {
                responder.onResult(this._result);
            }
        }
        catch (RuntimeException e) {
            if (this.getUncaughtExceptionHandler() != null) {
                this.getUncaughtExceptionHandler().uncaughtException(responder, e);
            }
            throw e;
        }
        catch (Error e) {
            if (this.getUncaughtExceptionHandler() != null) {
                this.getUncaughtExceptionHandler().uncaughtException(responder, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireResult2Responders() {
        AsyncToken asyncToken = this;
        synchronized (asyncToken) {
            this._isFiredResult = true;
            if (this.awaitResultSignal != null) {
                this.awaitResultSignal.countDown();
            }
        }
        for (IResponder r : this._responders) {
            this.fireResult2Responder(r);
        }
    }

    public void setComplete() {
        this.setComplete(null);
    }

    public void setComplete(T result) {
        if (this._isFiredResult) {
            throw new IllegalStateException("token already fired");
        }
        this._result = result;
        this.fireResult2Responders();
    }

    public void setFault(Exception fault) {
        if (fault == null) {
            throw new NullPointerException();
        }
        if (this._isFiredResult) {
            throw new IllegalStateException("token already fired");
        }
        this._fault = fault;
        this.fireResult2Responders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        AsyncToken asyncToken = this;
        synchronized (asyncToken) {
            return this._isFiredResult;
        }
    }

    @Deprecated
    public Object waitForResult() throws InterruptedException, Exception {
        return this.waitForResult(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Object waitForResult(long timeout, TimeUnit timeUnit) throws InterruptedException, Exception {
        AsyncToken asyncToken = this;
        synchronized (asyncToken) {
            if (this._isFiredResult) {
                if (this._fault != null) {
                    throw this._fault;
                }
                return this._result;
            }
            this.awaitResultSignal = new CountDownLatch(1);
        }
        if (timeout > 0L) {
            this.awaitResultSignal.await(timeout, timeUnit);
        } else {
            this.awaitResultSignal.await();
        }
        if (this._fault != null) {
            throw this._fault;
        }
        return this._result;
    }
}

