/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.web.session.wrapper;

import cn.org.rapid_framework.web.session.store.SessionStore;
import cn.org.rapid_framework.web.session.wrapper.HttpSessionWrapper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class HttpSessionSessionStoreWrapper
extends HttpSessionWrapper {
    String sessionId;
    Map sessionData;
    SessionStore store;

    public HttpSessionSessionStoreWrapper(HttpSession session, SessionStore store, String sessionId, Map sessionData) {
        super(session);
        this.store = store;
        this.sessionId = sessionId;
        this.sessionData = sessionData;
    }

    public void invalidate() {
        this.sessionData.clear();
        this.store.deleteSession(this.getId());
    }

    public String getId() {
        return this.sessionId;
    }

    public Object getAttribute(String key) {
        return this.sessionData.get(key);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.sessionData.keySet());
    }

    public void removeAttribute(String key) {
        this.sessionData.remove(key);
        this.store.onRemoveAttribute(this.sessionId, key, this.sessionData, this.getMaxInactiveInterval());
    }

    public void setAttribute(String key, Object value) {
        this.sessionData.put(key, value);
        this.store.onSetAttribute(this.sessionId, key, this.sessionData, this.getMaxInactiveInterval());
    }
}

