/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenTypes;

public abstract class Token
implements TokenTypes {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    public int offset = -1;
    public int type = 0;
    private boolean hyperlink = false;
    private Token nextToken = null;
    private int languageIndex;
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;

    public Token() {
    }

    public Token(char[] cArray, int n, int n2, int n3, int n4) {
        this();
        this.set(cArray, n, n2, n3, n4);
    }

    public Token(Token token) {
        this();
        this.copyFrom(token);
    }

    public StringBuffer appendHTMLRepresentation(StringBuffer stringBuffer, RSyntaxTextArea rSyntaxTextArea, boolean bl) {
        return this.appendHTMLRepresentation(stringBuffer, rSyntaxTextArea, bl, false);
    }

    public StringBuffer appendHTMLRepresentation(StringBuffer stringBuffer, RSyntaxTextArea rSyntaxTextArea, boolean bl, boolean bl2) {
        SyntaxScheme syntaxScheme = rSyntaxTextArea.getSyntaxScheme();
        Style style = syntaxScheme.getStyle(this.type);
        Font font = rSyntaxTextArea.getFontForTokenType(this.type);
        if (font.isBold()) {
            stringBuffer.append("<b>");
        }
        if (font.isItalic()) {
            stringBuffer.append("<em>");
        }
        if (style.underline || this.isHyperlink()) {
            stringBuffer.append("<u>");
        }
        stringBuffer.append("<font");
        if (bl) {
            stringBuffer.append(" face=\"").append(font.getFamily()).append("\"");
        }
        stringBuffer.append(" color=\"").append(Token.getHTMLFormatForColor(style.foreground)).append("\">");
        this.appendHtmlLexeme(rSyntaxTextArea, stringBuffer, bl2);
        stringBuffer.append("</font>");
        if (style.underline || this.isHyperlink()) {
            stringBuffer.append("</u>");
        }
        if (font.isItalic()) {
            stringBuffer.append("</em>");
        }
        if (font.isBold()) {
            stringBuffer.append("</b>");
        }
        return stringBuffer;
    }

    private final StringBuffer appendHtmlLexeme(RSyntaxTextArea rSyntaxTextArea, StringBuffer stringBuffer, boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = n = this.textOffset;
        String string = null;
        while (n < this.textOffset + this.textCount) {
            char c = this.text[n];
            switch (c) {
                case ' ': {
                    stringBuffer.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuffer.append(bl2 ? "&nbsp;" : " ");
                    bl2 = true;
                    break;
                }
                case '\t': {
                    stringBuffer.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    if (bl && string == null) {
                        string = "";
                        for (int i = 0; i < rSyntaxTextArea.getTabSize(); ++i) {
                            string = string + "&nbsp;";
                        }
                    }
                    stringBuffer.append(bl ? string : "&#09;");
                    bl2 = false;
                    break;
                }
                case '<': {
                    stringBuffer.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuffer.append("&lt;");
                    bl2 = false;
                    break;
                }
                case '>': {
                    stringBuffer.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuffer.append("&gt;");
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            ++n;
        }
        if (n2 < this.textOffset + this.textCount) {
            stringBuffer.append(this.text, n2, this.textOffset + this.textCount - n2);
        }
        return stringBuffer;
    }

    public boolean containsPosition(int n) {
        return n >= this.offset && n < this.offset + this.textCount;
    }

    public void copyFrom(Token token) {
        this.text = token.text;
        this.textOffset = token.textOffset;
        this.textCount = token.textCount;
        this.offset = token.offset;
        this.type = token.type;
        this.languageIndex = token.languageIndex;
        this.nextToken = token.nextToken;
    }

    public int documentToToken(int n) {
        return n + (this.textOffset - this.offset);
    }

    public boolean endsWith(char[] cArray) {
        if (cArray == null || cArray.length > this.textCount) {
            return false;
        }
        int n = this.textOffset + this.textCount - cArray.length;
        for (int i = 0; i < cArray.length; ++i) {
            if (this.text[n + i] == cArray[i]) continue;
            return false;
        }
        return true;
    }

    private static final String getHTMLFormatForColor(Color color) {
        String string;
        String string2;
        if (color == null) {
            return "black";
        }
        String string3 = Integer.toHexString(color.getRed());
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(color.getGreen())).length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(color.getBlue())).length() == 1) {
            string = "0" + string;
        }
        return "#" + string3 + string2 + string;
    }

    public String getHTMLRepresentation(RSyntaxTextArea rSyntaxTextArea) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendHTMLRepresentation(stringBuffer, rSyntaxTextArea, true);
        return stringBuffer.toString();
    }

    public int getLanguageIndex() {
        return this.languageIndex;
    }

    public Token getLastNonCommentNonWhitespaceToken() {
        Token token = null;
        Token token2 = this;
        while (token2 != null && token2.isPaintable()) {
            switch (token2.type) {
                case 1: 
                case 2: 
                case 3: 
                case 21: {
                    break;
                }
                default: {
                    token = token2;
                }
            }
            token2 = token2.nextToken;
        }
        return token;
    }

    public Token getLastPaintableToken() {
        Token token = this;
        while (token.isPaintable()) {
            if (token.nextToken == null || !token.nextToken.isPaintable()) {
                return token;
            }
            token = token.nextToken;
        }
        return null;
    }

    public String getLexeme() {
        return new String(this.text, this.textOffset, this.textCount);
    }

    public abstract int getListOffset(RSyntaxTextArea var1, TabExpander var2, float var3, float var4);

    public Token getNextToken() {
        return this.nextToken;
    }

    public int getOffsetBeforeX(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        int n;
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        int n2 = n + this.textCount;
        float f3 = f;
        for (n = this.textOffset; n < n2; ++n) {
            f3 = this.text[n] == '\t' ? tabExpander.nextTabStop(f3, 0) : (f3 += (float)fontMetrics.charWidth(this.text[n]));
            if (!(f3 > f2)) continue;
            int n3 = Math.max(n - this.textOffset, 1);
            return this.offset + n3;
        }
        return this.offset + this.textCount - 1;
    }

    public float getWidth(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        return this.getWidthUpTo(this.textCount, rSyntaxTextArea, tabExpander, f);
    }

    public abstract float getWidthUpTo(int var1, RSyntaxTextArea var2, TabExpander var3, float var4);

    public boolean is(int n, char[] cArray) {
        if (this.type == n && this.textCount == cArray.length) {
            for (int i = 0; i < this.textCount; ++i) {
                if (this.text[this.textOffset + i] == cArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean is(int n, String string) {
        return this.type == n && this.textCount == string.length() && string.equals(this.getLexeme());
    }

    public boolean isComment() {
        return this.type >= 1 && this.type <= 5;
    }

    public boolean isHyperlink() {
        return this.hyperlink;
    }

    public boolean isIdentifier() {
        return this.type == 20;
    }

    public boolean isLeftCurly() {
        return this.type == 22 && this.isSingleChar('{');
    }

    public boolean isRightCurly() {
        return this.type == 22 && this.isSingleChar('}');
    }

    public boolean isPaintable() {
        return this.type > 0;
    }

    public boolean isSingleChar(char c) {
        return this.textCount == 1 && this.text[this.textOffset] == c;
    }

    public boolean isWhitespace() {
        return this.type == 21;
    }

    public abstract Rectangle listOffsetToView(RSyntaxTextArea var1, TabExpander var2, int var3, int var4, Rectangle var5);

    public void makeStartAt(int n) {
        if (n < this.offset || n >= this.offset + this.textCount) {
            throw new IllegalArgumentException("pos " + n + " is not in range " + this.offset + "-" + (this.offset + this.textCount - 1));
        }
        int n2 = n - this.offset;
        this.offset = n;
        this.textOffset += n2;
        this.textCount -= n2;
    }

    public void moveOffset(int n) {
        if (n < 0 || n > this.textCount) {
            throw new IllegalArgumentException("amt " + n + " is not in range 0-" + this.textCount);
        }
        this.offset += n;
        this.textOffset += n;
        this.textCount -= n;
    }

    public final float paint(Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander) {
        return this.paint(graphics2D, f, f2, rSyntaxTextArea, tabExpander, 0.0f);
    }

    public abstract float paint(Graphics2D var1, float var2, float var3, RSyntaxTextArea var4, TabExpander var5, float var6);

    protected void paintBackground(float f, float f2, float f3, float f4, Graphics2D graphics2D, int n, RSyntaxTextArea rSyntaxTextArea, Color color) {
        Color color2 = rSyntaxTextArea.getBackground();
        graphics2D.setXORMode(color2 != null ? color2 : Color.WHITE);
        graphics2D.setColor(color);
        this.bgRect.setRect(f, f2 - (float)n, f3, f4);
        graphics2D.fillRect((int)f, (int)(f2 - (float)n), (int)f3, (int)f4);
        graphics2D.setPaintMode();
    }

    protected void paintTabLines(int n, int n2, int n3, Graphics2D graphics2D, TabExpander tabExpander, RSyntaxTextArea rSyntaxTextArea) {
        int n4;
        int n5;
        if (this.type != 21) {
            int n6;
            for (n6 = this.textOffset; n6 < this.textOffset + this.textCount && RSyntaxUtilities.isWhitespace(this.text[n6]); ++n6) {
            }
            n5 = n6 - this.textOffset;
            if (n5 < 2) {
                return;
            }
            n3 = (int)this.getWidthUpTo(n5, rSyntaxTextArea, tabExpander, 0.0f);
        }
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        n5 = rSyntaxTextArea.getTabSize();
        if (tabBuf == null || tabBuf.length < n5) {
            tabBuf = new char[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                Token.tabBuf[n4] = 32;
            }
        }
        n4 = fontMetrics.charsWidth(tabBuf, 0, n5);
        graphics2D.setColor(rSyntaxTextArea.getTabLineColor());
        int n7 = n + n4;
        int n8 = n2 - fontMetrics.getAscent();
        if ((n8 & 1) > 0) {
            ++n8;
        }
        while (n7 < n3) {
            int n9 = n8 + rSyntaxTextArea.getLineHeight();
            for (int i = n8; i < n9; i += 2) {
                graphics2D.drawLine(n7, i, n7, i);
            }
            n7 += n4;
        }
    }

    public void set(char[] cArray, int n, int n2, int n3, int n4) {
        this.text = cArray;
        this.textOffset = n;
        this.textCount = n2 - n + 1;
        this.type = n4;
        this.offset = n3;
        this.nextToken = null;
    }

    public void setHyperlink(boolean bl) {
        this.hyperlink = bl;
    }

    public void setLanguageIndex(int n) {
        this.languageIndex = n;
    }

    public void setNextToken(Token token) {
        this.nextToken = token;
    }

    public boolean startsWith(char[] cArray) {
        if (cArray.length <= this.textCount) {
            for (int i = 0; i < cArray.length; ++i) {
                if (this.text[this.textOffset + i] == cArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int tokenToDocument(int n) {
        return n + (this.offset - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.type == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : this.getLexeme() + "'; " + "offset: " + this.offset + "; type: " + this.type + "; " + "isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

