/*
 * Decompiled with CFR 0.152.
 */
package com.siit.image.wscommon.tools;

import com.siit.image.wscommon.tools.ResultMsg;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ResultMsgToXml {
    public static String toResultXml(List<ResultMsg> resultMsgList) {
        Document doc = DocumentHelper.createDocument();
        doc.setXMLEncoding("UTF-8");
        Element root = doc.addElement("root");
        if (resultMsgList != null && resultMsgList.size() > 0) {
            boolean b = true;
            int i = 0;
            while (i < resultMsgList.size()) {
                ResultMsg rm = resultMsgList.get(i);
                if ("1".equals(rm.getResult())) {
                    root.addElement("result").setText("1");
                    root.addElement("success");
                    root.addElement("errormsg").setText(rm.getErrormsg());
                    b = false;
                    break;
                }
                ++i;
            }
            if (b) {
                ResultMsg rm = resultMsgList.get(0);
                root.addElement("result").setText("0");
                root.addElement("success").setText(rm.getSuccess() == null ? "" : rm.getSuccess());
                root.addElement("errormsg").setText("");
            }
            Element items = root.addElement("items");
            int i2 = 0;
            while (i2 < resultMsgList.size()) {
                Element item = items.addElement("item");
                ResultMsg rm = resultMsgList.get(i2);
                item.addElement("serviceid").setText(rm.getServiceid());
                item.addElement("result").setText(rm.getResult());
                item.addElement("success").setText(rm.getSuccess() == null ? "" : rm.getSuccess());
                item.addElement("errormsg").setText(rm.getErrormsg() == null ? "" : rm.getErrormsg());
                ++i2;
            }
        }
        OutputFormat format = OutputFormat.createCompactFormat();
        StringWriter writer = new StringWriter();
        XMLWriter output = new XMLWriter((Writer)writer, format);
        try {
            output.write(doc);
            writer.close();
            output.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return e1.getMessage();
        }
        return writer.toString();
    }
}

