/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;

public class JpaFlowExecutionListener
implements FlowExecutionListener {
    public static final String PERSISTENCE_CONTEXT_ATTRIBUTE = "persistenceContext";
    private EntityManagerFactory entityManagerFactory;
    private TransactionTemplate transactionTemplate;

    public JpaFlowExecutionListener(EntityManagerFactory entityManagerFactory, PlatformTransactionManager transactionManager) {
        this.entityManagerFactory = entityManagerFactory;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    @Override
    public void sessionStarting(RequestContext context, FlowSession session, MutableAttributeMap<?> input) {
        boolean reusePersistenceContext = false;
        if (this.isParentPersistenceContext(session)) {
            if (this.isPersistenceContext(session.getDefinition())) {
                this.setEntityManager(session, this.getEntityManager(session.getParent()));
                reusePersistenceContext = true;
            } else {
                this.unbind(this.getEntityManager(session.getParent()));
            }
        }
        if (this.isPersistenceContext(session.getDefinition()) && !reusePersistenceContext) {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            session.getScope().put(PERSISTENCE_CONTEXT_ATTRIBUTE, em);
            this.bind(em);
        }
    }

    @Override
    public void paused(RequestContext context) {
        if (this.isPersistenceContext(context.getActiveFlow())) {
            this.unbind(this.getEntityManager(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    @Override
    public void resuming(RequestContext context) {
        if (this.isPersistenceContext(context.getActiveFlow())) {
            this.bind(this.getEntityManager(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    @Override
    public void sessionEnding(RequestContext context, FlowSession session, String outcome, MutableAttributeMap<?> output) {
        if (this.isParentPersistenceContext(session)) {
            return;
        }
        if (this.isPersistenceContext(session.getDefinition())) {
            final EntityManager em = this.getEntityManager(session);
            Boolean commitStatus = session.getState().getAttributes().getBoolean("commit");
            if (Boolean.TRUE.equals(commitStatus)) {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        em.joinTransaction();
                    }
                });
            }
            this.unbind(em);
            em.close();
        }
    }

    @Override
    public void sessionEnded(RequestContext context, FlowSession session, String outcome, AttributeMap<?> output) {
        if (this.isParentPersistenceContext(session) && !this.isPersistenceContext(session.getDefinition())) {
            this.bind(this.getEntityManager(session.getParent()));
        }
    }

    @Override
    public void exceptionThrown(RequestContext context, FlowExecutionException exception) {
        if (context.getFlowExecutionContext().isActive() && this.isPersistenceContext(context.getActiveFlow())) {
            this.unbind(this.getEntityManager(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    private boolean isPersistenceContext(FlowDefinition flow) {
        return flow.getAttributes().contains(PERSISTENCE_CONTEXT_ATTRIBUTE);
    }

    private boolean isParentPersistenceContext(FlowSession flowSession) {
        return !flowSession.isRoot() && this.isPersistenceContext(flowSession.getParent().getDefinition());
    }

    private EntityManager getEntityManager(FlowSession session) {
        return (EntityManager)session.getScope().get(PERSISTENCE_CONTEXT_ATTRIBUTE);
    }

    private void setEntityManager(FlowSession session, EntityManager em) {
        session.getScope().put(PERSISTENCE_CONTEXT_ATTRIBUTE, em);
    }

    private void bind(EntityManager em) {
        TransactionSynchronizationManager.bindResource((Object)this.entityManagerFactory, (Object)new EntityManagerHolder(em));
    }

    private void unbind(EntityManager em) {
        if (TransactionSynchronizationManager.hasResource((Object)this.entityManagerFactory)) {
            TransactionSynchronizationManager.unbindResource((Object)this.entityManagerFactory);
        }
    }
}

