/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLockCommand
extends SVNCommand {
    public SVNLockCommand() {
        super("lock", null);
    }

    public boolean isCommitter() {
        return true;
    }

    public String getFileAmbigousErrorMessage() {
        return "Lock comment file is a versioned file; use '--force-log' to override";
    }

    public String getMessageAmbigousErrorMessage() {
        return "The lock comment is a pathname (was -F intended?); use '--force-log' to override";
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.MESSAGE);
        options.add(SVNOption.FILE);
        options.add(SVNOption.FORCE_LOG);
        options.add(SVNOption.ENCODING);
        options.add(SVNOption.FORCE);
        return options;
    }

    public void run() throws SVNException {
        List targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
        String message = this.getLockMessage();
        ArrayList<File> paths = new ArrayList<File>();
        ArrayList<SVNURL> urls = new ArrayList<SVNURL>();
        Iterator ts = targets.iterator();
        while (ts.hasNext()) {
            String targetName = (String)ts.next();
            SVNPath target = new SVNPath(targetName);
            if (target.isURL()) {
                urls.add(target.getURL());
                continue;
            }
            paths.add(target.getFile());
        }
        if (!paths.isEmpty()) {
            File[] filesArray = paths.toArray(new File[paths.size()]);
            client.doLock(filesArray, this.getSVNEnvironment().isForce(), message);
        }
        if (!urls.isEmpty()) {
            SVNURL[] urlsArray = urls.toArray(new SVNURL[urls.size()]);
            client.doLock(urlsArray, this.getSVNEnvironment().isForce(), message);
        }
    }

    protected String getLockMessage() throws SVNException {
        if (this.getSVNEnvironment().getFileData() != null) {
            byte[] data = this.getSVNEnvironment().getFileData();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 0) continue;
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_BAD_LOG_MESSAGE, (String)"Log message contains a zero byte"), (SVNLogType)SVNLogType.CLIENT);
            }
            try {
                return new String(this.getSVNEnvironment().getFileData(), this.getSVNEnvironment().getEncoding() != null ? this.getSVNEnvironment().getEncoding() : "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)e.getMessage()), (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (this.getSVNEnvironment().getMessage() != null) {
            return this.getSVNEnvironment().getMessage();
        }
        return null;
    }
}

