/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMkDirCommand
extends SVNCommand {
    public SVNMkDirCommand() {
        super("mkdir", null);
    }

    public boolean isCommitter() {
        return true;
    }

    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.PARENTS);
        options = SVNOption.addLogMessageOptions(options);
        return options;
    }

    public void run() throws SVNException {
        SVNCommitClient client;
        SVNErrorMessage err;
        List targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        boolean hasURLs = false;
        boolean hasPaths = false;
        Iterator ts = targets.iterator();
        while (ts.hasNext()) {
            String targetName = (String)ts.next();
            if (!SVNCommandUtil.isURL(targetName)) {
                if (this.getSVNEnvironment().getMessage() != null || this.getSVNEnvironment().getFileData() != null || this.getSVNEnvironment().getRevisionProperties() != null) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, (String)"Local, non-commit operations do not take a log message or revision properties");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                hasPaths = true;
                continue;
            }
            hasURLs = true;
        }
        if (hasURLs && hasPaths) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Specify either URLs or local paths, not both"), (SVNLogType)SVNLogType.CLIENT);
        }
        if (hasURLs) {
            client = this.getSVNEnvironment().getClientManager().getCommitClient();
            if (!this.getSVNEnvironment().isQuiet()) {
                client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
            }
            client.setCommitHandler((ISVNCommitHandler)this.getSVNEnvironment());
            SVNURL[] urls = new SVNURL[targets.size()];
            for (int i = 0; i < targets.size(); ++i) {
                String url = (String)targets.get(i);
                urls[i] = SVNURL.parseURIEncoded((String)url);
            }
            try {
                SVNCommitInfo info = client.doMkDir(urls, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().isParents());
                this.getSVNEnvironment().printCommitInfo(info);
            }
            catch (SVNException e) {
                SVNErrorMessage err2 = e.getErrorMessage();
                if (!(this.getSVNEnvironment().isParents() || err2.getErrorCode() != SVNErrorCode.FS_NOT_FOUND && err2.getErrorCode() != SVNErrorCode.FS_NOT_DIRECTORY && err2.getErrorCode() != SVNErrorCode.RA_DAV_PATH_NOT_FOUND)) {
                    err2 = err2.wrap("Try 'svn mkdir --parents' instead?");
                }
                SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
            }
        } else {
            client = this.getSVNEnvironment().getClientManager().getWCClient();
            if (!this.getSVNEnvironment().isQuiet()) {
                client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
            }
            try {
                Iterator ts2 = targets.iterator();
                while (ts2.hasNext()) {
                    String targetName = (String)ts2.next();
                    SVNPath target = new SVNPath(targetName);
                    client.doAdd(target.getFile(), false, true, false, SVNDepth.INFINITY, false, this.getSVNEnvironment().isParents());
                }
            }
            catch (SVNException e) {
                err = e.getErrorMessage();
                if (err.getErrorCode() == SVNErrorCode.IO_ERROR) {
                    err = err.wrap("Try 'svn mkdir --parents' instead?");
                } else if (!this.getSVNEnvironment().isParents() && err.getErrorCode() == SVNErrorCode.IO_ERROR) {
                    err = err.wrap("Try 'svn add' or 'svn add --non-recursive' instead?");
                }
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        }
    }
}

