/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnsync;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svnsync.SVNSyncCommand;
import org.tmatesoft.svn.cli.svnsync.SVNSyncOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNSyncInfo;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSyncInfoCommand
extends SVNSyncCommand {
    public SVNSyncInfoCommand() {
        super("info", null, 1);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNSyncOption> options = new LinkedList<SVNSyncOption>();
        options.add(SVNSyncOption.NON_INTERACTIVE);
        options.add(SVNSyncOption.NO_AUTH_CACHE);
        options.add(SVNSyncOption.USERNAME);
        options.add(SVNSyncOption.PASSWORD);
        options.add(SVNSyncOption.TRUST_SERVER_CERT);
        options.add(SVNSyncOption.SOURCE_USERNAME);
        options.add(SVNSyncOption.SOURCE_PASSWORD);
        options.add(SVNSyncOption.SYNC_USERNAME);
        options.add(SVNSyncOption.SYNC_PASSWORD);
        options.add(SVNSyncOption.CONFIG_DIR);
        return options;
    }

    public void run() throws SVNException {
        SVNPath toURL;
        SVNErrorMessage err;
        List targets = this.getEnvironment().combineTargets(null, false);
        if (targets.size() < 1) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (targets.size() > 1) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (!(toURL = new SVNPath((String)targets.get(0))).isURL()) {
            SVNErrorMessage err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Path ''{0}'' is not a URL", (Object)toURL.getTarget());
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        }
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        SVNSyncInfo info = client.doInfo(toURL.getURL());
        this.getSVNSyncEnvironment().getOut().println("Source URL: " + info.getSrcURL());
        if (info.getSourceRepositoryUUID() != null) {
            this.getSVNSyncEnvironment().getOut().println("Source Repository UUID: " + info.getSourceRepositoryUUID());
        }
        if (SVNRevision.isValidRevisionNumber((long)info.getLastMergedRevision())) {
            this.getSVNSyncEnvironment().getOut().println("Last Merged Revision: " + info.getLastMergedRevision());
        }
    }
}

