/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String CFSTR_INETURLW = "UniformResourceLocatorW";
    static final int CFSTR_INETURLIDW = URLTransfer.registerType("UniformResourceLocatorW");
    static final String CFSTR_INETURL = "UniformResourceLocator";
    static final int CFSTR_INETURLID = URLTransfer.registerType("UniformResourceLocator");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String string = (String)object;
        if (transferData.type == CFSTR_INETURLIDW) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            int n2 = cArray.length * 2;
            long l = OS.GlobalAlloc(64, n2);
            OS.MoveMemory(l, cArray, n2);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = l;
            transferData.stgmedium.pUnkForRelease = 0L;
            transferData.result = 0;
        } else if (transferData.type == CFSTR_INETURLID) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            int n3 = OS.GetACP();
            int n4 = OS.WideCharToMultiByte(n3, 0, cArray, -1, null, 0, null, null);
            if (n4 == 0) {
                transferData.stgmedium = new STGMEDIUM();
                transferData.result = -2147221402;
                return;
            }
            long l = OS.GlobalAlloc(64, n4);
            OS.WideCharToMultiByte(n3, 0, cArray, -1, l, n4, null, null);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = l;
            transferData.stgmedium.pUnkForRelease = 0L;
            transferData.result = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData)) return null;
        if (transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        FORMATETC fORMATETC = transferData.formatetc;
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        long l = sTGMEDIUM.unionField;
        try {
            if (transferData.type == CFSTR_INETURLIDW) {
                String string;
                int n = OS.GlobalSize(l) / 2 * 2;
                if (n == 0) {
                    Object var8_8 = null;
                    Object var18_10 = null;
                    OS.GlobalFree(l);
                    return var8_8;
                }
                char[] cArray = new char[n / 2];
                long l2 = OS.GlobalLock(l);
                if (l2 == 0L) {
                    Object var11_21 = null;
                    Object var18_11 = null;
                    OS.GlobalFree(l);
                    return var11_21;
                }
                try {
                    OS.MoveMemory(cArray, l2, n);
                    int n2 = cArray.length;
                    for (int i = 0; i < cArray.length; ++i) {
                        if (cArray[i] != '\u0000') continue;
                        n2 = i;
                        break;
                    }
                    string = new String(cArray, 0, n2);
                    Object var14_28 = null;
                }
                catch (Throwable throwable) {
                    Object var14_29 = null;
                    OS.GlobalUnlock(l);
                    throw throwable;
                }
                OS.GlobalUnlock(l);
                Object var18_12 = null;
                OS.GlobalFree(l);
                return string;
            }
            if (transferData.type == CFSTR_INETURLID) {
                int n;
                int n3;
                long l3;
                block15: {
                    Object var11_23;
                    l3 = OS.GlobalLock(l);
                    if (l3 == 0L) {
                        Object var9_19 = null;
                        Object var18_13 = null;
                        OS.GlobalFree(l);
                        return var9_19;
                    }
                    try {
                        n3 = OS.GetACP();
                        n = OS.MultiByteToWideChar(n3, 1, l3, -1, null, 0);
                        if (n != 0) break block15;
                        var11_23 = null;
                        Object var16_32 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_34 = null;
                        OS.GlobalUnlock(l);
                        throw throwable;
                    }
                    OS.GlobalUnlock(l);
                    Object var18_14 = null;
                    OS.GlobalFree(l);
                    return var11_23;
                }
                char[] cArray = new char[n - 1];
                OS.MultiByteToWideChar(n3, 1, l3, -1, cArray, cArray.length);
                String string = new String(cArray);
                Object var16_33 = null;
                OS.GlobalUnlock(l);
                Object var18_15 = null;
                OS.GlobalFree(l);
                return string;
            }
            Object var18_16 = null;
            OS.GlobalFree(l);
            return null;
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            OS.GlobalFree(l);
            throw throwable;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{CFSTR_INETURLIDW, CFSTR_INETURLID};
    }

    protected String[] getTypeNames() {
        return new String[]{CFSTR_INETURLW, CFSTR_INETURL};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

