/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    ToolBar parent;
    Control control;
    String toolTipText;
    Image disabledImage;
    Image hotImage;
    Image disabledImage2;
    int id;
    short cx;

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ToolItem.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void click(boolean bl) {
        long l = this.parent.handle;
        if (OS.GetKeyState(1) < 0) {
            return;
        }
        int n = (int)OS.SendMessage(l, 1049, (long)this.id, 0L);
        RECT rECT = new RECT();
        OS.SendMessage(l, 1053, (long)n, rECT);
        int n2 = (int)OS.SendMessage(l, 1095, 0L, 0L);
        int n3 = rECT.top + (rECT.bottom - rECT.top) / 2;
        long l2 = OS.MAKELPARAM(bl ? rECT.right - 1 : rECT.left, n3);
        this.parent.ignoreMouse = true;
        OS.SendMessage(l, 513, 0L, l2);
        OS.SendMessage(l, 514, 0L, l2);
        this.parent.ignoreMouse = false;
        if (n2 != -1) {
            OS.SendMessage(l, 1096, (long)n2, 0L);
        }
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getEnabled()) {
            if ((this.style & 2) != 0) {
                if (this.control != null) {
                    return this.control.computeTabList();
                }
            } else {
                return new Widget[]{this};
            }
        }
        return new Widget[0];
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        long l = this.parent.handle;
        int n = (int)OS.SendMessage(l, 1049, (long)this.id, 0L);
        RECT rECT = new RECT();
        OS.SendMessage(l, 1053, (long)n, rECT);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return (this.state & 8) == 0;
        }
        long l = this.parent.handle;
        long l2 = OS.SendMessage(l, 1042, (long)this.id, 0L);
        return (l2 & 4L) != 0L;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        long l = this.parent.handle;
        long l2 = OS.SendMessage(l, 1042, (long)this.id, 0L);
        return (l2 & 1L) != 0L;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        long l = this.parent.handle;
        int n = (int)OS.SendMessage(l, 1049, (long)this.id, 0L);
        RECT rECT = new RECT();
        OS.SendMessage(l, 1053, (long)n, rECT);
        return rECT.right - rECT.left;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTabGroup() {
        int n;
        ToolItem[] toolItemArray = this.parent._getTabItemList();
        if (toolItemArray != null) {
            for (n = 0; n < toolItemArray.length; ++n) {
                if (toolItemArray[n] != this) continue;
                return true;
            }
        }
        if ((this.style & 2) != 0) {
            return true;
        }
        n = this.parent.indexOf(this);
        if (n == 0) {
            return true;
        }
        ToolItem toolItem = this.parent.getItem(n - 1);
        return (toolItem.getStyle() & 2) != 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.releaseImages();
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        if (this.disabledImage2 != null) {
            this.disabledImage2.dispose();
        }
        this.disabledImage2 = null;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
    }

    void releaseImages() {
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 9;
        long l = this.parent.handle;
        OS.SendMessage(l, OS.TB_GETBUTTONINFO, (long)this.id, tBBUTTONINFO);
        if ((tBBUTTONINFO.fsStyle & 1) == 0 && tBBUTTONINFO.iImage != -2) {
            ImageList imageList = this.parent.getImageList();
            ImageList imageList2 = this.parent.getHotImageList();
            ImageList imageList3 = this.parent.getDisabledImageList();
            if (imageList != null) {
                imageList.put(tBBUTTONINFO.iImage, null);
            }
            if (imageList2 != null) {
                imageList2.put(tBBUTTONINFO.iImage, null);
            }
            if (imageList3 != null) {
                imageList3.put(tBBUTTONINFO.iImage, null);
            }
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            Rectangle rectangle = this.getBounds();
            this.control.setSize(rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.control.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.control.setLocation(rectangle2.x, rectangle2.y);
        }
    }

    void selectRadio() {
        ToolItem[] toolItemArray = this.parent.getItems();
        for (int i = 0; i < toolItemArray.length && toolItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && toolItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < toolItemArray.length && toolItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        this.control = control;
        if ((this.parent.style & 0x240) != 0) {
            boolean bl = false;
            long l = this.parent.handle;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 12;
            OS.SendMessage(l, OS.TB_GETBUTTONINFO, (long)this.id, tBBUTTONINFO);
            if (control == null) {
                if ((tBBUTTONINFO.fsStyle & 1) == 0) {
                    bl = true;
                    tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle & 0xFFFFFFBF);
                    tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle | 1);
                    tBBUTTONINFO.fsState = (this.state & 8) != 0 ? (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB) : (byte)(tBBUTTONINFO.fsState | 4);
                }
            } else if ((tBBUTTONINFO.fsStyle & 1) != 0) {
                bl = true;
                tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle & 0xFFFFFFFE);
                tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle | 0x40);
                tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB);
                tBBUTTONINFO.dwMask |= 1;
                tBBUTTONINFO.iImage = -2;
            }
            if (bl) {
                OS.SendMessage(l, OS.TB_SETBUTTONINFO, (long)this.id, tBBUTTONINFO);
                if (OS.SendMessage(l, 1064, 0L, 0L) > 1L) {
                    OS.InvalidateRect(l, null, true);
                }
            }
        }
        this.resizeControl();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        long l = this.parent.handle;
        int n = (int)OS.SendMessage(l, 1042, (long)this.id, 0L);
        if ((n & 4) != 0 == bl) {
            return;
        }
        if (bl) {
            n |= 4;
            this.state &= 0xFFFFFFF7;
        } else {
            n &= 0xFFFFFFFB;
            this.state |= 8;
        }
        OS.SendMessage(l, 1041, (long)this.id, (long)n);
        if ((this.style & 2) == 0 && this.image != null) {
            this.updateImages(bl && this.parent.getEnabled());
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.disabledImage = image;
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.hotImage = image;
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        this.updateImages(this.getEnabled() && this.parent.getEnabled());
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        long l = this.parent.handle;
        int n = (int)OS.SendMessage(l, 1042, (long)this.id, 0L);
        if ((n & 1) != 0 == bl) {
            return;
        }
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        OS.SendMessage(l, 1041, (long)this.id, (long)n);
        if (!((this.style & 0x30) == 0 || this.getEnabled() && this.parent.getEnabled())) {
            this.updateImages(false);
        }
    }

    boolean setTabItemFocus() {
        if (this.parent.setTabItemFocus()) {
            long l = this.parent.handle;
            int n = (int)OS.SendMessage(l, 1049, (long)this.id, 0L);
            OS.SendMessage(l, 1096, (long)n, 0L);
            return true;
        }
        return false;
    }

    void _setText(String string) {
        long l = this.parent.handle;
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 10;
        tBBUTTONINFO.fsStyle = (byte)(this.widgetStyle() | 0x10);
        long l2 = OS.GetProcessHeap();
        long l3 = 0L;
        if (string.length() != 0) {
            int n;
            tBBUTTONINFO.fsStyle = (byte)(tBBUTTONINFO.fsStyle | 0x40);
            TCHAR tCHAR = (this.style & Integer.MIN_VALUE) != 0 ? (((n = OS.GetWindowLong(l, -20)) & 0x400000) != 0 ? new TCHAR(this.parent.getCodePage(), '\u202a' + string, true) : new TCHAR(this.parent.getCodePage(), '\u202b' + string, true)) : new TCHAR(this.parent.getCodePage(), string, true);
            n = tCHAR.length() * TCHAR.sizeof;
            l3 = OS.HeapAlloc(l2, 8, n);
            OS.MoveMemory(l3, tCHAR, n);
            tBBUTTONINFO.pszText = l3;
        }
        OS.SendMessage(l, OS.TB_SETBUTTONINFO, (long)this.id, tBBUTTONINFO);
        if (l3 != 0L) {
            OS.HeapFree(l2, 0, l3);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        this._setText(string);
        this.parent.setDropDownItems(false);
        long l = this.parent.handle;
        long l2 = OS.SendMessage(l, 49, 0L, 0L);
        OS.SendMessage(l, 48, l2, 0L);
        this.parent.setDropDownItems(true);
        this.parent.layoutItems();
    }

    boolean updateTextDirection(int n) {
        if (super.updateTextDirection(n) && this.text.length() != 0) {
            this._setText(this.text);
            return true;
        }
        return false;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setWidth(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        long l = this.parent.handle;
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 64;
        tBBUTTONINFO.cx = this.cx = (short)n;
        OS.SendMessage(l, OS.TB_SETBUTTONINFO, (long)this.id, tBBUTTONINFO);
        this.parent.layoutItems();
    }

    void updateImages(boolean bl) {
        Object object;
        if ((this.style & 2) != 0) {
            return;
        }
        long l = this.parent.handle;
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 1;
        OS.SendMessage(l, OS.TB_GETBUTTONINFO, (long)this.id, tBBUTTONINFO);
        if (tBBUTTONINFO.iImage == -2 && this.image == null) {
            return;
        }
        ImageList imageList = this.parent.getImageList();
        ImageList imageList2 = this.parent.getHotImageList();
        ImageList imageList3 = this.parent.getDisabledImageList();
        if (tBBUTTONINFO.iImage == -2) {
            object = this.image.getBounds();
            int n = this.parent.style & 0x4000000;
            if (imageList == null) {
                imageList = this.display.getImageListToolBar(n, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            if (imageList3 == null) {
                imageList3 = this.display.getImageListToolBarDisabled(n, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            if (imageList2 == null) {
                imageList2 = this.display.getImageListToolBarHot(n, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            Image image = this.disabledImage;
            if (this.disabledImage == null) {
                if (this.disabledImage2 != null) {
                    this.disabledImage2.dispose();
                }
                this.disabledImage2 = null;
                image = this.image;
                if (!bl) {
                    image = this.disabledImage2 = new Image((Device)this.display, this.image, 1);
                }
            }
            Image image2 = this.image;
            Image image3 = this.hotImage;
            if ((this.style & 0x30) != 0 && !bl) {
                image2 = image3 = image;
            }
            tBBUTTONINFO.iImage = imageList.add(image2);
            imageList3.add(image);
            imageList2.add(image3 != null ? image3 : image2);
            this.parent.setImageList(imageList);
            this.parent.setDisabledImageList(imageList3);
            this.parent.setHotImageList(imageList2);
        } else {
            object = null;
            if (imageList3 != null) {
                if (this.image != null) {
                    if (this.disabledImage2 != null) {
                        this.disabledImage2.dispose();
                    }
                    this.disabledImage2 = null;
                    object = this.disabledImage;
                    if (this.disabledImage == null) {
                        object = this.image;
                        if (!bl) {
                            this.disabledImage2 = new Image((Device)this.display, this.image, 1);
                            object = this.disabledImage2;
                        }
                    }
                }
                imageList3.put(tBBUTTONINFO.iImage, (Image)object);
            }
            Object object2 = this.image;
            Object object3 = this.hotImage;
            if ((this.style & 0x30) != 0 && !bl) {
                object2 = object3 = object;
            }
            if (imageList != null) {
                imageList.put(tBBUTTONINFO.iImage, (Image)object2);
            }
            if (imageList2 != null) {
                imageList2.put(tBBUTTONINFO.iImage, (Image)(object3 != null ? object3 : object2));
            }
            if (this.image == null) {
                tBBUTTONINFO.iImage = -2;
            }
        }
        tBBUTTONINFO.dwMask |= 0x40;
        tBBUTTONINFO.cx = 0;
        OS.SendMessage(l, OS.TB_SETBUTTONINFO, (long)this.id, tBBUTTONINFO);
        long l2 = OS.SendMessage(l, 49, 0L, 0L);
        OS.SendMessage(l, 48, l2, 0L);
        this.parent.layoutItems();
    }

    int widgetStyle() {
        if ((this.style & 4) != 0) {
            return 8;
        }
        if ((this.style & 8) != 0) {
            return 0;
        }
        if ((this.style & 0x20) != 0) {
            return 2;
        }
        if ((this.style & 0x10) != 0) {
            return 2;
        }
        if ((this.style & 2) != 0) {
            return 1;
        }
        return 0;
    }

    LRESULT wmCommandChild(long l, long l2) {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13);
        return null;
    }
}

