/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.UcanaccessResultSet;

public class UcanaccessResultSetMetaData
implements ResultSetMetaData {
    private ResultSetMetaData wrapped;
    private Metadata metadata;
    private Map<String, String> aliases;

    public UcanaccessResultSetMetaData(ResultSetMetaData _wrapped, Map<String, String> _aliases, UcanaccessResultSet _resultSet) throws SQLException {
        this.wrapped = _wrapped;
        this.metadata = new Metadata(_resultSet.getStatement().getConnection());
        this.aliases = _aliases;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.wrapped.getCatalogName(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.wrapped.getColumnClassName(column);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.wrapped.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.wrapped.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        String name = SQLConverter.preEscapingIdentifier(this.wrapped.getColumnLabel(column));
        return this.aliases.containsKey(name) ? this.aliases.get(name) : this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String columnName = SQLConverter.preEscapingIdentifier(this.wrapped.getColumnName(column));
        String tableName = SQLConverter.preEscapingIdentifier(this.wrapped.getTableName(column));
        String cn = this.metadata.getColumnName(tableName, columnName);
        return cn == null ? columnName : cn;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.wrapped.getColumnType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.wrapped.getColumnTypeName(column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.wrapped.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.wrapped.getScale(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.wrapped.getSchemaName(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        String tableName = SQLConverter.preEscapingIdentifier(this.wrapped.getTableName(column));
        if ("SYSTEM_SUBQUERY".equals(tableName)) {
            return tableName;
        }
        return this.metadata.getTableName(tableName);
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        String columnName = SQLConverter.preEscapingIdentifier(this.wrapped.getColumnName(column));
        String tableName = SQLConverter.preEscapingIdentifier(this.wrapped.getTableName(column));
        return this.metadata.isAutoIncrement(tableName, columnName);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.wrapped.isCaseSensitive(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        String columnName = SQLConverter.preEscapingIdentifier(this.wrapped.getColumnName(column));
        String tableName = SQLConverter.preEscapingIdentifier(this.wrapped.getTableName(column));
        return this.metadata.isCurrency(tableName, columnName);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.wrapped.isDefinitelyWritable(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.wrapped.isNullable(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.wrapped.isReadOnly(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.wrapped.isSearchable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.wrapped.isSigned(column);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrapped.isWrapperFor(iface);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.wrapped.isWritable(column);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrapped.unwrap(iface);
    }
}

