/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NodeYUI;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean hasFinally;

    public final void transform(ScriptOrFnNode tree) {
        this.transformCompilationUnit(tree);
        int i = 0;
        while (i != tree.getFunctionCount()) {
            FunctionNode fn = tree.getFunctionNode(i);
            this.transform(fn);
            ++i;
        }
    }

    private void transformCompilationUnit(ScriptOrFnNode tree) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.hasFinally = false;
        boolean createScopeObjects = tree.getType() != 108 || ((FunctionNode)tree).requiresActivation();
        tree.flattenSymbolTable(!createScopeObjects);
        this.transformCompilationUnit_r(tree, tree, tree, createScopeObjects);
    }

    private void transformCompilationUnit_r(ScriptOrFnNode tree, NodeYUI parent, NodeYUI.Scope scope, boolean createScopeObjects) {
        NodeYUI node = null;
        block16: while (true) {
            NodeYUI previous = null;
            if (node == null) {
                node = parent.getFirstChild();
            } else {
                previous = node;
                node = node.getNext();
            }
            if (node == null) break;
            int type = node.getType();
            if (createScopeObjects && (type == 128 || type == 131 || type == 156) && node instanceof NodeYUI.Scope) {
                NodeYUI.Scope newScope = (NodeYUI.Scope)node;
                if (newScope.symbolTable != null) {
                    NodeYUI let = new NodeYUI(type == 156 ? 157 : 152);
                    NodeYUI innerLet = new NodeYUI(152);
                    let.addChildToBack(innerLet);
                    for (String name : newScope.symbolTable.keySet()) {
                        innerLet.addChildToBack(NodeYUI.newString(39, name));
                    }
                    newScope.symbolTable = null;
                    NodeYUI oldNode = node;
                    node = NodeTransformer.replaceCurrent(parent, previous, node, let);
                    type = node.getType();
                    let.addChildToBack(oldNode);
                }
            }
            switch (type) {
                case 113: 
                case 129: 
                case 131: {
                    this.loops.push(node);
                    this.loopEnds.push(((NodeYUI.Jump)node).target);
                    break;
                }
                case 122: {
                    this.loops.push(node);
                    NodeYUI leave = node.getNext();
                    if (leave.getType() != 3) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 80: {
                    NodeYUI.Jump jump = (NodeYUI.Jump)node;
                    NodeYUI finallytarget = jump.getFinally();
                    if (finallytarget == null) break;
                    this.hasFinally = true;
                    this.loops.push(node);
                    this.loopEnds.push(finallytarget);
                    break;
                }
                case 3: 
                case 130: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 72: {
                    ((FunctionNode)tree).addResumptionPoint(node);
                    break;
                }
                case 4: {
                    NodeYUI n;
                    boolean isGenerator;
                    boolean bl = isGenerator = tree.getType() == 108 && ((FunctionNode)tree).isGenerator();
                    if (isGenerator) {
                        node.putIntProp(20, 1);
                    }
                    if (!this.hasFinally) break;
                    NodeYUI unwindBlock = null;
                    int i = this.loops.size() - 1;
                    while (i >= 0) {
                        n = (NodeYUI)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype == 80 || elemtype == 122) {
                            NodeYUI unwind;
                            if (elemtype == 80) {
                                NodeYUI jsrtarget;
                                NodeYUI.Jump jsrnode = new NodeYUI.Jump(134);
                                jsrnode.target = jsrtarget = ((NodeYUI.Jump)n).getFinally();
                                unwind = jsrnode;
                            } else {
                                unwind = new NodeYUI(3);
                            }
                            if (unwindBlock == null) {
                                unwindBlock = new NodeYUI(128, node.getLineno());
                            }
                            unwindBlock.addChildToBack(unwind);
                        }
                        --i;
                    }
                    if (unwindBlock == null) break;
                    NodeYUI returnNode = node;
                    NodeYUI returnExpr = returnNode.getFirstChild();
                    node = NodeTransformer.replaceCurrent(parent, previous, node, unwindBlock);
                    if (returnExpr == null || isGenerator) {
                        unwindBlock.addChildToBack(returnNode);
                        continue block16;
                    }
                    NodeYUI store = new NodeYUI(133, returnExpr);
                    unwindBlock.addChildToFront(store);
                    returnNode = new NodeYUI(64);
                    unwindBlock.addChildToBack(returnNode);
                    this.transformCompilationUnit_r(tree, store, scope, createScopeObjects);
                    continue block16;
                }
                case 119: 
                case 120: {
                    NodeYUI n;
                    NodeYUI.Jump jump = (NodeYUI.Jump)node;
                    NodeYUI.Jump jumpStatement = jump.getJumpStatement();
                    if (jumpStatement == null) {
                        Kit.codeBug();
                    }
                    int i = this.loops.size();
                    while (true) {
                        if (i == 0) {
                            throw Kit.codeBug();
                        }
                        if ((n = (NodeYUI)this.loops.get(--i)) == jumpStatement) break;
                        int elemtype = n.getType();
                        if (elemtype == 122) {
                            NodeYUI leave = new NodeYUI(3);
                            previous = NodeTransformer.addBeforeCurrent(parent, previous, node, leave);
                            continue;
                        }
                        if (elemtype != 80) continue;
                        NodeYUI.Jump tryNode = (NodeYUI.Jump)n;
                        NodeYUI.Jump jsrFinally = new NodeYUI.Jump(134);
                        jsrFinally.target = tryNode.getFinally();
                        previous = NodeTransformer.addBeforeCurrent(parent, previous, node, jsrFinally);
                    }
                    jump.target = type == 119 ? jumpStatement.target : jumpStatement.getContinue();
                    jump.setType(5);
                    break;
                }
                case 38: {
                    this.visitCall(node, tree);
                    break;
                }
                case 30: {
                    this.visitNew(node, tree);
                    break;
                }
                case 152: 
                case 157: {
                    NodeYUI child = node.getFirstChild();
                    if (child.getType() == 152) {
                        boolean createWith = tree.getType() != 108 || ((FunctionNode)tree).requiresActivation();
                        node = this.visitLet(createWith, parent, previous, node);
                        break;
                    }
                }
                case 121: 
                case 153: {
                    NodeYUI result = new NodeYUI(128);
                    NodeYUI cursor = node.getFirstChild();
                    while (cursor != null) {
                        NodeYUI n = cursor;
                        cursor = cursor.getNext();
                        if (n.getType() == 39) {
                            if (!n.hasChildren()) continue;
                            NodeYUI init = n.getFirstChild();
                            n.removeChild(init);
                            n.setType(49);
                            n = new NodeYUI(type == 153 ? 154 : 8, n, init);
                        } else if (n.getType() != 157) {
                            throw Kit.codeBug();
                        }
                        NodeYUI pop = new NodeYUI(132, n, node.getLineno());
                        result.addChildToBack(pop);
                    }
                    node = NodeTransformer.replaceCurrent(parent, previous, node, result);
                    break;
                }
                case 136: {
                    NodeYUI.Scope defining = scope.getDefiningScope(node.getString());
                    if (defining == null) break;
                    node.setScope(defining);
                    break;
                }
                case 7: 
                case 32: {
                    NodeYUI child = node.getFirstChild();
                    if (type == 7) {
                        while (child.getType() == 26) {
                            child = child.getFirstChild();
                        }
                        if (child.getType() == 12 || child.getType() == 13) {
                            NodeYUI first = child.getFirstChild();
                            NodeYUI last = child.getLastChild();
                            if (first.getType() == 39 && first.getString().equals("undefined")) {
                                child = last;
                            } else if (last.getType() == 39 && last.getString().equals("undefined")) {
                                child = first;
                            }
                        }
                    }
                    if (child.getType() != 33) break;
                    child.setType(34);
                    break;
                }
                case 8: 
                case 31: 
                case 39: 
                case 154: {
                    String name;
                    NodeYUI.Scope defining;
                    NodeYUI nameSource;
                    NodeYUI n;
                    if (createScopeObjects) break;
                    if (type == 39) {
                        nameSource = node;
                    } else {
                        nameSource = node.getFirstChild();
                        if (nameSource.getType() != 49) {
                            if (type == 31) break;
                            throw Kit.codeBug();
                        }
                    }
                    if (nameSource.getScope() != null || (defining = scope.getDefiningScope(name = nameSource.getString())) == null) break;
                    nameSource.setScope(defining);
                    if (type == 39) {
                        node.setType(55);
                        break;
                    }
                    if (type == 8) {
                        node.setType(56);
                        nameSource.setType(41);
                        break;
                    }
                    if (type == 154) {
                        node.setType(155);
                        nameSource.setType(41);
                        break;
                    }
                    if (type == 31) {
                        n = new NodeYUI(44);
                        node = NodeTransformer.replaceCurrent(parent, previous, node, n);
                        break;
                    }
                    throw Kit.codeBug();
                }
            }
            this.transformCompilationUnit_r(tree, node, node instanceof NodeYUI.Scope ? (NodeYUI.Scope)node : scope, createScopeObjects);
        }
    }

    protected void visitNew(NodeYUI node, ScriptOrFnNode tree) {
    }

    protected void visitCall(NodeYUI node, ScriptOrFnNode tree) {
    }

    protected NodeYUI visitLet(boolean createWith, NodeYUI parent, NodeYUI previous, NodeYUI scopeNode) {
        NodeYUI result;
        boolean isExpression;
        NodeYUI vars = scopeNode.getFirstChild();
        NodeYUI body = vars.getNext();
        scopeNode.removeChild(vars);
        scopeNode.removeChild(body);
        boolean bl = isExpression = scopeNode.getType() == 157;
        if (createWith) {
            result = new NodeYUI(isExpression ? 158 : 128);
            result = NodeTransformer.replaceCurrent(parent, previous, scopeNode, result);
            ArrayList<Object> list = new ArrayList<Object>();
            NodeYUI objectLiteral = new NodeYUI(66);
            NodeYUI v = vars.getFirstChild();
            while (v != null) {
                NodeYUI current = v;
                if (current.getType() == 157) {
                    List destructuringNames = (List)current.getProp(22);
                    NodeYUI c = current.getFirstChild();
                    if (c.getType() != 152) {
                        throw Kit.codeBug();
                    }
                    body = isExpression ? new NodeYUI(88, c.getNext(), body) : new NodeYUI(128, new NodeYUI(132, c.getNext()), body);
                    if (destructuringNames != null) {
                        list.addAll(destructuringNames);
                        int i = 0;
                        while (i < destructuringNames.size()) {
                            objectLiteral.addChildToBack(new NodeYUI(125, NodeYUI.newNumber(0.0)));
                            ++i;
                        }
                    }
                    current = c.getFirstChild();
                }
                if (current.getType() != 39) {
                    throw Kit.codeBug();
                }
                list.add(ScriptRuntime.getIndexObject(current.getString()));
                NodeYUI init = current.getFirstChild();
                if (init == null) {
                    init = new NodeYUI(125, NodeYUI.newNumber(0.0));
                }
                objectLiteral.addChildToBack(init);
                v = v.getNext();
            }
            objectLiteral.putProp(12, list.toArray());
            NodeYUI newVars = new NodeYUI(2, objectLiteral);
            result.addChildToBack(newVars);
            result.addChildToBack(new NodeYUI(122, body));
            result.addChildToBack(new NodeYUI(3));
        } else {
            result = new NodeYUI(isExpression ? 88 : 128);
            result = NodeTransformer.replaceCurrent(parent, previous, scopeNode, result);
            NodeYUI newVars = new NodeYUI(88);
            NodeYUI v = vars.getFirstChild();
            while (v != null) {
                NodeYUI current = v;
                if (current.getType() == 157) {
                    NodeYUI c = current.getFirstChild();
                    if (c.getType() != 152) {
                        throw Kit.codeBug();
                    }
                    body = isExpression ? new NodeYUI(88, c.getNext(), body) : new NodeYUI(128, new NodeYUI(132, c.getNext()), body);
                    NodeYUI.Scope.joinScopes((NodeYUI.Scope)current, (NodeYUI.Scope)scopeNode);
                    current = c.getFirstChild();
                }
                if (current.getType() != 39) {
                    throw Kit.codeBug();
                }
                NodeYUI stringNode = NodeYUI.newString(current.getString());
                stringNode.setScope((NodeYUI.Scope)scopeNode);
                NodeYUI init = current.getFirstChild();
                if (init == null) {
                    init = new NodeYUI(125, NodeYUI.newNumber(0.0));
                }
                newVars.addChildToBack(new NodeYUI(56, stringNode, init));
                v = v.getNext();
            }
            if (isExpression) {
                result.addChildToBack(newVars);
                scopeNode.setType(88);
                result.addChildToBack(scopeNode);
                scopeNode.addChildToBack(body);
            } else {
                result.addChildToBack(new NodeYUI(132, newVars));
                scopeNode.setType(128);
                result.addChildToBack(scopeNode);
                scopeNode.addChildrenToBack(body);
            }
        }
        return result;
    }

    private static NodeYUI addBeforeCurrent(NodeYUI parent, NodeYUI previous, NodeYUI current, NodeYUI toAdd) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.addChildToFront(toAdd);
        } else {
            if (current != previous.getNext()) {
                Kit.codeBug();
            }
            parent.addChildAfter(toAdd, previous);
        }
        return toAdd;
    }

    private static NodeYUI replaceCurrent(NodeYUI parent, NodeYUI previous, NodeYUI current, NodeYUI replacement) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.replaceChild(current, replacement);
        } else if (previous.next == current) {
            parent.replaceChildAfter(previous, replacement);
        } else {
            parent.replaceChild(current, replacement);
        }
        return replacement;
    }
}

