/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptOrFnNode;

public class NodeYUI {
    public static final int FUNCTION_PROP = 1;
    public static final int LOCAL_PROP = 2;
    public static final int LOCAL_BLOCK_PROP = 3;
    public static final int REGEXP_PROP = 4;
    public static final int CASEARRAY_PROP = 5;
    public static final int TARGETBLOCK_PROP = 6;
    public static final int VARIABLE_PROP = 7;
    public static final int ISNUMBER_PROP = 8;
    public static final int DIRECTCALL_PROP = 9;
    public static final int SPECIALCALL_PROP = 10;
    public static final int SKIP_INDEXES_PROP = 11;
    public static final int OBJECT_IDS_PROP = 12;
    public static final int INCRDECR_PROP = 13;
    public static final int CATCH_SCOPE_PROP = 14;
    public static final int LABEL_ID_PROP = 15;
    public static final int MEMBER_TYPE_PROP = 16;
    public static final int NAME_PROP = 17;
    public static final int CONTROL_BLOCK_PROP = 18;
    public static final int PARENTHESIZED_PROP = 19;
    public static final int GENERATOR_END_PROP = 20;
    public static final int DESTRUCTURING_ARRAY_LENGTH = 21;
    public static final int DESTRUCTURING_NAMES = 22;
    public static final int LAST_PROP = 22;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int NON_SPECIALCALL = 0;
    public static final int SPECIALCALL_EVAL = 1;
    public static final int SPECIALCALL_WITH = 2;
    public static final int DECR_FLAG = 1;
    public static final int POST_FLAG = 2;
    public static final int PROPERTY_FLAG = 1;
    public static final int ATTRIBUTE_FLAG = 2;
    public static final int DESCENDANTS_FLAG = 4;
    static final int END_UNREACHED = 0;
    static final int END_DROPS_OFF = 1;
    static final int END_RETURNS = 2;
    static final int END_RETURNS_VALUE = 4;
    static final int END_YIELDS = 8;
    int type;
    NodeYUI next;
    private NodeYUI first;
    private NodeYUI last;
    protected int lineno = -1;
    private PropListItem propListHead;

    public NodeYUI(int nodeType) {
        this.type = nodeType;
    }

    public NodeYUI(int nodeType, NodeYUI child) {
        this.type = nodeType;
        this.first = this.last = child;
        child.next = null;
    }

    public NodeYUI(int nodeType, NodeYUI left, NodeYUI right) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = right;
        right.next = null;
    }

    public NodeYUI(int nodeType, NodeYUI left, NodeYUI mid, NodeYUI right) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = right;
        right.next = null;
    }

    public NodeYUI(int nodeType, int line) {
        this.type = nodeType;
        this.lineno = line;
    }

    public NodeYUI(int nodeType, NodeYUI child, int line) {
        this(nodeType, child);
        this.lineno = line;
    }

    public NodeYUI(int nodeType, NodeYUI left, NodeYUI right, int line) {
        this(nodeType, left, right);
        this.lineno = line;
    }

    public NodeYUI(int nodeType, NodeYUI left, NodeYUI mid, NodeYUI right, int line) {
        this(nodeType, left, mid, right);
        this.lineno = line;
    }

    public static NodeYUI newNumber(double number) {
        return new NumberNode(number);
    }

    public static NodeYUI newString(String str) {
        return new StringNode(41, str);
    }

    public static NodeYUI newString(int type, String str) {
        return new StringNode(type, str);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    public NodeYUI getFirstChild() {
        return this.first;
    }

    public NodeYUI getLastChild() {
        return this.last;
    }

    public NodeYUI getNext() {
        return this.next;
    }

    public NodeYUI getChildBefore(NodeYUI child) {
        if (child == this.first) {
            return null;
        }
        NodeYUI n = this.first;
        while (n.next != child) {
            n = n.next;
            if (n != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return n;
    }

    public NodeYUI getLastSibling() {
        NodeYUI n = this;
        while (n.next != null) {
            n = n.next;
        }
        return n;
    }

    public void addChildToFront(NodeYUI child) {
        child.next = this.first;
        this.first = child;
        if (this.last == null) {
            this.last = child;
        }
    }

    public void addChildToBack(NodeYUI child) {
        child.next = null;
        if (this.last == null) {
            this.first = this.last = child;
            return;
        }
        this.last.next = child;
        this.last = child;
    }

    public void addChildrenToFront(NodeYUI children) {
        NodeYUI lastSib = children.getLastSibling();
        lastSib.next = this.first;
        this.first = children;
        if (this.last == null) {
            this.last = lastSib;
        }
    }

    public void addChildrenToBack(NodeYUI children) {
        if (this.last != null) {
            this.last.next = children;
        }
        this.last = children.getLastSibling();
        if (this.first == null) {
            this.first = children;
        }
    }

    public void addChildBefore(NodeYUI newChild, NodeYUI node) {
        if (newChild.next != null) {
            throw new RuntimeException("newChild had siblings in addChildBefore");
        }
        if (this.first == node) {
            newChild.next = this.first;
            this.first = newChild;
            return;
        }
        NodeYUI prev = this.getChildBefore(node);
        this.addChildAfter(newChild, prev);
    }

    public void addChildAfter(NodeYUI newChild, NodeYUI node) {
        if (newChild.next != null) {
            throw new RuntimeException("newChild had siblings in addChildAfter");
        }
        newChild.next = node.next;
        node.next = newChild;
        if (this.last == node) {
            this.last = newChild;
        }
    }

    public void removeChild(NodeYUI child) {
        NodeYUI prev = this.getChildBefore(child);
        if (prev == null) {
            this.first = this.first.next;
        } else {
            prev.next = child.next;
        }
        if (child == this.last) {
            this.last = prev;
        }
        child.next = null;
    }

    public void replaceChild(NodeYUI child, NodeYUI newChild) {
        newChild.next = child.next;
        if (child == this.first) {
            this.first = newChild;
        } else {
            NodeYUI prev = this.getChildBefore(child);
            prev.next = newChild;
        }
        if (child == this.last) {
            this.last = newChild;
        }
        child.next = null;
    }

    public void replaceChildAfter(NodeYUI prevChild, NodeYUI newChild) {
        NodeYUI child = prevChild.next;
        newChild.next = child.next;
        prevChild.next = newChild;
        if (child == this.last) {
            this.last = newChild;
        }
        child.next = null;
    }

    private static final String propToString(int propType) {
        return null;
    }

    private PropListItem lookupProperty(int propType) {
        PropListItem x = this.propListHead;
        while (x != null && propType != x.type) {
            x = x.next;
        }
        return x;
    }

    private PropListItem ensureProperty(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            item = new PropListItem();
            item.type = propType;
            item.next = this.propListHead;
            this.propListHead = item;
        }
        return item;
    }

    public void removeProp(int propType) {
        PropListItem x = this.propListHead;
        if (x != null) {
            PropListItem prev = null;
            while (x.type != propType) {
                prev = x;
                x = x.next;
                if (x != null) continue;
                return;
            }
            if (prev == null) {
                this.propListHead = x.next;
            } else {
                prev.next = x.next;
            }
        }
    }

    public Object getProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return null;
        }
        return item.objectValue;
    }

    public int getIntProp(int propType, int defaultValue) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            return defaultValue;
        }
        return item.intValue;
    }

    public int getExistingIntProp(int propType) {
        PropListItem item = this.lookupProperty(propType);
        if (item == null) {
            Kit.codeBug();
        }
        return item.intValue;
    }

    public void putProp(int propType, Object prop) {
        if (prop == null) {
            this.removeProp(propType);
        } else {
            PropListItem item = this.ensureProperty(propType);
            item.objectValue = prop;
        }
    }

    public void putIntProp(int propType, int prop) {
        PropListItem item = this.ensureProperty(propType);
        item.intValue = prop;
    }

    public int getLineno() {
        return this.lineno;
    }

    public final double getDouble() {
        return ((NumberNode)this).number;
    }

    public final void setDouble(double number) {
        ((NumberNode)this).number = number;
    }

    public final String getString() {
        return ((StringNode)this).str;
    }

    public final void setString(String s) {
        if (s == null) {
            Kit.codeBug();
        }
        ((StringNode)this).str = s;
    }

    public final Scope getScope() {
        return ((StringNode)this).scope;
    }

    public final void setScope(Scope s) {
        if (s == null) {
            Kit.codeBug();
        }
        if (!(this instanceof StringNode)) {
            throw Kit.codeBug();
        }
        ((StringNode)this).scope = s;
    }

    public static NodeYUI newTarget() {
        return new NodeYUI(130);
    }

    public final int labelId() {
        if (this.type != 130 && this.type != 72) {
            Kit.codeBug();
        }
        return this.getIntProp(15, -1);
    }

    public void labelId(int labelId) {
        if (this.type != 130 && this.type != 72) {
            Kit.codeBug();
        }
        this.putIntProp(15, labelId);
    }

    public boolean hasConsistentReturnUsage() {
        int n = this.endCheck();
        return (n & 4) == 0 || (n & 0xB) == 0;
    }

    private int endCheckIf() {
        int rv = 0;
        NodeYUI th = this.next;
        NodeYUI el = ((Jump)this).target;
        rv = th.endCheck();
        rv = el != null ? (rv |= el.endCheck()) : (rv |= 1);
        return rv;
    }

    private int endCheckSwitch() {
        int rv = 0;
        NodeYUI n = this.first.next;
        while (n != null) {
            if (n.type != 114) break;
            rv |= ((Jump)n).target.endCheck();
            n = n.next;
        }
        rv &= 0xFFFFFFFE;
        n = ((Jump)this).getDefault();
        rv = n != null ? (rv |= n.endCheck()) : (rv |= 1);
        return rv |= this.getIntProp(18, 0);
    }

    private int endCheckTry() {
        int rv = 0;
        NodeYUI n = ((Jump)this).getFinally();
        rv = n != null ? n.next.first.endCheck() : 1;
        if ((rv & 1) != 0) {
            rv &= 0xFFFFFFFE;
            rv |= this.first.endCheck();
            n = ((Jump)this).target;
            if (n != null) {
                n = n.next.first;
                while (n != null) {
                    rv |= n.next.first.next.first.endCheck();
                    n = n.next.next;
                }
            }
        }
        return rv;
    }

    private int endCheckLoop() {
        int rv = 0;
        NodeYUI n = this.first;
        while (n.next != this.last) {
            n = n.next;
        }
        if (n.type != 6) {
            return 1;
        }
        rv = ((Jump)n).target.next.endCheck();
        if (n.first.type == 45) {
            rv &= 0xFFFFFFFE;
        }
        return rv |= this.getIntProp(18, 0);
    }

    private int endCheckBlock() {
        int rv = 1;
        NodeYUI n = this.first;
        while (rv & true && n != null) {
            rv &= 0xFFFFFFFE;
            rv |= n.endCheck();
            n = n.next;
        }
        return rv;
    }

    private int endCheckLabel() {
        int rv = 0;
        rv = this.next.endCheck();
        return rv |= this.getIntProp(18, 0);
    }

    private int endCheckBreak() {
        Jump n = ((Jump)this).jumpNode;
        n.putIntProp(18, 1);
        return 0;
    }

    private int endCheck() {
        switch (this.type) {
            case 119: {
                return this.endCheckBreak();
            }
            case 132: {
                if (this.first != null) {
                    return this.first.endCheck();
                }
                return 1;
            }
            case 72: {
                return 8;
            }
            case 50: 
            case 120: {
                return 0;
            }
            case 4: {
                if (this.first != null) {
                    return 4;
                }
                return 2;
            }
            case 130: {
                if (this.next != null) {
                    return this.next.endCheck();
                }
                return 1;
            }
            case 131: {
                return this.endCheckLoop();
            }
            case 128: 
            case 140: {
                if (this.first == null) {
                    return 1;
                }
                switch (this.first.type) {
                    case 129: {
                        return this.first.endCheckLabel();
                    }
                    case 7: {
                        return this.first.endCheckIf();
                    }
                    case 113: {
                        return this.first.endCheckSwitch();
                    }
                    case 80: {
                        return this.first.endCheckTry();
                    }
                }
                return this.endCheckBlock();
            }
        }
        return 1;
    }

    public boolean hasSideEffects() {
        switch (this.type) {
            case 88: 
            case 132: {
                if (this.last != null) {
                    return this.last.hasSideEffects();
                }
                return true;
            }
            case 101: {
                if (this.first == null || this.first.next == null || this.first.next.next == null) {
                    Kit.codeBug();
                }
                return this.first.next.hasSideEffects() && this.first.next.next.hasSideEffects();
            }
            case 103: 
            case 104: {
                if (this.first == null || this.last == null) {
                    Kit.codeBug();
                }
                return this.first.hasSideEffects() || this.last.hasSideEffects();
            }
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 30: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 80: 
            case 81: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 152: 
            case 153: 
            case 157: 
            case 158: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.type);
    }

    private void toString(ObjToIntMap printIds, StringBuffer sb) {
    }

    public String toStringTree(ScriptOrFnNode treeTop) {
        return null;
    }

    private static void toStringTreeHelper(ScriptOrFnNode treeTop, NodeYUI n, ObjToIntMap printIds, int level, StringBuffer sb) {
    }

    private static void generatePrintIds(NodeYUI n, ObjToIntMap map) {
    }

    private static void appendPrintId(NodeYUI n, ObjToIntMap printIds, StringBuffer sb) {
    }

    public static class Jump
    extends NodeYUI {
        public NodeYUI target;
        private NodeYUI target2;
        private Jump jumpNode;

        public Jump(int type) {
            super(type);
        }

        Jump(int type, int lineno) {
            super(type, lineno);
        }

        Jump(int type, NodeYUI child) {
            super(type, child);
        }

        Jump(int type, NodeYUI child, int lineno) {
            super(type, child, lineno);
        }

        public final Jump getJumpStatement() {
            if (this.type != 119 && this.type != 120) {
                Kit.codeBug();
            }
            return this.jumpNode;
        }

        public final void setJumpStatement(Jump jumpStatement) {
            if (this.type != 119 && this.type != 120) {
                Kit.codeBug();
            }
            if (jumpStatement == null) {
                Kit.codeBug();
            }
            if (this.jumpNode != null) {
                Kit.codeBug();
            }
            this.jumpNode = jumpStatement;
        }

        public final NodeYUI getDefault() {
            if (this.type != 113) {
                Kit.codeBug();
            }
            return this.target2;
        }

        public final void setDefault(NodeYUI defaultTarget) {
            if (this.type != 113) {
                Kit.codeBug();
            }
            if (defaultTarget.type != 130) {
                Kit.codeBug();
            }
            if (this.target2 != null) {
                Kit.codeBug();
            }
            this.target2 = defaultTarget;
        }

        public final NodeYUI getFinally() {
            if (this.type != 80) {
                Kit.codeBug();
            }
            return this.target2;
        }

        public final void setFinally(NodeYUI finallyTarget) {
            if (this.type != 80) {
                Kit.codeBug();
            }
            if (finallyTarget.type != 130) {
                Kit.codeBug();
            }
            if (this.target2 != null) {
                Kit.codeBug();
            }
            this.target2 = finallyTarget;
        }

        public final Jump getLoop() {
            if (this.type != 129) {
                Kit.codeBug();
            }
            return this.jumpNode;
        }

        public final void setLoop(Jump loop) {
            if (this.type != 129) {
                Kit.codeBug();
            }
            if (loop == null) {
                Kit.codeBug();
            }
            if (this.jumpNode != null) {
                Kit.codeBug();
            }
            this.jumpNode = loop;
        }

        public final NodeYUI getContinue() {
            if (this.type != 131) {
                Kit.codeBug();
            }
            return this.target2;
        }

        public final void setContinue(NodeYUI continueTarget) {
            if (this.type != 131) {
                Kit.codeBug();
            }
            if (continueTarget.type != 130) {
                Kit.codeBug();
            }
            if (this.target2 != null) {
                Kit.codeBug();
            }
            this.target2 = continueTarget;
        }
    }

    private static class NumberNode
    extends NodeYUI {
        double number;

        NumberNode(double number) {
            super(40);
            this.number = number;
        }
    }

    private static class PropListItem {
        PropListItem next;
        int type;
        int intValue;
        Object objectValue;

        private PropListItem() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Scope
    extends Jump {
        protected LinkedHashMap<String, Symbol> symbolTable;
        private Scope parent;
        private ScriptOrFnNode top;

        public Scope(int nodeType) {
            super(nodeType);
        }

        public Scope(int nodeType, int lineno) {
            super(nodeType, lineno);
        }

        public Scope(int nodeType, NodeYUI n, int lineno) {
            super(nodeType, n, lineno);
        }

        public static Scope splitScope(Scope scope) {
            Scope result = new Scope(scope.getType());
            result.symbolTable = scope.symbolTable;
            scope.symbolTable = null;
            result.parent = scope.parent;
            scope.parent = result;
            result.top = scope.top;
            return result;
        }

        public static void joinScopes(Scope source, Scope dest) {
            source.ensureSymbolTable();
            dest.ensureSymbolTable();
            if (!Collections.disjoint((Collection)source.symbolTable.keySet(), (Collection)dest.symbolTable.keySet())) {
                throw Kit.codeBug();
            }
            dest.symbolTable.putAll(source.symbolTable);
        }

        public void setParent(Scope parent) {
            this.parent = parent;
            this.top = parent == null ? (ScriptOrFnNode)this : parent.top;
        }

        public Scope getParentScope() {
            return this.parent;
        }

        public Scope getDefiningScope(String name) {
            Scope sn = this;
            while (sn != null) {
                if (sn.symbolTable != null && sn.symbolTable.containsKey(name)) {
                    return sn;
                }
                sn = sn.parent;
            }
            return null;
        }

        public Symbol getSymbol(String name) {
            return this.symbolTable == null ? null : this.symbolTable.get(name);
        }

        public void putSymbol(String name, Symbol symbol) {
            this.ensureSymbolTable();
            this.symbolTable.put(name, symbol);
            symbol.containingTable = this;
            this.top.addSymbol(symbol);
        }

        public Map<String, Symbol> getSymbolTable() {
            return this.symbolTable;
        }

        private void ensureSymbolTable() {
            if (this.symbolTable == null) {
                this.symbolTable = new LinkedHashMap(5);
            }
        }
    }

    private static class StringNode
    extends NodeYUI {
        String str;
        Scope scope;

        StringNode(int type, String str) {
            super(type);
            this.str = str;
        }
    }

    static class Symbol {
        int declType;
        int index;
        String name;
        Scope containingTable;

        Symbol(int declType, String name) {
            this.declType = declType;
            this.name = name;
            this.index = -1;
        }
    }
}

