/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleListDeserializer
extends SimpleDeserializer {
    StringBuffer val = new StringBuffer();
    private Constructor constructor = null;
    private Map propertyMap = null;
    private HashMap attributeMap = null;
    private DeserializationContext context = null;
    public QName xmlType;
    public Class javaType;
    private TypeDesc typeDesc = null;
    protected SimpleListDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public SimpleListDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public SimpleListDeserializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        super(javaType, xmlType, typeDesc);
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
    }

    public void reset() {
        this.val.setLength(0);
        this.attributeMap = null;
        this.isNil = false;
        this.isEnded = false;
    }

    public void setConstructor(Constructor c) {
        this.constructor = c;
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        throw new SAXException(Messages.getMessage("cantHandle00", "SimpleDeserializer"));
    }

    public void characters(char[] chars, int start, int end) throws SAXException {
        this.val.append(chars, start, end);
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.isNil || this.val == null) {
            this.value = null;
            return;
        }
        try {
            this.value = this.makeValue(this.val.toString());
        }
        catch (InvocationTargetException ite) {
            Throwable realException = ite.getTargetException();
            if (realException instanceof Exception) {
                throw new SAXException((Exception)realException);
            }
            throw new SAXException(ite.getMessage());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this.setSimpleTypeAttributes();
    }

    public Object makeValue(String source) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(source.trim());
        int length = tokenizer.countTokens();
        Object list = Array.newInstance(this.javaType, length);
        int i = 0;
        while (i < length) {
            String token = tokenizer.nextToken();
            Array.set(list, i, this.makeUnitValue(token));
            ++i;
        }
        return list;
    }

    private Object makeUnitValue(String source) throws Exception {
        Class<?> clazz;
        block41: {
            block40: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                if (this.javaType == Boolean.TYPE) break block36;
                                Class<?> clazz2 = class$1;
                                if (clazz2 == null) {
                                    try {
                                        clazz2 = class$1 = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (this.javaType != clazz2) break block37;
                            }
                            switch (source.charAt(0)) {
                                case '0': 
                                case 'F': 
                                case 'f': {
                                    return Boolean.FALSE;
                                }
                                case '1': 
                                case 'T': 
                                case 't': {
                                    return Boolean.TRUE;
                                }
                            }
                            throw new NumberFormatException(Messages.getMessage("badBool00"));
                        }
                        if (this.javaType == Float.TYPE) break block38;
                        Class<?> clazz3 = class$3;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$3 = Class.forName("java.lang.Float");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (this.javaType != clazz3) break block39;
                    }
                    if (source.equals("NaN")) {
                        return new Float(Float.NaN);
                    }
                    if (source.equals("INF")) {
                        return new Float(Float.POSITIVE_INFINITY);
                    }
                    if (source.equals("-INF")) {
                        return new Float(Float.NEGATIVE_INFINITY);
                    }
                }
                if (this.javaType == Double.TYPE) break block40;
                Class<?> clazz4 = class$5;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$5 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.javaType != clazz4) break block41;
            }
            if (source.equals("NaN")) {
                return new Double(Double.NaN);
            }
            if (source.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (source.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        if ((clazz = class$6) == null) {
            try {
                clazz = class$6 = Class.forName("javax.xml.namespace.QName");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.javaType == clazz) {
            int colon = source.lastIndexOf(":");
            String namespace = colon < 0 ? "" : this.context.getNamespaceURI(source.substring(0, colon));
            String localPart = colon < 0 ? source : source.substring(colon + 1);
            return new QName(namespace, localPart);
        }
        return this.constructor.newInstance(source);
    }

    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        this.context = context;
        if (this.typeDesc == null) {
            return;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            BeanPropertyDescriptor bpd;
            QName attrQName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String fieldName = this.typeDesc.getFieldNameForAttribute(attrQName);
            if (fieldName != null && (bpd = (BeanPropertyDescriptor)this.propertyMap.get(fieldName)) != null && bpd.isWriteable() && !bpd.isIndexed()) {
                Class type;
                TypeMapping tm = context.getTypeMapping();
                QName qn = tm.getTypeQName(type = bpd.getType());
                if (qn == null) {
                    throw new SAXException(Messages.getMessage("unregistered00", type.toString()));
                }
                Deserializer dSer = context.getDeserializerForType(qn);
                if (dSer == null) {
                    throw new SAXException(Messages.getMessage("noDeser00", type.toString()));
                }
                if (!(dSer instanceof SimpleListDeserializer)) {
                    throw new SAXException(Messages.getMessage("AttrNotSimpleType00", bpd.getName(), type.toString()));
                }
                if (this.attributeMap == null) {
                    this.attributeMap = new HashMap();
                }
                try {
                    Object val = ((SimpleListDeserializer)dSer).makeValue(attributes.getValue(i));
                    this.attributeMap.put(fieldName, val);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            ++i;
        }
    }

    private void setSimpleTypeAttributes() throws SAXException {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.apache.axis.encoding.SimpleType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(this.javaType) || this.attributeMap == null) {
            return;
        }
        Set entries = this.attributeMap.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object val = entry.getValue();
            BeanPropertyDescriptor bpd = (BeanPropertyDescriptor)this.propertyMap.get(name);
            if (!bpd.isWriteable() || bpd.isIndexed()) continue;
            try {
                bpd.set(this.value, val);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }
}

