<Data version="20170616">
	<Sources>
		<BizMetaSource name="s1624500707427" bizMetaType="EASEntity" dataCenterId="SP1UPD861" type="BizMeta" />
		<BizMetaSource name="s1624604807537" bizMetaType="EASQuery" dataCenterId="SP1UPD861" type="BizMeta" />
		<BizMetaSource name="s1630579720874" bizMetaType="EASDBCenter" dbCenterId="ORANEW0824" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1630579740855" sqlType="KSQL"><![CDATA[SELECT 

"CREDITLIMIT".FID AS "ID", 
"CREDITLIMIT".FIsBankCredit AS "ISBANKCREDIT", 
"CREDITLIMIT".FRegion AS "REGION", 
"CREDITLIMIT".FProperty AS "PROPERTY", 
"CREDITLIMIT".FQuotaAmount AS "QUOTAAMOUNT", 
"CREDITLIMIT".FUsedAmount AS "USEDAMOUNT", 
"CREDITLIMIT".FBalance AS "BALANCE", 
"CREDITLIMIT".FExchangeRate AS "EXCHANGERATE", 
"CREDITLIMIT".FIssueDate AS "ISSUEDATE", 
"CREDITLIMIT".FExpiredDate AS "EXPIREDDATE", 
"CREDITLIMIT".FCreditHorizon AS "CREDITHORIZON", 
"CREDITLIMIT".FShareType AS "SHARETYPE", 
"CREDITLIMIT".FIsClosed AS "ISCLOSED", 
"CREDITLIMIT".FNumber AS "NUMBER", 
"CREDITLIMIT".FBizDate AS "BIZDATE", 
"CREDITLIMIT".FDescription AS "DESCRIPTION", 
"COMPANY".FName_l2 AS "COMPANY.NAME", 
"CREDITLIMIT".FRemark AS "REMARK", 
"CREDITLIMIT".FCreditLimitStat AS "CREDITLIMITSTAT", 
ISNULL("CREDITINSTITUTION".FName_l2, "CREDITCOMPANY".FName_l2) AS "CREDITINSTITUTION.NAME", 
"CREDITLIMIT".FCurrencyID AS "CURRENCY.ID", 
"CREDITLIMIT".FCreditInstitutionId AS "CREDITINSTITUTION.ID", 
"CREDITINSTITUTION".FNumber AS "CREDITINSTITUTION.NUMBER", 
"CREDITLIMIT".FCreditUsageID AS "CREDITUSAGE.ID", 
"CURRENCY".FName_l2 AS "CURRENCY.NAME", 
"CREDITLIMIT".FIsPromises AS "ISPROMISES", 
0 AS "NEWSTATE", 
"CREDITLIMIT".FIsUnion AS "ISUNION", 
"CREDITLIMIT".FGuaranteeTypeInputMode AS "GUARANTEETYPEINPUTMODE", 
"GUARANTEETYPE".FName_l2 AS "GUARANTEETYPE.NAME", 
"CREDITLIMIT".FGuaranteeTypeID AS "GUARANTEETYPE.ID", 
"PROJECT".FName_l2 AS "PROJECT.NAME", 
"CREDITLIMIT".FProjectID AS "PROJECT.ID", 
"CREDITCOMPANY".FName_l2 AS "CREDITCOMPANY.NAME", 
"CREDITLIMIT".FcreditCompanyID AS "CREDITCOMPANY.ID", 
"CREDITUSAGE".FName_l2 AS "CREDITUSAGE.NAME", 
"CREDITLIMIT".FDeferDay AS "DEFERDAY", 
"CREDITLIMIT".FCreditCloseDate AS "CREDITCLOSEDATE", 
"CREDITLIMIT".FIsGroupCredit AS "ISGROUPCREDIT", 
"CREDITLIMIT".FBillStatus AS "BILLSTATUS", 
"CREDITLIMIT".FSupplier AS "SUPPLIER.ID", 
"SUPPLIER".FName_l2 AS "SUPPLIER.NAME"

FROM T_FIN_CreditLimit AS "CREDITLIMIT"

LEFT OUTER JOIN T_BD_Currency AS "CURRENCY"
ON "CREDITLIMIT".FCurrencyID = "CURRENCY".FID

LEFT OUTER JOIN T_FIN_CreditUsage AS "CREDITUSAGE"
ON "CREDITLIMIT".FCreditUsageID = "CREDITUSAGE".FID

LEFT OUTER JOIN T_BD_Bank AS "CREDITINSTITUTION"
ON "CREDITLIMIT".FCreditInstitutionId = "CREDITINSTITUTION".FID

LEFT OUTER JOIN T_ORG_Company AS "COMPANY"
ON "CREDITLIMIT".FCompanyID = "COMPANY".FID

LEFT OUTER JOIN T_BD_Project AS "PROJECT"
ON "CREDITLIMIT".FProjectID = "PROJECT".FID

LEFT OUTER JOIN T_FIN_GuaranteeType AS "GUARANTEETYPE"
ON "CREDITLIMIT".FGuaranteeTypeID = "GUARANTEETYPE".FID

LEFT OUTER JOIN T_ORG_Company AS "CREDITCOMPANY"
ON "CREDITLIMIT".FcreditCompanyID = "CREDITCOMPANY".FID

LEFT OUTER JOIN T_BD_Supplier AS "SUPPLIER"
ON "CREDITLIMIT".FSupplier = "SUPPLIER".FID]]></UserSQL>
				<UserSQL name="dm1630580281743" sqlType="KSQL"><![CDATA[SELECT 

"LOAN".FAmount AS "AMOUNT", 
"LOAN".FBalance AS "BALANCE", 
"LOAN".FLocalCurExRate AS "LOCALCUREXRATE", 
"LOAN".FUsedQuota AS "USEDQUOTA", 
"LOAN".FIssueDate AS "ISSUEDATE", 
"LOAN".FExpiredDate AS "EXPIREDDATE", 
"LOAN".FHorizon AS "HORIZON", 
"LOAN".FRemark AS "REMARK", 
"LOAN".FGarantee AS "GARANTEE", 
"LOAN".FAmountLocalCur AS "AMOUNTLOCALCUR", 
"LOAN".FNumber AS "NUMBER", 
"LOAN".FBizDate AS "BIZDATE", 
"LOAN".FID AS "ID", 
"CURRENCY".FName_l2 AS "CURRENCY.NAME", 
"TYPE".FName_l2 AS "TYPE.NAME", 
"SOURCE".FName_l2 AS "SOURCE.NAME", 
"COMPANY".FName_l2 AS "COMPANY.NAME", 
"LOAN".FIsBankLoan AS "ISBANKLOAN", 
"CREDITORGROUP".FName_l2 AS "CREDITORGROUP.NAME", 
"BANKACCT".FBankAccountNumber AS "BANKACCT.BANKACCOUNTNUMBER", 
"LOANACCT".FName_l2 AS "LOANACCT.NAME", 
"LOAN".FYieldRate AS "YIELDRATE", 
"LOAN".FRepaymentType AS "REPAYMENTTYPE", 
ISNULL("INTRATETYPE".FName_l2, '协议利率') AS "INTRATETYPE.NAME", 
ISNULL("INSTITUTION".FName_l2, "GROUPID".FName_l2) AS "INSTITUTION.NAME", 
"CURRENCY".FID AS "CURRENCY.ID", 
"TYPE".FNumber AS "TYPE.NUMBER", 
"TYPE".FID AS "TYPE.ID", 
"SOURCE".FNumber AS "SOURCE.NUMBER", 
"SOURCE".FID AS "SOURCE.ID", 
"INSTITUTION".FNumber AS "INSTITUTION.NUMBER", 
"INSTITUTION".FID AS "INSTITUTION.ID", 
"INTRATETYPE".FNumber AS "INTRATETYPE.NUMBER", 
"LOAN".FIntRateTypeID AS "INTRATETYPE.ID", 
"LOANACCT".FNumber AS "LOANACCT.NUMBER", 
"LOAN".FLoanAcctID AS "LOANACCT.ID", 
"BANKACCT".FName_l2 AS "BANKACCT.NAME", 
"BANKACCT".FNumber AS "BANKACCT.NUMBER", 
"LOAN".FBankAcctID AS "BANKACCT.ID", 
"LOAN".FDescription AS "DESCRIPTION", 
"LOAN".FIsInCredit AS "ISINCREDIT", 
"CREDITLIMIT".FNumber AS "CREDITLIMIT.NUMBER", 
"LOAN".FCreditLimitId AS "CREDITLIMIT.ID", 
"LOAN".FApplicationRule AS "APPLICATIONRULE", 
"LOAN".FBasePoints AS "BASEPOINTS", 
"GROUPID".FName_l2 AS "GROUPID.NAME", 
"LOAN".FIsGroupLoan AS "ISGROUPLOAN", 
"ACCOUNTANT".FName_l2 AS "ACCOUNTANT.NAME", 
"LOAN".FAccountantID AS "ACCOUNTANT.ID", 
"LOAN".FHistoryBill AS "HISTORYBILL", 
"LOAN".FPenAccrualType AS "PENACCRUALTYPE", 
"LOAN".FPenAccrualRate AS "PENACCRUALRATE", 
"LOAN".FIsOverdue AS "ISOVERDUE", 
"LOAN".FIntRateTypeExpression AS "INTRATETYPEEXPRESSION", 
"LOAN".FYearDays AS "YEARDAYS", 
"CREATOR".FName_l2 AS "CREATOR.NAME", 
"LOAN".FContractNum AS "CONTRACTNUM", 
"LOAN".FIsMulCon AS "ISMULCON", 
"LOAN".FSeqMulCon AS "SEQMULCON", 
"PROJECT".FName_l2 AS "PROJECT.NAME", 
"GARANTEETYPE".FName_l2 AS "GARANTEETYPE.NAME", 
"PAYINTMODE".FName_l2 AS "PAYINTMODE.NAME", 
"LOAN".FFloatAction AS "FLOATACTION", 
"LOAN".FRateAdjustPeriod AS "RATEADJUSTPERIOD", 
"LOAN".FFirstRateAdjustDate AS "FIRSTRATEADJUSTDATE", 
"LOAN".FStatus AS "STATUS", 
"LOAN".FHandlerRemark AS "HANDLERREMARK", 
"LOAN".FEntLoanID AS "ENTLOANID.ID", 
"CASHIER".FNumber AS "CASHIER.NUMBER", 
"CASHIER".FName_l2 AS "CASHIER.NAME", 
"LOAN".FCashierID AS "CASHIER.ID", 
"LOAN".FCreditLocalAmt AS "CREDITLOCALAMT", 
"LOAN".FCautionAmt AS "CAUTIONAMT", 
"INTFEEACCTVIEW".FName_l2 AS "INTFEEACCTVIEW.NAME", 
"CAUTIONACCTBANK".FName_l2 AS "CAUTIONACCTBANK.NAME", 
"LOAN".FAuctionPerc AS "AUCTIONPERC", 
"LOAN".FIntFeeAcctViewID AS "INTFEEACCTVIEW.ID", 
"LOAN".FCautionAcctBankID AS "CAUTIONACCTBANK.ID", 
"VOUCHERTYPE".FName_l2 AS "VOUCHERTYPE.NAME", 
"LOAN".FVoucherTypeID AS "VOUCHERTYPE.ID", 
"LOAN".FVoucherNumber AS "VOUCHERNUMBER", 
"LOAN".FFiVouchered AS "FIVOUCHERED", 
"LOAN".FIsGenRecBill AS "ISGENRECBILL", 
"LOAN".FCreditCurExRate AS "CREDITCUREXRATE", 
"CREDITCURRENCY".FName_l2 AS "CREDITCURRENCY.NAME", 
"LOAN".FCreditCurrencyID AS "CREDITCURRENCY.ID", 
"LOAN".FRepaymentSource AS "REPAYMENTSOURCE", 
"LOAN".FOutBgItemId AS "OUTBGITEMID", 
"LOAN".FOutBgItemName AS "OUTBGITEMNAME", 
"LOAN".FOutBgItemNumber AS "OUTBGITEMNUMBER", 
"FPITEM".FName_l2 AS "FPITEM.NAME", 
"DEPOSITARY".FName_l2 AS "DEPOSITARY.NAME", 
"COSTCENTER".FName_l2 AS "COSTCENTER.NAME", 
"SETTLEMENTACCT".FName_l2 AS "SETTLEMENTACCT.NAME", 
"SETTLEMENTACCT".FNumber AS "SETTLEMENTACCT.NUMBER", 
"LOAN".FSettlementAcctID AS "SETTLEMENTACCT.ID", 
"AUDITOR".FName_l2 AS "AUDITOR.NAME", 
"LOAN".FLastIntDate AS "LASTINTDATE", 
"COMPANY".FID AS "COMPANY.ID", 
"FUNDFLOWITEM".FName_l2 AS "FUNDFLOWITEM.NAME", 
"FUNDFLOWITEM".FNumber AS "FUNDFLOWITEM.NUMBER", 
"LOAN".FFundFlowItemID AS "FUNDFLOWITEM.ID"

FROM T_FIN_Loan AS "LOAN"

LEFT OUTER JOIN T_FIN_CreditLimit AS "CREDITLIMIT"
ON "LOAN".FCreditLimitId = "CREDITLIMIT".FID

INNER JOIN T_BD_Currency AS "CURRENCY"
ON "LOAN".FCurrencyID = "CURRENCY".FID

INNER JOIN T_FIN_FinancingProducts AS "TYPE"
ON "LOAN".FTypeID = "TYPE".FID

INNER JOIN T_FIN_FinancingSources AS "SOURCE"
ON "LOAN".FSourceID = "SOURCE".FID

INNER JOIN T_ORG_Company AS "COMPANY"
ON "LOAN".FCompanyID = "COMPANY".FID

INNER JOIN T_FIN_CreditorGroup AS "CREDITORGROUP"
ON "LOAN".FCreditorGroupID = "CREDITORGROUP".FID

LEFT OUTER JOIN T_BD_AccountBanks AS "BANKACCT"
ON "LOAN".FBankAcctID = "BANKACCT".FID

LEFT OUTER JOIN T_BD_AccountView AS "LOANACCT"
ON "LOAN".FLoanAcctID = "LOANACCT".FID

LEFT OUTER JOIN T_INT_IntRateType AS "INTRATETYPE"
ON "LOAN".FIntRateTypeID = "INTRATETYPE".FID

LEFT OUTER JOIN T_BD_Bank AS "INSTITUTION"
ON "INSTITUTION".FID = "LOAN".FInstitutionId

LEFT OUTER JOIN T_ORG_Company AS "GROUPID"
ON "LOAN".FGroupId = "GROUPID".FID

LEFT OUTER JOIN T_PM_User AS "ACCOUNTANT"
ON "LOAN".FAccountantID = "ACCOUNTANT".FID

INNER JOIN T_PM_User AS "CREATOR"
ON "LOAN".FCreatorID = "CREATOR".FID

LEFT OUTER JOIN T_BD_Project AS "PROJECT"
ON "LOAN".FProjectID = "PROJECT".FID

LEFT OUTER JOIN T_FIN_GuaranteeType AS "GARANTEETYPE"
ON "LOAN".FGaranteeTypeID = "GARANTEETYPE".FID

LEFT OUTER JOIN T_INT_IntScheme AS "PAYINTMODE"
ON "LOAN".FPayIntModeID = "PAYINTMODE".FID

LEFT OUTER JOIN T_IVT_ChLoan AS "ENTLOANID"
ON "LOAN".FEntLoanID = "ENTLOANID".FID

LEFT OUTER JOIN T_PM_User AS "CASHIER"
ON "LOAN".FCashierID = "CASHIER".FID

LEFT OUTER JOIN T_BD_AccountView AS "INTFEEACCTVIEW"
ON "LOAN".FIntFeeAcctViewID = "INTFEEACCTVIEW".FID

LEFT OUTER JOIN T_BD_AccountBanks AS "CAUTIONACCTBANK"
ON "LOAN".FCautionAcctBankID = "CAUTIONACCTBANK".FID

LEFT OUTER JOIN T_BD_VoucherTypes AS "VOUCHERTYPE"
ON "LOAN".FVoucherTypeID = "VOUCHERTYPE".FID

LEFT OUTER JOIN T_BD_Currency AS "CREDITCURRENCY"
ON "LOAN".FCreditCurrencyID = "CREDITCURRENCY".FID

LEFT OUTER JOIN T_FPL_FpItem AS "FPITEM"
ON "LOAN".FFpItemID = "FPITEM".FID

LEFT OUTER JOIN T_BD_Bank AS "DEPOSITARY"
ON "LOAN".FDepositaryID = "DEPOSITARY".FID

LEFT OUTER JOIN T_ORG_CostCenter AS "COSTCENTER"
ON "LOAN".FCostCenterID = "COSTCENTER".FID

LEFT OUTER JOIN T_BD_AccountView AS "SETTLEMENTACCT"
ON "LOAN".FSettlementAcctID = "SETTLEMENTACCT".FID

LEFT OUTER JOIN T_PM_User AS "AUDITOR"
ON "LOAN".FAuditorID = "AUDITOR".FID

LEFT OUTER JOIN T_CAS_FundFlowItem AS "FUNDFLOWITEM"
ON "LOAN".FFundFlowItemID = "FUNDFLOWITEM".FID]]></UserSQL>
				<UserSQL name="dm1630982140899" sqlType="KSQL"><![CDATA[SELECT 

"PAYABLEBILL".FCompanyID AS "COMPANY.ID", 
"COMPANY".FName_l2 AS "COMPANY.NAME", 
"PAYABLEBILL".FApplyUnitId AS "APPLYUNIT.ID", 
"APPLYUNIT".FName_l2 AS "APPLYUNIT.NAME", 
"PAYABLEBILL".FBillState AS "BILLSTATE", 
"PAYABLEBILL".FReturnOption AS "RETURNOPTION", 
"PAYABLEBILL".FMakeType AS "MAKETYPE", 
"PAYABLEBILL".FHistoryBill AS "HISTORYBILL", 
"PAYABLEBILL".FIssueDate AS "ISSUEDATE", 
"PAYABLEBILL".FAcceptDate AS "ACCEPTDATE", 
"PAYABLEBILL".FExpiredDate AS "EXPIREDDATE", 
ISNULL("BILLMAKER".FName_l2, "PAYABLEBILL".FBillMakerName) AS "BILLMAKERNAME", 
"PAYABLEBILL".FOutBankAccountName AS "OUTBANKACCOUNTNAME", 
"PAYABLEBILL".FInstitutionId AS "INSTITUTION.ID", 
"INSTITUTION".FName_l2 AS "INSTITUTION.NAME", 
"PAYABLEBILL".FPayeeName AS "PAYEENAME", 
"PAYABLEBILL".FPayeeAccountName AS "PAYEEACCOUNTNAME", 
"PAYABLEBILL".FPayeeBankName AS "PAYEEBANKNAME", 
"PAYABLEBILL".FCurrencyID AS "CURRENCY.ID", 
"CURRENCY".FName_l2 AS "CURRENCY.NAME", 
"PAYABLEBILL".FAmount AS "AMOUNT", 
"PAYABLEBILL".FAmountLocalCur AS "AMOUNTLOCALCUR", 
"PAYABLEBILL".FLocalCurExRate AS "LOCALCUREXRATE", 
"PAYABLEBILL".FAssureProportion AS "ASSUREPROPORTION", 
"PAYABLEBILL".FAssureAmount AS "ASSUREAMOUNT", 
"PAYABLEBILL".FBalance AS "BALANCE", 
"PAYABLEBILL".FContractNumber AS "CONTRACTNUMBER", 
"PAYABLEBILL".FHorizon AS "HORIZON", 
"PAYABLEBILL".FOppAccountID AS "OPPACCOUNT.ID", 
"OPPACCOUNT".FName_l2 AS "OPPACCOUNT.NAME", 
"GARANTEETYPE".FName_l2 AS "GARANTEETYPE.NAME", 
"PAYABLEBILL".FGuaranteeTypeInputMode AS "GUARANTEETYPEINPUTMODE", 
"PAYABLEBILL".FBlockFlowTypeID AS "BLOCKFLOWTYPE.ID", 
"BLOCKFLOWTYPE".FName_l2 AS "BLOCKFLOWTYPE.NAME", 
"PAYABLEBILL".FAdminOrgUnitID AS "ADMINORGUNIT.ID", 
"ADMINORGUNIT".FName_l2 AS "ADMINORGUNIT.NAME", 
"PAYABLEBILL".FPersonID AS "PERSON.ID", 
"PERSON".FName_l2 AS "PERSON.NAME", 
"PAYABLEBILL".FRemark AS "REMARK", 
"PAYABLEBILL".FIssueUnit AS "ISSUEUNIT", 
"PAYABLEBILL".FDigest AS "DIGEST", 
"PAYABLEBILL".FBuyerPayDisCnt AS "BUYERPAYDISCNT", 
"PAYABLEBILL".FDiscountDate AS "DISCOUNTDATE", 
"PAYABLEBILL".FDiscountRate AS "DISCOUNTRATE", 
"PAYABLEBILL".FDiscount AS "DISCOUNT", 
"PAYABLEBILL".FIsInCredit AS "ISINCREDIT", 
"PAYABLEBILL".FCreditLimitId AS "CREDITLIMIT.ID", 
"PAYABLEBILL".FCreditCurExRate AS "CREDITCUREXRATE", 
"PAYABLEBILL".FBizDate AS "BIZDATE", 
"PAYABLEBILL".FFiVouchered AS "FIVOUCHERED", 
"PAYABLEBILL".FCreatorID AS "CREATOR.ID", 
"CREATOR".FName_l2 AS "CREATOR.NAME", 
"PAYABLEBILL".FCreateTime AS "CREATETIME", 
"PAYABLEBILL".FTransferDate AS "TRANSFERDATE", 
"PAYABLEBILL".FUsedQuota AS "USEDQUOTA", 
"PAYABLEBILL".FRegion AS "REGION", 
"PAYABLEBILL".FNumber AS "NUMBER", 
"PAYABLEBILL".FID AS "ID", 
"CREDITLIMIT".FNumber AS "CREDITLIMIT.NUMBER", 
"PAYABLEBILL".FGarantee AS "GARANTEE", 
"SOURCE".FName_l2 AS "SOURCE.NAME", 
"CURRENCY".FNumber AS "CURRENCY.NUMBER", 
"SOURCE".FNumber AS "SOURCE.NUMBER", 
"PAYABLEBILL".FSourceID AS "SOURCE.ID", 
"BLOCKFLOWTYPE".FNumber AS "BLOCKFLOWTYPE.NUMBER", 
"INSTITUTION".FNumber AS "INSTITUTION.NUMBER", 
"CONFIRMER".FName_l2 AS "CONFIRMER.NAME", 
"PAYABLEBILL".FAssureProportion AS "PAYABLEBILL.PROPORTION", 
"PAYABLEBILL".FOriAssureAmount AS "ORIASSUREAMOUNT", 
"PAYABLEBILL".FAssureAmount AS "PAYABLEBILL.ASSUREAMOUNT", 
"PAYABLEBILL".FHistoryBill AS "PAYABLEBILL.HISTORYBILL", 
"BILLACCOUNT".FName_l2 AS "BILLACCOUNT.NAME", 
"PAYABLEBILL".FBillAccountID AS "BILLACCOUNT.ID", 
"PAYABLEBILL".FConfirmerID AS "CONFIRMER.ID", 
"AUDITOR".FName_l2 AS "AUDITOR.NAME", 
"PAYABLEBILL".FIsTDPrinted AS "ISTDPRINTED", 
"OUTBANKACCOUNT".FBankAccountNumber AS "OUTBANKACCOUNT.BANKACCOUNTNU76", 
"OUTBANKACCOUNT".FName_l2 AS "OUTBANKACCOUNT.NAME", 
"NTTYPE".FName_l2 AS "NTTYPE.NAME", 
"PAYABLEBILL".FNtTypeID AS "NTTYPE.ID", 
"PAYMENTBILL".FNumber AS "PAYMENTBILL.NUMBER", 
"PAYABLEBILL".FIsApply AS "ISAPPLY", 
"PAYABLEBILL".FApplyDate AS "APPLYDATE", 
"PAYABLEBILL".FPersonName AS "PERSONNAME", 
"PAYABLEBILL".FApplyInfo AS "APPLYINFO", 
"PAYABLEBILL".FIsAccept AS "ISACCEPT", 
"ACCOUNTANT".FName_l2 AS "ACCOUNTANT.NAME", 
"PAYABLEBILL".FOutBgItemId AS "OUTBGITEMID", 
"PAYABLEBILL".FOutBgItemName AS "OUTBGITEMNAME", 
"PAYABLEBILL".FOutBgItemNumber AS "OUTBGITEMNUMBER", 
"FUNDFLOWITEM".FName_l2 AS "FUNDFLOWITEM.NAME", 
"PROJECT".FNumber AS "PROJECT.NUMBER", 
"PROJECT".FName_l2 AS "PROJECT.NAME", 
"PAYABLEBILL".FBatchNo AS "BATCHNO", 
"PAYABLEBILL".FCostCenterID AS "COSTCENTER.ID", 
"COSTCENTER".FName_l2 AS "COSTCENTER.NAME", 
"PAYABLEBILL".FIsAcceptSubmit AS "ISACCEPTSUBMIT", 
"PAYABLEBILL".FDraftNumber AS "DRAFTNUMBER", 
"PAYABLEBILL".FAcceptor AS "ACCEPTOR", 
"CURRENCY2".FName_l2 AS "CURRENCY2.NAME", 
"CREDITLIMIT".FCurrencyID AS "CURRENCY2.ID", 
"PAYABLEBILL".FBillMedium AS "BILLMEDIUM", 
"PAYABLEBILL".FIsCanTransfer AS "ISCANTRANSFER", 
"PAYABLEBILL".FAcceptorAccountName AS "ACCEPTORACCOUNTNAME", 
"PAYABLEBILL".FAcceptorBankNum AS "ACCEPTORBANKNUM", 
"PAYABLEBILL".FDrawerBankNumber AS "DRAWERBANKNUMBER", 
"PAYABLEBILL".FPayeeBankNumber AS "PAYEEBANKNUMBER", 
"PAYABLEBILL".FElecBillStatus AS "ELECBILLSTATUS", 
"PAYABLEBILL".FCommitToBe AS "COMMITTOBE", 
"PAYABLEBILL".FBankReturnStatus AS "BANKRETURNSTATUS", 
"PAYABLEBILL".FBankReturnInfo AS "BANKRETURNINFO", 
"PAYABLEBILL".FAcceptorBankID AS "ACCEPTORBANK.ID", 
"ACCEPTORBANK".FName_l2 AS "ACCEPTORBANK.NAME", 
"PAYABLEBILL".FHorizonType AS "HORIZONTYPE", 
"PAYABLEBILL".FSourceBillID AS "SOURCEBILLID", 
"PAYABLEBILL".FIsPreBill AS "ISPREBILL", 
"PAYABLEBILL".FAbandonDate AS "ABANDONDATE", 
"PAYABLEBILL".FIsBitBack AS "ISBITBACK"

FROM T_NT_PayableBill AS "PAYABLEBILL"

LEFT OUTER JOIN T_FIN_CreditLimit AS "CREDITLIMIT"
ON "PAYABLEBILL".FCreditLimitId = "CREDITLIMIT".FID

LEFT OUTER JOIN T_BD_Currency AS "CURRENCY"
ON "PAYABLEBILL".FCurrencyID = "CURRENCY".FID

LEFT OUTER JOIN T_FIN_FinancingSources AS "SOURCE"
ON "PAYABLEBILL".FSourceID = "SOURCE".FID

LEFT OUTER JOIN T_ORG_Company AS "COMPANY"
ON "PAYABLEBILL".FCompanyID = "COMPANY".FID

LEFT OUTER JOIN T_MNT_BlockingFlowType AS "BLOCKFLOWTYPE"
ON "PAYABLEBILL".FBlockFlowTypeID = "BLOCKFLOWTYPE".FID

LEFT OUTER JOIN T_BD_Bank AS "INSTITUTION"
ON "PAYABLEBILL".FInstitutionId = "INSTITUTION".FID

LEFT OUTER JOIN T_BD_Person AS "CONFIRMER"
ON "PAYABLEBILL".FConfirmerID = "CONFIRMER".FID

LEFT OUTER JOIN T_ORG_Company AS "APPLYUNIT"
ON "PAYABLEBILL".FApplyUnitId = "APPLYUNIT".FID

LEFT OUTER JOIN T_FIN_GuaranteeType AS "GARANTEETYPE"
ON "GARANTEETYPE".FID = "PAYABLEBILL".FGaranteeTypeID

LEFT OUTER JOIN T_FPL_FpItem AS "FPITEM"
ON "PAYABLEBILL".FFpItemID = "FPITEM".FID

LEFT OUTER JOIN T_BD_AccountView AS "OPPACCOUNT"
ON "PAYABLEBILL".FOppAccountID = "OPPACCOUNT".FID

LEFT OUTER JOIN T_BD_AccountView AS "BILLACCOUNT"
ON "PAYABLEBILL".FBillAccountID = "BILLACCOUNT".FID

LEFT OUTER JOIN T_BD_Person AS "PERSON"
ON "PAYABLEBILL".FPersonID = "PERSON".FID

LEFT OUTER JOIN T_ORG_Admin AS "ADMINORGUNIT"
ON "PAYABLEBILL".FAdminOrgUnitID = "ADMINORGUNIT".FID

LEFT OUTER JOIN T_PM_User AS "CREATOR"
ON "PAYABLEBILL".FCreatorID = "CREATOR".FID

LEFT OUTER JOIN T_PM_User AS "AUDITOR"
ON "PAYABLEBILL".FAuditorID = "AUDITOR".FID

LEFT OUTER JOIN T_BD_AccountBanks AS "OUTBANKACCOUNT"
ON "PAYABLEBILL".FOutBankAccountId = "OUTBANKACCOUNT".FID

LEFT OUTER JOIN T_NT_NTType AS "NTTYPE"
ON "PAYABLEBILL".FNtTypeID = "NTTYPE".FID

LEFT OUTER JOIN T_CAS_PaymentBill AS "PAYMENTBILL"
ON "PAYABLEBILL".FRpBillId = "PAYMENTBILL".FID

LEFT OUTER JOIN T_ORG_Company AS "BILLMAKER"
ON "PAYABLEBILL".FBillMakerId = "BILLMAKER".FID

LEFT OUTER JOIN T_PM_User AS "ACCOUNTANT"
ON "PAYABLEBILL".FAccountant = "ACCOUNTANT".FID

LEFT OUTER JOIN T_BD_Project AS "PROJECT"
ON "PAYABLEBILL".FProjectId = "PROJECT".FID

LEFT OUTER JOIN T_ORG_CostCenter AS "COSTCENTER"
ON "PAYABLEBILL".FCostCenterID = "COSTCENTER".FID

LEFT OUTER JOIN T_CAS_FundFlowItem AS "FUNDFLOWITEM"
ON "PAYABLEBILL".FFundFlowItemID = "FUNDFLOWITEM".FID

LEFT OUTER JOIN T_BE_BEBank AS "ACCEPTORBANK"
ON "PAYABLEBILL".FAcceptorBankID = "ACCEPTORBANK".FID

LEFT OUTER JOIN T_BD_Currency AS "CURRENCY2"
ON "CREDITLIMIT".FCurrencyID = "CURRENCY2".FID]]></UserSQL>
				<UserSQL name="dm1630982565980" sqlType="KSQL"><![CDATA[SELECT 

"FINANCINGACCOUNT".FID AS "ID", 
"FINANCINGACCOUNT".FNumber AS "NUMBER", 
"FINANCINGACCOUNT".FBizDate AS "BIZDATE", 
"FINANCEFINANCING".FName_l2 AS "FINANCEFINANCING.NAME", 
"BANK".FName_l2 AS "BANK.NAME", 
"ACCOUNTBANK".FName_l2 AS "ACCOUNTBANK.NAME", 
"FINANCINGACCOUNT".FFinancingProNumber AS "FINANCINGPRONUMBER", 
"FINANCINGACCOUNT".FFinancingProName AS "FINANCINGPRONAME", 
"FINANCINGACCOUNT".FSaleSize AS "SALESIZE", 
"CURRENCY".FName_l2 AS "CURRENCY.NAME", 
"FINANCINGACCOUNT".FExchangeRate AS "EXCHANGERATE", 
"FINANCINGACCOUNT".FFinanceAmount AS "FINANCEAMOUNT", 
"FINANCINGACCOUNT".FBeginDate AS "BEGINDATE", 
"FINANCINGACCOUNT".FEndDate AS "ENDDATE", 
"FINANCINGACCOUNT".FTerm AS "TERM", 
"FINANCINGACCOUNT".FChangeDate AS "CHANGEDATE", 
"FINANCINGACCOUNT".FPredictYield AS "PREDICTYIELD", 
"FINANCINGACCOUNT".FPredictWinAmount AS "PREDICTWINAMOUNT", 
"FINANCINGACCOUNT".FIsNoOut AS "ISNOOUT", 
"FINANCINGACCOUNT".FEarnType AS "EARNTYPE", 
"FINANCINGACCOUNT".FState AS "STATE", 
"CREATOR".FName_l2 AS "CREATOR.NAME", 
"COMPANY".FName_l2 AS "COMPANY.NAME", 
"FINANCINGACCOUNT".FCurrencyID AS "CURRENCY.ID", 
"CURRENCY".FPrecision AS "CURRENCY.PRECISION", 
"FINANCINGACCOUNT".FPracticalWinAmount AS "PRACTICALWINAMOUNT", 
"FINANCINGACCOUNT".FBalance AS "BALANCE", 
"FINANCINGACCOUNT".FFinanceLocAmount AS "FINANCELOCAMOUNT", 
"FINANCINGACCOUNT".FIntRateTypeExpression AS "INTRATETYPEEXPRESSION", 
"FINANCINGACCOUNT".FDays AS "DAYS", 
"FINANCINGACCOUNT".FPredictWinLocAmount AS "PREDICTWINLOCAMOUNT", 
"FINANCINGACCOUNT".FBankID AS "BANK.ID", 
"FINANCINGACCOUNT".FCompanyID AS "COMPANY.ID", 
"FINANCINGACCOUNT".FFinanceFinancingID AS "FINANCEFINANCING.ID", 
"FINANCINGACCOUNT".FAccountBankID AS "ACCOUNTBANK.ID", 
"FINANCINGACCOUNT".FIsGenePayBill AS "ISGENEPAYBILL", 
"FINANCINGACCOUNT".FAuditTime AS "AUDITTIME", 
"FINANCINGACCOUNT".FIsBook AS "ISBOOK", 
"AUDITOR".FName_l2 AS "AUDITOR.NAME", 
"FINANCINGACCOUNT".FSumRedeemAmount AS "SUMREDEEMAMOUNT", 
"FINANCINGACCOUNT".FPracticalWinLocAmount AS "PRACTICALWINLOCAMOUNT", 
"ACCOUNTBANK".FBankAccountNumber AS "ACCOUNTBANK.BANKACCOUNTNUMBER", 
"ACCOUNTANT".FNumber AS "ACCOUNTANT.NUMBER", 
"ACCOUNTANT".FName_l2 AS "ACCOUNTANT.NAME", 
"FINANCINGACCOUNT".FAccountantID AS "ACCOUNTANT.ID", 
"OPPACCOUNTVIEW".FName_l2 AS "OPPACCOUNTVIEW.NAME", 
"OPPACCOUNTVIEW".FNumber AS "OPPACCOUNTVIEW.NUMBER", 
"FINANCINGACCOUNT".FOppAccountViewID AS "OPPACCOUNTVIEW.ID", 
"VOUCHERTYPE".FName_l2 AS "VOUCHERTYPE.NAME", 
"FINANCINGACCOUNT".FVoucherNumber AS "VOUCHERNUMBER", 
"FINANCINGACCOUNT".FVouchered AS "FIVOUCHERED"

FROM T_IVT_FinancingAccount AS "FINANCINGACCOUNT"

LEFT OUTER JOIN T_IVT_FinanceFinancing AS "FINANCEFINANCING"
ON "FINANCINGACCOUNT".FFinanceFinancingID = "FINANCEFINANCING".FID

LEFT OUTER JOIN T_BD_AccountBanks AS "ACCOUNTBANK"
ON "FINANCINGACCOUNT".FAccountBankID = "ACCOUNTBANK".FID

LEFT OUTER JOIN T_BD_Bank AS "BANK"
ON "FINANCINGACCOUNT".FBankID = "BANK".FID

LEFT OUTER JOIN T_BD_Currency AS "CURRENCY"
ON "FINANCINGACCOUNT".FCurrencyID = "CURRENCY".FID

LEFT OUTER JOIN T_PM_User AS "CREATOR"
ON "FINANCINGACCOUNT".FCreatorID = "CREATOR".FID

LEFT OUTER JOIN T_ORG_Company AS "COMPANY"
ON "FINANCINGACCOUNT".FCompanyID = "COMPANY".FID

LEFT OUTER JOIN T_PM_User AS "AUDITOR"
ON "FINANCINGACCOUNT".FAuditorID = "AUDITOR".FID

LEFT OUTER JOIN T_BD_AccountView AS "OPPACCOUNTVIEW"
ON "FINANCINGACCOUNT".FOppAccountViewID = "OPPACCOUNTVIEW".FID

LEFT OUTER JOIN T_PM_User AS "ACCOUNTANT"
ON "FINANCINGACCOUNT".FAccountantID = "ACCOUNTANT".FID

LEFT OUTER JOIN T_BD_VoucherTypes AS "VOUCHERTYPE"
ON "FINANCINGACCOUNT".FVoucherTypeID = "VOUCHERTYPE".FID

ORDER BY 
"COMPANY.NAME" ASC,
"BIZDATE" ASC]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
	</Sources>
	<ExtractSchedule dayAtMonthly="0" weekAtWeekly="1" time="75600" />
	<Entities>
		<Entity name="FinancingAccount" alias="金融理财台账1" associateName="com.kingdee.eas.fm.ivt.app.FinancingAccount" directModel="false" source="s1624500707427">
			<Properties>
				<Property name="id" associateName="id" alias="ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="creator" associateName="creator" alias="创建者" dataType="STRING" hideInDataModeling="false" />
				<Property name="createTime" associateName="createTime" alias="创建时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="lastUpdateUser" associateName="lastUpdateUser" alias="最后修改者" dataType="STRING" hideInDataModeling="false" />
				<Property name="lastUpdateTime" associateName="lastUpdateTime" alias="最后修改时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="CU" associateName="CU" alias="控制单元" dataType="STRING" hideInDataModeling="false" />
				<Property name="number" associateName="number" alias="单据编号" dataType="STRING" hideInDataModeling="false" />
				<Property name="bizDate" associateName="bizDate" alias="业务日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="handler" associateName="handler" alias="经手人" dataType="STRING" hideInDataModeling="false" />
				<Property name="description" associateName="description" alias="参考信息" dataType="STRING" hideInDataModeling="false" />
				<Property name="hasEffected" associateName="hasEffected" alias="是否曾经生效" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="auditor" associateName="auditor" alias="审核人" dataType="STRING" hideInDataModeling="false" />
				<Property name="sourceBillId" associateName="sourceBillId" alias="原始单据ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="sourceFunction" associateName="sourceFunction" alias="来源功能" dataType="STRING" hideInDataModeling="false" />
				<Property name="company" associateName="company" alias="公司" dataType="STRING" hideInDataModeling="false" />
				<Property name="voucherNumber" associateName="voucherNumber" alias="凭证号" dataType="STRING" hideInDataModeling="false" />
				<Property name="voucherType" associateName="voucherType" alias="凭证字" dataType="STRING" hideInDataModeling="false" />
				<Property name="financeFinancing" associateName="financeFinancing" alias="金融理财品种" dataType="STRING" hideInDataModeling="false" />
				<Property name="bank" associateName="bank" alias="金融机构" dataType="STRING" hideInDataModeling="false" />
				<Property name="accountBank" associateName="accountBank" alias="理财账户" dataType="STRING" hideInDataModeling="false" />
				<Property name="financingProNumber" associateName="financingProNumber" alias="金融理财产品编号" dataType="STRING" hideInDataModeling="false" />
				<Property name="financingProName" associateName="financingProName" alias="理财产品名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="saleSize" associateName="saleSize" alias="发售规模" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="currency" associateName="currency" alias="币别" dataType="STRING" hideInDataModeling="false" />
				<Property name="exchangeRate" associateName="exchangeRate" alias="汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="financeAmount" associateName="financeAmount" alias="投资金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="beginDate" associateName="beginDate" alias="投资起始日" dataType="DATE" hideInDataModeling="false" />
				<Property name="endDate" associateName="endDate" alias="投资到期日" dataType="DATE" hideInDataModeling="false" />
				<Property name="changeDate" associateName="changeDate" alias="收益兑换日" dataType="DATE" hideInDataModeling="false" />
				<Property name="predictYield" associateName="predictYield" alias="预计年化收益率_" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="predictWinAmount" associateName="predictWinAmount" alias="预计收益金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="practicalWinAmount" associateName="practicalWinAmount" alias="实计收益金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="isNoOut" associateName="isNoOut" alias="是否保本" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="earnType" associateName="earnType" alias="收益类型" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="浮动" />
						<Enum key="2" value="固定" />
					</Enums>
				</Property>
				<Property name="state" associateName="state" alias="状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="保存" />
						<Enum key="1" value="已提交" />
						<Enum key="2" value="已关闭" />
						<Enum key="3" value="已审批" />
					</Enums>
				</Property>
				<Property name="remark" associateName="remark" alias="其它补充条款" dataType="STRING" hideInDataModeling="false" />
				<Property name="term" associateName="term" alias="投资期限" dataType="STRING" hideInDataModeling="false" />
				<Property name="balance" associateName="balance" alias="余额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="financeLocAmount" associateName="financeLocAmount" alias="投资折本位币金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="intRateTypeExpression" associateName="intRateTypeExpression" alias="利率表示" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="month" value="月" />
						<Enum key="year" value="年" />
						<Enum key="day" value="日" />
					</Enums>
				</Property>
				<Property name="days" associateName="days" alias="折算天数" dataType="INT" format="#,##0" hideInDataModeling="false" />
				<Property name="predictWinLocAmount" associateName="predictWinLocAmount" alias="预计收益折本位币金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="isGenePayBill" associateName="isGenePayBill" alias="是否生成付款单" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="auditTime" associateName="auditTime" alias="审批时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="isBook" associateName="isBook" alias="是否登账" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="SumRedeemAmount" associateName="SumRedeemAmount" alias="赎回金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="practicalWinLocAmount" associateName="practicalWinLocAmount" alias="实计收益折本位币" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="oppAccountView" associateName="oppAccountView" alias="对方科目" dataType="STRING" hideInDataModeling="false" />
				<Property name="fiVouchered" associateName="fiVouchered" alias="是否生成凭证" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="accountant" associateName="accountant" alias="会计" dataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="balance" compare="GREATER" value="0" lb="1" rb="1" logic="AND" compareType="APPOINTED" />
				<Item property="endDate" compare="RELATIVE_DATE_RANGE" mode="SystemVar" lb="1" rb="1" compareType="APPOINTED">
					<RelativeDateRange period="Day" fromNowOn="7" upToNow="false" />
				</Item>
			</Filters>
		</Entity>
		<Entity name="PayableBill" alias="应付票据1" associateName="com.kingdee.eas.fm.nt.app.PayableBill" directModel="false" source="s1624500707427">
			<Properties>
				<Property name="id" associateName="id" alias="ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="creator" associateName="creator" alias="创建者" dataType="STRING" hideInDataModeling="false" />
				<Property name="createTime" associateName="createTime" alias="创建时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="lastUpdateUser" associateName="lastUpdateUser" alias="最后修改者" dataType="STRING" hideInDataModeling="false" />
				<Property name="lastUpdateTime" associateName="lastUpdateTime" alias="最后修改时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="CU" associateName="CU" alias="控制单元" dataType="STRING" hideInDataModeling="false" />
				<Property name="number" associateName="number" alias="单据编号" dataType="STRING" hideInDataModeling="false" />
				<Property name="bizDate" associateName="bizDate" alias="业务日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="handler" associateName="handler" alias="经手人" dataType="STRING" hideInDataModeling="false" />
				<Property name="description" associateName="description" alias="参考信息" dataType="STRING" hideInDataModeling="false" />
				<Property name="hasEffected" associateName="hasEffected" alias="是否曾经生效" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="auditor" associateName="auditor" alias="审核人" dataType="STRING" hideInDataModeling="false" />
				<Property name="sourceBillId" associateName="sourceBillId" alias="原始单据ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="sourceFunction" associateName="sourceFunction" alias="来源功能" dataType="STRING" hideInDataModeling="false" />
				<Property name="company" associateName="company" alias="公司" dataType="STRING" hideInDataModeling="false" />
				<Property name="voucherNumber" associateName="voucherNumber" alias="凭证号" dataType="STRING" hideInDataModeling="false" />
				<Property name="voucherType" associateName="voucherType" alias="凭证字" dataType="STRING" hideInDataModeling="false" />
				<Property name="Source" associateName="Source" alias="融资来源" dataType="STRING" hideInDataModeling="false" />
				<Property name="Type" associateName="Type" alias="融资品种" dataType="STRING" hideInDataModeling="false" />
				<Property name="Region" associateName="Region" alias="境内外" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="中国大陆" />
						<Enum key="2" value="境外" />
						<Enum key="3" value="港澳台" />
					</Enums>
				</Property>
				<Property name="Currency" associateName="Currency" alias="币别" dataType="STRING" hideInDataModeling="false" />
				<Property name="Amount" associateName="Amount" alias="金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="Balance" associateName="Balance" alias="余额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="LocalCurExRate" associateName="LocalCurExRate" alias="汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="IsInCredit" associateName="IsInCredit" alias="额度内" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="UsedQuota" associateName="UsedQuota" alias="申请额度" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="IssueDate" associateName="IssueDate" alias="起始日" dataType="DATE" hideInDataModeling="false" />
				<Property name="ExpiredDate" associateName="ExpiredDate" alias="汇票到期日" dataType="DATE" hideInDataModeling="false" />
				<Property name="Horizon" associateName="Horizon" alias="票据期限" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="GaranteeType" associateName="GaranteeType" alias="主保证方式" dataType="STRING" hideInDataModeling="false" />
				<Property name="Remark" associateName="Remark" alias="备注" dataType="STRING" hideInDataModeling="false" />
				<Property name="Garantee" associateName="Garantee" alias="保证人抵质押物名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditLimit" associateName="CreditLimit" alias="授信额度" dataType="STRING" hideInDataModeling="false" />
				<Property name="AmountLocalCur" associateName="AmountLocalCur" alias="折本位币" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="Institution" associateName="Institution" alias="债权人名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditCurrency" associateName="CreditCurrency" alias="授信币别" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditCurExRate" associateName="CreditCurExRate" alias="折授信币别汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="creditLocalAmt" associateName="creditLocalAmt" alias="折授信币别金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="useAssureBill" associateName="useAssureBill" alias="使用担保" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="assureBill" associateName="assureBill" alias="担保单" dataType="STRING" hideInDataModeling="false" />
				<Property name="assExRate" associateName="assExRate" alias="担保币别汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="assCurrency" associateName="assCurrency" alias="担保币别" dataType="STRING" hideInDataModeling="false" />
				<Property name="fiVouchered" associateName="fiVouchered" alias="生成凭证" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="historyBill" associateName="historyBill" alias="历史票据" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="guaranteeTypeInputMode" associateName="guaranteeTypeInputMode" alias="保证方式的录入方式" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="保证" />
						<Enum key="2" value="抵押" />
						<Enum key="3" value="质押" />
						<Enum key="4" value="信用" />
						<Enum key="5" value="其它" />
						<Enum key="6" value="混合" />
						<Enum key="7" value="无担保" />
					</Enums>
				</Property>
				<Property name="isRelBankInCredit" associateName="isRelBankInCredit" alias="银行关联授信额度" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="BuyerPayDisCnt" associateName="BuyerPayDisCnt" alias="买方付息" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="DiscountDate" associateName="DiscountDate" alias="贴现日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="DiscountRate" associateName="DiscountRate" alias="贴现率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="Discount" associateName="Discount" alias="贴现息" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BlockFlowType" associateName="BlockFlowType" alias="重大收支类别" dataType="STRING" hideInDataModeling="false" />
				<Property name="InstitutionName" associateName="InstitutionName" alias="承兑人名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="ApplyUnit" associateName="ApplyUnit" alias="申请公司" dataType="STRING" hideInDataModeling="false" />
				<Property name="OutBankAccount" associateName="OutBankAccount" alias="付款人账号" dataType="STRING" hideInDataModeling="false" />
				<Property name="InBankAccount" associateName="InBankAccount" alias="收款人账号" dataType="STRING" hideInDataModeling="false" />
				<Property name="InBank" associateName="InBank" alias="收款银行" dataType="STRING" hideInDataModeling="false" />
				<Property name="ContractNumber" associateName="ContractNumber" alias="交易合同号" dataType="STRING" hideInDataModeling="false" />
				<Property name="assureProportion" associateName="assureProportion" alias="保证金比例" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="assureAmount" associateName="assureAmount" alias="累计保证金" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="billAmount" associateName="billAmount" alias="票面金额_已作废_" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="billMaker" associateName="billMaker" alias="付款人全称" dataType="STRING" hideInDataModeling="false" />
				<Property name="billMakerName" associateName="billMakerName" alias="付款人名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="confirmer" associateName="confirmer" alias="确认人" dataType="STRING" hideInDataModeling="false" />
				<Property name="billState" associateName="billState" alias="单据状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="登记" />
						<Enum key="1" value="兑付" />
						<Enum key="2" value="对内转付" />
						<Enum key="3" value="对外转付" />
						<Enum key="4" value="保存" />
						<Enum key="5" value="审批" />
						<Enum key="6" value="贴现" />
						<Enum key="7" value="转借款" />
						<Enum key="8" value="手工作废" />
						<Enum key="9" value="退票" />
						<Enum key="10" value="作废" />
					</Enums>
				</Property>
				<Property name="makeType" associateName="makeType" alias="开票方式" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="自开" />
						<Enum key="1" value="代开" />
						<Enum key="2" value="委开" />
					</Enums>
				</Property>
				<Property name="sourceCompany" associateName="sourceCompany" alias="来源公司" dataType="STRING" hideInDataModeling="false" />
				<Property name="payee" associateName="payee" alias="收款人全称_供应商_" dataType="STRING" hideInDataModeling="false" />
				<Property name="payeeName" associateName="payeeName" alias="收款人名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="InstitutionCompany" associateName="InstitutionCompany" alias="承兑单位" dataType="STRING" hideInDataModeling="false" />
				<Property name="outBankAccountName" associateName="outBankAccountName" alias="付款账户名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="RepaymentDate" associateName="RepaymentDate" alias="兑付日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="payee1" associateName="payee1" alias="收款人全称_客户_" dataType="STRING" hideInDataModeling="false" />
				<Property name="fpItem" associateName="fpItem" alias="计划项目" dataType="STRING" hideInDataModeling="false" />
				<Property name="oppAccount" associateName="oppAccount" alias="对方科目" dataType="STRING" hideInDataModeling="false" />
				<Property name="PayeeAccountName" associateName="PayeeAccountName" alias="收款人账号1" dataType="STRING" hideInDataModeling="false" />
				<Property name="PayeeBankName" associateName="PayeeBankName" alias="收款银行1" dataType="STRING" hideInDataModeling="false" />
				<Property name="acceptDate" associateName="acceptDate" alias="承兑日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="digest" associateName="digest" alias="摘要" dataType="STRING" hideInDataModeling="false" />
				<Property name="transferDate" associateName="transferDate" alias="转付日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="transfer" associateName="transfer" alias="转付单" dataType="STRING" hideInDataModeling="false" />
				<Property name="billLastState" associateName="billLastState" alias="单据上个状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="登记" />
						<Enum key="1" value="兑付" />
						<Enum key="2" value="对内转付" />
						<Enum key="3" value="对外转付" />
						<Enum key="4" value="保存" />
						<Enum key="5" value="审批" />
						<Enum key="6" value="贴现" />
						<Enum key="7" value="转借款" />
						<Enum key="8" value="手工作废" />
						<Enum key="9" value="退票" />
						<Enum key="10" value="作废" />
					</Enums>
				</Property>
				<Property name="isTDPrinted" associateName="isTDPrinted" alias="已经套打" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="billAccount" associateName="billAccount" alias="应付票据科目" dataType="STRING" hideInDataModeling="false" />
				<Property name="adminOrgUnit" associateName="adminOrgUnit" alias="部门" dataType="STRING" hideInDataModeling="false" />
				<Property name="person" associateName="person" alias="业务员" dataType="STRING" hideInDataModeling="false" />
				<Property name="issueUnit" associateName="issueUnit" alias="出票单位" dataType="STRING" hideInDataModeling="false" />
				<Property name="ntType" associateName="ntType" alias="票据类型" dataType="STRING" hideInDataModeling="false" />
				<Property name="rpBillId" associateName="rpBillId" alias="关联付款单" dataType="STRING" hideInDataModeling="false" />
				<Property name="isApply" associateName="isApply" alias="领用" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="applyDate" associateName="applyDate" alias="领用日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="personName" associateName="personName" alias="业务员名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="applyInfo" associateName="applyInfo" alias="其他领用信息" dataType="STRING" hideInDataModeling="false" />
				<Property name="lastTransferDate" associateName="lastTransferDate" alias="上一次转付日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="isAccept" associateName="isAccept" alias="承兑" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="accountant" associateName="accountant" alias="会计" dataType="STRING" hideInDataModeling="false" />
				<Property name="batchNaturalAmount" associateName="batchNaturalAmount" alias="批量新增的汇总金额本位币" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="batchAssureAmount" associateName="batchAssureAmount" alias="批量新增的汇总保证金" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="batchNo" associateName="batchNo" alias="批号" dataType="STRING" hideInDataModeling="false" />
				<Property name="oriAssureAmount" associateName="oriAssureAmount" alias="初始保证金" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="outBgItemId" associateName="outBgItemId" alias="预算项目Id" dataType="STRING" hideInDataModeling="false" />
				<Property name="outBgItemNumber" associateName="outBgItemNumber" alias="预算项目编码" dataType="STRING" hideInDataModeling="false" />
				<Property name="outBgItemName" associateName="outBgItemName" alias="预算项目名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="project" associateName="project" alias="项目" dataType="STRING" hideInDataModeling="false" />
				<Property name="costCenter" associateName="costCenter" alias="成本中心" dataType="STRING" hideInDataModeling="false" />
				<Property name="draftNumber" associateName="draftNumber" alias="票据号码" dataType="STRING" hideInDataModeling="false" />
				<Property name="acceptor" associateName="acceptor" alias="承兑人" dataType="STRING" hideInDataModeling="false" />
				<Property name="isAcceptSubmit" associateName="isAcceptSubmit" alias="是否提交承兑登记" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="returnOption" associateName="returnOption" alias="打回意见" dataType="STRING" hideInDataModeling="false" />
				<Property name="fundFlowItem" associateName="fundFlowItem" alias="资金流量项目" dataType="STRING" hideInDataModeling="false" />
				<Property name="billMedium" associateName="billMedium" alias="票据种类" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="纸质" />
						<Enum key="2" value="电子" />
					</Enums>
				</Property>
				<Property name="isCanTransfer" associateName="isCanTransfer" alias="允许转让" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="acceptorAccountName" associateName="acceptorAccountName" alias="承兑人账号" dataType="STRING" hideInDataModeling="false" />
				<Property name="acceptorBankNum" associateName="acceptorBankNum" alias="承兑人开户行行号" dataType="STRING" hideInDataModeling="false" />
				<Property name="acceptorBank" associateName="acceptorBank" alias="承兑人开户行" dataType="STRING" hideInDataModeling="false" />
				<Property name="drawerBankNumber" associateName="drawerBankNumber" alias="出票人开户行行号" dataType="STRING" hideInDataModeling="false" />
				<Property name="payeeBankNumber" associateName="payeeBankNumber" alias="收款人开户行行号" dataType="STRING" hideInDataModeling="false" />
				<Property name="elecBillStatus" associateName="elecBillStatus" alias="电票状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="110105" value="买断式贴现已签收已排队" />
						<Enum key="110106" value="买断式贴现已签收" />
						<Enum key="110103" value="买断式贴现已签收待清算" />
						<Enum key="110101" value="买断式贴现待签收" />
						<Enum key="160003" value="回购式再贴现赎回已签收待清算" />
						<Enum key="160005" value="回购式再贴现赎回已签收已排队" />
						<Enum key="160006" value="回购式再贴现赎回已签收" />
						<Enum key="STS002" value="委托收款在途" />
						<Enum key="160001" value="回购式再贴现赎回待签收" />
						<Enum key="220710" value="非拒付追索已撤销" />
						<Enum key="250003" value="央行卖票已签收待清算" />
						<Enum key="250001" value="央行卖票待签收" />
						<Enum key="250006" value="央行卖票已签收" />
						<Enum key="250005" value="央行卖票已签收已排队" />
						<Enum key="170001" value="保证待签收" />
						<Enum key="110216" value="回购式贴现已至赎回开放日" />
						<Enum key="000002" value="票据已作废" />
						<Enum key="000000" value="票据已结清" />
						<Enum key="130203" value="回购式转贴现已签收待清算" />
						<Enum key="130201" value="回购式转贴现待签收" />
						<Enum key="220707" value="非拒付追索待清偿" />
						<Enum key="130206" value="回购式转贴现已签收" />
						<Enum key="200512" value="提示付款已拒付（不可进行拒付追索）" />
						<Enum key="130205" value="回购式转贴现已签收已排队" />
						<Enum key="180020" value="质押已至票据到期日" />
						<Enum key="110218" value="回购式贴现已逾赎回截止日" />
						<Enum key="200312" value="提示付款已拒付（可拒付追索，只能追出票人，承兑人及其保证人）" />
						<Enum key="150206" value="回购式再贴现已签收" />
						<Enum key="200001" value="提示付款待签收" />
						<Enum key="140001" value="回购式转贴现赎回待签收" />
						<Enum key="010004" value="出票已登记" />
						<Enum key="150205" value="回购式再贴现已签收已排队" />
						<Enum key="140003" value="回购式转贴现赎回已签收待清算" />
						<Enum key="STS000" value="托管在池" />
						<Enum key="150203" value="回购式再贴现已签收待清算" />
						<Enum key="020006" value="提示承兑已签收" />
						<Enum key="STS001" value="质押在池" />
						<Enum key="140005" value="回购式转贴现赎回已签收已排队" />
						<Enum key="210312" value="逾期提示付款已拒付（可拒付追索，只能追出票人，承兑人及其保证人）" />
						<Enum key="140006" value="回购式转贴现赎回已签收" />
						<Enum key="150201" value="回购式再贴现待签收" />
						<Enum key="230706" value="非拒付追索同意清偿已签收" />
						<Enum key="020001" value="提示承兑待签收" />
						<Enum key="230701" value="非拒付追索同意清偿待签收" />
						<Enum key="110205" value="回购式贴现已签收" />
						<Enum key="110203" value="回购式贴现已签收待清算" />
						<Enum key="030006" value="提示收票已签收" />
						<Enum key="110201" value="回购式贴现待签收" />
						<Enum key="130218" value="回购式转贴现已逾赎回截止日" />
						<Enum key="030001" value="提示收票待签收" />
						<Enum key="130216" value="回购式转贴现已至赎回开放日" />
						<Enum key="200003" value="提示付款已签收待清算" />
						<Enum key="110206" value="回购式贴现已签收" />
						<Enum key="200005" value="提示付款已签收已排队" />
						<Enum key="120003" value="回购式贴现赎回已签收待清算" />
						<Enum key="120005" value="回购式贴现赎回已签收已排队" />
						<Enum key="120006" value="回购式贴现赎回已签收" />
						<Enum key="150218" value="回购式再贴现已逾赎回截止日" />
						<Enum key="150216" value="回购式再贴现已至赎回开放日" />
						<Enum key="120001" value="回购式贴现赎回待签收" />
						<Enum key="210003" value="逾期提示付款已签收待清算" />
						<Enum key="210001" value="逾期提示付款待签收" />
						<Enum key="210005" value="逾期提示付款已签收已排队" />
						<Enum key="180001" value="质押待签收" />
						<Enum key="130103" value="买断式转贴现已签收待清算" />
						<Enum key="180006" value="质押已签收" />
						<Enum key="220607" value="拒付追索待清偿" />
						<Enum key="130101" value="买断式转贴现待签收" />
						<Enum key="130105" value="买断式转贴现已签收已排队" />
						<Enum key="130106" value="买断式转贴现已签收" />
						<Enum key="200412" value="提示付款已拒付（可拒付追索，可以追所有人）" />
						<Enum key="150105" value="买断式再贴现已签收已排队" />
						<Enum key="150106" value="买断式再贴现已签收" />
						<Enum key="150103" value="买断式再贴现已签收待清算" />
						<Enum key="100001" value="背书待签收" />
						<Enum key="150101" value="买断式再贴现待签收" />
						<Enum key="190006" value="质押解除已签收" />
						<Enum key="230606" value="拒付追索同意清偿已签收" />
						<Enum key="UNKNOWN" value="未知" />
						<Enum key="100006" value="背书已签收" />
						<Enum key="190001" value="质押解除待签收" />
						<Enum key="210412" value="逾期提示付款已拒付（可拒付追索，可以追索所有人）" />
						<Enum key="230601" value="拒付追索同意清偿待签收" />
					</Enums>
				</Property>
				<Property name="commitToBe" associateName="commitToBe" alias="提交银企互联" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="出票登记" />
						<Enum key="2" value="提示承兑" />
						<Enum key="3" value="提示收票" />
						<Enum key="4" value="撤销" />
						<Enum key="5" value="撤票" />
					</Enums>
				</Property>
				<Property name="bankReturnStatus" associateName="bankReturnStatus" alias="银行返回状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="银企中间件处理中" />
						<Enum key="2" value="银行处理中" />
						<Enum key="3" value="银行交易成功" />
						<Enum key="4" value="银行交易失败" />
						<Enum key="5" value="银行交易未确认" />
						<Enum key="6" value="提交失败" />
					</Enums>
				</Property>
				<Property name="bankReturnInfo" associateName="bankReturnInfo" alias="银行返回信息" dataType="STRING" hideInDataModeling="false" />
				<Property name="batchSeqID" associateName="batchSeqID" alias="提交银企批次流水" dataType="STRING" hideInDataModeling="false" />
				<Property name="detailSeqID" associateName="detailSeqID" alias="支付明细流水" dataType="STRING" hideInDataModeling="false" />
				<Property name="isFromEntrust" associateName="isFromEntrust" alias="是否来自于委开单据" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="isFromSub" associateName="isFromSub" alias="是否来自于代开票据" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="horizonType" associateName="horizonType" alias="期限类型" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="月" />
						<Enum key="2" value="天" />
					</Enums>
				</Property>
				<Property name="draftSource" associateName="draftSource" alias="票据来源" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="手工登记" />
						<Enum key="2" value="ECDS" />
					</Enums>
				</Property>
				<Property name="isPreBill" associateName="isPreBill" alias="是否预开票" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="lastBatchSeqID" associateName="lastBatchSeqID" alias="上次交易批次号" dataType="STRING" hideInDataModeling="false" />
				<Property name="lastDetailSeqID" associateName="lastDetailSeqID" alias="上次交易流水号" dataType="STRING" hideInDataModeling="false" />
				<Property name="abandonDate" associateName="abandonDate" alias="作废日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="isBitBack" associateName="isBitBack" alias="是否打回" dataType="BOOLEAN" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="Balance" compare="GREATER" value="0" lb="1" rb="1" logic="AND" compareType="APPOINTED" />
				<Item property="ExpiredDate" compare="RELATIVE_DATE_RANGE" mode="SystemVar" lb="1" rb="1" compareType="APPOINTED">
					<RelativeDateRange period="Day" fromNowOn="7" upToNow="false" />
				</Item>
			</Filters>
		</Entity>
		<Entity name="GuaranteeDetail_1" alias="保证明细分录_1" associateName="com.kingdee.eas.fm.fin.app.GuaranteeDetail" parentName="PayableBill" directModel="false" source="s1624500707427">
			<Properties>
				<Property name="id" associateName="guaranteeEntrys.id" alias="ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="creator" associateName="guaranteeEntrys.creator" alias="创建者" dataType="STRING" hideInDataModeling="false" />
				<Property name="createTime" associateName="guaranteeEntrys.createTime" alias="创建时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="lastUpdateUser" associateName="guaranteeEntrys.lastUpdateUser" alias="最后修改者" dataType="STRING" hideInDataModeling="false" />
				<Property name="lastUpdateTime" associateName="guaranteeEntrys.lastUpdateTime" alias="最后修改时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="CU" associateName="guaranteeEntrys.CU" alias="控制单元" dataType="STRING" hideInDataModeling="false" />
				<Property name="name" associateName="guaranteeEntrys.name" alias="名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="number" associateName="guaranteeEntrys.number" alias="编码" dataType="STRING" hideInDataModeling="false" />
				<Property name="description" associateName="guaranteeEntrys.description" alias="描述" dataType="STRING" hideInDataModeling="false" />
				<Property name="simpleName" associateName="guaranteeEntrys.simpleName" alias="简称" dataType="STRING" hideInDataModeling="false" />
				<Property name="parentBillType" associateName="guaranteeEntrys.parentBillType" alias="单头类型" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="借款单" />
						<Enum key="2" value="应付票据" />
						<Enum key="3" value="信用证" />
						<Enum key="4" value="银行保函" />
						<Enum key="5" value="借款合同" />
						<Enum key="6" value="发行计划" />
						<Enum key="7" value="提款单" />
						<Enum key="8" value="发行情况公告" />
					</Enums>
				</Property>
				<Property name="parentBillId" associateName="guaranteeEntrys.parentBillId" alias="单头ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="scale" associateName="guaranteeEntrys.scale" alias="保证比例" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="amount" associateName="guaranteeEntrys.amount" alias="担保金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="exchangeRate" associateName="guaranteeEntrys.exchangeRate" alias="折担保汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="balance" associateName="guaranteeEntrys.balance" alias="余额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="guaranteeType" associateName="guaranteeEntrys.guaranteeType" alias="保证方式" dataType="STRING" hideInDataModeling="false" />
				<Property name="guaranteeName" associateName="guaranteeEntrys.guaranteeName" alias="保证人抵押物名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="billId" associateName="guaranteeEntrys.billId" alias="业务单据ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="billNumber" associateName="guaranteeEntrys.billNumber" alias="业务单据编号" dataType="STRING" hideInDataModeling="false" />
				<Property name="billtype" associateName="guaranteeEntrys.billtype" alias="单据类型" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="" />
						<Enum key="1" value="担保单" />
						<Enum key="2" value="应收票据" />
						<Enum key="3" value="抵（质）押物" />
					</Enums>
				</Property>
				<Property name="currency" associateName="guaranteeEntrys.currency" alias="币别" dataType="STRING" hideInDataModeling="false" />
				<Property name="guaranteeComp" associateName="guaranteeEntrys.guaranteeComp" alias="担保单位抵押人质押人保证人" dataType="STRING" hideInDataModeling="false" />
				<Property name="guaranteeCompHand" associateName="guaranteeEntrys.guaranteeCompHand" alias="担保单位抵押人质押人保证人1" dataType="STRING" hideInDataModeling="false" />
				<Property name="wage" associateName="guaranteeEntrys.wage" alias="抵押物评估价评估价值" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="wageRate" associateName="guaranteeEntrys.wageRate" alias="抵押率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="canWage" associateName="guaranteeEntrys.canWage" alias="可抵押价值" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="realWage" associateName="guaranteeEntrys.realWage" alias="实际抵押价值" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="remark" associateName="guaranteeEntrys.remark" alias="备注" dataType="STRING" hideInDataModeling="false" />
				<Property name="guaranteeTypeProperty" associateName="guaranteeEntrys.guaranteeTypeProperty" alias="保证方式属性区别分录" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="保证" />
						<Enum key="2" value="抵押" />
						<Enum key="3" value="质押" />
						<Enum key="4" value="信用" />
						<Enum key="5" value="其他" />
					</Enums>
				</Property>
				<Property name="mortgageType" associateName="guaranteeEntrys.mortgageType" alias="抵押性质" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="抵押物" />
						<Enum key="1" value="应收账款" />
					</Enums>
				</Property>
				<Property name="guaranteeCustomer" associateName="guaranteeEntrys.guaranteeCustomer" alias="担保单位_客户_" dataType="STRING" hideInDataModeling="false" />
				<Property name="revokeStatus" associateName="guaranteeEntrys.revokeStatus" alias="撤销状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="正常" />
						<Enum key="1" value="已撤销" />
					</Enums>
				</Property>
				<Property name="revokeDate" associateName="guaranteeEntrys.revokeDate" alias="撤销日期" dataType="DATE" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="LoanTDQuery" alias="借款1" associateName="com.kingdee.eas.fm.fin.app.LoanTDQuery" directModel="false" source="s1624604807537">
			<Properties>
				<Property name="Amount" associateName="Amount" alias="借款金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="Balance" associateName="Balance" alias="借款余额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="LocalCurExRate" associateName="LocalCurExRate" alias="折本位币汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="UsedQuota" associateName="UsedQuota" alias="申请额度" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="IssueDate" associateName="IssueDate" alias="起始日" dataType="DATE" hideInDataModeling="false" />
				<Property name="ExpiredDate" associateName="ExpiredDate" alias="到期日" dataType="DATE" hideInDataModeling="false" />
				<Property name="Horizon" associateName="Horizon" alias="期限" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="Remark" associateName="Remark" alias="借款用途" dataType="STRING" hideInDataModeling="false" />
				<Property name="Garantee" associateName="Garantee" alias="保证人_抵_质_押物名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="AmountLocalCur" associateName="AmountLocalCur" alias="折本位币" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="number" associateName="number" alias="单据编号" dataType="STRING" hideInDataModeling="false" />
				<Property name="bizDate" associateName="bizDate" alias="业务日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="Currency_name" associateName="Currency.name" alias="币别" dataType="STRING" hideInDataModeling="false" />
				<Property name="Type_name" associateName="Type.name" alias="融资品种" dataType="STRING" hideInDataModeling="false" />
				<Property name="Source_name" associateName="Source.name" alias="融资来源" dataType="STRING" hideInDataModeling="false" />
				<Property name="company_name" associateName="company.name" alias="公司" dataType="STRING" hideInDataModeling="false" />
				<Property name="IsBankLoan" associateName="IsBankLoan" alias="是否银行借款" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="CreditorGroup_name" associateName="CreditorGroup.name" alias="融资形式" dataType="STRING" hideInDataModeling="false" />
				<Property name="BankAcct_bankAccountNumber" associateName="BankAcct.bankAccountNumber" alias="银行账户" dataType="STRING" hideInDataModeling="false" />
				<Property name="LoanAcct_name" associateName="LoanAcct.name" alias="贷款科目" dataType="STRING" hideInDataModeling="false" />
				<Property name="YieldRate" associateName="YieldRate" alias="实际年利率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="RepaymentType" associateName="RepaymentType" alias="还款方式" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="到期还本" />
						<Enum key="2" value="分期还款" />
						<Enum key="3" value="其他方式" />
					</Enums>
				</Property>
				<Property name="IntRateType_name" associateName="IntRateType.name" alias="利率类型" dataType="STRING" hideInDataModeling="false" />
				<Property name="Institution_name" associateName="Institution.name" alias="债权人" dataType="STRING" hideInDataModeling="false" />
				<Property name="Currency_id" associateName="Currency.id" alias="币别id" dataType="STRING" hideInDataModeling="false" />
				<Property name="Type_number" associateName="Type.number" alias="融资品种编码" dataType="STRING" hideInDataModeling="false" />
				<Property name="Type_id" associateName="Type.id" alias="融资品种id" dataType="STRING" hideInDataModeling="false" />
				<Property name="Source_number" associateName="Source.number" alias="编码" dataType="STRING" hideInDataModeling="false" />
				<Property name="Source_id" associateName="Source.id" alias="融资来源id" dataType="STRING" hideInDataModeling="false" />
				<Property name="Institution_number" associateName="Institution.number" alias="编码1" dataType="STRING" hideInDataModeling="false" />
				<Property name="Institution_id" associateName="Institution.id" alias="债权人id" dataType="STRING" hideInDataModeling="false" />
				<Property name="IntRateType_number" associateName="IntRateType.number" alias="利率表" dataType="STRING" hideInDataModeling="false" />
				<Property name="IntRateType_id" associateName="IntRateType.id" alias="利率表id" dataType="STRING" hideInDataModeling="false" />
				<Property name="LoanAcct_number" associateName="LoanAcct.number" alias="编码2" dataType="STRING" hideInDataModeling="false" />
				<Property name="LoanAcct_id" associateName="LoanAcct.id" alias="贷款科目id" dataType="STRING" hideInDataModeling="false" />
				<Property name="BankAcct_name" associateName="BankAcct.name" alias="银行账户1" dataType="STRING" hideInDataModeling="false" />
				<Property name="BankAcct_number" associateName="BankAcct.number" alias="编码3" dataType="STRING" hideInDataModeling="false" />
				<Property name="BankAcct_id" associateName="BankAcct.id" alias="银行账户id" dataType="STRING" hideInDataModeling="false" />
				<Property name="description" associateName="description" alias="摘要" dataType="STRING" hideInDataModeling="false" />
				<Property name="IsInCredit" associateName="IsInCredit" alias="额度内" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="CreditLimit_number" associateName="CreditLimit.number" alias="授信额度" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditLimit_id" associateName="CreditLimit.id" alias="授信额度id" dataType="STRING" hideInDataModeling="false" />
				<Property name="ApplicationRule" associateName="ApplicationRule" alias="利率适用" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="固定利率" />
						<Enum key="2" value="浮动利率" />
						<Enum key="3" value="分段计息" />
					</Enums>
				</Property>
				<Property name="BasePoints" associateName="BasePoints" alias="浮动点数" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="GroupID_name" associateName="GroupID.name" alias="名称1" dataType="STRING" hideInDataModeling="false" />
				<Property name="IsGroupLoan" associateName="IsGroupLoan" alias="借款债权人性质" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="accountant_name" associateName="accountant.name" alias="会计" dataType="STRING" hideInDataModeling="false" />
				<Property name="historyBill" associateName="historyBill" alias="是否历史单据" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="penAccrualType" associateName="penAccrualType" alias="罚息方式" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="addPercent" value="加点" />
						<Enum key="addaccrual" value="加息" />
					</Enums>
				</Property>
				<Property name="penAccrualRate" associateName="penAccrualRate" alias="罚息率_" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="isOverdue" associateName="isOverdue" alias="是否逾期" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="intRateTypeExpression" associateName="intRateTypeExpression" alias="利率表示" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="month" value="月" />
						<Enum key="year" value="年" />
						<Enum key="day" value="日" />
					</Enums>
				</Property>
				<Property name="yearDays" associateName="yearDays" alias="折算天数" dataType="INT" format="#,##0" hideInDataModeling="false" />
				<Property name="creator_name" associateName="creator.name" alias="用户实名" dataType="STRING" hideInDataModeling="false" />
				<Property name="contractNum" associateName="contractNum" alias="合同号" dataType="STRING" hideInDataModeling="false" />
				<Property name="isMulCon" associateName="isMulCon" alias="是否多次发放的合同借款" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="project_name" associateName="project.name" alias="项目" dataType="STRING" hideInDataModeling="false" />
				<Property name="GaranteeType_name" associateName="GaranteeType.name" alias="主担保方式" dataType="STRING" hideInDataModeling="false" />
				<Property name="payIntMode_name" associateName="payIntMode.name" alias="付息方式" dataType="STRING" hideInDataModeling="false" />
				<Property name="floatAction" associateName="floatAction" alias="浮动情况" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="LPR浮动" />
						<Enum key="1" value="基准利率浮动" />
						<Enum key="2" value="LIBOR浮动" />
						<Enum key="3" value="HIBOR浮动" />
						<Enum key="4" value="NIBOR浮动" />
						<Enum key="5" value="SIBOR浮动" />
						<Enum key="6" value="SHIBOR浮动" />
					</Enums>
				</Property>
				<Property name="rateAdjustPeriod" associateName="rateAdjustPeriod" alias="重定价周期" dataType="INT" format="#,##0" hideInDataModeling="false" />
				<Property name="firstRateAdjustDate" associateName="firstRateAdjustDate" alias="首个重定价日" dataType="DATE" hideInDataModeling="false" />
				<Property name="status" associateName="status" alias="单据状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="保存" />
						<Enum key="1" value="提交" />
						<Enum key="3" value="已审批" />
					</Enums>
				</Property>
				<Property name="handlerRemark" associateName="handlerRemark" alias="经办人" dataType="STRING" hideInDataModeling="false" />
				<Property name="entLoanID_id" associateName="entLoanID.id" alias="企业贷款单ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="cashier_number" associateName="cashier.number" alias="出纳用户名" dataType="STRING" hideInDataModeling="false" />
				<Property name="cashier_name" associateName="cashier.name" alias="出纳" dataType="STRING" hideInDataModeling="false" />
				<Property name="creditLocalAmt" associateName="creditLocalAmt" alias="折授信币别金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="cautionAmt" associateName="cautionAmt" alias="保证金" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="intFeeAcctView_name" associateName="intFeeAcctView.name" alias="利息费用科目" dataType="STRING" hideInDataModeling="false" />
				<Property name="cautionAcctBank_name" associateName="cautionAcctBank.name" alias="保证金帐户" dataType="STRING" hideInDataModeling="false" />
				<Property name="auctionPerc" associateName="auctionPerc" alias="保证金比例" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="intFeeAcctView_id" associateName="intFeeAcctView.id" alias="利息费用科目id" dataType="STRING" hideInDataModeling="false" />
				<Property name="cautionAcctBank_id" associateName="cautionAcctBank.id" alias="保证金帐户id" dataType="STRING" hideInDataModeling="false" />
				<Property name="voucherType_name" associateName="voucherType.name" alias="名称2" dataType="STRING" hideInDataModeling="false" />
				<Property name="voucherType_id" associateName="voucherType.id" alias="凭证类型" dataType="STRING" hideInDataModeling="false" />
				<Property name="voucherNumber" associateName="voucherNumber" alias="凭证号" dataType="STRING" hideInDataModeling="false" />
				<Property name="fiVouchered" associateName="fiVouchered" alias="是否生成凭证" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="isGenRecBill" associateName="isGenRecBill" alias="是否生成收款单" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="CreditCurExRate" associateName="CreditCurExRate" alias="折授信币别汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CreditCurrency_name" associateName="CreditCurrency.name" alias="授信币别" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditCurrency_id" associateName="CreditCurrency.id" alias="授信币别id" dataType="STRING" hideInDataModeling="false" />
				<Property name="repaymentSource" associateName="repaymentSource" alias="还款来源" dataType="STRING" hideInDataModeling="false" />
				<Property name="outBgItemId" associateName="outBgItemId" alias="预算项目Id" dataType="STRING" hideInDataModeling="false" />
				<Property name="outBgItemName" associateName="outBgItemName" alias="预算项目名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="outBgItemNumber" associateName="outBgItemNumber" alias="预算项目编码" dataType="STRING" hideInDataModeling="false" />
				<Property name="fpItem_name" associateName="fpItem.name" alias="计划项目" dataType="STRING" hideInDataModeling="false" />
				<Property name="intFreeAmt" associateName="intFreeAmt" alias="免息额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="convertDays" associateName="convertDays" alias="折算天数1" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="365" value="365天/年" />
						<Enum key="360" value="360天/年" />
					</Enums>
				</Property>
				<Property name="punishIntRateType" associateName="punishIntRateType" alias="罚息方式1" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="addRate" value="加息" />
						<Enum key="addPoint" value="加点" />
					</Enums>
				</Property>
				<Property name="punishIntRate" associateName="punishIntRate" alias="罚息率日加息率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="purpose" associateName="purpose" alias="用途" dataType="STRING" hideInDataModeling="false" />
				<Property name="lastIntDate" associateName="lastIntDate" alias="上次结息日" dataType="DATE" hideInDataModeling="false" />
				<Property name="lastPreIntDate" associateName="lastPreIntDate" alias="上次预提日" dataType="DATE" hideInDataModeling="false" />
				<Property name="cautionAmtRepay" associateName="cautionAmtRepay" alias="已经归还的保证金" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="Region" associateName="Region" alias="境内外" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="中国大陆" />
						<Enum key="2" value="境外" />
						<Enum key="3" value="港澳台" />
					</Enums>
				</Property>
				<Property name="useAssureBill" associateName="useAssureBill" alias="使用担保" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="assExRate" associateName="assExRate" alias="担保币别汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="guaranteeTypeInputMode" associateName="guaranteeTypeInputMode" alias="保证方式的录入方式" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="保证" />
						<Enum key="2" value="抵押" />
						<Enum key="3" value="质押" />
						<Enum key="4" value="信用" />
						<Enum key="5" value="其它" />
						<Enum key="6" value="混合" />
						<Enum key="7" value="无担保" />
					</Enums>
				</Property>
				<Property name="isRelBankInCredit" associateName="isRelBankInCredit" alias="银行是否关联授信额度" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="hasEffected" associateName="hasEffected" alias="是否曾经生效" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="sourceBillId" associateName="sourceBillId" alias="原始单据ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="sourceFunction" associateName="sourceFunction" alias="来源功能" dataType="STRING" hideInDataModeling="false" />
				<Property name="createTime" associateName="createTime" alias="创建时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="lastUpdateTime" associateName="lastUpdateTime" alias="最后修改时间" dataType="DATETIME" hideInDataModeling="false" />
				<Property name="CreditLimit_Guarantee" associateName="CreditLimit.Guarantee" alias="保证人抵质押物名称" dataType="STRING" hideInDataModeling="false" />
				<Property name="costCenter_name" associateName="costCenter.name" alias="成本中心" dataType="STRING" hideInDataModeling="false" />
				<Property name="SettlementAcct_name" associateName="SettlementAcct.name" alias="结算科目" dataType="STRING" hideInDataModeling="false" />
				<Property name="SettlementAcct_number" associateName="SettlementAcct.number" alias="结算科目编码" dataType="STRING" hideInDataModeling="false" />
				<Property name="SettlementAcct_id" associateName="SettlementAcct.id" alias="结算科目ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="seqMulCon" associateName="seqMulCon" alias="发放序号" dataType="INT" format="#,##0" hideInDataModeling="false" />
				<Property name="mainConLoan_startDate" associateName="mainConLoan.startDate" alias="合同开始日" dataType="DATE" hideInDataModeling="false" />
				<Property name="mainConLoan_endDate" associateName="mainConLoan.endDate" alias="合同结束日" dataType="DATE" hideInDataModeling="false" />
				<Property name="mainConLoan_conAmount" associateName="mainConLoan.conAmount" alias="合同总金额" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="auditor_name" associateName="auditor.name" alias="审批人姓名" dataType="STRING" hideInDataModeling="false" />
				<Property name="isLPR" associateName="isLPR" alias="是否LPR利率转换" dataType="BOOLEAN" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="Balance" compare="GREATER" value="0" lb="1" rb="1" logic="AND" compareType="APPOINTED" />
				<Item property="ExpiredDate" compare="RELATIVE_DATE_RANGE" mode="SystemVar" lb="1" rb="1" compareType="APPOINTED">
					<RelativeDateRange period="Day" fromNowOn="7" upToNow="false" />
				</Item>
			</Filters>
		</Entity>
		<Entity name="CreditLimitQuery" alias="授信额度1" associateName="com.kingdee.eas.fm.fin.app.CreditLimitQuery" directModel="false" source="s1624604807537">
			<Properties>
				<Property name="id" associateName="id" alias="ID" dataType="STRING" hideInDataModeling="false" />
				<Property name="IsBankCredit" associateName="IsBankCredit" alias="是否银行授信" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="非银行授信" />
						<Enum key="1" value="银行授信" />
						<Enum key="2" value="内部授信" />
					</Enums>
				</Property>
				<Property name="Region" associateName="Region" alias="境内_外" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="中国大陆" />
						<Enum key="2" value="境外" />
						<Enum key="3" value="港澳台" />
					</Enums>
				</Property>
				<Property name="Property" associateName="Property" alias="额度性质" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="循环" />
						<Enum key="2" value="非循环" />
					</Enums>
				</Property>
				<Property name="QuotaAmount" associateName="QuotaAmount" alias="总额度" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="UsedAmount" associateName="UsedAmount" alias="已使用额度" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="Balance" associateName="Balance" alias="剩余额度" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ExchangeRate" associateName="ExchangeRate" alias="汇率" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="IssueDate" associateName="IssueDate" alias="开始时间" dataType="DATE" hideInDataModeling="false" />
				<Property name="ExpiredDate" associateName="ExpiredDate" alias="结束时间" dataType="DATE" hideInDataModeling="false" />
				<Property name="CreditHorizon" associateName="CreditHorizon" alias="期限" dataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ShareType" associateName="ShareType" alias="共享方式" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="总额共享" />
						<Enum key="2" value="按金额共享" />
						<Enum key="3" value="自用" />
					</Enums>
				</Property>
				<Property name="IsClosed" associateName="IsClosed" alias="是否关闭" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="number" associateName="number" alias="合同号" dataType="STRING" hideInDataModeling="false" />
				<Property name="bizDate" associateName="bizDate" alias="录入日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="description" associateName="description" alias="参考信息" dataType="STRING" hideInDataModeling="false" />
				<Property name="company_name" associateName="company.name" alias="公司" dataType="STRING" hideInDataModeling="false" />
				<Property name="Remark" associateName="Remark" alias="备注" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditLimitStat" associateName="CreditLimitStat" alias="状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="未生效" />
						<Enum key="2" value="正常" />
						<Enum key="3" value="过期" />
					</Enums>
				</Property>
				<Property name="CreditInstitution_name" associateName="CreditInstitution.name" alias="授信机构" dataType="STRING" hideInDataModeling="false" />
				<Property name="Currency_id" associateName="Currency.id" alias="币别" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditInstitution_id" associateName="CreditInstitution.id" alias="授信机构id" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditInstitution_number" associateName="CreditInstitution.number" alias="编码" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditUsage_id" associateName="CreditUsage.id" alias="授信用途" dataType="STRING" hideInDataModeling="false" />
				<Property name="Currency_name" associateName="Currency.name" alias="币别1" dataType="STRING" hideInDataModeling="false" />
				<Property name="IsPromises" associateName="IsPromises" alias="是否承诺型" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="否" />
						<Enum key="1" value="是" />
					</Enums>
				</Property>
				<Property name="NewState" associateName="NewState" alias="新状态" dataType="INT" format="#,##0" hideInDataModeling="false" />
				<Property name="IsUnion" associateName="IsUnion" alias="是否纳入新增" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="guaranteeTypeInputMode" associateName="guaranteeTypeInputMode" alias="保证方式的录入方式" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="1" value="保证" />
						<Enum key="2" value="抵押" />
						<Enum key="3" value="质押" />
						<Enum key="4" value="信用" />
						<Enum key="5" value="其它" />
						<Enum key="6" value="混合" />
						<Enum key="7" value="无担保" />
					</Enums>
				</Property>
				<Property name="GuaranteeType_name" associateName="GuaranteeType.name" alias="主担保方式" dataType="STRING" hideInDataModeling="false" />
				<Property name="GuaranteeType_id" associateName="GuaranteeType.id" alias="主担保方式1" dataType="STRING" hideInDataModeling="false" />
				<Property name="project_name" associateName="project.name" alias="项目" dataType="STRING" hideInDataModeling="false" />
				<Property name="project_id" associateName="project.id" alias="项目1" dataType="STRING" hideInDataModeling="false" />
				<Property name="creditCompany_name" associateName="creditCompany.name" alias="授信机构财务组织" dataType="STRING" hideInDataModeling="false" />
				<Property name="creditCompany_id" associateName="creditCompany.id" alias="ID1" dataType="STRING" hideInDataModeling="false" />
				<Property name="CreditUsage_name" associateName="CreditUsage.name" alias="授信用途1" dataType="STRING" hideInDataModeling="false" />
				<Property name="deferDay" associateName="deferDay" alias="延期天数" dataType="INT" format="#,##0" hideInDataModeling="false" />
				<Property name="creditCloseDate" associateName="creditCloseDate" alias="授信关闭日期" dataType="DATE" hideInDataModeling="false" />
				<Property name="isGroupCredit" associateName="isGroupCredit" alias="是否集团授信" dataType="BOOLEAN" hideInDataModeling="false" />
				<Property name="billStatus" associateName="billStatus" alias="单据状态" dataType="STRING" hideInDataModeling="false">
					<Enums>
						<Enum key="0" value="已提交" />
						<Enum key="1" value="已审批" />
					</Enums>
				</Property>
				<Property name="supplier_id" associateName="supplier.id" alias="供应商" dataType="STRING" hideInDataModeling="false" />
				<Property name="supplier_name" associateName="supplier.name" alias="供应商名称" dataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="Balance" compare="GREATER" value="0" lb="1" rb="1" logic="AND" compareType="APPOINTED" />
				<Item property="ExpiredDate" compare="RELATIVE_DATE_RANGE" mode="SystemVar" lb="1" rb="1" compareType="APPOINTED">
					<RelativeDateRange period="Day" fromNowOn="7" upToNow="false" />
				</Item>
			</Filters>
		</Entity>
		<Entity name="dm1630579740855" alias="授信额度" associateName="dm1630579740855" directModel="false" source="s1630579720874">
			<Properties>
				<Property name="ID" associateName="ID" alias="ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISBANKCREDIT" associateName="ISBANKCREDIT" alias="是否银行授信" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="REGION" associateName="REGION" alias="境内_外" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PROPERTY" associateName="PROPERTY" alias="额度性质" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="QUOTAAMOUNT" associateName="QUOTAAMOUNT" alias="总额度" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="USEDAMOUNT" associateName="USEDAMOUNT" alias="已使用额度" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BALANCE" associateName="BALANCE" alias="剩余额度" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="EXCHANGERATE" associateName="EXCHANGERATE" alias="汇率" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISSUEDATE" associateName="ISSUEDATE" alias="开始时间" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="EXPIREDDATE" associateName="EXPIREDDATE" alias="结束时间" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="CREDITHORIZON" associateName="CREDITHORIZON" alias="期限" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="SHARETYPE" associateName="SHARETYPE" alias="共享方式" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISCLOSED" associateName="ISCLOSED" alias="是否关闭" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="NUMBER" associateName="NUMBER" alias="合同号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BIZDATE" associateName="BIZDATE" alias="录入日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="DESCRIPTION" associateName="DESCRIPTION" alias="参考信息" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANY_NAME" associateName="COMPANY.NAME" alias="公司" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="REMARK" associateName="REMARK" alias="备注" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITLIMITSTAT" associateName="CREDITLIMITSTAT" alias="状态" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITINSTITUTION_NAME" associateName="CREDITINSTITUTION.NAME" alias="授信机构" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_ID" associateName="CURRENCY.ID" alias="币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITINSTITUTION_ID" associateName="CREDITINSTITUTION.ID" alias="授信机构id" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITINSTITUTION_NUMBER" associateName="CREDITINSTITUTION.NUMBER" alias="编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITUSAGE_ID" associateName="CREDITUSAGE.ID" alias="授信用途" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_NAME" associateName="CURRENCY.NAME" alias="币别1" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISPROMISES" associateName="ISPROMISES" alias="是否承诺型" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="NEWSTATE" associateName="NEWSTATE" alias="新状态" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISUNION" associateName="ISUNION" alias="是否纳入新增" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="GUARANTEETYPEINPUTMODE" associateName="GUARANTEETYPEINPUTMODE" alias="保证方式的录入方式" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="GUARANTEETYPE_NAME" associateName="GUARANTEETYPE.NAME" alias="主担保方式" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="GUARANTEETYPE_ID" associateName="GUARANTEETYPE.ID" alias="主担保方式1" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PROJECT_NAME" associateName="PROJECT.NAME" alias="项目" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PROJECT_ID" associateName="PROJECT.ID" alias="项目1" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITCOMPANY_NAME" associateName="CREDITCOMPANY.NAME" alias="授信机构财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITCOMPANY_ID" associateName="CREDITCOMPANY.ID" alias="ID1" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITUSAGE_NAME" associateName="CREDITUSAGE.NAME" alias="授信用途1" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="DEFERDAY" associateName="DEFERDAY" alias="延期天数" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITCLOSEDATE" associateName="CREDITCLOSEDATE" alias="授信关闭日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="ISGROUPCREDIT" associateName="ISGROUPCREDIT" alias="是否集团授信" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BILLSTATUS" associateName="BILLSTATUS" alias="单据状态" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="SUPPLIER_ID" associateName="SUPPLIER.ID" alias="供应商" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SUPPLIER_NAME" associateName="SUPPLIER.NAME" alias="供应商名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="BALANCE" compare="GREATER" value="0" lb="1" rb="1" logic="AND" compareType="APPOINTED" />
				<Item property="EXPIREDDATE" compare="RELATIVE_DATE_RANGE" mode="SystemVar" lb="1" rb="1" compareType="APPOINTED">
					<RelativeDateRange period="Day" fromNowOn="6" upToNow="false" />
				</Item>
			</Filters>
		</Entity>
		<Entity name="dm1630580281743" alias="借款" associateName="dm1630580281743" directModel="false" source="s1630579720874">
			<Properties>
				<Property name="AMOUNT" associateName="AMOUNT" alias="借款金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BALANCE" associateName="BALANCE" alias="借款余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="LOCALCUREXRATE" associateName="LOCALCUREXRATE" alias="折本位币汇率" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="USEDQUOTA" associateName="USEDQUOTA" alias="申请额度" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISSUEDATE" associateName="ISSUEDATE" alias="起始日" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="EXPIREDDATE" associateName="EXPIREDDATE" alias="到期日" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="HORIZON" associateName="HORIZON" alias="期限" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="REMARK" associateName="REMARK" alias="借款用途" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="GARANTEE" associateName="GARANTEE" alias="保证人_抵_质_押物名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="AMOUNTLOCALCUR" associateName="AMOUNTLOCALCUR" alias="折本位币" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="NUMBER" associateName="NUMBER" alias="单据编号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BIZDATE" associateName="BIZDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="ID" associateName="ID" alias="ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_NAME" associateName="CURRENCY.NAME" alias="币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="TYPE_NAME" associateName="TYPE.NAME" alias="融资品种" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SOURCE_NAME" associateName="SOURCE.NAME" alias="融资来源" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANY_NAME" associateName="COMPANY.NAME" alias="公司" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISBANKLOAN" associateName="ISBANKLOAN" alias="是否银行借款" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITORGROUP_NAME" associateName="CREDITORGROUP.NAME" alias="融资形式" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BANKACCT_BANKACCOUNTNUMBER" associateName="BANKACCT.BANKACCOUNTNUMBER" alias="银行账户" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="LOANACCT_NAME" associateName="LOANACCT.NAME" alias="贷款科目" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="YIELDRATE" associateName="YIELDRATE" alias="实际年利率" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="REPAYMENTTYPE" associateName="REPAYMENTTYPE" alias="还款方式" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="INTRATETYPE_NAME" associateName="INTRATETYPE.NAME" alias="利率类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="INSTITUTION_NAME" associateName="INSTITUTION.NAME" alias="债权人" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_ID" associateName="CURRENCY.ID" alias="币别id" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="TYPE_NUMBER" associateName="TYPE.NUMBER" alias="融资品种编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="TYPE_ID" associateName="TYPE.ID" alias="融资品种id" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SOURCE_NUMBER" associateName="SOURCE.NUMBER" alias="编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SOURCE_ID" associateName="SOURCE.ID" alias="SOURCE_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="INSTITUTION_NUMBER" associateName="INSTITUTION.NUMBER" alias="INSTITUTION_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="INSTITUTION_ID" associateName="INSTITUTION.ID" alias="INSTITUTION_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="INTRATETYPE_NUMBER" associateName="INTRATETYPE.NUMBER" alias="INTRATETYPE_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="INTRATETYPE_ID" associateName="INTRATETYPE.ID" alias="INTRATETYPE_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="LOANACCT_NUMBER" associateName="LOANACCT.NUMBER" alias="LOANACCT_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="LOANACCT_ID" associateName="LOANACCT.ID" alias="LOANACCT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BANKACCT_NAME" associateName="BANKACCT.NAME" alias="BANKACCT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BANKACCT_NUMBER" associateName="BANKACCT.NUMBER" alias="BANKACCT_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BANKACCT_ID" associateName="BANKACCT.ID" alias="BANKACCT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="DESCRIPTION" associateName="DESCRIPTION" alias="DESCRIPTION" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISINCREDIT" associateName="ISINCREDIT" alias="ISINCREDIT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITLIMIT_NUMBER" associateName="CREDITLIMIT.NUMBER" alias="CREDITLIMIT_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITLIMIT_ID" associateName="CREDITLIMIT.ID" alias="CREDITLIMIT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="APPLICATIONRULE" associateName="APPLICATIONRULE" alias="APPLICATIONRULE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BASEPOINTS" associateName="BASEPOINTS" alias="BASEPOINTS" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="GROUPID_NAME" associateName="GROUPID.NAME" alias="GROUPID_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISGROUPLOAN" associateName="ISGROUPLOAN" alias="ISGROUPLOAN" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ACCOUNTANT_NAME" associateName="ACCOUNTANT.NAME" alias="ACCOUNTANT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCOUNTANT_ID" associateName="ACCOUNTANT.ID" alias="ACCOUNTANT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="HISTORYBILL" associateName="HISTORYBILL" alias="HISTORYBILL" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PENACCRUALTYPE" associateName="PENACCRUALTYPE" alias="PENACCRUALTYPE" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PENACCRUALRATE" associateName="PENACCRUALRATE" alias="PENACCRUALRATE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISOVERDUE" associateName="ISOVERDUE" alias="ISOVERDUE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="INTRATETYPEEXPRESSION" associateName="INTRATETYPEEXPRESSION" alias="INTRATETYPEEXPRESSION" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="YEARDAYS" associateName="YEARDAYS" alias="YEARDAYS" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREATOR_NAME" associateName="CREATOR.NAME" alias="CREATOR_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CONTRACTNUM" associateName="CONTRACTNUM" alias="CONTRACTNUM" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISMULCON" associateName="ISMULCON" alias="ISMULCON" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="SEQMULCON" associateName="SEQMULCON" alias="SEQMULCON" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PROJECT_NAME" associateName="PROJECT.NAME" alias="PROJECT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="GARANTEETYPE_NAME" associateName="GARANTEETYPE.NAME" alias="GARANTEETYPE_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PAYINTMODE_NAME" associateName="PAYINTMODE.NAME" alias="PAYINTMODE_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FLOATACTION" associateName="FLOATACTION" alias="FLOATACTION" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="RATEADJUSTPERIOD" associateName="RATEADJUSTPERIOD" alias="RATEADJUSTPERIOD" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FIRSTRATEADJUSTDATE" associateName="FIRSTRATEADJUSTDATE" alias="FIRSTRATEADJUSTDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="STATUS" associateName="STATUS" alias="STATUS" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="HANDLERREMARK" associateName="HANDLERREMARK" alias="HANDLERREMARK" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ENTLOANID_ID" associateName="ENTLOANID.ID" alias="ENTLOANID_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CASHIER_NUMBER" associateName="CASHIER.NUMBER" alias="CASHIER_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CASHIER_NAME" associateName="CASHIER.NAME" alias="CASHIER_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CASHIER_ID" associateName="CASHIER.ID" alias="CASHIER_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITLOCALAMT" associateName="CREDITLOCALAMT" alias="CREDITLOCALAMT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CAUTIONAMT" associateName="CAUTIONAMT" alias="CAUTIONAMT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="INTFEEACCTVIEW_NAME" associateName="INTFEEACCTVIEW.NAME" alias="INTFEEACCTVIEW_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CAUTIONACCTBANK_NAME" associateName="CAUTIONACCTBANK.NAME" alias="CAUTIONACCTBANK_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="AUCTIONPERC" associateName="AUCTIONPERC" alias="AUCTIONPERC" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="INTFEEACCTVIEW_ID" associateName="INTFEEACCTVIEW.ID" alias="INTFEEACCTVIEW_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CAUTIONACCTBANK_ID" associateName="CAUTIONACCTBANK.ID" alias="CAUTIONACCTBANK_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="VOUCHERTYPE_NAME" associateName="VOUCHERTYPE.NAME" alias="VOUCHERTYPE_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="VOUCHERTYPE_ID" associateName="VOUCHERTYPE.ID" alias="VOUCHERTYPE_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="VOUCHERNUMBER" associateName="VOUCHERNUMBER" alias="VOUCHERNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FIVOUCHERED" associateName="FIVOUCHERED" alias="FIVOUCHERED" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISGENRECBILL" associateName="ISGENRECBILL" alias="ISGENRECBILL" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITCUREXRATE" associateName="CREDITCUREXRATE" alias="CREDITCUREXRATE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITCURRENCY_NAME" associateName="CREDITCURRENCY.NAME" alias="CREDITCURRENCY_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITCURRENCY_ID" associateName="CREDITCURRENCY.ID" alias="CREDITCURRENCY_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="REPAYMENTSOURCE" associateName="REPAYMENTSOURCE" alias="REPAYMENTSOURCE" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OUTBGITEMID" associateName="OUTBGITEMID" alias="OUTBGITEMID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OUTBGITEMNAME" associateName="OUTBGITEMNAME" alias="OUTBGITEMNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OUTBGITEMNUMBER" associateName="OUTBGITEMNUMBER" alias="OUTBGITEMNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FPITEM_NAME" associateName="FPITEM.NAME" alias="FPITEM_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="DEPOSITARY_NAME" associateName="DEPOSITARY.NAME" alias="DEPOSITARY_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COSTCENTER_NAME" associateName="COSTCENTER.NAME" alias="COSTCENTER_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SETTLEMENTACCT_NAME" associateName="SETTLEMENTACCT.NAME" alias="SETTLEMENTACCT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SETTLEMENTACCT_NUMBER" associateName="SETTLEMENTACCT.NUMBER" alias="SETTLEMENTACCT_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SETTLEMENTACCT_ID" associateName="SETTLEMENTACCT.ID" alias="SETTLEMENTACCT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="AUDITOR_NAME" associateName="AUDITOR.NAME" alias="AUDITOR_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="LASTINTDATE" associateName="LASTINTDATE" alias="LASTINTDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="COMPANY_ID" associateName="COMPANY.ID" alias="COMPANY_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FUNDFLOWITEM_NAME" associateName="FUNDFLOWITEM.NAME" alias="FUNDFLOWITEM_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FUNDFLOWITEM_NUMBER" associateName="FUNDFLOWITEM.NUMBER" alias="FUNDFLOWITEM_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FUNDFLOWITEM_ID" associateName="FUNDFLOWITEM.ID" alias="FUNDFLOWITEM_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="BALANCE" compare="GREATER" value="0" lb="1" rb="1" logic="AND" compareType="APPOINTED" />
				<Item property="EXPIREDDATE" compare="RELATIVE_DATE_RANGE" mode="SystemVar" lb="1" rb="1" compareType="APPOINTED">
					<RelativeDateRange period="Day" fromNowOn="6" upToNow="false" />
				</Item>
			</Filters>
		</Entity>
		<Entity name="dm1630982140899" alias="应付票据" associateName="dm1630982140899" directModel="false" source="s1630579720874">
			<Properties>
				<Property name="COMPANY_ID" associateName="COMPANY.ID" alias="COMPANY_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANY_NAME" associateName="COMPANY.NAME" alias="公司" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="APPLYUNIT_ID" associateName="APPLYUNIT.ID" alias="APPLYUNIT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="APPLYUNIT_NAME" associateName="APPLYUNIT.NAME" alias="APPLYUNIT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BILLSTATE" associateName="BILLSTATE" alias="BILLSTATE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="RETURNOPTION" associateName="RETURNOPTION" alias="RETURNOPTION" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="MAKETYPE" associateName="MAKETYPE" alias="MAKETYPE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="HISTORYBILL" associateName="HISTORYBILL" alias="HISTORYBILL" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISSUEDATE" associateName="ISSUEDATE" alias="ISSUEDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="ACCEPTDATE" associateName="ACCEPTDATE" alias="ACCEPTDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="EXPIREDDATE" associateName="EXPIREDDATE" alias="到期日" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="BILLMAKERNAME" associateName="BILLMAKERNAME" alias="BILLMAKERNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OUTBANKACCOUNTNAME" associateName="OUTBANKACCOUNTNAME" alias="OUTBANKACCOUNTNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="INSTITUTION_ID" associateName="INSTITUTION.ID" alias="INSTITUTION_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="INSTITUTION_NAME" associateName="INSTITUTION.NAME" alias="债权人名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PAYEENAME" associateName="PAYEENAME" alias="PAYEENAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PAYEEACCOUNTNAME" associateName="PAYEEACCOUNTNAME" alias="PAYEEACCOUNTNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PAYEEBANKNAME" associateName="PAYEEBANKNAME" alias="PAYEEBANKNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_ID" associateName="CURRENCY.ID" alias="CURRENCY_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_NAME" associateName="CURRENCY.NAME" alias="币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="AMOUNT" associateName="AMOUNT" alias="金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="AMOUNTLOCALCUR" associateName="AMOUNTLOCALCUR" alias="AMOUNTLOCALCUR" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="LOCALCUREXRATE" associateName="LOCALCUREXRATE" alias="LOCALCUREXRATE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ASSUREPROPORTION" associateName="ASSUREPROPORTION" alias="ASSUREPROPORTION" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ASSUREAMOUNT" associateName="ASSUREAMOUNT" alias="ASSUREAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BALANCE" associateName="BALANCE" alias="BALANCE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CONTRACTNUMBER" associateName="CONTRACTNUMBER" alias="CONTRACTNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="HORIZON" associateName="HORIZON" alias="HORIZON" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="OPPACCOUNT_ID" associateName="OPPACCOUNT.ID" alias="OPPACCOUNT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OPPACCOUNT_NAME" associateName="OPPACCOUNT.NAME" alias="OPPACCOUNT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="GARANTEETYPE_NAME" associateName="GARANTEETYPE.NAME" alias="GARANTEETYPE_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="GUARANTEETYPEINPUTMODE" associateName="GUARANTEETYPEINPUTMODE" alias="GUARANTEETYPEINPUTMODE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BLOCKFLOWTYPE_ID" associateName="BLOCKFLOWTYPE.ID" alias="BLOCKFLOWTYPE_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BLOCKFLOWTYPE_NAME" associateName="BLOCKFLOWTYPE.NAME" alias="BLOCKFLOWTYPE_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ADMINORGUNIT_ID" associateName="ADMINORGUNIT.ID" alias="ADMINORGUNIT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ADMINORGUNIT_NAME" associateName="ADMINORGUNIT.NAME" alias="ADMINORGUNIT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PERSON_ID" associateName="PERSON.ID" alias="PERSON_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PERSON_NAME" associateName="PERSON.NAME" alias="PERSON_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="REMARK" associateName="REMARK" alias="REMARK" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISSUEUNIT" associateName="ISSUEUNIT" alias="ISSUEUNIT" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="DIGEST" associateName="DIGEST" alias="DIGEST" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BUYERPAYDISCNT" associateName="BUYERPAYDISCNT" alias="BUYERPAYDISCNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="DISCOUNTDATE" associateName="DISCOUNTDATE" alias="DISCOUNTDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="DISCOUNTRATE" associateName="DISCOUNTRATE" alias="DISCOUNTRATE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="DISCOUNT" associateName="DISCOUNT" alias="DISCOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISINCREDIT" associateName="ISINCREDIT" alias="ISINCREDIT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITLIMIT_ID" associateName="CREDITLIMIT.ID" alias="CREDITLIMIT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITCUREXRATE" associateName="CREDITCUREXRATE" alias="CREDITCUREXRATE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BIZDATE" associateName="BIZDATE" alias="BIZDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FIVOUCHERED" associateName="FIVOUCHERED" alias="FIVOUCHERED" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREATOR_ID" associateName="CREATOR.ID" alias="CREATOR_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREATOR_NAME" associateName="CREATOR.NAME" alias="CREATOR_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREATETIME" associateName="CREATETIME" alias="CREATETIME" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="TRANSFERDATE" associateName="TRANSFERDATE" alias="TRANSFERDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="USEDQUOTA" associateName="USEDQUOTA" alias="USEDQUOTA" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="REGION" associateName="REGION" alias="REGION" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="NUMBER" associateName="NUMBER" alias="单据编号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ID" associateName="ID" alias="ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CREDITLIMIT_NUMBER" associateName="CREDITLIMIT.NUMBER" alias="CREDITLIMIT_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="GARANTEE" associateName="GARANTEE" alias="GARANTEE" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SOURCE_NAME" associateName="SOURCE.NAME" alias="SOURCE_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_NUMBER" associateName="CURRENCY.NUMBER" alias="CURRENCY_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SOURCE_NUMBER" associateName="SOURCE.NUMBER" alias="SOURCE_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SOURCE_ID" associateName="SOURCE.ID" alias="SOURCE_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BLOCKFLOWTYPE_NUMBER" associateName="BLOCKFLOWTYPE.NUMBER" alias="BLOCKFLOWTYPE_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="INSTITUTION_NUMBER" associateName="INSTITUTION.NUMBER" alias="INSTITUTION_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CONFIRMER_NAME" associateName="CONFIRMER.NAME" alias="CONFIRMER_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PAYABLEBILL_PROPORTION" associateName="PAYABLEBILL.PROPORTION" alias="PAYABLEBILL_PROPORTION" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ORIASSUREAMOUNT" associateName="ORIASSUREAMOUNT" alias="ORIASSUREAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PAYABLEBILL_ASSUREAMOUNT" associateName="PAYABLEBILL.ASSUREAMOUNT" alias="PAYABLEBILL_ASSUREAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PAYABLEBILL_HISTORYBILL" associateName="PAYABLEBILL.HISTORYBILL" alias="PAYABLEBILL_HISTORYBILL" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BILLACCOUNT_NAME" associateName="BILLACCOUNT.NAME" alias="BILLACCOUNT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BILLACCOUNT_ID" associateName="BILLACCOUNT.ID" alias="BILLACCOUNT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CONFIRMER_ID" associateName="CONFIRMER.ID" alias="CONFIRMER_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="AUDITOR_NAME" associateName="AUDITOR.NAME" alias="AUDITOR_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISTDPRINTED" associateName="ISTDPRINTED" alias="ISTDPRINTED" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="OUTBANKACCOUNT_BANKACCOUNTNU76" associateName="OUTBANKACCOUNT.BANKACCOUNTNU76" alias="OUTBANKACCOUNT_BANKACCOUNTNU76" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OUTBANKACCOUNT_NAME" associateName="OUTBANKACCOUNT.NAME" alias="OUTBANKACCOUNT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="NTTYPE_NAME" associateName="NTTYPE.NAME" alias="NTTYPE_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="NTTYPE_ID" associateName="NTTYPE.ID" alias="NTTYPE_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PAYMENTBILL_NUMBER" associateName="PAYMENTBILL.NUMBER" alias="PAYMENTBILL_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISAPPLY" associateName="ISAPPLY" alias="ISAPPLY" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="APPLYDATE" associateName="APPLYDATE" alias="APPLYDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="PERSONNAME" associateName="PERSONNAME" alias="PERSONNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="APPLYINFO" associateName="APPLYINFO" alias="APPLYINFO" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISACCEPT" associateName="ISACCEPT" alias="ISACCEPT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ACCOUNTANT_NAME" associateName="ACCOUNTANT.NAME" alias="ACCOUNTANT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OUTBGITEMID" associateName="OUTBGITEMID" alias="OUTBGITEMID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OUTBGITEMNAME" associateName="OUTBGITEMNAME" alias="OUTBGITEMNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OUTBGITEMNUMBER" associateName="OUTBGITEMNUMBER" alias="OUTBGITEMNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FUNDFLOWITEM_NAME" associateName="FUNDFLOWITEM.NAME" alias="FUNDFLOWITEM_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PROJECT_NUMBER" associateName="PROJECT.NUMBER" alias="PROJECT_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PROJECT_NAME" associateName="PROJECT.NAME" alias="PROJECT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BATCHNO" associateName="BATCHNO" alias="BATCHNO" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COSTCENTER_ID" associateName="COSTCENTER.ID" alias="COSTCENTER_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COSTCENTER_NAME" associateName="COSTCENTER.NAME" alias="COSTCENTER_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISACCEPTSUBMIT" associateName="ISACCEPTSUBMIT" alias="ISACCEPTSUBMIT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="DRAFTNUMBER" associateName="DRAFTNUMBER" alias="DRAFTNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCEPTOR" associateName="ACCEPTOR" alias="ACCEPTOR" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY2_NAME" associateName="CURRENCY2.NAME" alias="CURRENCY2_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY2_ID" associateName="CURRENCY2.ID" alias="CURRENCY2_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BILLMEDIUM" associateName="BILLMEDIUM" alias="BILLMEDIUM" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISCANTRANSFER" associateName="ISCANTRANSFER" alias="ISCANTRANSFER" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ACCEPTORACCOUNTNAME" associateName="ACCEPTORACCOUNTNAME" alias="ACCEPTORACCOUNTNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCEPTORBANKNUM" associateName="ACCEPTORBANKNUM" alias="ACCEPTORBANKNUM" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="DRAWERBANKNUMBER" associateName="DRAWERBANKNUMBER" alias="DRAWERBANKNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="PAYEEBANKNUMBER" associateName="PAYEEBANKNUMBER" alias="PAYEEBANKNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ELECBILLSTATUS" associateName="ELECBILLSTATUS" alias="ELECBILLSTATUS" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMMITTOBE" associateName="COMMITTOBE" alias="COMMITTOBE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BANKRETURNSTATUS" associateName="BANKRETURNSTATUS" alias="BANKRETURNSTATUS" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BANKRETURNINFO" associateName="BANKRETURNINFO" alias="BANKRETURNINFO" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCEPTORBANK_ID" associateName="ACCEPTORBANK.ID" alias="ACCEPTORBANK_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCEPTORBANK_NAME" associateName="ACCEPTORBANK.NAME" alias="ACCEPTORBANK_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="HORIZONTYPE" associateName="HORIZONTYPE" alias="HORIZONTYPE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="SOURCEBILLID" associateName="SOURCEBILLID" alias="SOURCEBILLID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISPREBILL" associateName="ISPREBILL" alias="ISPREBILL" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ABANDONDATE" associateName="ABANDONDATE" alias="ABANDONDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="ISBITBACK" associateName="ISBITBACK" alias="ISBITBACK" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="BALANCE" compare="GREATER" value="0" lb="1" rb="1" logic="AND" compareType="APPOINTED" />
				<Item property="EXPIREDDATE" compare="RELATIVE_DATE_RANGE" mode="SystemVar" lb="1" rb="1" compareType="APPOINTED">
					<RelativeDateRange period="Day" fromNowOn="6" upToNow="false" />
				</Item>
			</Filters>
		</Entity>
		<Entity name="dm1630982565980" alias="金融理财台账" associateName="dm1630982565980" directModel="false" source="s1630579720874">
			<Properties>
				<Property name="ID" associateName="ID" alias="ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="NUMBER" associateName="NUMBER" alias="单据编号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BIZDATE" associateName="BIZDATE" alias="BIZDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINANCEFINANCING_NAME" associateName="FINANCEFINANCING.NAME" alias="金融理财品种" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BANK_NAME" associateName="BANK.NAME" alias="金融机构" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCOUNTBANK_NAME" associateName="ACCOUNTBANK.NAME" alias="ACCOUNTBANK_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINANCINGPRONUMBER" associateName="FINANCINGPRONUMBER" alias="FINANCINGPRONUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINANCINGPRONAME" associateName="FINANCINGPRONAME" alias="FINANCINGPRONAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SALESIZE" associateName="SALESIZE" alias="SALESIZE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CURRENCY_NAME" associateName="CURRENCY.NAME" alias="币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="EXCHANGERATE" associateName="EXCHANGERATE" alias="EXCHANGERATE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FINANCEAMOUNT" associateName="FINANCEAMOUNT" alias="投资金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BEGINDATE" associateName="BEGINDATE" alias="BEGINDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="ENDDATE" associateName="ENDDATE" alias="投资到期日" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="TERM" associateName="TERM" alias="TERM" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CHANGEDATE" associateName="CHANGEDATE" alias="CHANGEDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="PREDICTYIELD" associateName="PREDICTYIELD" alias="PREDICTYIELD" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PREDICTWINAMOUNT" associateName="PREDICTWINAMOUNT" alias="PREDICTWINAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ISNOOUT" associateName="ISNOOUT" alias="ISNOOUT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="EARNTYPE" associateName="EARNTYPE" alias="EARNTYPE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="STATE" associateName="STATE" alias="STATE" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREATOR_NAME" associateName="CREATOR.NAME" alias="CREATOR_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANY_NAME" associateName="COMPANY.NAME" alias="公司" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_ID" associateName="CURRENCY.ID" alias="CURRENCY_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCY_PRECISION" associateName="CURRENCY.PRECISION" alias="CURRENCY_PRECISION" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PRACTICALWINAMOUNT" associateName="PRACTICALWINAMOUNT" alias="PRACTICALWINAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BALANCE" associateName="BALANCE" alias="余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FINANCELOCAMOUNT" associateName="FINANCELOCAMOUNT" alias="FINANCELOCAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="INTRATETYPEEXPRESSION" associateName="INTRATETYPEEXPRESSION" alias="INTRATETYPEEXPRESSION" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="DAYS" associateName="DAYS" alias="DAYS" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PREDICTWINLOCAMOUNT" associateName="PREDICTWINLOCAMOUNT" alias="PREDICTWINLOCAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BANK_ID" associateName="BANK.ID" alias="BANK_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANY_ID" associateName="COMPANY.ID" alias="COMPANY_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINANCEFINANCING_ID" associateName="FINANCEFINANCING.ID" alias="FINANCEFINANCING_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCOUNTBANK_ID" associateName="ACCOUNTBANK.ID" alias="ACCOUNTBANK_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ISGENEPAYBILL" associateName="ISGENEPAYBILL" alias="ISGENEPAYBILL" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="AUDITTIME" associateName="AUDITTIME" alias="AUDITTIME" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="ISBOOK" associateName="ISBOOK" alias="ISBOOK" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="AUDITOR_NAME" associateName="AUDITOR.NAME" alias="AUDITOR_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="SUMREDEEMAMOUNT" associateName="SUMREDEEMAMOUNT" alias="SUMREDEEMAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="PRACTICALWINLOCAMOUNT" associateName="PRACTICALWINLOCAMOUNT" alias="PRACTICALWINLOCAMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="ACCOUNTBANK_BANKACCOUNTNUMBER" associateName="ACCOUNTBANK.BANKACCOUNTNUMBER" alias="ACCOUNTBANK_BANKACCOUNTNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCOUNTANT_NUMBER" associateName="ACCOUNTANT.NUMBER" alias="ACCOUNTANT_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCOUNTANT_NAME" associateName="ACCOUNTANT.NAME" alias="ACCOUNTANT_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCOUNTANT_ID" associateName="ACCOUNTANT.ID" alias="ACCOUNTANT_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OPPACCOUNTVIEW_NAME" associateName="OPPACCOUNTVIEW.NAME" alias="OPPACCOUNTVIEW_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OPPACCOUNTVIEW_NUMBER" associateName="OPPACCOUNTVIEW.NUMBER" alias="OPPACCOUNTVIEW_NUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="OPPACCOUNTVIEW_ID" associateName="OPPACCOUNTVIEW.ID" alias="OPPACCOUNTVIEW_ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="VOUCHERTYPE_NAME" associateName="VOUCHERTYPE.NAME" alias="VOUCHERTYPE_NAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="VOUCHERNUMBER" associateName="VOUCHERNUMBER" alias="VOUCHERNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FIVOUCHERED" associateName="FIVOUCHERED" alias="FIVOUCHERED" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="BALANCE" compare="GREATER" value="0" lb="1" rb="1" logic="AND" compareType="APPOINTED" />
				<Item property="ENDDATE" compare="RELATIVE_DATE_RANGE" mode="SystemVar" lb="1" rb="1" compareType="APPOINTED">
					<RelativeDateRange period="Day" fromNowOn="6" upToNow="false" />
				</Item>
			</Filters>
		</Entity>
	</Entities>
	<Relations>
		<Relation fromEntity="PayableBill" fromProperty="id" toEntity="GuaranteeDetail_1" toProperty="parentBillId" related="1-n" keepFifthWheel="1" />
	</Relations>
	<UnionEntityInnerRelations />
</Data>