<Data version="20170616">
	<Sources>
		<BizMetaSource name="s1657675845796" bizMetaType="EASDBCenter" dbCenterId="SP1UPDBC860TEST" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1657675875260" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FTaxAmtTotal,FAmountTaxTotal
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'1' then N'增值税电子普通发票'
	  when N'2' then N'增值税电子专用发票'
	  when N'3' then N'增值税普通发票'
	  when N'4' then N'增值税专用发票'
	  when N'5' then N'增值税普通发票（卷票）'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTax,0) as FTaxAmtTotal,
	isnull(invoice.FAmountTax,0) as FAmountTaxTotal	
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid

	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'26' then N'全电普票'
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费电子发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'7' then N'通用机打发票'
	  when N'17' then N'过路过桥费'
	  when N'23' then N'通用机打电子发票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_MachineInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'8' then N'的士票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TaxiInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'9' then N'火车票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TrainInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'10' then N'飞机票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_PlaneInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'11' then N'其他发票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_OtherInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'13' then N'二手车票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_SecondHandCarInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'14' then N'定额发票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_QuotaInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'16' then N'客运票'
	  when N'20' then N'轮船票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_ShipInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'19' then N'完税证明'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_PurchaseInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'24' then N'火车票退票凭证'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TrainRefundVoucher as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'25' then N'财政电子票据'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_FinancialInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'f854b40f-22ef-4c9f-87fc-79e9e55d81c7PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'f854b40f-22ef-4c9f-87fc-79e9e55d81c7PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'f854b40f-22ef-4c9f-87fc-79e9e55d81c7PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'f854b40f-22ef-4c9f-87fc-79e9e55d81c7PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
	</Sources>
	<ExtractSchedule dayAtMonthly="0" weekAtWeekly="1" time="75600" />
	<Entities>
		<Entity name="dm1657675875260" alias="收票趋势分析" associateName="dm1657675875260" directModel="false" source="s1657675845796">
			<Design x="10" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FAMOUNTTAXTOTAL" associateName="FAMOUNTTAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
	</Entities>
	<Relations />
	<UnionEntityInnerRelations />
</Data>