/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ksql.translator;

import com.kingdee.bos.ksql.pub.KSQLException;
import com.kingdee.bos.ksql.pub.StringCollection;
import com.kingdee.bos.ksql.translator.Automata;
import java.util.ArrayList;

public class Tokenizer {
    private final int NAME = 1;
    private final int SPECIAL = 2;
    private final int NUMBER = 3;
    private final int FLOAT = 4;
    private final int STRING = 5;
    private final int LONG = 6;
    private final int DATE = 7;
    private final int TIME = 8;
    private final int DATETIME = 9;
    private final int DATE_TIME_TIEMSTAMP = 10;
    private final int OLEDB_COMMAND_IDENTIFIER = 11;
    private final int TEMP_TABLE_IDENTIFIER = 12;
    private final int QUOTED_IDENTIFIER = 13;
    private final int REMARK_LINE = 14;
    private final int REMARK = 15;
    private final int ID_POINT = 16;
    private final int OLEDB_COMMAND_NAMED_PARAMETER = 17;
    private String sCommand;
    private int iLength;
    private int iIndex;
    private int iType;
    private String sToken;
    private String lex;
    private String additionalInfo;
    private boolean idpoint;
    private boolean bWait;
    private int lineNo;
    private boolean m_End;
    private StringCollection hKeyword;
    private String[] keyword = new String[]{"AND", "ALL", "AVG", "BY", "COUNT", "CASEWHEN", "DISTINCT", "EXISTS", "FALSE", "FROM", "GROUP", "INTO", "IS", "IN", "INTERSECT", "INNER", "LIKE", "MAX", "MIN", "NULL", "ON", "ORDER", "OR", "OUTER", "SELECT", "SET", "SUM", "TO", "UNIQUE", "UNION", "VALUES", "WHERE", "CAST", "CONCAT", "REPLACE", "MINUS", "CALL", "ACTION", "ADD", "ALLOCATE", "ALTER", "ARE", "AS", "ASC", "ASSERTION", "AUTHORIZATION", "BEGIN", "BIT", "BIT_LENGTH", "CASCADE", "CASCADED", "CASE", "CATALOG", "CHARACTER", "CHAR_LENGTH", "CHARACTER_LENGTH", "CHECK", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CORRESPONDING", "CREATE", "CROSS", "CURRENT", "CURRENT_TIME", "CURRENT_DATETIME", "CURRENT_USER", "CURSOR", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DOUBLE", "DROP", "ELSE", "END", "ESCAPE", "EXCEPTION", "EXEC", "EXECUTE", "EXTRACT", "FETCH", "FIRST", "FLOAT", "FOREIGN", "FOUND", "FULL", "GET", "GO", "GOTO", "GRANT", "HAVING", "IDENTITY", "IMMEDIATE", "INDICATOR", "INITIALLY", "INSENSITIVE", "INSERT", "INT", "INTEGER", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LEADING", "LEVEL", "LOCAL", "LOWER", "MINUTE", "MODULE", "MONTH", "NAMES", "NATURAL", "NCHAR", "NEXT", "NO", "NUMERIC", "OCTET_LENGTH", "OF", "ONLY", "OPTION", "OUTPUT", "OVERLAPS", "PAD", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECTION", "SESSION", "SESSION_USER", "SIZE", "SOME", "SPACE", "SQL", "SQLCODE", "SQLSTATE", "SUBSTRING", "SYSTEM_USER", "TABLE", "THEN", "TIME", "DATETIME", "TIMEZONE_HOUR", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USING", "VALUE", "VARCHAR", "NVARCHAR", "VARYING", "WHEN", "WHENEVER", "WITH", "WORK", "YEAR", "ZONE", "CHARINDEX", "TOP", "PERCENT", "TIES", "DESC", "LEFT", "RIGHT", "NOT", "BETWEEN", "ANY", "NULLIF", "ISNULL", "CONVERT", "CHAR", "CLOB", "NCLOB", "BLOB", "ABS", "CEILING", "COS", "EXP", "FLOOR", "LOG", "PI", "SIGN", "SIN", "SORT", "TAN", "LOG10", "ROUND", "MOD", "ASCII", "LCASE", "UCASE", "LTRIM", "RTRIM", "LENGTH", "NOW", "CURDATE", "CURTIME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "WEEK", "HOUR", "SECOND", "MONTHNAME", "DAYNAME", "QUARTER", "DATEADD", "YY", "QQ", "MM", "DY", "DD", "WK", "HH", "MI", "SS", "MS", "DATEDIFF", "USER_ID", "USER_NAME", "SQRT", "VIEW", "INDEX", "UNIQUE", "CONSTRAINT", "PRIMARY", "KEY", "FOREIGN", "REFERENCES", "DEFAULT", "CHECK", "CURRENT_USER", "USER", "SESSION_USER", "SYSTEM_USER", "BINARY", "VARBINARY"};

    public Tokenizer(String s) {
        this.sCommand = s;
        this.iLength = s.length();
        this.iIndex = 0;
        this.m_End = false;
        this.lineNo = 0;
        this.lex = "";
        this.additionalInfo = "";
        this.hKeyword = new StringCollection();
        this.hKeyword.addRange(this.keyword);
    }

    public String getSCommand() {
        return this.sCommand;
    }

    public void setSCommand(String sCommand) {
        this.sCommand = sCommand;
    }

    public int getILength() {
        return this.iLength;
    }

    public void setILength(int iLength) {
        this.iLength = iLength;
    }

    public int getIIndex() {
        return this.iIndex;
    }

    public void setIIndex(int iIndex) {
        this.iIndex = iIndex;
    }

    public boolean getEnd() {
        return this.m_End;
    }

    public void setEnd(boolean m_End) {
        this.m_End = m_End;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public String[] getKeyWord() {
        return this.keyword;
    }

    public void setKeyword(String[] keyword) {
        this.keyword = keyword;
    }

    public String getLex() {
        return this.lex.toUpperCase();
    }

    public void setLex(String lex) {
        this.lex = lex;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String addtionalInfo) {
        this.additionalInfo = addtionalInfo;
    }

    public String getSToken() {
        return this.sToken;
    }

    public void setSToken(String sToken) {
        this.sToken = sToken;
    }

    public int getIType() {
        return this.iType;
    }

    public void setIType(int iType) {
        this.iType = iType;
    }

    public void back() {
        this.bWait = true;
    }

    public void getThis(String match) throws KSQLException {
        this.getToken();
        if (!this.sToken.equals(match)) {
            throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(this.sToken))));
        }
    }

    public String getStringToken() throws KSQLException {
        this.getToken();
        String str = "";
        if (this.iType == 5) {
            str = this.sToken.substring(1).toUpperCase();
        } else if (this.iType == 1) {
            str = this.sToken;
        } else if (this.iType == 13) {
            str = this.sToken.toUpperCase();
        }
        return str;
    }

    public boolean wasValue() {
        if (this.iType == 5 || this.iType == 3 || this.iType == 4) {
            return true;
        }
        if (this.sToken.equals("NULL")) {
            return true;
        }
        return this.sToken.equals("TRUE") || this.sToken.equals("FALSE");
    }

    public boolean wasLongName() {
        return false;
    }

    public boolean wasName() {
        if (this.iType == 13) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !this.hKeyword.contains(this.sToken);
    }

    public String getName() throws KSQLException {
        this.getToken();
        if (!this.wasName()) {
            throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(this.sToken))));
        }
        return this.sToken;
    }

    public Object getAsValue() throws KSQLException {
        if (!this.wasValue()) {
            throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(this.sToken))));
        }
        if (this.iType == 5) {
            return this.sToken.substring(1);
        }
        if (this.sToken.equals("NULL")) {
            return null;
        }
        if (this.iType == 3) {
            if (this.sToken.length() > 9) {
                this.iType = 6;
                return new Long(this.sToken);
            }
            return new Integer(this.sToken);
        }
        if (this.iType == 4) {
            return new Float(this.sToken);
        }
        return this.sToken;
    }

    public int getPosition() {
        return this.iIndex;
    }

    public String getPart(int begin, int end) {
        return this.sCommand.substring(begin, end);
    }

    public void getKeywords(String s) {
        int i;
        ArrayList<String> scoll = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(s);
        if (sb != null) {
            for (int i2 = 0; i2 < sb.length(); ++i2) {
                if (sb.charAt(i2) != '\r' && sb.charAt(i2) != '\n') continue;
                sb.setCharAt(i2, ' ');
            }
        }
        String _str = sb.toString();
        String[] sArr = this.split(_str, "|");
        for (i = 0; i < this.keyword.length; ++i) {
            if (scoll.contains(this.keyword[i])) continue;
            scoll.add(this.keyword[i]);
        }
        int j = 0;
        for (i = 0; i < scoll.size(); ++i) {
            if (j == 4) {
                j = 0;
                continue;
            }
            ++j;
        }
    }

    public String[] split(String ss, String token) {
        ArrayList<String> v_Array = new ArrayList<String>();
        ss = ss.trim();
        String str = "";
        for (int i = 0; i < ss.length(); ++i) {
            String tmpString = ss.substring(i, i + 1);
            if (!tmpString.equals(token)) {
                str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(tmpString)));
                continue;
            }
            v_Array.add(str);
            str = "";
        }
        v_Array.add(str);
        String[] retStr = new String[v_Array.size()];
        for (int i = 0; i < v_Array.size(); ++i) {
            retStr[i] = (String)v_Array.get(i);
        }
        return retStr;
    }

    public String getString() throws KSQLException {
        this.getToken();
        switch (this.iType) {
            case 1: {
                if (this.hKeyword.contains(this.sToken.toUpperCase())) {
                    this.lex = this.sToken = this.sToken.toUpperCase();
                    break;
                }
                this.lex = "ID";
                break;
            }
            case 2: {
                this.lex = this.sToken;
                break;
            }
            case 3: 
            case 4: {
                this.lex = "UINT";
                break;
            }
            case 5: {
                this.lex = "CONSTSTR";
                break;
            }
            case 7: {
                this.lex = "DATESTR";
                break;
            }
            case 8: {
                this.lex = "TIMESTR";
                break;
            }
            case 9: {
                this.lex = "DATETIMESTR";
                break;
            }
            case 10: {
                throw new KSQLException("Unrecognised date time format ".concat(String.valueOf(String.valueOf(this.sToken))));
            }
            case 11: 
            case 12: 
            case 13: {
                this.lex = "ID";
                break;
            }
            case 16: {
                this.lex = ".";
                break;
            }
            case 17: {
                this.additionalInfo = this.sToken;
                this.lex = this.sToken = "?";
                break;
            }
            default: {
                if (this.m_End) {
                    this.lex = "#";
                    break;
                }
                if (this.iType == 0) {
                    this.lex = "#";
                    this.m_End = true;
                    break;
                }
                throw new KSQLException("Unrecognised token ".concat(String.valueOf(String.valueOf(this.sToken))));
            }
        }
        if (this.lex == "DATESTR" || this.lex == "TIMESTR" || this.lex == "DATETIMESTR") {
            this.sToken = this.sToken.replace('{', ' ');
            this.sToken = this.sToken.replace('}', ' ');
            this.sToken = this.sToken.replace('d', ' ');
            this.sToken = this.sToken.replace('t', ' ');
            this.sToken = this.sToken.replace('s', ' ');
        }
        return this.sToken;
    }

    private void getToken() throws KSQLException {
        if (this.bWait) {
            this.bWait = false;
            return;
        }
        while (this.iIndex < this.iLength && Character.isWhitespace(this.sCommand.charAt(this.iIndex))) {
            ++this.iIndex;
        }
        this.sToken = "";
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        boolean point = false;
        boolean digit = false;
        boolean exp = false;
        boolean afterexp = false;
        boolean end = false;
        boolean namedParam = false;
        int iTmp = 0;
        int flag = 0;
        char c = this.sCommand.charAt(this.iIndex);
        int cfirst = 32;
        StringBuffer name = new StringBuffer();
        if (Character.isLetter(c)) {
            if (this.iIndex + 1 < this.iLength && this.sCommand.charAt(this.iIndex + 1) == '\'' && (c == 'n' || c == 'N')) {
                this.iType = 5;
                name.append(c);
                ++this.iIndex;
                if (this.iIndex < this.iLength) {
                    name.append(this.sCommand.charAt(this.iIndex));
                }
            } else {
                this.iType = 1;
            }
        } else {
            if ("(),*=;+%?".indexOf(c) >= 0) {
                this.iType = 2;
                ++this.iIndex;
                this.sToken = String.valueOf(String.valueOf(c)).concat("");
                return;
            }
            if ("!<>|/-".indexOf(c) >= 0) {
                this.iType = 2;
                cfirst = c;
            } else if (c == '\"') {
                this.iType = 13;
                name.append(c);
            } else if (c == '\'') {
                this.iType = 5;
                name.append(c);
            } else if (c == '.') {
                if (this.idpoint) {
                    this.idpoint = false;
                    this.iType = 16;
                    ++this.iIndex;
                    this.sToken = ".";
                    return;
                }
                this.iType = 4;
                point = true;
            } else if (Character.isDigit(c)) {
                this.iType = 3;
                digit = true;
            } else if (c == ':') {
                this.iType = 11;
                name.append(c);
            } else if (c == '#') {
                ++flag;
                this.iType = 12;
                name.append(c);
            } else if (c == '{') {
                this.iType = 10;
                name.append(c);
            } else if (c == '@') {
                this.iType = 1;
                namedParam = true;
            } else {
                throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(c))));
            }
        }
        int start = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                c = ' ';
                end = true;
                this.m_End = true;
            } else {
                c = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: {
                    if (Character.isLetterOrDigit(c) || c == '_') break;
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    if (namedParam) {
                        this.iType = 17;
                        return;
                    }
                    if (c == '.') {
                        this.idpoint = true;
                    }
                    return;
                }
                case 13: {
                    if (c == '\"') {
                        ++this.iIndex;
                        if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '\"') {
                            name.append(c);
                            this.sToken = name.toString();
                            if (this.iIndex < this.iLength && this.sCommand.charAt(this.iIndex) == '.') {
                                this.idpoint = true;
                            }
                            return;
                        }
                    }
                    name.append(c);
                    break;
                }
                case 5: {
                    if (c == '\'') {
                        ++iTmp;
                        if (this.iIndex + 1 < this.iLength && this.sCommand.charAt(this.iIndex + 1) == '\'') {
                            name.append(c);
                            break;
                        }
                        if (iTmp % 2 == 0) {
                            name.append(c);
                            break;
                        }
                        name.append(c);
                        ++this.iIndex;
                        this.sToken = name.toString();
                        return;
                    }
                    name.append(c);
                    break;
                }
                case 11: {
                    if (Character.isDigit(c)) break;
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
                case 12: {
                    if (c == '#') {
                        if (++flag > 2) {
                            throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(c))));
                        }
                        if (this.iIndex + 1 < this.iLength && this.sCommand.charAt(this.iIndex + 1) == '_') {
                            throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(String.valueOf(this.sCommand.charAt(this.iIndex + 1))))));
                        }
                        name.append(c);
                        break;
                    }
                    if (Character.isLetterOrDigit(c) || c == '_') break;
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    if (c == '.') {
                        this.idpoint = true;
                    }
                    return;
                }
                case 10: {
                    if (c == '}') {
                        ++this.iIndex;
                        if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '}') {
                            name.append(c);
                            this.sToken = name.toString();
                            Automata dfa = new Automata(this.sToken);
                            if (dfa.accepts()) {
                                this.iType = dfa.getIType() == 1 ? 7 : (dfa.getIType() == 2 ? 8 : 9);
                            } else {
                                throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(c))));
                            }
                            return;
                        }
                    }
                    name.append(c);
                    break;
                }
                case 15: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != 42) break;
                    ++this.iIndex;
                    while (this.iIndex < this.iLength) {
                        if (this.iIndex < this.iLength && this.sCommand.charAt(this.iIndex - 1) == '*' && this.sCommand.charAt(this.iIndex) == '/') {
                            ++this.iIndex;
                            this.getToken();
                            return;
                        }
                        ++this.iIndex;
                    }
                    break;
                }
                case 14: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != '\r' && c != 10) break;
                    this.getToken();
                    ++this.lineNo;
                    return;
                }
                case 2: {
                    if (c == '/' && cfirst == 47) {
                        this.iType = 14;
                        break;
                    }
                    if (c == '-' && cfirst == 45) {
                        this.iType = 14;
                        break;
                    }
                    if (c == '*' && cfirst == 47) {
                        this.iType = 15;
                        break;
                    }
                    if (">=|".indexOf(c) >= 0) break;
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
                case 3: 
                case 4: {
                    if (Character.isDigit(c)) {
                        digit = true;
                        break;
                    }
                    if (c == '.') {
                        this.iType = 4;
                        if (point) {
                            throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(c))));
                        }
                        point = true;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        if (exp) {
                            throw new KSQLException("Unexpected token E");
                        }
                        afterexp = true;
                        point = true;
                        exp = true;
                        break;
                    }
                    if (c == '-' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    if (c == '+' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    afterexp = false;
                    if (!digit) {
                        if (point && start == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 2;
                            return;
                        }
                        throw new KSQLException("Unexpected token ".concat(String.valueOf(String.valueOf(c))));
                    }
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }
}

