/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart;

import java.awt.BasicStroke;
import java.awt.Stroke;

class LineStrokeGenerator {
    private static final float[] WIDTHS = new float[]{1.0f, 2.0f};
    private static final float WIDTHSTEP = 1.0f;
    private static final int[] STYLES = new int[]{1, 5};
    private float width = WIDTHS[0];
    private int style = STYLES[0];

    LineStrokeGenerator() {
    }

    public Stroke next() {
        BasicStroke ret = LineStrokeGenerator.getStroke(this.width, this.style);
        this.width += 1.0f;
        if (this.width > WIDTHS[1]) {
            this.width = WIDTHS[0];
            ++this.style;
            if (this.style > STYLES[1]) {
                this.style = STYLES[0];
            }
        }
        return ret;
    }

    public static BasicStroke getStroke(float width, int style) {
        BasicStroke ret = null;
        if (style == 1) {
            ret = new BasicStroke(width, 2, 2);
        } else if (style <= 5 && style > 1) {
            float[] dashPattern = LineStrokeGenerator.getdash(style);
            ret = new BasicStroke(width, 0, 2, 10.0f, dashPattern, 0.0f);
        }
        return ret;
    }

    static float[] getdash(int style) {
        float[] dash = null;
        switch (style) {
            case 2: {
                dash = new float[]{2.0f};
                break;
            }
            case 3: {
                dash = new float[]{4.0f};
                break;
            }
            case 4: {
                dash = new float[]{9.0f, 3.0f};
                break;
            }
            case 5: {
                dash = new float[]{3.0f, 3.0f, 9.0f, 3.0f};
            }
        }
        return dash;
    }
}

