/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.image;

import com.kingdee.bos.web.anole.config.Configurator;
import com.kingdee.bos.web.anole.image.Encoder;
import com.kingdee.bos.web.anole.image.ImageIcon;
import com.kingdee.bos.web.anole.image.PNGEncoder;
import com.kingdee.bos.web.anole.image.WBMPEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageManager {
    public static final int FORMAT_PNG = 0;
    public static final int FORMAT_WBMP = 1;
    private static Map pics = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putImageIcon(ImageIcon icon) {
        Map map = pics;
        synchronized (map) {
            if (!ImageManager.contains(icon.getDescription())) {
                String PngFileName = ImageManager.SaveIconToFile(icon);
                pics.put(icon.getDescription(), PngFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putImageURL(URL url) {
        String strUrl = url.toString();
        String strFileName = ImageManager.getFileNameByUrl(strUrl);
        Map map = pics;
        synchronized (map) {
            if (!ImageManager.contains(strFileName)) {
                String PngFileName = ImageManager.SaveUrlToFile(url, strFileName);
                pics.put(strFileName, PngFileName);
            }
        }
        return strFileName;
    }

    public static InputStream getImageStream(String desc, int type) {
        FileInputStream stream = null;
        String strPath = null;
        try {
            switch (type) {
                case 0: {
                    strPath = String.valueOf(Configurator.getTempPath()) + desc + "kdpng";
                    stream = new FileInputStream(strPath);
                    break;
                }
                case 1: {
                    strPath = String.valueOf(Configurator.getTempPath()) + desc + "kdwbmp";
                    stream = new FileInputStream(strPath);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return stream;
    }

    public static boolean contains(String sKey) {
        return pics.containsKey(sKey);
    }

    private static String getFileNameByUrl(String strPath) {
        int spos = strPath.lastIndexOf("/");
        int epos = strPath.length();
        String strFilename = strPath.substring(spos + 1, epos);
        return strFilename;
    }

    private static String SaveUrlToFile(URL url, String strFileName) {
        String strPNGFileName = String.valueOf(Configurator.getTempPath()) + strFileName + ".png";
        try {
            BufferedImage image = ImageIO.read(url);
            FileOutputStream pngStream = new FileOutputStream(strPNGFileName);
            PNGEncoder pngEncoder = new PNGEncoder(image);
            ((Encoder)pngEncoder).encode(pngStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return strPNGFileName;
    }

    private static String SaveIconToFile(ImageIcon icon) {
        Image image = icon.getImage();
        String strWBMPFileName = String.valueOf(Configurator.getTempPath()) + icon.getDescription() + ".wbmp";
        String strPNGFileName = String.valueOf(Configurator.getTempPath()) + icon.getDescription() + ".png";
        FileOutputStream wbmpStream = null;
        FileOutputStream pngStream = null;
        try {
            wbmpStream = new FileOutputStream(strWBMPFileName);
            pngStream = new FileOutputStream(strPNGFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        PNGEncoder pngEncoder = new PNGEncoder(image);
        WBMPEncoder wbmpEncoder = new WBMPEncoder(image);
        ((Encoder)pngEncoder).encode(pngStream);
        ((Encoder)wbmpEncoder).encode(wbmpStream);
        return strPNGFileName;
    }
}

